/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixLabelCounterpartyComboController;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixController;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlenixLabelCounterpartySuperProductComboController
extends GlenixLabelCounterpartyComboController {
    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) {
        String name = this.getGlenixElementName();
        if (name == null) {
            return;
        }
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + name);
        el.setTextContent(this.getGlenixElementValue());
        resultElement.appendChild(el);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            this.setGlenixElementValue(loadElement.getTextContent());
        }
    }

    @Override
    public void setComboId(String id) {
        Platform.runLater(() -> {
            if (this.filteredItems != null) {
                if (id == null) {
                    this.filteredItems.setPredicate(transaction -> transaction != null && transaction.getCounterpartySuperProductUSI() != null);
                    this.glenixCombo.valueProperty().set(null);
                    this.glenixCombo.getSelectionModel().clearSelection();
                    return;
                }
                ObservableList ol = this.glenixCombo.getItems();
                for (int i = 0; i < ol.size(); ++i) {
                    Transaction t;
                    Counterparty c;
                    Object o = ol.get(i);
                    if (o == null || !(o instanceof Transaction) || (c = (t = (Transaction)o).getCounterparty()) == null || !id.equals(c.getCounterpartyIdentifier())) continue;
                    this.glenixCombo.valueProperty().set((Object)t);
                    this.glenixCombo.getSelectionModel().clearAndSelect(i);
                    return;
                }
                this.filteredItems.setPredicate(transaction -> transaction != null && transaction.getCounterpartySuperProductUSI() != null);
            }
            this.glenixCombo.valueProperty().set(null);
            this.glenixCombo.getSelectionModel().clearSelection();
        });
    }

    @Override
    public void setItems(ObservableList<Transaction> ol) {
        this.filteredItems = new FilteredList(ol, transaction -> transaction != null && transaction.getCounterpartySuperProductUSI() != null);
        this.glenixCombo.setItems((ObservableList)this.filteredItems);
        this.glenixCombo.getEditor().textProperty().addListener((obs, oldValue, newValue) -> {
            Transaction selected;
            if (this.glenixCombo.focusedProperty().get()) {
                this.glenixCombo.show();
            }
            if ((selected = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem()) == null || !selected.getCounterpartyLegalName().equals(newValue)) {
                Platform.runLater(() -> this.filteredItems.setPredicate(transaction -> {
                    if (transaction == null || transaction.getCounterpartySuperProductUSI() == null) {
                        return false;
                    }
                    if (newValue != null) {
                        String counterpartyLegalName = transaction.getCounterpartyLegalName();
                        return counterpartyLegalName != null && counterpartyLegalName.toLowerCase().contains(newValue.toLowerCase());
                    }
                    return true;
                }));
            }
        });
    }
}

