/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelComboAbstractController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlenixLabelCounterpartyComboController
extends GlenixLabelComboAbstractController {
    protected FilteredList<Transaction> filteredItems;
    private ChangeListener<Transaction> changeListener = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        Callback<ListView<Transaction>, ListCell<Transaction>> cellFactory = new Callback<ListView<Transaction>, ListCell<Transaction>>(){

            public ListCell<Transaction> call(ListView<Transaction> p) {
                ListCell<Transaction> cell = new ListCell<Transaction>(){

                    protected void updateItem(Transaction t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getCounterpartyLegalName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.glenixCombo.setConverter((StringConverter)new StringConverter<Transaction>(){

            public String toString(Transaction t) {
                if (t != null) {
                    String str = t.getCounterpartyLegalName();
                    return str;
                }
                return "";
            }

            public Transaction fromString(String string) {
                for (Transaction t : GlenixLabelCounterpartyComboController.this.filteredItems) {
                    String legalName = t.getCounterpartyLegalName();
                    if (legalName == null || !legalName.equals(string)) continue;
                    return t;
                }
                System.out.println("Error, returning null from fromString counterparty select.");
                return null;
            }
        });
        this.glenixCombo.setButtonCell((ListCell)cellFactory.call(null));
        this.glenixCombo.setCellFactory((Callback)cellFactory);
        this.glenixCombo.setEditable(true);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<Transaction>(){

            public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                if (GlenixLabelCounterpartyComboController.this.changeListener != null) {
                    GlenixLabelCounterpartyComboController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    public void setSingleChangeListener(ChangeListener<Transaction> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setComboId(String id) {
        if (this.filteredItems != null) {
            if (id == null) {
                this.filteredItems.setPredicate(p -> true);
                this.glenixCombo.valueProperty().set(null);
                this.glenixCombo.getSelectionModel().clearSelection();
                return;
            }
            ObservableList ol = this.glenixCombo.getItems();
            for (int i = 0; i < ol.size(); ++i) {
                Transaction t;
                Counterparty c;
                Object o = ol.get(i);
                if (o == null || !(o instanceof Transaction) || (c = (t = (Transaction)o).getCounterparty()) == null || !id.equals(c.getCounterpartyIdentifier())) continue;
                this.glenixCombo.valueProperty().set((Object)t);
                this.glenixCombo.getSelectionModel().clearAndSelect(i);
                return;
            }
            this.filteredItems.setPredicate(p -> true);
        }
        this.glenixCombo.valueProperty().set(null);
        this.glenixCombo.getSelectionModel().clearSelection();
    }

    @Override
    public String getGlenixElementValue() {
        Transaction t = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem();
        if (t != null) {
            return t.getCounterpartyIdentifier();
        }
        t = (Transaction)this.glenixCombo.valueProperty().getValue();
        if (t != null) {
            return t.getCounterpartyIdentifier();
        }
        return null;
    }

    public Transaction getCounterpartyTransaction() {
        Transaction t = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem();
        if (t != null) {
            return t;
        }
        return (Transaction)this.glenixCombo.valueProperty().getValue();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<Transaction> ol) {
        this.filteredItems = new FilteredList(ol, p -> true);
        this.glenixCombo.setItems(this.filteredItems);
        this.glenixCombo.getEditor().textProperty().addListener((obs, oldValue, newValue) -> {
            Transaction selected;
            if (this.glenixCombo.focusedProperty().get()) {
                this.glenixCombo.show();
            }
            if ((selected = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem()) == null || !selected.getCounterpartyLegalName().equals(newValue)) {
                this.filteredItems.setPredicate(transaction -> {
                    if (newValue != null) {
                        String counterpartyLegalName = transaction.getCounterpartyLegalName();
                        return counterpartyLegalName != null && counterpartyLegalName.toLowerCase().contains(newValue.toLowerCase());
                    }
                    return true;
                });
            }
        });
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) {
        Element el = resultElement;
        String name = this.getGlenixElementName();
        if (name != null && !name.isEmpty()) {
            String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
            el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + name);
            resultElement.appendChild(el);
        }
        Element idel = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:counterpartyIdentifier");
        idel.setTextContent(this.getGlenixElementValue());
        el.appendChild(idel);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) {
        String name = this.getGlenixElementName();
        if (name == null || name.isEmpty()) {
            if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("counterpartyIdentifier")) {
                this.setGlenixElementValue(loadElement.getTextContent());
            }
            return;
        }
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element idElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (idElement = (Element)node).getNamespaceURI() == null || !idElement.getNamespaceURI().equals("http://www.glenix.com.au/") || idElement.getLocalName() == null || !idElement.getLocalName().equals("counterpartyIdentifier")) continue;
                this.setGlenixElementValue(idElement.getTextContent());
            }
        }
    }

    public void addValueChangeListener(ChangeListener<Transaction> changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }
}

