/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixLabelListAbstractController;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ListCell;
import javafx.scene.control.SelectionMode;

public class GlenixLabelAccountListController
extends GlenixLabelListAbstractController {
    private ChangeListener<Transaction> changeListener;
    private String idtoset = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.glenixList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.glenixList.setCellFactory(lv -> new ListCell<Transaction>(){

            protected void updateItem(Transaction item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(item == null ? null : item.getAccountName());
            }
        });
    }

    public void setSingleChangeListener(ChangeListener<Transaction> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setComboId(String id) {
        this.idtoset = id;
        this.glenixList.getSelectionModel().clearSelection();
        if (id == null || id.isEmpty()) {
            return;
        }
        String[] ids = id.split(",");
        HashSet<String> idSet = new HashSet<String>();
        for (String s : ids) {
            idSet.add(s);
        }
        ObservableList ol = this.glenixList.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            Object o = ol.get(i);
            if (!(o instanceof Transaction) || !idSet.contains(((Transaction)o).getAccountIdentifier())) continue;
            this.glenixList.getSelectionModel().select(i);
            this.glenixList.scrollTo(i);
        }
    }

    @Override
    public String getGlenixElementValue() {
        String prefix = "";
        StringBuilder sb = new StringBuilder();
        ObservableList ol = this.glenixList.getSelectionModel().getSelectedItems();
        if (ol.size() == 0) {
            return null;
        }
        for (Object o : ol) {
            if (!(o instanceof Transaction)) continue;
            sb.append(prefix + ((Transaction)o).getAccountIdentifier());
            prefix = ",";
        }
        return sb.toString();
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<Transaction> ol) {
        if (ol != null) {
            ol.sort((Comparator)new Comparator<Transaction>(){

                @Override
                public int compare(Transaction t1, Transaction t2) {
                    String s1 = t1.getAccountName();
                    String s2 = t2.getAccountName();
                    return s1.compareTo(s2);
                }
            });
        }
        this.glenixList.setItems(ol);
        this.setComboId(this.idtoset);
    }
}

