/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.Account;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixLabelAbstractPane;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlenixLabelAccountCombo
extends GlenixLabelAbstractPane {
    private FilteredList<Transaction> filteredItems;
    private ChangeListener<Transaction> changeListener = null;
    private String cachedId = null;
    protected ComboBox glenixCombo = new ComboBox();

    public GlenixLabelAccountCombo() throws Exception {
        this.glenixCombo.getStyleClass().add((Object)"glenixPaneCombo");
        this.getChildren().add((Object)this.glenixCombo);
        Callback<ListView<Transaction>, ListCell<Transaction>> cellFactory = new Callback<ListView<Transaction>, ListCell<Transaction>>(){

            public ListCell<Transaction> call(ListView<Transaction> p) {
                ListCell<Transaction> cell = new ListCell<Transaction>(){

                    protected void updateItem(Transaction t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getAccountName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.glenixCombo.setConverter((StringConverter)new StringConverter<Transaction>(){
            private Map<String, Transaction> map = new HashMap<String, Transaction>();

            public String toString(Transaction t) {
                if (t != null) {
                    String str = t.getAccountName();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Transaction fromString(String string) {
                return this.map.get(string);
            }
        });
        this.glenixCombo.setButtonCell((ListCell)cellFactory.call(null));
        this.glenixCombo.setCellFactory((Callback)cellFactory);
        this.glenixCombo.setEditable(true);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<Transaction>(){

            public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                if (GlenixLabelAccountCombo.this.changeListener != null) {
                    GlenixLabelAccountCombo.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this.glenixCombo;
    }

    public void setSingleTransactionChangeListener(ChangeListener<Transaction> changeListener) {
        this.changeListener = changeListener;
    }

    public void setComboId(String id) {
        if (id == null) {
            if (this.filteredItems != null) {
                this.filteredItems.setPredicate(p -> true);
            }
            this.glenixCombo.valueProperty().set(null);
            this.glenixCombo.getSelectionModel().clearSelection();
            return;
        }
        ObservableList ol = this.glenixCombo.getItems();
        for (int i = 0; i < ol.size(); ++i) {
            Transaction t;
            Account c;
            Object o = ol.get(i);
            if (o == null || !(o instanceof Transaction) || (c = (t = (Transaction)o).getAccount()) == null || !id.equals(c.getAccountIdentifier())) continue;
            this.glenixCombo.valueProperty().set((Object)t);
            this.glenixCombo.getSelectionModel().clearAndSelect(i);
            return;
        }
        this.cachedId = id;
        if (this.filteredItems != null) {
            this.filteredItems.setPredicate(p -> true);
        }
        this.glenixCombo.valueProperty().set(null);
        this.glenixCombo.getSelectionModel().clearSelection();
    }

    @Override
    public String getGlenixElementValue() {
        Transaction t = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem();
        if (t != null) {
            return t.getAccountIdentifier();
        }
        t = (Transaction)this.glenixCombo.valueProperty().getValue();
        if (t != null) {
            return t.getAccountIdentifier();
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<Transaction> ol) {
        this.filteredItems = new FilteredList(ol, p -> true);
        this.glenixCombo.setItems(this.filteredItems);
        if (this.cachedId != null) {
            this.setComboId(this.cachedId);
            this.cachedId = null;
        }
        this.glenixCombo.getEditor().textProperty().addListener((obs, oldValue, newValue) -> {
            Transaction selected;
            if (this.glenixCombo.focusedProperty().get()) {
                this.glenixCombo.show();
            }
            if ((selected = (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem()) == null || !selected.getAccountName().equals(newValue)) {
                this.filteredItems.setPredicate(transaction -> {
                    if (newValue != null) {
                        String accountName = transaction.getAccountName();
                        return accountName != null && accountName.toLowerCase().contains(newValue.toLowerCase());
                    }
                    return true;
                });
            }
        });
    }

    private void buildGlenixXBRLSub(Pane pane, Document resultDoc, Element resultElement) throws Exception {
        for (Node component : pane.getChildren()) {
            if (component instanceof GlenixController) {
                ((GlenixController)component).buildGlenixXBRL(resultDoc, resultElement);
                continue;
            }
            if (!(component instanceof Pane)) continue;
            this.buildGlenixXBRLSub((Pane)component, resultDoc, resultElement);
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        String nsp = GlenixController.getNSP(this.getGlenixElementNamespace());
        Element el = resultDoc.createElementNS(this.getGlenixElementNamespace(), nsp + ":" + this.getGlenixElementName());
        resultElement.appendChild(el);
        Element idel = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:accountIdentifier");
        idel.setTextContent(this.getGlenixElementValue());
        el.appendChild(idel);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals(this.getGlenixElementNamespace()) && loadElement.getLocalName() != null && loadElement.getLocalName().equals(this.getGlenixElementName())) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element idElement;
                org.w3c.dom.Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (idElement = (Element)node).getNamespaceURI() == null || !idElement.getNamespaceURI().equals("http://www.glenix.com.au/") || idElement.getLocalName() == null || !idElement.getLocalName().equals("accountIdentifier")) continue;
                this.setGlenixElementValue(idElement.getTextContent());
            }
        }
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    public Transaction getSelectedAccountTransaction() {
        return (Transaction)this.glenixCombo.getSelectionModel().getSelectedItem();
    }
}

