/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.AUSKeyCredential;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.widget.GlenixLabelComboAbstractController;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class GlenixLabelAUSKeyComboController
extends GlenixLabelComboAbstractController {
    private FilteredList<GlenixElement> filteredItems;
    private ChangeListener<GlenixElement> changeListener = null;
    private Map<String, GlenixElement> map = new HashMap<String, GlenixElement>();

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        Callback<ListView<GlenixElement>, ListCell<GlenixElement>> cellFactory = new Callback<ListView<GlenixElement>, ListCell<GlenixElement>>(){

            public ListCell<GlenixElement> call(ListView<GlenixElement> p) {
                ListCell<GlenixElement> cell = new ListCell<GlenixElement>(){

                    protected void updateItem(GlenixElement t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.glenixCombo.setConverter((StringConverter)new StringConverter<GlenixElement>(){

            public String toString(GlenixElement t) {
                if (t != null) {
                    String str = t.toString();
                    GlenixLabelAUSKeyComboController.this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public GlenixElement fromString(String string) {
                return (GlenixElement)GlenixLabelAUSKeyComboController.this.map.get(string);
            }
        });
        this.glenixCombo.setButtonCell((ListCell)cellFactory.call(null));
        this.glenixCombo.setCellFactory((Callback)cellFactory);
        this.glenixCombo.setEditable(true);
        this.glenixCombo.valueProperty().addListener((ChangeListener)new ChangeListener<GlenixElement>(){

            public void changed(ObservableValue<? extends GlenixElement> observable, GlenixElement oldValue, GlenixElement newValue) {
                if (GlenixLabelAUSKeyComboController.this.changeListener != null) {
                    GlenixLabelAUSKeyComboController.this.changeListener.changed(observable, (Object)oldValue, (Object)newValue);
                }
            }
        });
    }

    public void setSingleChangeListener(ChangeListener<GlenixElement> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setComboId(String id) {
        Platform.runLater(() -> {
            if (id == null) {
                this.filteredItems.setPredicate(p -> true);
                this.glenixCombo.valueProperty().set(null);
                this.glenixCombo.getSelectionModel().clearSelection();
                return;
            }
            ObservableList ol = this.glenixCombo.getItems();
            for (int i = 0; i < ol.size(); ++i) {
                AUSKeyCredential t;
                Object o = ol.get(i);
                if (o == null || !(o instanceof AUSKeyCredential) || (t = (AUSKeyCredential)o) == null || !id.equals(t.getId())) continue;
                this.map.put(t.toString(), t);
                this.glenixCombo.getSelectionModel().clearAndSelect(i);
                this.glenixCombo.valueProperty().setValue((Object)t);
                return;
            }
            this.filteredItems.setPredicate(p -> true);
            this.glenixCombo.valueProperty().set(null);
            this.glenixCombo.getSelectionModel().clearSelection();
        });
    }

    @Override
    public String getGlenixElementValue() {
        GlenixElement t = (GlenixElement)this.glenixCombo.getSelectionModel().getSelectedItem();
        if (t != null && t instanceof AUSKeyCredential) {
            return ((AUSKeyCredential)t).getId();
        }
        t = (GlenixElement)this.glenixCombo.valueProperty().getValue();
        if (t != null && t instanceof AUSKeyCredential) {
            return ((AUSKeyCredential)t).getId();
        }
        return null;
    }

    @Override
    public void setGlenixElementValue(String glenixElementValue) {
        String im = this.getGlenixElementImmutableValue();
        if (im == null) {
            this.setComboId(glenixElementValue);
        }
    }

    public void setItems(ObservableList<GlenixElement> ol) {
        this.filteredItems = new FilteredList(ol, p -> true);
        this.glenixCombo.setItems(this.filteredItems);
        this.glenixCombo.getEditor().textProperty().addListener((obs, oldValue, newValue) -> {
            GlenixElement selected;
            if (this.glenixCombo.focusedProperty().get()) {
                this.glenixCombo.show();
            }
            if ((selected = (GlenixElement)this.glenixCombo.getSelectionModel().getSelectedItem()) == null || !selected.toString().equals(newValue)) {
                Platform.runLater(() -> this.filteredItems.setPredicate(ge -> {
                    if (newValue != null) {
                        String name = ge.toString();
                        return name != null && name.toLowerCase().contains(newValue.toLowerCase());
                    }
                    return true;
                }));
            }
        });
    }

    public void addValueChangeListener(ChangeListener changeListener) {
        this.glenixCombo.valueProperty().addListener(changeListener);
    }

    public void setErrorDisplay(String status) {
        if (status == null || status.equals("ok")) {
            this.glenixCombo.getStyleClass().removeAll((Object[])new String[]{"error_background"});
        } else {
            this.glenixCombo.getStyleClass().add((Object)"error_background");
        }
    }
}

