/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.Glenix;
import au.com.glenix.GlenixFile;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixCertificate;
import au.com.glenix.trn.GlenixCertificateList;
import au.com.glenix.trn.GlenixTrnXBRL;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.filechooser.FileSystemView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.w3c.dom.Document;

public class GlenixFilePGP
extends GlenixFile {
    private boolean skipcloseandrepoen = false;
    private KeyFingerPrintCalculator fpCalc = new BcKeyFingerprintCalculator();

    public GlenixFilePGP(Stage stage, String codeName) throws Exception {
        super(stage, codeName);
    }

    @Override
    public String getFileName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }

    @Override
    public byte[] getFullFileBytes() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(this.file);
        byte[] tmp = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)is).read(tmp)) > 0) {
            bos.write(tmp, 0, len);
        }
        return bos.toByteArray();
    }

    @Override
    public void openFileSub(boolean createIfNew) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        if (createIfNew) {
            env.put("create", "true");
        }
        URI uri = URI.create("jar:" + this.file.toURI());
        this.fileSystem = FileSystems.newFileSystem(uri, env);
    }

    private File getHomeDir() {
        File f;
        File f2;
        String pathStr = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        if (pathStr != null && !pathStr.isEmpty() && (f2 = new File(pathStr)).exists()) {
            return f2;
        }
        String home = System.getProperty("user.home");
        if (home != null && !home.isEmpty() && (f = new File(home)).exists()) {
            return f;
        }
        return null;
    }

    @Override
    public void openFile() throws IOException {
        File home = this.getHomeDir();
        if (home != null) {
            this.fileChooser.setInitialDirectory(home);
        }
        this.file = this.fileChooser.showOpenDialog((Window)this.stage);
        if (this.file != null) {
            this.openFileSub(true);
            this.stage.setTitle(this.codeName + " - " + this.file.getAbsolutePath());
        }
    }

    @Override
    public boolean isOpen() {
        return this.file != null;
    }

    @Override
    public void openFIDFileCreate(String defaultName) throws IOException {
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("FID files (*.fid)", new String[]{"*.fid"});
        this.fileChooser.getExtensionFilters().add((Object)extFilter);
        FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("All files (*.*)", new String[]{"*.*"});
        this.fileChooser.getExtensionFilters().add((Object)extFilter2);
        this.fileChooser.setInitialFileName(defaultName + ".fid");
        this.fileChooser.setTitle("Create your FAS identity file, suggested name is MyFasIdentity.fid");
        File home = this.getHomeDir();
        if (home != null) {
            this.fileChooser.setInitialDirectory(home);
        }
        this.file = this.fileChooser.showSaveDialog((Window)this.stage);
        if (this.file != null) {
            this.openFileSub(true);
            this.stage.setTitle(this.codeName + " - " + this.file.getAbsolutePath());
        }
    }

    @Override
    public void openFIDFileCreate(File file) throws IOException {
        this.file = file;
        if (this.file != null) {
            this.openFileSub(true);
            this.stage.setTitle(this.codeName + " - " + file.getAbsolutePath());
        }
    }

    @Override
    public void openFileCreate(String defaultName) throws IOException {
        this.fileChooser.setInitialFileName(defaultName);
        File home = this.getHomeDir();
        if (home != null) {
            this.fileChooser.setInitialDirectory(home);
        }
        this.file = this.fileChooser.showSaveDialog((Window)this.stage);
        if (this.file != null) {
            this.file.setReadable(true, false);
            this.file.setWritable(true, false);
            this.openFileSub(true);
            this.stage.setTitle(this.codeName + " - " + this.file.getAbsolutePath());
        }
    }

    @Override
    public void openBusinessFileDoNotCreate(File afile) throws Exception {
        if (afile != null) {
            this.file = afile;
            this.openFileSub(false);
            Document certListDoc = this.getDocument("glenixCertificateList.xml");
            this.glenixCertificateListFile = new GlenixTrnXBRL();
            this.glenixCertificateListFile.loadDocumentElement(certListDoc, certListDoc.getDocumentElement());
        }
    }

    @Override
    public void openBusinessFileDoNotCreate(String defaultName) throws Exception {
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("FAS files (*.fas)", new String[]{"*.fas"});
        this.fileChooser.getExtensionFilters().add((Object)extFilter);
        FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("All files (*.*)", new String[]{"*.*"});
        this.fileChooser.getExtensionFilters().add((Object)extFilter2);
        this.fileChooser.setInitialFileName(defaultName + ".fas");
        File home = this.getHomeDir();
        if (home != null) {
            this.fileChooser.setInitialDirectory(home);
        }
        this.file = this.fileChooser.showOpenDialog((Window)this.stage);
        if (this.file != null) {
            this.openFileSub(false);
            this.stage.setTitle(this.codeName + " - " + this.file.getAbsolutePath());
            Document certListDoc = this.getDocument("glenixCertificateList.xml");
            this.glenixCertificateListFile = new GlenixTrnXBRL();
            this.glenixCertificateListFile.loadDocumentElement(certListDoc, certListDoc.getDocumentElement());
        }
    }

    @Override
    public void openProfileFileDoNotCreate(String defaultName) throws Exception {
        this.fileChooser.setInitialFileName(defaultName);
        File home = this.getHomeDir();
        if (home != null) {
            this.fileChooser.setInitialDirectory(home);
        }
        this.file = this.fileChooser.showOpenDialog((Window)this.stage);
        if (this.file != null) {
            this.openFileSub(false);
            this.stage.setTitle(this.codeName + " - " + this.file.getAbsolutePath());
            Document certListDoc = this.getDocument("glenixCertificateList.xml");
            if (certListDoc != null) {
                this.glenixCertificateListFile = new GlenixTrnXBRL();
                this.glenixCertificateListFile.loadDocumentElement(certListDoc, certListDoc.getDocumentElement());
            }
        }
    }

    @Override
    public void openProfileFileDoNotCreate(File file) throws Exception {
        if (file != null) {
            this.file = file;
            this.openFileSub(false);
            this.stage.setTitle(Glenix.codeName + " - " + file.getAbsolutePath());
            Document certListDoc = this.getDocument("glenixCertificateList.xml");
            if (certListDoc != null) {
                this.glenixCertificateListFile = new GlenixTrnXBRL();
                this.glenixCertificateListFile.loadDocumentElement(certListDoc, certListDoc.getDocumentElement());
            }
        }
    }

    @Override
    public boolean hasGlenixCertificateListFile() {
        return this.glenixCertificateListFile != null;
    }

    @Override
    public void openTempFile() throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        UUID uuid = UUID.randomUUID();
        String randomUUIDString = uuid.toString();
        this.file = tmpdir != null && !tmpdir.isEmpty() ? new File(tmpdir + "/fas_tmp_" + randomUUIDString + ".zip") : new File("fas_tmp_" + randomUUIDString + ".zip");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + this.file.toURI());
        this.fileSystem = FileSystems.newFileSystem(uri, env);
        this.file.deleteOnExit();
        SecureRandom secureRandom = new SecureRandom();
        this.key = new byte[16];
        secureRandom.nextBytes(this.key);
    }

    @Override
    public void openFile(File file) throws IOException {
        if (file != null) {
            this.file = file;
            this.openFileSub(true);
        }
    }

    @Override
    public void openFileDoNotCreate(File file) throws IOException {
        if (file != null) {
            this.file = file;
            this.openFileSub(false);
        }
    }

    @Override
    public void closeFile() throws IOException {
        this.fileSystem.close();
    }

    @Override
    public void reopenFile() throws IOException {
        this.openFileSub(false);
    }

    private void closeAndReopenFile() throws IOException {
        if (this.skipcloseandrepoen) {
            return;
        }
        this.closeFile();
        this.openFileSub(false);
    }

    @Override
    public void saveAndEncryptStream(String dataSource, InputStream in, OutputStream logFileOutputStream) throws Exception {
        int len;
        if (this.hasGlenixCertificateListFile()) {
            this.saveAndEncryptStreamPGPPublic(dataSource, in, logFileOutputStream);
            return;
        }
        if (!this.hasKey()) {
            throw new Exception("Error, key not set. Cannot encrypt doc, set key first.");
        }
        SecureRandom secureRandom = new SecureRandom();
        SecretKeySpec secretKey = new SecretKeySpec(this.key, "AES");
        byte[] iv = new byte[12];
        secureRandom.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secretKey, parameterSpec);
        Path zipFileDataSource = this.fileSystem.getPath(dataSource, new String[0]);
        OutputStream zfos = Files.newOutputStream(zipFileDataSource, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        zfos.write("FAS3D000".getBytes("UTF-8"));
        int ivLength = iv.length;
        byte[] lengthByte = new byte[]{(byte)(ivLength >> 24), (byte)(ivLength >> 16), (byte)(ivLength >> 8), (byte)ivLength};
        zfos.write(lengthByte);
        zfos.write(iv);
        CipherOutputStream cos = new CipherOutputStream(zfos, cipher);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            cos.write(buffer, 0, len);
            if (logFileOutputStream == null) continue;
            logFileOutputStream.write(buffer, 0, len);
        }
        cos.flush();
        cos.close();
        this.closeAndReopenFile();
        if (logFileOutputStream != null) {
            logFileOutputStream.flush();
        }
    }

    public void saveAndEncryptStreamPGPPublic(String dataSource, InputStream in, OutputStream logFileOutputStream) throws Exception {
        this.saveAndEncryptStreamPGP(dataSource + ".pgp", in, logFileOutputStream);
    }

    private void saveAndEncryptStreamPGP(String dataSource, InputStream in, OutputStream logFileOutputStream) throws Exception {
        int len;
        Path dataSourcePath = this.fileSystem.getPath(dataSource, new String[0]);
        int count = dataSourcePath.getNameCount();
        System.out.println("PATH = " + dataSourcePath + " count = " + count);
        if (count > 1) {
            Path dirPath = dataSourcePath.subpath(0, count - 1);
            System.out.println("Dirpath = " + dirPath);
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        GlenixEncryptedOutputStream os = new GlenixEncryptedOutputStream(dataSource);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)os).write(buf, 0, len);
            if (logFileOutputStream == null) continue;
            logFileOutputStream.write(buf, 0, len);
        }
        if (logFileOutputStream != null) {
            logFileOutputStream.flush();
        }
        ((OutputStream)os).close();
        in.close();
    }

    @Override
    public void saveAndEncryptDoc(String dataSource, Document doc) throws Exception {
        this.saveAndEncryptDocPGP(dataSource + ".pgp", doc);
    }

    private void saveAndEncryptDocPGP(String dataSource, final Document doc) throws Exception {
        if (!this.hasKey()) {
            throw new Exception("Error, key not set. Cannot encrypt doc, set key first.");
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer1 = tf.newTransformer();
        transformer1.setOutputProperty("omit-xml-declaration", "no");
        transformer1.setOutputProperty("method", "xml");
        transformer1.setOutputProperty("encoding", "UTF-8");
        transformer1.setOutputProperty("standalone", "yes");
        PipedInputStream docinpipe = new PipedInputStream();
        final PipedOutputStream docoutpipe = new PipedOutputStream(docinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    transformer1.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)docoutpipe, "UTF-8")));
                    docoutpipe.flush();
                    docoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        this.saveAndEncryptStreamPGP(dataSource, docinpipe, null);
    }

    @Override
    public void saveBytes(String dataSource, byte[] bytes, int offset, int length) throws IOException {
        try {
            Path zipFileDataSource = this.fileSystem.getPath(dataSource, new String[0]);
            OutputStream zfos = Files.newOutputStream(zipFileDataSource, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            zfos.write(bytes, offset, length);
            zfos.flush();
            zfos.close();
            this.closeAndReopenFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveStream(String dataSource, InputStream in, OutputStream logFileOutputStream) throws IOException {
        try {
            Path zipFileDataSource = this.fileSystem.getPath(dataSource, new String[0]);
            OutputStream zfos = Files.newOutputStream(zipFileDataSource, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            byte[] buf = new byte[1024];
            int bytes = 0;
            while ((bytes = in.read(buf)) >= 0) {
                zfos.write(buf, 0, bytes);
                if (logFileOutputStream == null) continue;
                logFileOutputStream.write(buf, 0, bytes);
            }
            zfos.flush();
            zfos.close();
            this.closeAndReopenFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveFile(String dataSource, Document doc) throws IOException {
        try {
            Path zipFileDataSource = this.fileSystem.getPath(dataSource, new String[0]);
            OutputStream zfos = Files.newOutputStream(zipFileDataSource, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            this.printDocument(doc, zfos);
            zfos.flush();
            zfos.close();
            this.closeAndReopenFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveFileAs(String dataSource, Document doc) throws IOException {
        File tmpFile = this.file;
        FileSystem tmpFileSystem = this.fileSystem;
        try {
            File home = this.getHomeDir();
            if (home != null) {
                this.fileChooser.setInitialDirectory(home);
            }
            this.file = this.fileChooser.showSaveDialog((Window)this.stage);
            if (this.file != null) {
                if (this.file.equals(tmpFile)) {
                    this.saveFile(dataSource, doc);
                    return;
                }
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                URI uri = URI.create("jar:" + this.file.toURI());
                this.fileSystem = FileSystems.newFileSystem(uri, env);
                Path root = tmpFileSystem.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        Files.copy(path, GlenixFilePGP.this.fileSystem.getPath(path.toString(), new String[0]), new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
                this.saveFile(dataSource, doc);
                this.stage.setTitle("Free Accounting Software - " + this.file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.file = tmpFile;
            this.fileSystem = tmpFileSystem;
            throw e;
        }
    }

    @Override
    public void makeDirectory(String dataSource) throws Exception {
        if (this.file == null || this.fileSystem == null) {
            throw new Exception("File is not yet opened");
        }
        Path dataSourcePath = this.fileSystem.getPath(dataSource, new String[0]);
        if (dataSourcePath != null && !Files.exists(dataSourcePath, new LinkOption[0])) {
            Files.createDirectory(dataSourcePath, new FileAttribute[0]);
        }
    }

    @Override
    public Document getDocument(String zipFileDataSource) throws Exception {
        if (this.file == null) {
            throw new Exception("File is not yet opened");
        }
        Path zipFileDataSourcePath = this.fileSystem.getPath(zipFileDataSource, new String[0]);
        try {
            InputStream zfis = Files.newInputStream(zipFileDataSourcePath, StandardOpenOption.READ);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(zfis);
            return doc;
        }
        catch (NoSuchFileException nsfe) {
            return null;
        }
    }

    @Override
    public OutputStream getEncryptedOutputStream(String dataSource) throws Exception {
        return new GlenixEncryptedOutputStream(dataSource);
    }

    private OutputStream getEncryptedOutputStream(String dataSource, byte[] thisKey) throws Exception {
        if (this.file == null) {
            throw new Exception("File is not yet opened");
        }
        if (thisKey == null) {
            throw new Exception("Key is null");
        }
        SecureRandom secureRandom = new SecureRandom();
        SecretKeySpec secretKey = new SecretKeySpec(thisKey, "AES");
        byte[] iv = new byte[12];
        secureRandom.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secretKey, parameterSpec);
        Path zipFileDataSource = this.fileSystem.getPath(dataSource, new String[0]);
        OutputStream zfos = Files.newOutputStream(zipFileDataSource, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        zfos.write("FAS3D000".getBytes("UTF-8"));
        int ivLength = iv.length;
        byte[] lengthByte = new byte[]{(byte)(ivLength >> 24), (byte)(ivLength >> 16), (byte)(ivLength >> 8), (byte)ivLength};
        zfos.write(lengthByte);
        zfos.write(iv);
        CipherOutputStream cos = new CipherOutputStream(zfos, cipher);
        return cos;
    }

    private InputStream readAndDecryptDataSourcePGP(String zipFileDataSource, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.file == null) {
            throw new Exception("File is not yet opened");
        }
        Path zipFileDataSourcePath = this.fileSystem.getPath(zipFileDataSource, new String[0]);
        InputStream zfis = Files.newInputStream(zipFileDataSourcePath, StandardOpenOption.READ);
        if (zfis == null) {
            return null;
        }
        InputStream pgpIn = PGPUtil.getDecoderStream(zfis);
        PGPObjectFactory pgpF = new PGPObjectFactory(pgpIn, this.fpCalc);
        PGPEncryptedDataList enc = null;
        Object o = pgpF.nextObject();
        enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        Iterator it = enc.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pbe = null;
        boolean found = false;
        while (it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            System.out.println("Key id = " + pbe.getKeyID() + " private key id = " + pgpPrivateKey.getKeyID() + " pub key id = " + pgpPublicKey.getKeyID());
            if (pbe.getKeyID() != pgpPublicKey.getKeyID()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Error, you do not have access to this file");
        }
        InputStream clear = pbe.getDataStream(new BcPublicKeyDataDecryptorFactory(pgpPrivateKey));
        PGPObjectFactory plainFact = new PGPObjectFactory(clear, this.fpCalc);
        Object message = plainFact.nextObject();
        if (message instanceof PGPCompressedData) {
            PGPCompressedData cData = (PGPCompressedData)message;
            PGPObjectFactory pgpFact = new PGPObjectFactory(cData.getDataStream(), this.fpCalc);
            message = pgpFact.nextObject();
        }
        if (message instanceof PGPLiteralData) {
            PGPLiteralData ld = (PGPLiteralData)message;
            InputStream unc = ld.getInputStream();
            return unc;
        }
        if (message instanceof PGPOnePassSignatureList) {
            throw new PGPException("encrypted message contains a signed message - not literal data.");
        }
        throw new PGPException("message is not a simple encrypted file - type unknown.");
    }

    @Override
    public InputStream readAndDecryptDataSource(String zipFileDataSource, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        int readlen;
        InputStream result;
        if (this.file == null) {
            throw new Exception("File is not yet opened");
        }
        if (pgpPrivateKey != null && (result = this.readAndDecryptDataSourcePGP(zipFileDataSource + ".pgp", pgpPrivateKey, pgpPublicKey)) != null) {
            return result;
        }
        if (this.key == null) {
            throw new Exception("Key is null");
        }
        Path zipFileDataSourcePath = this.fileSystem.getPath(zipFileDataSource, new String[0]);
        InputStream zfis = Files.newInputStream(zipFileDataSourcePath, StandardOpenOption.READ);
        if (zfis == null) {
            return null;
        }
        int pos = 0;
        byte[] headerSignatureBytes = new byte[8];
        while (headerSignatureBytes.length - pos > 0 && (readlen = zfis.read(headerSignatureBytes, pos, headerSignatureBytes.length - pos)) >= 0) {
            pos += readlen;
        }
        String headerSignatureStr = new String(headerSignatureBytes, "UTF-8");
        if (!headerSignatureStr.equals("FAS3D000")) {
            throw new Exception("Error, this is not a FAS 3 Desktop encrypted file.");
        }
        byte[] ivLengthBytes = new byte[4];
        pos = 0;
        while ((readlen = zfis.read(ivLengthBytes, pos, ivLengthBytes.length - pos)) >= 0 && ivLengthBytes.length - pos > 0) {
            pos += readlen;
        }
        int ivLength = ivLengthBytes[0] << 24 | ivLengthBytes[1] << 16 | ivLengthBytes[2] << 8 | ivLengthBytes[3];
        byte[] iv = new byte[ivLength];
        pos = 0;
        while (iv.length - pos > 0 && (readlen = zfis.read(iv, pos, iv.length - pos)) >= 0) {
            pos += readlen;
        }
        if (readlen == -1) {
            throw new Exception("Error, unable to read data source");
        }
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(this.key, "AES"), new GCMParameterSpec(128, iv));
        CipherInputStream cis = new CipherInputStream(zfis, cipher);
        return cis;
    }

    @Override
    public Document getDocumentDecrypt(String dataSource, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        InputStream zfis = this.readAndDecryptDataSource(dataSource, pgpPrivateKey, pgpPublicKey);
        if (zfis == null) {
            System.out.println("ERROR, cannot decrypt " + dataSource + " input stream is null");
            return null;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(zfis);
        return doc;
    }

    private Document getDocumentDecryptPGP(String dataSource, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        InputStream zfis = this.readAndDecryptDataSourcePGP(dataSource, pgpPrivateKey, pgpPublicKey);
        if (zfis == null) {
            System.out.println("ERROR, cannot decrypt " + dataSource + " input stream is null");
            return null;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(zfis);
        return doc;
    }

    @Override
    public InputStream readDataSource(String zipFileDataSource) throws Exception {
        if (this.file == null) {
            throw new Exception("File is not yet opened");
        }
        Path zipFileDataSourcePath = this.fileSystem.getPath(zipFileDataSource, new String[0]);
        try {
            return Files.newInputStream(zipFileDataSourcePath, StandardOpenOption.READ);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        this.transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    @Override
    public void forceSaveNow() throws Exception {
        this.closeAndReopenFile();
    }

    @Override
    public ArrayList<Path> getFileList(String directoryPath) throws Exception {
        ArrayList<Path> result = new ArrayList<Path>();
        if (directoryPath == null || directoryPath.isEmpty()) {
            Iterable<Path> paths = this.fileSystem.getRootDirectories();
            for (Path p : paths) {
                DirectoryStream<Path> stream = Files.newDirectoryStream(p);
                for (Path path : stream) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        ArrayList<Path> subres = this.getFileList(path.toString());
                        for (int i = 0; i < subres.size(); ++i) {
                            Path subPath = subres.get(i);
                            result.add(subPath);
                            System.out.println("ADDING " + subPath.toString());
                        }
                        continue;
                    }
                    result.add(path);
                }
            }
        } else {
            Path p = this.fileSystem.getPath(directoryPath, new String[0]);
            DirectoryStream<Path> stream = Files.newDirectoryStream(p);
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    ArrayList<Path> subres = this.getFileList(path.toString());
                    for (int i = 0; i < subres.size(); ++i) {
                        Path subPath = subres.get(i);
                        result.add(subPath);
                        System.out.println("ADDING " + subPath.toString());
                    }
                    continue;
                }
                result.add(path);
            }
        }
        return result;
    }

    @Override
    public ArrayList<Path> getFileList() throws Exception {
        return this.getFileList(null);
    }

    @Override
    public void deleteFile(String dataSource) throws Exception {
        Path zipFileDataSourcePath = this.fileSystem.getPath(dataSource, new String[0]);
        Files.delete(zipFileDataSourcePath);
    }

    private X509Certificate readX509Certificate(String publicKeyStr) throws Exception {
        ByteArrayInputStream bis;
        if (publicKeyStr == null || publicKeyStr.isEmpty()) {
            throw new Exception("Error, public key string is empty cannot read X509 cert.");
        }
        String tmpString = publicKeyStr.replaceAll("\n", "");
        tmpString = tmpString.replaceAll("\r", "");
        byte[] pubcertbytes = Base64.getDecoder().decode(tmpString);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certCollection = cf.generateCertificates(bis = new ByteArrayInputStream(pubcertbytes));
        Iterator<? extends Certificate> certIterator = certCollection.iterator();
        if (certIterator.hasNext()) {
            X509Certificate firstCert = (X509Certificate)certIterator.next();
            return firstCert;
        }
        throw new Exception("Error, cannot extract X509 cert from provided string.");
    }

    private PublicKey readPublicKey(String publicKeyStr) throws Exception {
        X509Certificate x509 = this.readX509Certificate(publicKeyStr);
        if (x509 == null) {
            return null;
        }
        return x509.getPublicKey();
    }

    @Override
    public void createNewFile(String defaultName, byte[] profilePublicPem) throws Exception {
        this.openFileCreate(defaultName);
        this.createGlenixCertificateList(profilePublicPem);
    }

    @Override
    public void createGlenixCertificateList(byte[] profilePublicPem) throws Exception {
        String profilePublicPemStr = new String(profilePublicPem, "UTF-8");
        if (profilePublicPemStr == null || profilePublicPemStr.isEmpty()) {
            throw new Exception("Error, unable to create certificate file as profile public certificate is empty.");
        }
        String publicCertStr = profilePublicPemStr.replace("-----BEGIN CERTIFICATE-----\n", "");
        publicCertStr = publicCertStr.replace("-----END CERTIFICATE-----", "");
        publicCertStr = publicCertStr.replaceAll("\n", "");
        publicCertStr = publicCertStr.replaceAll("\r", "");
        publicCertStr = publicCertStr.trim();
        PublicKey pk = this.readPublicKey(publicCertStr);
        this.glenixCertificateListFile = new GlenixTrnXBRL();
        this.glenixCertificateListFile.initBusiness();
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, unable to create certificate.");
        }
        GlenixCertificateList gcl = b.getOrAddGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, unable to create certificate.");
        }
        GlenixCertificate gc = gcl.addGlenixCertificate();
        if (gc == null) {
            throw new Exception("Error, unable to create certificate.");
        }
        gc.setPemEncodedPublicCertificate(profilePublicPemStr);
        gc.setPublicCertificate(publicCertStr);
        SecureRandom secureRandom = new SecureRandom();
        this.key = new byte[16];
        secureRandom.nextBytes(this.key);
        SecretKeySpec secretKey = new SecretKeySpec(this.key, "AES");
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, pk);
        byte[] enced = cipher.doFinal(this.key);
        byte[] encedBase64 = Base64.getEncoder().encode(enced);
        gc.setKey(new String(encedBase64, "UTF-8"));
        Document savedoc = this.glenixCertificateListFile.buildDocument();
        this.saveFile("glenixCertificateList.xml", savedoc);
    }

    @Override
    public boolean hasKey() {
        return this.key != null;
    }

    @Override
    public void setKey(byte[] newKey, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.key != null && Arrays.equals(this.key, newKey)) {
            return;
        }
        if (this.key == null) {
            this.key = newKey;
            return;
        }
        this.reKeyAllDataSources(newKey, pgpPrivateKey, pgpPublicKey);
    }

    private GlenixCertificate findGlenixCertificate(GlenixCertificateList gcl, PublicKey searchPK) throws Exception {
        for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
            PublicKey gcPublicKey;
            GlenixCertificate gc = gcl.getGlenixCertificate(i);
            String publicKeyDer = this.getPublicKeyDerStr(gc);
            if (publicKeyDer == null || publicKeyDer.isEmpty() || (gcPublicKey = this.readPublicKey(publicKeyDer)) == null || !Arrays.equals(gcPublicKey.getEncoded(), searchPK.getEncoded())) continue;
            return gc;
        }
        return null;
    }

    @Override
    public String getBase64EncryptedKey(PublicKey pk) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list does not have a certificate.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list does not have a certificate.");
        }
        GlenixCertificate gc = this.findGlenixCertificate(gcl, pk);
        if (gc != null) {
            return gc.getKey();
        }
        return null;
    }

    @Override
    public String getPublicKeyDerStr(GlenixCertificate gc) {
        String publicKeyDer = gc.getPublicCertificate();
        if (publicKeyDer != null && !publicKeyDer.isEmpty()) {
            return publicKeyDer;
        }
        publicKeyDer = gc.getPemEncodedPublicCertificate();
        if (publicKeyDer == null || publicKeyDer.isEmpty()) {
            return null;
        }
        publicKeyDer = publicKeyDer.replace("-----BEGIN CERTIFICATE-----\n", "");
        publicKeyDer = publicKeyDer.replace("-----END CERTIFICATE-----", "");
        publicKeyDer = publicKeyDer.replaceAll("\n", "");
        publicKeyDer = publicKeyDer.replaceAll("\r", "");
        publicKeyDer = publicKeyDer.trim();
        return publicKeyDer;
    }

    @Override
    public void addPublicKeyPem(String publicKeyPemStr, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        if (this.key == null) {
            throw new Exception("Error, key is not yet loaded.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        String publicKeyDer = publicKeyPemStr.replace("-----BEGIN CERTIFICATE-----\n", "");
        publicKeyDer = publicKeyDer.replace("-----END CERTIFICATE-----", "");
        publicKeyDer = publicKeyDer.replaceAll("\n", "");
        publicKeyDer = publicKeyDer.replaceAll("\r", "");
        PublicKey pk = this.readPublicKey(publicKeyDer = publicKeyDer.trim());
        GlenixCertificate gc = this.findGlenixCertificate(gcl, pk);
        if (gc != null) {
            throw new Exception("Error, the certificate is already in the file.");
        }
        gc = gcl.addGlenixCertificate();
        gc.setPemEncodedPublicCertificate(publicKeyPemStr);
        gc.setPublicCertificate(publicKeyDer);
        this.reKeyAllDataSources(null, pgpPrivateKey, pgpPublicKey);
    }

    @Override
    public void addPublicKey(String publicKeyDer, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        if (this.key == null) {
            throw new Exception("Error, key is not yet loaded.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        PublicKey pk = this.readPublicKey(publicKeyDer);
        GlenixCertificate gc = this.findGlenixCertificate(gcl, pk);
        if (gc != null) {
            throw new Exception("Error, the certificate is already in the file.");
        }
        gc = gcl.addGlenixCertificate();
        gc.setPublicCertificate(publicKeyDer);
        this.reKeyAllDataSources(null, pgpPrivateKey, pgpPublicKey);
    }

    @Override
    public int getCertificateCount() throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded cannot get certificate count.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption cannot get certificate count.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption cannot get certificate count.");
        }
        return gcl.getGlenixCertificateCount();
    }

    @Override
    public PublicKey getPublicKey(int i) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded cannot get certificate.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption cannot get certificate.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption cannot get certificate.");
        }
        GlenixCertificate gclgc = gcl.getGlenixCertificate(i);
        String gclpkStr = this.getPublicKeyDerStr(gclgc);
        return this.readPublicKey(gclpkStr);
    }

    @Override
    public void updateCertificate(PublicKey publicKey, byte[] newCertBytes) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        String newCert = new String(newCertBytes);
        X509Certificate x = this.readX509Certificate(newCert);
        if (x == null) {
            throw new Exception("Error cannot read new certificate bytes");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
            GlenixCertificate gclgc = gcl.getGlenixCertificate(i);
            String gclpkStr = this.getPublicKeyDerStr(gclgc);
            PublicKey gclPublicKey = this.readPublicKey(gclpkStr);
            if (gclPublicKey == null || !Arrays.equals(gclPublicKey.getEncoded(), publicKey.getEncoded())) continue;
            gclgc.setPublicCertificate(newCert);
            break;
        }
        Document savedoc = this.glenixCertificateListFile.buildDocument();
        this.saveFile("glenixCertificateList.xml", savedoc);
    }

    @Override
    public X509Certificate getSavedX509Certificate(String certString) throws Exception {
        if (certString == null || certString.isEmpty()) {
            return null;
        }
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        X509Certificate x = this.readX509Certificate(certString);
        if (x == null) {
            throw new Exception("Error cannot read new certificate bytes");
        }
        PublicKey publicKey = x.getPublicKey();
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
            GlenixCertificate gclgc = gcl.getGlenixCertificate(i);
            String gclpkStr = this.getPublicKeyDerStr(gclgc);
            X509Certificate gclx = this.readX509Certificate(gclpkStr);
            PublicKey gclPublicKey = gclx.getPublicKey();
            if (gclPublicKey == null || !Arrays.equals(gclPublicKey.getEncoded(), publicKey.getEncoded())) continue;
            return gclx;
        }
        return null;
    }

    @Override
    public void deleteGlenixCertificatesX509(List<X509Certificate> selectedCerts, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        if (gcl.getGlenixCertificateCount() == 1) {
            throw new Exception("Error, you cannot delete the last certificate otherwise no one will have access you might as well delete the whole file.");
        }
        block0: for (X509Certificate x509 : selectedCerts) {
            PublicKey gcPublicKey = x509.getPublicKey();
            if (gcPublicKey == null) continue;
            for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
                GlenixCertificate gclgc = gcl.getGlenixCertificate(i);
                String gclpkStr = this.getPublicKeyDerStr(gclgc);
                PublicKey gclPublicKey = this.readPublicKey(gclpkStr);
                if (gclPublicKey == null || !Arrays.equals(gclPublicKey.getEncoded(), gcPublicKey.getEncoded())) continue;
                gcl.deleteGlenixCertificateByIndex(i);
                continue block0;
            }
        }
        this.reKeyAllDataSources(null, pgpPrivateKey, pgpPublicKey);
    }

    @Override
    public void deleteGlenixCertificates(List<GlenixCertificate> selectedCerts, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        if (this.key == null) {
            throw new Exception("Error, key is not yet loaded.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        if (gcl.getGlenixCertificateCount() == 1) {
            throw new Exception("Error, you cannot delete the last certificate otherwise no one will have access you may as well delete the whole file.");
        }
        block0: for (GlenixCertificate gc : selectedCerts) {
            PublicKey gcPublicKey;
            String gcPkStr = this.getPublicKeyDerStr(gc);
            if (gcPkStr == null || (gcPublicKey = this.readPublicKey(gcPkStr)) == null) continue;
            for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
                GlenixCertificate gclgc = gcl.getGlenixCertificate(i);
                String gclpkStr = this.getPublicKeyDerStr(gclgc);
                PublicKey gclPublicKey = this.readPublicKey(gclpkStr);
                if (gclPublicKey == null || !Arrays.equals(gclPublicKey.getEncoded(), gcPublicKey.getEncoded())) continue;
                gcl.deleteGlenixCertificateByIndex(i);
                continue block0;
            }
        }
        this.reKeyAllDataSources(null, pgpPrivateKey, pgpPublicKey);
    }

    @Override
    public void reKeyAllDataSources(byte[] newKey, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        if (this.key == null) {
            throw new Exception("Error, key is not yet loaded.");
        }
        Business b = this.glenixCertificateListFile.getBusiness();
        if (b == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        GlenixCertificateList gcl = b.getGlenixCertificateList();
        if (gcl == null) {
            throw new Exception("Error, certificate list corruption.");
        }
        if (newKey == null) {
            SecureRandom secureRandom = new SecureRandom();
            newKey = new byte[16];
            secureRandom.nextBytes(newKey);
        }
        if (newKey == null || newKey.length != 16) {
            throw new Exception("Error, rekeying, new key must have length 16.");
        }
        ArrayList<Path> rmPaths = new ArrayList<Path>();
        Iterable<Path> dirs = this.fileSystem.getRootDirectories();
        for (Path dir : dirs) {
            DirectoryStream<Path> paths = Files.newDirectoryStream(dir);
            Iterator<Path> iterator = paths.iterator();
            while (iterator.hasNext()) {
                Path p = iterator.next();
                if (!p.toString().matches(".*[.]old$")) continue;
                rmPaths.add(p);
            }
        }
        for (Path p : rmPaths) {
            Files.delete(p);
        }
        this.skipcloseandrepoen = true;
        try {
            byte[] buffer = new byte[1024];
            ArrayList<Path> paths = this.getFileList();
            for (Path p : paths) {
                int len;
                InputStream is;
                Path rmp;
                if (p.toString().equals("/glenixCertificateList.xml")) continue;
                System.out.println("REKEYING " + p.toString());
                if (p.toString().endsWith(".pgp")) {
                    rmp = this.fileSystem.getPath(p.toString() + ".old.pgp", new String[0]);
                    Files.deleteIfExists(rmp);
                    Files.move(p, rmp, new CopyOption[0]);
                    is = this.readAndDecryptDataSource(p.toString() + ".old", pgpPrivateKey, pgpPublicKey);
                    this.saveAndEncryptStreamPGP(p.toString(), is, null);
                    continue;
                }
                rmp = this.fileSystem.getPath(p.toString() + ".old", new String[0]);
                Files.deleteIfExists(rmp);
                Files.move(p, rmp, new CopyOption[0]);
                is = this.readAndDecryptDataSource(rmp.toString(), null, null);
                OutputStream os = this.getEncryptedOutputStream(p.toString(), newKey);
                while ((len = is.read(buffer)) >= 0) {
                    if (len <= 0) continue;
                    os.write(buffer, 0, len);
                }
                is.close();
                os.flush();
                os.close();
            }
            for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
                GlenixCertificate gc = gcl.getGlenixCertificate(i);
                String publicKeyDer = this.getPublicKeyDerStr(gc);
                PublicKey gcPublicKey = this.readPublicKey(publicKeyDer);
                if (gcPublicKey == null) continue;
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(1, gcPublicKey);
                byte[] enced = cipher.doFinal(newKey);
                byte[] encedBase64 = Base64.getEncoder().encode(enced);
                gc.setKey(new String(encedBase64, "UTF-8"));
            }
            Document savedoc = this.glenixCertificateListFile.buildDocument();
            this.saveFile("glenixCertificateList.xml", savedoc);
            this.key = newKey;
            rmPaths = new ArrayList();
            paths = this.getFileList();
            for (Path p : paths) {
                if (p.toString().matches(".*[.]old$")) {
                    rmPaths.add(p);
                    continue;
                }
                if (!p.toString().matches(".*[.]old.pgp$")) continue;
                rmPaths.add(p);
            }
            for (Path p : rmPaths) {
                Files.delete(p);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.skipcloseandrepoen = false;
        }
        this.closeAndReopenFile();
    }

    @Override
    public void copyAllDataSources(GlenixFile sourceGlenixFile, PGPPrivateKey pgpPrivateKey, PGPPublicKey pgpPublicKey) throws Exception {
        if (this.glenixCertificateListFile == null) {
            throw new Exception("Error, certificate list is not yet loaded.");
        }
        if (this.key == null) {
            throw new Exception("Error, key is not yet loaded.");
        }
        Document gcdoc = sourceGlenixFile.getDocument("glenixCertificateList.xml");
        if (gcdoc != null) {
            GlenixCertificateList gcl;
            GlenixTrnXBRL glenixTrnXBRLFileAccess = new GlenixTrnXBRL();
            glenixTrnXBRLFileAccess.loadDocumentElement(gcdoc, gcdoc.getDocumentElement());
            Business business = glenixTrnXBRLFileAccess.getBusiness();
            if (business != null && (gcl = business.getGlenixCertificateList()) != null) {
                ArrayList<GlenixCertificate> gcal = gcl.getGlenixCertificateList();
                for (int i = 0; i < gcal.size(); ++i) {
                    GlenixCertificate gc = gcal.get(i);
                    String derStr = gc.getPublicCertificate();
                    try {
                        this.addPublicKey(derStr, pgpPrivateKey, pgpPublicKey);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        byte[] buffer = new byte[1024];
        ArrayList<Path> sourceFilesList = sourceGlenixFile.getFileList();
        for (Path sourcePath : sourceFilesList) {
            int len;
            if (sourcePath.toString().equals("/glenixCertificateList.xml")) continue;
            System.out.println("Saving " + sourcePath.toString());
            if (sourcePath.toString().endsWith(".pgp")) {
                String dataSource = sourcePath.toString();
                dataSource = dataSource.substring(0, dataSource.length() - 4);
                InputStream is = sourceGlenixFile.readAndDecryptDataSource(dataSource, pgpPrivateKey, pgpPublicKey);
                this.saveAndEncryptStreamPGP(sourcePath.toString(), is, null);
                continue;
            }
            InputStream is = sourceGlenixFile.readAndDecryptDataSource(sourcePath.toString(), null, null);
            OutputStream os = this.getEncryptedOutputStream(sourcePath.toString(), this.key);
            while ((len = is.read(buffer)) >= 0) {
                if (len <= 0) continue;
                os.write(buffer, 0, len);
            }
            is.close();
            os.flush();
            os.close();
        }
        this.closeAndReopenFile();
    }

    public class GlenixEncryptedOutputStream
    extends OutputStream {
        private Path pgpZipFileDataSource;
        private OutputStream pgpZfos;
        private OutputStream pOut;
        private PGPCompressedDataGenerator compressedData;
        private OutputStream writeToEncrypt;
        private PGPLiteralDataGenerator lData;

        public GlenixEncryptedOutputStream(String dataSource) throws Exception {
            this.pgpZipFileDataSource = GlenixFilePGP.this.fileSystem.getPath(dataSource, new String[0]);
            this.pgpZfos = Files.newOutputStream(this.pgpZipFileDataSource, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            JcePGPDataEncryptorBuilder dataEncryptor = new JcePGPDataEncryptorBuilder(7);
            dataEncryptor.setWithIntegrityPacket(true);
            dataEncryptor.setSecureRandom(new SecureRandom());
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptor);
            Business b = GlenixFilePGP.this.glenixCertificateListFile.getBusiness();
            if (b == null) {
                throw new Exception("Error, certificate list corruption.");
            }
            GlenixCertificateList gcl = b.getGlenixCertificateList();
            if (gcl == null) {
                throw new Exception("Error, certificate list corruption.");
            }
            for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
                GlenixCertificate gc = gcl.getGlenixCertificate(i);
                String publicKeyDer = GlenixFilePGP.this.getPublicKeyDerStr(gc);
                X509Certificate x509 = GlenixFilePGP.this.readX509Certificate(publicKeyDer);
                PublicKey gcPublicKey = x509.getPublicKey();
                Date notBefore = x509.getNotBefore();
                System.out.println("OS NOT BEFORE = " + notBefore);
                JcaPGPKeyConverter converter = new JcaPGPKeyConverter();
                PGPPublicKey pgpPublicKey = converter.getPGPPublicKey(2, gcPublicKey, notBefore);
                encryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pgpPublicKey).setProvider("BC"));
            }
            byte[] encbuffer = new byte[1024];
            this.writeToEncrypt = encryptedDataGenerator.open(this.pgpZfos, encbuffer);
            this.compressedData = new PGPCompressedDataGenerator(1);
            byte[] buffer = new byte[1024];
            this.lData = new PGPLiteralDataGenerator();
            this.pOut = this.lData.open(this.compressedData.open(this.writeToEncrypt), 'b', dataSource, new Date(), buffer);
        }

        @Override
        public void close() throws IOException {
            this.pOut.flush();
            this.writeToEncrypt.flush();
            this.pgpZfos.flush();
            this.pOut.close();
            this.lData.close();
            this.compressedData.close();
            this.writeToEncrypt.close();
            this.pgpZfos.close();
            GlenixFilePGP.this.closeAndReopenFile();
        }

        @Override
        public void flush() throws IOException {
            this.pOut.flush();
            this.writeToEncrypt.flush();
            this.pgpZfos.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.pOut.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.pOut.write(b);
        }
    }
}

