/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixFile;
import au.com.glenix.widget.GlenixBranchController;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javax.swing.SwingUtilities;

public class GlenixFileListController
extends GlenixBranchController {
    @FXML
    protected Label error_message;
    @FXML
    protected TableView fileTable;
    @FXML
    protected TableColumn fileNameColumn;
    protected ApplicationController xbrlFileController = null;
    protected GlenixFile glenixFile = null;
    protected ArrayList<Path> paths = null;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;

    public GlenixFileListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.fileTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                Path path;
                if (event.getClickCount() == 2 && !row.isEmpty() && (path = (Path)row.getItem()) != null) {
                    try {
                        this.openFile(path);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_message.setText("Error, could not open file.");
                        this.xbrlFileController.setStatusBarMessage("Error, could not open file.");
                    }
                }
            });
            return row;
        });
        this.fileNameColumn.setCellFactory((Callback)new Callback<TableColumn<Path, Path>, TableCell<Path, Path>>(){

            public TableCell call(TableColumn<Path, Path> param) {
                TableCell<Path, Path> cell = new TableCell<Path, Path>(){

                    public void updateItem(Path item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            Path p = (Path)this.getTableRow().getItem();
                            this.setText(p.toString());
                        }
                    }
                };
                return cell;
            }
        });
        this.fileTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public void openFile(Path path) {
        block17: {
            try {
                if (path == null) {
                    throw new Exception("Error, cannot open null file.");
                }
                InputStream is = null;
                String filename = path.toString();
                filename = filename.endsWith(".pgp") ? filename.substring(1, filename.length() - 4) : filename.substring(1, filename.length());
                is = path.getFileName().toString().equals("glenixCertificateList.xml") ? this.xbrlFileController.readDataSource(path.getFileName().toString()) : this.xbrlFileController.getFileDecrypt(filename);
                if (is == null) break block17;
                String saveFileName = path.getFileName().toString();
                if (saveFileName.endsWith(".pgp")) {
                    saveFileName = saveFileName.substring(0, saveFileName.length() - 4);
                }
                final File file = this.xbrlFileController.createOtherFile(saveFileName);
                try (FileOutputStream out = new FileOutputStream(file);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    out.flush();
                    out.close();
                    is.close();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Desktop.getDesktop().open(file);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    public String getCurrentDirectory() {
        return null;
    }

    public void refreshTable() {
        try {
            this.paths = this.xbrlFileController.getFileList(this.getCurrentDirectory());
            if (this.paths != null && this.fileTable != null) {
                ObservableList pathObservableList = FXCollections.observableList(this.paths);
                this.fileTable.setItems(pathObservableList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void deleteSelectedFiles() {
        try {
            ObservableList selectedFiles = this.fileTable.getSelectionModel().getSelectedItems();
            if (selectedFiles != null && selectedFiles.size() > 0) {
                this.xbrlFileController.deleteSelectedFiles((ObservableList<Path>)selectedFiles);
            } else {
                String message = "Error, there are no selected files to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void importFile() {
        try {
            File f = this.xbrlFileController.openOtherFile(null);
            if (f != null) {
                FileInputStream is = new FileInputStream(f);
                String dir = this.getCurrentDirectory();
                if (dir == null || dir.isEmpty()) {
                    this.xbrlFileController.saveFileEncryptStream(f.getName(), is);
                } else {
                    this.xbrlFileController.makeFileDirectory(dir);
                    this.xbrlFileController.saveFileEncryptStream(dir + f.getName(), is);
                }
                this.error_message.setText("Saved " + f.getName());
                this.xbrlFileController.setStatusBarMessage("Saved " + f.getName());
                this.refreshTable();
            } else {
                this.error_message.setText("No file selected");
                this.xbrlFileController.setStatusBarMessage("No file selected");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

