/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixFileListController;
import au.com.glenix.widget.GlenixFlowPane;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class GlenixFileImagesController
extends GlenixFileListController {
    @FXML
    private GlenixFlowPane fp1;
    @FXML
    private Label error_message;
    @FXML
    private TableView fileTable;
    @FXML
    private TableColumn fileNameColumn;
    private ApplicationController xbrlFileController = null;
    private GlenixFile glenixFile = null;
    private ArrayList<Path> paths = null;
    private String pattern = "dd MMM yyyy";
    private DateTimeFormatter displayDateFormatter;

    public GlenixFileImagesController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public String getCurrentDirectory() {
        return "images/";
    }

    @FXML
    private void importFile() {
        try {
            File f = this.xbrlFileController.openOtherFile(null);
            if (f != null) {
                FileInputStream is = new FileInputStream(f);
                this.xbrlFileController.makeFileDirectory("images");
                this.xbrlFileController.saveFileEncryptStream("images/" + f.getName(), is);
                this.error_message.setText("Saved " + f.getName());
                this.xbrlFileController.setStatusBarMessage("Saved " + f.getName());
                this.refreshTable();
            } else {
                this.error_message.setText("No file selected");
                this.xbrlFileController.setStatusBarMessage("No file selected");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoDocumentLayout() {
        try {
            this.xbrlFileController.gotoDocumentLayout();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }
}

