/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.GlenixNodeSet;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.MessageDetails;
import au.com.glenix.trn.AUSKeyCredential;
import au.com.glenix.trn.AUSKeyCredentialStore;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import javafx.collections.ObservableList;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlenixAUSKey {
    private String publicCertificateString = null;
    private String publicCertificateStringMime = null;
    private String protectedPrivateKeyString = null;
    private String b64binarysecuritytoken = null;
    private Collection<X509Certificate> certCollection;
    private X509Certificate firstCert;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private PKCS10CertificationRequest certificateSigningRequest = null;
    private MessageDigest digest = null;
    private DocumentBuilder dBuilder;
    private String BinarySecurityToken_id = "BinarySecurityToken-1";
    byte[] testSignature;
    private Transformer transformer;
    protected String pbeAlgName = "PBEWithSHA1AndDESede";
    private AUSKeyCredentialStore ausKeyCredentialStore = null;
    private Date generateCSRDate = null;
    private String stsurl = null;
    private String stsurlhost = null;
    private String productID = null;
    private String companyNameSBR = null;
    private String softwareNameSBR = null;
    private String versionNumberSBR = null;
    private String productName = null;
    private String versionNumber = null;

    public GlenixAUSKey() throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        this.dBuilder = dbFactory.newDocumentBuilder();
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "no");
        this.transformer.setOutputProperty("method", "xml");
        this.transformer.setOutputProperty("encoding", "UTF-8");
        this.transformer.setOutputProperty("standalone", "yes");
    }

    public void setStsurl(String stsurl) {
        this.stsurl = stsurl;
    }

    public void setStsurlhost(String stsurlhost) {
        this.stsurlhost = stsurlhost;
    }

    public void setProductID(String productID) {
        this.productID = productID;
    }

    public void setCompanyNameSBR(String companyNameSBR) {
        this.companyNameSBR = companyNameSBR;
    }

    public void setSoftwareNameSBR(String softwareNameSBR) {
        this.softwareNameSBR = softwareNameSBR;
    }

    public void setVersionNumberSBR(String versionNumberSBR) {
        this.versionNumberSBR = versionNumberSBR;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    private void setPublicCertificate(String publicCertificateString) throws Exception {
        this.publicCertificateString = publicCertificateString;
        byte[] bytes = java.util.Base64.getDecoder().decode(publicCertificateString);
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        this.publicCertificateStringMime = encoder.encodeToString(bytes);
        this.extractX509Certificate();
        this.publicKey = this.firstCert.getPublicKey();
    }

    public void setProtectedPrivateKey(String protectedPrivateKeyString) {
        this.protectedPrivateKeyString = protectedPrivateKeyString;
    }

    public void setPublicKeyBase64TestFirst(String base64PublicCert) throws Exception {
        X509Certificate x = this.extractX509Certificate(base64PublicCert);
        if (x == null) {
            throw new Exception("Error, certificate is not valid");
        }
        this.publicCertificateString = base64PublicCert;
        byte[] bytes = java.util.Base64.getDecoder().decode(this.publicCertificateString);
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        this.publicCertificateStringMime = encoder.encodeToString(bytes);
        this.extractX509Certificate();
        this.publicKey = this.firstCert.getPublicKey();
    }

    public X509Certificate setPublicKeyBase64(String base64PublicCert) throws Exception {
        this.publicCertificateString = base64PublicCert;
        byte[] bytes = java.util.Base64.getMimeDecoder().decode(this.publicCertificateString);
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        this.publicCertificateStringMime = encoder.encodeToString(bytes);
        this.extractX509Certificate();
        this.publicKey = this.firstCert.getPublicKey();
        return this.firstCert;
    }

    public void setPublicKeyPEM(String pemPublicCert) throws Exception {
        String publicCertString = pemPublicCert.replaceFirst("-----BEGIN CERTIFICATE-----", "");
        publicCertString = publicCertString.replaceFirst("-----END CERTIFICATE-----", "");
        this.setPublicKeyBase64(publicCertString.trim());
    }

    public String getPublicKeyPEM() {
        if (this.publicCertificateString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        sb.append(this.publicCertificateStringMime);
        sb.append("\n-----END CERTIFICATE-----");
        return sb.toString();
    }

    public String getPublicKeyPEM(X509Certificate x509) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        byte[] bytes = x509.getEncoded();
        sb.append(encoder.encodeToString(bytes));
        sb.append("\n-----END CERTIFICATE-----");
        return sb.toString();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean matchPublicKey(PublicKey pk) {
        return this.publicKey.equals(pk);
    }

    public String getBase64PublicKeyOneLine() {
        return this.publicCertificateString.replaceAll("\r", "").replaceAll("\n", "").trim();
    }

    public String getBase64PublicKeyOneLineFromPEM(String pemString) {
        if (pemString == null || pemString.isEmpty()) {
            return null;
        }
        pemString = pemString.replaceFirst("-----BEGIN CERTIFICATE-----", "");
        pemString = pemString.replaceFirst("-----END CERTIFICATE-----", "");
        return pemString.replaceAll("\r", "").replaceAll("\n", "").trim();
    }

    public String getBase64ProtectedPrivateKey() {
        return this.protectedPrivateKeyString;
    }

    public String getBase64ProtectedPrivateKeyOneLine() {
        return this.protectedPrivateKeyString.replaceAll("\r", "").replaceAll("\n", "");
    }

    public String getProtectedPrivateKeyPEM() {
        if (this.protectedPrivateKeyString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN ENCRYPTED PRIVATE KEY-----\n");
        sb.append(this.protectedPrivateKeyString);
        sb.append("\n-----END ENCRYPTED PRIVATE KEY-----");
        return sb.toString();
    }

    public String getPublicKeyIdentifier() throws Exception {
        MessageDigest md = this.calcDigestBytes(this.publicKey.getEncoded(), "SHA-1");
        String result = java.util.Base64.getEncoder().withoutPadding().encodeToString(md.digest());
        return result.replace('+', '-').replace('/', '_');
    }

    public ObservableList getCredentialObservableList(String ausKeyFilePath) throws Exception {
        if (this.ausKeyCredentialStore == null) {
            throw new Exception("Error, you need to load the AUS key first");
        }
        return this.ausKeyCredentialStore.getCredentialObservableList();
    }

    public List getCredentialList() throws Exception {
        if (this.ausKeyCredentialStore == null) {
            throw new Exception("Error, you need to load the AUS key first");
        }
        return this.ausKeyCredentialStore.getCredentialList();
    }

    public void loadAUSKey(String ausKeyFilePath) throws Exception {
        if (ausKeyFilePath == null || ausKeyFilePath.isEmpty()) {
            return;
        }
        Document doc = this.dBuilder.parse(new FileInputStream(ausKeyFilePath));
        if (doc == null) {
            return;
        }
        this.ausKeyCredentialStore = new AUSKeyCredentialStore();
        this.ausKeyCredentialStore.loadDocumentElement(doc, doc.getDocumentElement());
    }

    public void loadCredential(String credentialID) throws Exception {
        if (this.ausKeyCredentialStore == null) {
            throw new Exception("Error, you need to load the AUS key first");
        }
        AUSKeyCredential ausKeyCredential = this.ausKeyCredentialStore.getAUSKeyCredential(credentialID);
        String protectedPrivateKey = ausKeyCredential.getProtectedPrivateKey();
        String publicCertificate = ausKeyCredential.getPublicCertificate();
        if (protectedPrivateKey == null || protectedPrivateKey.equals("")) {
            throw new Exception("Error, unable to get protectedPrivateKey for the requested credential id");
        }
        if (publicCertificate == null || publicCertificate.equals("")) {
            throw new Exception("Error, unable to get publicCertificate for the requested credential id");
        }
        this.setPublicCertificate(publicCertificate);
        this.setProtectedPrivateKey(protectedPrivateKey);
    }

    public void unprotectPrivateKey(char[] password) throws Exception {
        this.privateKey = null;
        if (this.publicCertificateString != null) {
            try {
                byte[] pkcs8Data = java.util.Base64.getDecoder().decode(this.protectedPrivateKeyString);
                PBEKeySpec pbeSpec = new PBEKeySpec(password);
                EncryptedPrivateKeyInfo pkinfo = new EncryptedPrivateKeyInfo(pkcs8Data);
                SecretKeyFactory skf = SecretKeyFactory.getInstance(pkinfo.getAlgName());
                SecretKey secret = skf.generateSecret(pbeSpec);
                PKCS8EncodedKeySpec keySpec = pkinfo.getKeySpec(secret);
                KeyFactory kf = KeyFactory.getInstance("RSA");
                this.privateKey = kf.generatePrivate(keySpec);
            }
            catch (InvalidKeyException ik) {
                throw new Exception("Error, password is incorrect");
            }
        }
    }

    public void reprotectPrivateKey() {
        this.privateKey = null;
    }

    public void generateProtectedPrivateKey(char[] password) throws Exception {
        if (this.privateKey == null) {
            throw new Exception("Private key is null, generate first");
        }
        byte[] encodedprivkey = this.privateKey.getEncoded();
        int count = 100100;
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.pbeAlgName);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance(this.pbeAlgName);
        pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
        byte[] ciphertext = pbeCipher.doFinal(encodedprivkey);
        AlgorithmParameters algparms = AlgorithmParameters.getInstance(this.pbeAlgName);
        algparms.init(pbeParamSpec);
        EncryptedPrivateKeyInfo encinfo = new EncryptedPrivateKeyInfo(algparms, ciphertext);
        byte[] encryptedPkcs8 = encinfo.getEncoded();
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        this.protectedPrivateKeyString = new String(encoder.encode(encryptedPkcs8));
    }

    public void generatePrivateKey(char[] password, String commonName) throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        SecureRandom sr = SecureRandom.getInstanceStrong();
        kpGen.initialize(2048, sr);
        KeyPair pair = kpGen.generateKeyPair();
        this.privateKey = pair.getPrivate();
        this.publicKey = pair.getPublic();
        SecureRandom random = new SecureRandom();
        X500Name subject = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, commonName).build();
        byte[] id = new byte[20];
        random.nextBytes(id);
        BigInteger serial = new BigInteger(160, random);
        long genMillis = System.currentTimeMillis();
        Date d = new Date(genMillis - 86400000L);
        LocalDate ld = LocalDate.now();
        LocalDateTime ldt = ld.atStartOfDay();
        LocalDate ldend = LocalDate.now().plusYears(5L);
        LocalDateTime ldendt = ldend.atStartOfDay();
        JcaX509v3CertificateBuilder certificate = new JcaX509v3CertificateBuilder(subject, serial, Date.from(ldt.toInstant(ZoneOffset.UTC)), Date.from(ldendt.toInstant(ZoneOffset.UTC)), subject, this.publicKey);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(this.privateKey);
        X509CertificateHolder holder = certificate.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        converter.setProvider(new BouncyCastleProvider());
        this.firstCert = converter.getCertificate(holder);
        this.publicCertificateString = this.b64binarysecuritytoken = java.util.Base64.getEncoder().encodeToString(this.firstCert.getEncoded());
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        this.publicCertificateStringMime = encoder.encodeToString(this.firstCert.getEncoded());
        this.generateProtectedPrivateKey(password);
    }

    public void setCommonName(String commonName) throws Exception {
        boolean isSigned = true;
        try {
            this.x509CertificateIsSigned(this.firstCert);
        }
        catch (Exception e) {
            isSigned = false;
        }
        if (isSigned) {
            throw new Exception("Error, this certificate is signed cannot change name");
        }
        SecureRandom random = new SecureRandom();
        X500Name subject = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, commonName).build();
        byte[] id = new byte[20];
        random.nextBytes(id);
        BigInteger serial = new BigInteger(160, random);
        LocalDate ld = LocalDate.now();
        LocalDateTime ldt = ld.atStartOfDay();
        LocalDate ldend = LocalDate.now().plusYears(5L);
        LocalDateTime ldendt = ldend.atStartOfDay();
        JcaX509v3CertificateBuilder certificate = new JcaX509v3CertificateBuilder(subject, serial, Date.from(ldt.toInstant(ZoneOffset.UTC)), Date.from(ldendt.toInstant(ZoneOffset.UTC)), subject, this.publicKey);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(this.privateKey);
        X509CertificateHolder holder = certificate.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        converter.setProvider(new BouncyCastleProvider());
        this.firstCert = converter.getCertificate(holder);
        this.publicCertificateString = this.b64binarysecuritytoken = java.util.Base64.getEncoder().encodeToString(this.firstCert.getEncoded());
        byte[] linebreak = new byte[]{10};
        Base64.Encoder encoder = java.util.Base64.getMimeEncoder(64, linebreak);
        this.publicCertificateStringMime = encoder.encodeToString(this.firstCert.getEncoded());
    }

    public void printPublicKeyChecksum() {
        if (this.publicKey == null) {
            System.out.println("Public key checksum: null");
            return;
        }
    }

    public void generateCSR(String commonName, String email) throws Exception {
        if (this.privateKey == null || this.publicKey == null) {
            throw new Exception("generateCSR is not ready, generate private key first");
        }
        String tmp = "CN=" + commonName;
        if (email != null) {
            tmp = tmp + ", EMAILADDRESS=" + email;
        }
        X500Principal xp = new X500Principal(tmp);
        this.certificateSigningRequest = new PKCS10CertificationRequest("SHA256withRSA", xp, this.publicKey, null, this.privateKey);
    }

    public InputStream getCSRInputStream() throws Exception {
        if (this.certificateSigningRequest == null) {
            throw new Exception("getCSRInputStream is not ready, generateCSR first");
        }
        PipedInputStream attinpipe = new PipedInputStream();
        final PipedOutputStream attoutpipe = new PipedOutputStream(attinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PEMWriter pemWrt = new PEMWriter(new OutputStreamWriter(attoutpipe));
                    pemWrt.writeObject(GlenixAUSKey.this.certificateSigningRequest);
                    pemWrt.flush();
                    pemWrt.close();
                    attoutpipe.flush();
                    attoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return attinpipe;
    }

    public MessageDigest getCSRDigest(String commonName) throws Exception {
        this.digest = this.calcDigest(this.getCSRInputStream(), "SHA-1");
        return this.digest;
    }

    public void extractX509Certificate() throws Exception {
        if (this.publicCertificateString != null) {
            String tmpString = this.publicCertificateString.replaceAll("\n", "");
            tmpString = tmpString.replaceAll("\r", "");
            byte[] pubcertbytes = java.util.Base64.getDecoder().decode(tmpString);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(pubcertbytes);
            this.certCollection = cf.generateCertificates(bis);
            Iterator<X509Certificate> certIterator = this.certCollection.iterator();
            if (certIterator.hasNext()) {
                this.firstCert = certIterator.next();
                this.b64binarysecuritytoken = java.util.Base64.getEncoder().encodeToString(this.firstCert.getEncoded());
            }
        }
    }

    public X509Certificate extractX509Certificate(String aPublicCertificateString) throws Exception {
        if (aPublicCertificateString != null) {
            ByteArrayInputStream bis;
            String tmpString = aPublicCertificateString.replaceAll("\n", "");
            tmpString = tmpString.replaceAll("\r", "");
            byte[] pubcertbytes = java.util.Base64.getDecoder().decode(tmpString);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> aCertCollection = cf.generateCertificates(bis = new ByteArrayInputStream(pubcertbytes));
            Iterator<? extends Certificate> certIterator = aCertCollection.iterator();
            if (certIterator.hasNext()) {
                return (X509Certificate)certIterator.next();
            }
        }
        return null;
    }

    public X509Certificate extractX509CertificatePEM(String aPemPublicCertificateString) throws Exception {
        return this.extractX509Certificate(this.getBase64PublicKeyOneLineFromPEM(aPemPublicCertificateString));
    }

    public void loadOtherCredential(char[] password) throws Exception {
        this.privateKey = null;
        if (this.publicCertificateString != null && this.protectedPrivateKeyString != null) {
            byte[] pkcs8Data = java.util.Base64.getDecoder().decode(this.protectedPrivateKeyString);
            PBEKeySpec pbeSpec = new PBEKeySpec(password);
            EncryptedPrivateKeyInfo pkinfo = new EncryptedPrivateKeyInfo(pkcs8Data);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(pkinfo.getAlgName());
            SecretKey secret = skf.generateSecret(pbeSpec);
            PKCS8EncodedKeySpec keySpec = pkinfo.getKeySpec(secret);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.privateKey = kf.generatePrivate(keySpec);
            byte[] pubcertbytes = java.util.Base64.getDecoder().decode(this.publicCertificateString);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(pubcertbytes);
            this.certCollection = cf.generateCertificates(bis);
            Iterator<X509Certificate> certIterator = this.certCollection.iterator();
            if (certIterator.hasNext()) {
                this.firstCert = certIterator.next();
                this.b64binarysecuritytoken = java.util.Base64.getEncoder().encodeToString(this.firstCert.getEncoded());
            }
        }
    }

    public boolean verifyPassword(char[] password) throws Exception {
        if (this.publicCertificateString != null && this.protectedPrivateKeyString != null) {
            byte[] pkcs8Data = java.util.Base64.getDecoder().decode(this.protectedPrivateKeyString);
            PBEKeySpec pbeSpec = new PBEKeySpec(password);
            EncryptedPrivateKeyInfo pkinfo = new EncryptedPrivateKeyInfo(pkcs8Data);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(pkinfo.getAlgName());
            SecretKey secret = skf.generateSecret(pbeSpec);
            PKCS8EncodedKeySpec keySpec = pkinfo.getKeySpec(secret);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey tmpPrivateKey = kf.generatePrivate(keySpec);
            return tmpPrivateKey != null;
        }
        return false;
    }

    public int getOtherCredentialIterations() throws Exception {
        byte[] pkcs8Data = java.util.Base64.getDecoder().decode(this.protectedPrivateKeyString);
        EncryptedPrivateKeyInfo pkinfo = new EncryptedPrivateKeyInfo(pkcs8Data);
        PBEParameterSpec pbeParamSpec = pkinfo.getAlgParameters().getParameterSpec(PBEParameterSpec.class);
        return pbeParamSpec.getIterationCount();
    }

    public byte[] buildGzippedData(List<GlenixSBRAttachment> attachments, OutputStream ungzippedLogFileOS) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(output), "UTF-8");
        byte[] bs = new byte[1000];
        int readlen = 0;
        if (attachments != null) {
            for (int i = 0; i < attachments.size(); ++i) {
                GlenixSBRAttachment attachment = attachments.get(i);
                writer.write("<Record_Delimiter DocumentID=\"");
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8("<Record_Delimiter DocumentID=\"", ungzippedLogFileOS, null);
                }
                writer.write(attachment.getDocumentID());
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8(attachment.getDocumentID(), ungzippedLogFileOS, null);
                }
                writer.write("\" DocumentType=\"");
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8("\" DocumentType=\"", ungzippedLogFileOS, null);
                }
                writer.write(attachment.getDocumentType());
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8(attachment.getDocumentType(), ungzippedLogFileOS, null);
                }
                writer.write("\" DocumentName=\"");
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8("\" DocumentName=\"", ungzippedLogFileOS, null);
                }
                writer.write(attachment.getDocumentName());
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8(attachment.getDocumentName(), ungzippedLogFileOS, null);
                }
                writer.write("\" RelatedDocumentID=\"");
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8("\" RelatedDocumentID=\"", ungzippedLogFileOS, null);
                }
                writer.write(attachment.getRelatedDocumentID());
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8(attachment.getRelatedDocumentID(), ungzippedLogFileOS, null);
                }
                writer.write("\"/>\n");
                if (ungzippedLogFileOS != null) {
                    this.writeUTF8("\"/>\n", ungzippedLogFileOS, null);
                }
                InputStream is = attachment.getInputStream();
                while ((readlen = is.read(bs)) >= 0) {
                    writer.write(new String(bs, 0, readlen));
                    if (ungzippedLogFileOS == null) continue;
                    this.writeUTF8(new String(bs, 0, readlen), ungzippedLogFileOS, null);
                }
                writer.write("\n");
                if (ungzippedLogFileOS == null) continue;
                this.writeUTF8("\n", ungzippedLogFileOS, null);
            }
        }
        ((Writer)writer).close();
        output.close();
        return output.toByteArray();
    }

    public MessageDigest calcDigestBytes(byte[] bytes, String digestMethod) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(digestMethod);
        digest.reset();
        digest.update(bytes);
        return digest;
    }

    public MessageDigest calcDigestBatch(List<GlenixSBRAttachment> attachments, String digestMethod) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(digestMethod);
        digest.reset();
        StringBuilder sb = new StringBuilder();
        byte[] bs = new byte[1000];
        int readlen = 0;
        if (attachments != null) {
            for (int i = 0; i < attachments.size(); ++i) {
                GlenixSBRAttachment attachment = attachments.get(i);
                digest.update("<Record_Delimiter DocumentID=\"".getBytes("UTF-8"));
                digest.update(attachment.getDocumentID().getBytes("UTF-8"));
                digest.update("\" DocumentType=\"".getBytes("UTF-8"));
                digest.update(attachment.getDocumentType().getBytes("UTF-8"));
                digest.update("\" DocumentName=\"".getBytes("UTF-8"));
                digest.update(attachment.getDocumentName().getBytes("UTF-8"));
                digest.update("\" RelatedDocumentID=\"".getBytes("UTF-8"));
                digest.update(attachment.getRelatedDocumentID().getBytes("UTF-8"));
                digest.update("\"/>\r\n".getBytes("UTF-8"));
                InputStream is = attachment.getInputStream();
                while ((readlen = is.read(bs)) >= 0) {
                    digest.update(bs, 0, readlen);
                }
                digest.update("\r\n".getBytes());
            }
        }
        return digest;
    }

    public void updateDigestInclusive(MessageDigest digest, Node node, boolean firstLine) throws Exception {
        String line;
        GlenixNodeSet data = new GlenixNodeSet(node, null);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        OctetStreamData transformedData = (OctetStreamData)canonicalizationMethod.transform(data, null);
        StringBuilder textBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(transformedData.getOctetStream()));
        while ((line = br.readLine()) != null) {
            if (firstLine) {
                textBuilder.append(line);
                digest.update(line.getBytes("UTF-8"), 0, line.length());
                firstLine = false;
                continue;
            }
            textBuilder.append("\n");
            textBuilder.append(line);
            digest.update(("\n" + line).getBytes("UTF-8"), 0, line.length() + 1);
        }
    }

    public void updateDigest(MessageDigest digest, Node node, boolean firstLine) throws Exception {
        String line;
        GlenixNodeSet data = new GlenixNodeSet(node, null);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        OctetStreamData transformedData = (OctetStreamData)canonicalizationMethod.transform(data, null);
        StringBuilder textBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(transformedData.getOctetStream()));
        while ((line = br.readLine()) != null) {
            if (firstLine) {
                textBuilder.append(line);
                digest.update(line.getBytes("UTF-8"), 0, line.length());
                firstLine = false;
                continue;
            }
            textBuilder.append("\n");
            textBuilder.append(line);
            digest.update(("\n" + line).getBytes("UTF-8"), 0, line.length() + 1);
        }
    }

    public MessageDigest calcDigest(Node node, String digestMethod) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(digestMethod);
        digest.reset();
        this.updateDigest(digest, node, true);
        return digest;
    }

    public MessageDigest calcDigestInclusive(Node node, String digestMethod) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(digestMethod);
        digest.reset();
        this.updateDigestInclusive(digest, node, true);
        return digest;
    }

    public MessageDigest calcDigest(InputStream is, String digestMethod) throws Exception {
        int readlength;
        MessageDigest digest = MessageDigest.getInstance(digestMethod);
        digest.reset();
        byte[] isbytes = new byte[8096];
        while ((readlength = is.read(isbytes)) >= 0) {
            digest.update(isbytes, 0, readlength);
        }
        return digest;
    }

    public Node buildAndSendSTSDocument(String stsurl, String endpointref_address) throws Exception {
        Document stsdoc = this.buildSTSDocument(stsurl, endpointref_address);
        return this.sendSTSDocument(stsdoc);
    }

    public Document buildSTSDocument(String stsurl, String endpointref_address) throws Exception {
        Document doc = this.dBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element node_Envelope = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "soapenv:Envelope");
        doc.appendChild(node_Envelope);
        Element node_Header = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "soapenv:Header");
        node_Header.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa", "http://www.w3.org/2005/08/addressing");
        node_Envelope.appendChild(node_Header);
        Element node_Security = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        node_Security.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        node_Header.appendChild(node_Security);
        node_Security.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "soapenv:MustUnderstand", "1");
        node_Security.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "soapenv:mustUnderstand", "true");
        Element node_Timestamp = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        node_Timestamp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        node_Security.appendChild(node_Timestamp);
        Attr attrT = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrT.setPrefix("wsu");
        attrT.setValue("Timestamp");
        node_Timestamp.setAttributeNodeNS(attrT);
        node_Timestamp.setIdAttributeNode(attrT, true);
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        Element node_Created = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        node_Timestamp.appendChild(node_Created);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String created_timestamp = isoFormat.format(date);
        node_Created.setTextContent(created_timestamp);
        Element node_Expires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        node_Timestamp.appendChild(node_Expires);
        date.setTime(date.getTime() + 300000L);
        node_Expires.setTextContent(isoFormat.format(date));
        date.setTime(date.getTime() + 1500000L);
        String expires30_timestamp = isoFormat.format(date);
        Element node_BinarySecurityToken = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        node_BinarySecurityToken.setTextContent(this.b64binarysecuritytoken);
        node_Security.appendChild(node_BinarySecurityToken);
        node_BinarySecurityToken.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrB.setPrefix("wsu");
        attrB.setValue(this.BinarySecurityToken_id);
        node_BinarySecurityToken.setAttributeNodeNS(attrB);
        node_BinarySecurityToken.setIdAttributeNode(attrB, true);
        node_BinarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        node_BinarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Element node_To = doc.createElementNS("http://www.w3.org/2005/08/addressing", "wsa:To");
        node_To.setTextContent(stsurl);
        node_Header.appendChild(node_To);
        node_To.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attr = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attr.setPrefix("wsu");
        attr.setValue("stsurl-1");
        node_To.setAttributeNodeNS(attr);
        node_To.setIdAttributeNode(attr, true);
        String uuid = UUID.randomUUID().toString();
        Element node_MessageID = doc.createElementNS("http://www.w3.org/2005/08/addressing", "wsa:MessageID");
        node_MessageID.setTextContent(uuid);
        node_Header.appendChild(node_MessageID);
        Element node_Action = doc.createElementNS("http://www.w3.org/2005/08/addressing", "wsa:Action");
        node_Action.setTextContent("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue");
        node_Header.appendChild(node_Action);
        Element node_Body = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "soapenv:Body");
        node_Envelope.appendChild(node_Body);
        Element node_RequestSecurityToken = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:RequestSecurityToken");
        node_Body.appendChild(node_RequestSecurityToken);
        Element node_RequestType = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:RequestType");
        node_RequestType.setTextContent("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue");
        node_RequestSecurityToken.appendChild(node_RequestType);
        Element node_AppliesTo = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp:AppliesTo");
        node_RequestSecurityToken.appendChild(node_AppliesTo);
        Element node_EndpointReference = doc.createElement("EndpointReference");
        node_AppliesTo.appendChild(node_EndpointReference);
        node_EndpointReference.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2005/08/addressing");
        Element node_Address = doc.createElement("Address");
        node_Address.setTextContent(endpointref_address);
        node_EndpointReference.appendChild(node_Address);
        Element node_TokenType = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:TokenType");
        node_TokenType.setTextContent("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        node_RequestSecurityToken.appendChild(node_TokenType);
        Element node_Claims = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:Claims");
        node_Claims.setAttribute("xmlns:i", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        node_Claims.setAttribute("Dialect", "http://schemas.xmlsoap.org/ws/2005/05/identity");
        node_RequestSecurityToken.appendChild(node_Claims);
        Element node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "false");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/abn");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "false");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/commonname");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "false");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/credentialtype");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "false");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/samlsubjectid");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "false");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/fingerprint");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/sbr_personid");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/givennames");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/credentialadministrator");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/stalecrlminutes");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/subjectdn");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/issuerdn");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/notafterdate");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/certificateserialnumber");
        node_ClaimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "i:ClaimType");
        node_Claims.appendChild(node_ClaimType);
        node_ClaimType.setAttribute("Optional", "true");
        node_ClaimType.setAttribute("Uri", "http://vanguard.ebusiness.gov.au/2008/06/identity/claims/previoussubject");
        Element node_Lifetime = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:Lifetime");
        node_RequestSecurityToken.appendChild(node_Lifetime);
        node_Created = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        node_Created.setTextContent(created_timestamp);
        node_Lifetime.appendChild(node_Created);
        node_Expires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        node_Expires.setTextContent(expires30_timestamp);
        node_Lifetime.appendChild(node_Expires);
        Element node_KeyType = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:KeyType");
        node_KeyType.setTextContent("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
        node_RequestSecurityToken.appendChild(node_KeyType);
        Element node_KeySize = doc.createElementNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "wst:KeySize");
        node_KeySize.setTextContent("512");
        node_RequestSecurityToken.appendChild(node_KeySize);
        Base64 b64oneline = new Base64();
        MessageDigest node_TimestampDigest = this.calcDigest(node_Timestamp, "SHA-1");
        String node_TimestampDigestString = b64oneline.encodeAsString(node_TimestampDigest.digest());
        MessageDigest node_ToDigest = this.calcDigest(node_To, "SHA-1");
        String node_ToDigestString = b64oneline.encodeAsString(node_ToDigest.digest());
        Element node_Signature = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        node_Security.appendChild(node_Signature);
        node_Signature.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        Element node_SignedInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        node_Signature.appendChild(node_SignedInfo);
        Element node_CanonicalizationMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        node_SignedInfo.appendChild(node_CanonicalizationMethod);
        node_CanonicalizationMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element node_SignatureMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        node_SignedInfo.appendChild(node_SignatureMethod);
        node_SignatureMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Element node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#Timestamp");
        Element node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        Element node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        Element node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_TimestampDigestString);
        node_Reference.appendChild(node_DigestValue);
        node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#stsurl-1");
        node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_ToDigestString);
        node_Reference.appendChild(node_DigestValue);
        Element node_SignatureValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        node_Signature.appendChild(node_SignatureValue);
        Element node_KeyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        node_Signature.appendChild(node_KeyInfo);
        node_KeyInfo.setAttribute("Id", "KeyId-1");
        Element node_SecurityTokenReference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        node_KeyInfo.appendChild(node_SecurityTokenReference);
        node_Reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        node_SecurityTokenReference.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#" + this.BinarySecurityToken_id);
        node_Reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        MessageDigest signedInfoDigest = this.calcDigest(node_SignedInfo, "SHA-1");
        byte[] signedInfoDigestBytes = signedInfoDigest.digest();
        DERObjectIdentifier sha1ObjectIdentifier = new DERObjectIdentifier("1.3.14.3.2.26");
        AlgorithmIdentifier sha1AlgoIdentifier = new AlgorithmIdentifier(sha1ObjectIdentifier, null);
        DigestInfo di = new DigestInfo(sha1AlgoIdentifier, signedInfoDigestBytes);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.privateKey);
        byte[] cipherText = cipher.doFinal(di.getEncoded("DER"));
        byte[] lineseparator = new byte[]{10};
        Base64 b64 = new Base64(64, lineseparator);
        String cipherString = b64.encodeAsString(cipherText);
        node_SignatureValue.setTextContent(cipherString.trim());
        return doc;
    }

    public String createSignatureBase64OneLine(byte[] digestBytes) throws Exception {
        Base64 b64 = new Base64();
        DERObjectIdentifier sha1ObjectIdentifier = new DERObjectIdentifier("1.3.14.3.2.26");
        AlgorithmIdentifier sha1AlgoIdentifier = new AlgorithmIdentifier(sha1ObjectIdentifier, null);
        DigestInfo di = new DigestInfo(sha1AlgoIdentifier, digestBytes);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.privateKey);
        byte[] cipherText = cipher.doFinal(di.getEncoded("DER"));
        return b64.encodeAsString(cipherText);
    }

    public boolean checkSignatureValue(Document doc) {
        Element sv = GlenixAUSKey.getSignatureValueElement(doc);
        if (sv != null) {
            byte[] lineseparator = new byte[]{10};
            Base64 b64 = new Base64(64, lineseparator);
            String orig = sv.getTextContent();
            byte[] bs = b64.decode(orig);
            try {
                Signature rsa = Signature.getInstance("SHA1withRSA");
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, this.firstCert);
                return rsa.verify(bs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean checkSignatureValue(byte[] encodedDigest, String signatureBase64String, String certString) {
        Base64 b64 = new Base64();
        byte[] bs = b64.decode(signatureBase64String);
        try {
            byte[] pubcertbytes = b64.decode(certString);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(pubcertbytes);
            this.certCollection = cf.generateCertificates(bis);
            Iterator<X509Certificate> certIterator = this.certCollection.iterator();
            X509Certificate pubCert = null;
            if (certIterator.hasNext()) {
                pubCert = certIterator.next();
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, pubCert);
            byte[] cipherText = cipher.doFinal(bs);
            boolean result = Arrays.equals(cipherText, encodedDigest);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private X509Certificate certStringToX509(String certString) throws Exception {
        Base64 b64 = new Base64();
        byte[] pubcertbytes = b64.decode(certString);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bis = new ByteArrayInputStream(pubcertbytes);
        this.certCollection = cf.generateCertificates(bis);
        Iterator<X509Certificate> certIterator = this.certCollection.iterator();
        if (certIterator.hasNext()) {
            return certIterator.next();
        }
        return null;
    }

    private X509Certificate getFASCACert() throws Exception {
        String fasCaCert = "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";
        return this.certStringToX509(fasCaCert);
    }

    public String getX509CertificateCommonNameUnverified(String certString) throws Exception {
        if (certString == null || certString.isEmpty()) {
            return null;
        }
        X509Certificate pubCert = this.certStringToX509(certString);
        X509Certificate fasCaCert = this.getFASCACert();
        if (pubCert != null) {
            X500Principal principal = pubCert.getSubjectX500Principal();
            X500Name x500name = new X500Name(principal.getName());
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString(cn.getFirst().getValue());
        }
        return null;
    }

    public String getX509CertificateCommonNameUnverified(X509Certificate pubCert) throws Exception {
        if (pubCert != null) {
            X500Principal principal = pubCert.getSubjectX500Principal();
            X500Name x500name = new X500Name(principal.getName());
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString(cn.getFirst().getValue());
        }
        return null;
    }

    public String getX509CertificateCommonName() throws Exception {
        if (this.firstCert != null) {
            X500Principal principal = this.firstCert.getSubjectX500Principal();
            X500Name x500name = new X500Name(principal.getName());
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString(cn.getFirst().getValue());
        }
        return null;
    }

    public void x509CertificateIsSigned(X509Certificate x) throws Exception {
        if (x == null) {
            throw new Exception("Error provided x509 cert is null");
        }
        X509Certificate fasCaCert = this.getFASCACert();
        x.verify(fasCaCert.getPublicKey());
    }

    public void signSTSDocument(Document doc) throws Exception {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        Transform transform = fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        Reference refT = fac.newReference("#Timestamp", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(transform), null, null);
        Transform transform2 = fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        Reference refS = fac.newReference("#stsurl-1", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(transform2), null, null);
        CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        ArrayList<Reference> references = new ArrayList<Reference>();
        references.add(refT);
        references.add(refS);
        SignedInfo si = fac.newSignedInfo(cm, fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), references);
        XMLSignature signature = fac.newXMLSignature(si, null);
        Element securityElement = GlenixAUSKey.getSecurityElement(doc);
        DOMSignContext dsc = new DOMSignContext(this.privateKey, (Node)securityElement);
        dsc.setDefaultNamespacePrefix("ds");
        signature.sign(dsc);
        this.checkSignatureValue(doc);
    }

    public Node sendSTSDocument(Document stsdoc) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(stsdoc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        HttpResponse hr = this.dorequest_apache(writer.toString());
        Document responseDoc = this.dBuilder.parse(hr.getEntity().getContent());
        Node encryptedDataNode = GlenixAUSKey.getEncryptedDataNode(responseDoc);
        return encryptedDataNode;
    }

    public GlenixSBRResponse buildAndSendLodgeDocumentBatchGzip(String urlString, Node encryptedDataNode, String tan, String agentABN, String abn, String wpn, String tfn, String service, String action, String messageId, String timestamp, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        String conversationIdIdentifier = abn;
        String fromPartyIdType = "http://abr.gov.au/PartyIdType/ABN";
        String fromPartyIdValue = abn;
        if (abn == null && wpn != null) {
            conversationIdIdentifier = wpn;
            fromPartyIdType = "http://abr.gov.au/PartyIdType/WPN";
            fromPartyIdValue = wpn;
        } else if (abn == null && tfn != null) {
            conversationIdIdentifier = tfn;
            fromPartyIdType = "http://ato.gov.au/PartyIdType/TFN";
            fromPartyIdValue = tfn;
        }
        String fromPartyRole = "http://sbr.gov.au/ato/Role/Business";
        if (tan != null && !tan.equals("")) {
            fromPartyIdType = "http://ato.gov.au/PartyIdType/TAN";
            fromPartyIdValue = tan;
            fromPartyRole = "http://sbr.gov.au/ato/Role/Registered Agent";
            conversationIdIdentifier = tan;
        } else if (agentABN != null && !agentABN.equals("")) {
            fromPartyIdType = "http://abr.gov.au/PartyIdType/ABN";
            fromPartyIdValue = agentABN;
            fromPartyRole = "http://sbr.gov.au/ato/Role/Business Intermediary";
        }
        if (logFileOutputStream != null) {
            this.writeUTF8("REQUEST:\nUnzipped payload:\n", logFileOutputStream, null);
        }
        byte[] zippedBytes = this.buildGzippedData(attachments, logFileOutputStream);
        MessageDigest md = this.calcDigestBytes(zippedBytes, "SHA-1");
        GlenixSBRAttachment dummyatt = new GlenixSBRAttachment((Document)null, "Attachment01", md);
        dummyatt.setDocumentName("PAYEVNT");
        dummyatt.setDocumentType("PARENT");
        dummyatt.setMimeType("text/plain");
        dummyatt.setCompressionType("application/gzip");
        ArrayList<GlenixSBRAttachment> dummylist = new ArrayList<GlenixSBRAttachment>();
        dummylist.add(dummyatt);
        Document lodgedoc = this.buildLodgeDocument(encryptedDataNode, conversationIdIdentifier, fromPartyIdType, fromPartyIdValue, fromPartyRole, service, action, "Batch", messageId, timestamp, dummylist);
        if (logFileOutputStream != null) {
            this.writeUTF8("\nSOAP MIME:\n", logFileOutputStream, null);
        }
        return this.dorequest_lodge_apache_batch_gzip(urlString, lodgedoc, dummyatt, zippedBytes, logFileOutputStream);
    }

    public GlenixSBRResponse buildAndSendPullDocument(String urlString, Node encryptedDataNode, String refToMessageId, String messageId, String timestamp, OutputStream logFileOutputStream) throws Exception {
        Document pulldoc = this.buildPullDocument(encryptedDataNode, messageId, refToMessageId, timestamp);
        return this.dorequest_pull_apache(urlString, pulldoc, logFileOutputStream);
    }

    public GlenixSBRResponse buildAndSendLodgeDocumentBatch(String urlString, Node encryptedDataNode, String tan, String agentABN, String abn, String wpn, String tfn, String service, String action, String messageId, String timestamp, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        if (encryptedDataNode == null) {
            throw new Exception("Error, signing of request failed");
        }
        String conversationIdIdentifier = abn;
        String fromPartyIdType = "http://abr.gov.au/PartyIdType/ABN";
        String fromPartyIdValue = abn;
        if (abn == null && wpn != null) {
            conversationIdIdentifier = wpn;
            fromPartyIdType = "http://abr.gov.au/PartyIdType/WPN";
            fromPartyIdValue = wpn;
        } else if (abn == null && tfn != null) {
            conversationIdIdentifier = tfn;
            fromPartyIdType = "http://ato.gov.au/PartyIdType/TFN";
            fromPartyIdValue = tfn;
        }
        String fromPartyRole = "http://sbr.gov.au/ato/Role/Business";
        if (tan != null && !tan.equals("")) {
            fromPartyIdType = "http://ato.gov.au/PartyIdType/TAN";
            fromPartyIdValue = tan;
            fromPartyRole = "http://sbr.gov.au/ato/Role/Registered Agent";
            conversationIdIdentifier = tan;
        } else if (agentABN != null && !agentABN.equals("")) {
            fromPartyIdType = "http://abr.gov.au/PartyIdType/ABN";
            fromPartyIdValue = agentABN;
            fromPartyRole = "http://sbr.gov.au/ato/Role/Business Intermediary";
        }
        MessageDigest md = this.calcDigestBatch(attachments, "SHA-1");
        GlenixSBRAttachment dummyatt = new GlenixSBRAttachment((Document)null, "Attachment01", md);
        dummyatt.setDocumentName("PAYEVNT");
        dummyatt.setDocumentType("PARENT");
        dummyatt.setMimeType("text/plain");
        ArrayList<GlenixSBRAttachment> dummylist = new ArrayList<GlenixSBRAttachment>();
        dummylist.add(dummyatt);
        Document lodgedoc = this.buildLodgeDocument(encryptedDataNode, conversationIdIdentifier, fromPartyIdType, fromPartyIdValue, fromPartyRole, service, action, "Batch", messageId, timestamp, dummylist);
        return this.dorequest_lodge_apache_batch(urlString, lodgedoc, dummyatt, attachments, logFileOutputStream);
    }

    public GlenixSBRResponse buildAndSendLodgeDocument(String urlString, Node encryptedDataNode, String tan, String agentABN, String abn, String wpn, String tfn, String service, String action, String messageId, String timestamp, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        if (encryptedDataNode == null) {
            throw new Exception("Error, signing of request failed");
        }
        String conversationIdIdentifier = abn;
        String fromPartyIdType = "http://abr.gov.au/PartyIdType/ABN";
        String fromPartyIdValue = abn;
        if (abn == null && wpn != null) {
            conversationIdIdentifier = wpn;
            fromPartyIdType = "http://abr.gov.au/PartyIdType/WPN";
            fromPartyIdValue = wpn;
        } else if (abn == null && tfn != null) {
            conversationIdIdentifier = tfn;
            fromPartyIdType = "http://ato.gov.au/PartyIdType/TFN";
            fromPartyIdValue = tfn;
        }
        String fromPartyRole = "http://sbr.gov.au/ato/Role/Business";
        if (tan != null && !tan.equals("")) {
            fromPartyIdType = "http://ato.gov.au/PartyIdType/TAN";
            fromPartyIdValue = tan;
            fromPartyRole = "http://sbr.gov.au/ato/Role/Registered Agent";
            conversationIdIdentifier = tan;
        } else if (agentABN != null && !agentABN.equals("")) {
            fromPartyIdType = "http://abr.gov.au/PartyIdType/ABN";
            fromPartyIdValue = agentABN;
            fromPartyRole = "http://sbr.gov.au/ato/Role/Business Intermediary";
        }
        Document lodgedoc = this.buildLodgeDocument(encryptedDataNode, conversationIdIdentifier, fromPartyIdType, fromPartyIdValue, fromPartyRole, service, action, "Single-Sync-Chatty", messageId, timestamp, attachments);
        return this.dorequest_lodge_apache(urlString, lodgedoc, attachments, logFileOutputStream);
    }

    protected String generateTimestamp() {
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return isoFormat.format(date);
    }

    public Document buildLodgeDocument(Node encryptedDataNode, String abnortan, String fromPartyIdType, String fromPartyIdValue, String fromPartyRole, String service, String action, String pmode, String messageId, String timestamp, List<GlenixSBRAttachment> attachments) throws Exception {
        if (this.productID == null || this.productID.isEmpty()) {
            throw new Exception("Error, productID is not set");
        }
        if (this.companyNameSBR == null || this.companyNameSBR.isEmpty()) {
            throw new Exception("Error, companyNameSBR is not set");
        }
        if (this.softwareNameSBR == null || this.softwareNameSBR.isEmpty()) {
            throw new Exception("Error, softwareNameSBR is not set");
        }
        if (this.versionNumberSBR == null || this.versionNumberSBR.isEmpty()) {
            throw new Exception("Error, versionNumberSBR is not set");
        }
        Base64 b64oneline = new Base64();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element node_Envelope = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Envelope");
        doc.appendChild(node_Envelope);
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:S12", "http://www.w3.org/2003/05/soap-envelope");
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:eb", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        Element node_Header = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Header");
        node_Envelope.appendChild(node_Header);
        Element node_Messaging = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "eb:Messaging");
        node_Header.appendChild(node_Messaging);
        node_Messaging.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "S12:mustUnderstand", "true");
        node_Messaging.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrM = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrM.setPrefix("wsu");
        attrM.setValue("messaging-id");
        node_Messaging.setAttributeNodeNS(attrM);
        node_Messaging.setIdAttributeNode(attrM, true);
        Element node_UserMessage = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:UserMessage");
        node_UserMessage.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns2", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        node_Messaging.appendChild(node_UserMessage);
        Element node_MessageInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageInfo");
        node_UserMessage.appendChild(node_MessageInfo);
        Element node_Timestamp = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Timestamp");
        node_MessageInfo.appendChild(node_Timestamp);
        if (timestamp == null || timestamp.isEmpty()) {
            timestamp = this.generateTimestamp();
        }
        node_Timestamp.setTextContent(timestamp);
        if (messageId == null) {
            messageId = UUID.randomUUID().toString() + "@freeaccountingsoftware.com.au";
        }
        Element node_MessageId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageId");
        node_MessageId.setTextContent(messageId);
        node_MessageInfo.appendChild(node_MessageId);
        Element node_PartyInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartyInfo");
        node_UserMessage.appendChild(node_PartyInfo);
        Element node_From = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:From");
        node_PartyInfo.appendChild(node_From);
        Element node_PartyId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartyId");
        node_PartyId.setTextContent(fromPartyIdValue);
        node_PartyId.setAttribute("type", fromPartyIdType);
        node_From.appendChild(node_PartyId);
        Element node_Role = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Role");
        node_Role.setTextContent(fromPartyRole);
        node_From.appendChild(node_Role);
        Element node_To = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:To");
        node_PartyInfo.appendChild(node_To);
        node_PartyId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartyId");
        node_PartyId.setTextContent("51824753556");
        node_PartyId.setAttribute("type", "http://abr.gov.au/PartyIdType/ABN");
        node_To.appendChild(node_PartyId);
        node_Role = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Role");
        node_Role.setTextContent("http://sbr.gov.au/agency");
        node_To.appendChild(node_Role);
        Element node_CollaborationInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:CollaborationInfo");
        node_UserMessage.appendChild(node_CollaborationInfo);
        Element node_Service = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Service");
        node_Service.setTextContent(service);
        node_CollaborationInfo.appendChild(node_Service);
        Element node_Action = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Action");
        node_Action.setTextContent(action);
        node_CollaborationInfo.appendChild(node_Action);
        Element node_AgreementRef = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:AgreementRef");
        if (pmode == null || pmode.equals("Single-Sync-Chatty")) {
            node_AgreementRef.setTextContent("http://sbr.gov.au/agreement/Gateway/1.0/TwoWaySync/PKI");
            node_AgreementRef.setAttribute("pmode", pmode);
        } else if (pmode.equals("BulkBatch-async-push")) {
            node_AgreementRef.setTextContent("http://sbr.gov.au/agreement/Gateway/1.0/Push/PKI");
        } else if (pmode.equals("BulkBatch-async-pull")) {
            // empty if block
        }
        node_CollaborationInfo.appendChild(node_AgreementRef);
        Element node_ConversationId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:ConversationId");
        node_ConversationId.setTextContent(abnortan + timestamp);
        node_CollaborationInfo.appendChild(node_ConversationId);
        Element node_MessageProperties = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageProperties");
        node_UserMessage.appendChild(node_MessageProperties);
        Element node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
        node_Property.setAttribute("name", "ProductID");
        node_Property.setTextContent(this.productID);
        node_MessageProperties.appendChild(node_Property);
        node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
        node_Property.setAttribute("name", "BMS Vendor");
        node_Property.setTextContent(this.companyNameSBR);
        node_MessageProperties.appendChild(node_Property);
        node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
        node_Property.setAttribute("name", "BMS Name");
        node_Property.setTextContent(this.softwareNameSBR);
        node_MessageProperties.appendChild(node_Property);
        node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
        node_Property.setAttribute("name", "BMS Version");
        node_Property.setTextContent(this.versionNumberSBR);
        node_MessageProperties.appendChild(node_Property);
        Element node_PayloadInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PayloadInfo");
        node_UserMessage.appendChild(node_PayloadInfo);
        for (int i = 0; i < attachments.size(); ++i) {
            GlenixSBRAttachment attachment = attachments.get(i);
            Element node_PartInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartInfo");
            node_PartInfo.setAttribute("href", "cid:" + attachment.getAttachmentCID());
            node_PayloadInfo.appendChild(node_PartInfo);
            Element node_Schema = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Schema");
            node_Schema.setTextContent(attachment.getSchema());
            node_PartInfo.appendChild(node_Schema);
            Element node_PartProperties = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartProperties");
            node_PartInfo.appendChild(node_PartProperties);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "DocumentName");
            node_Property.setTextContent(attachment.getDocumentName());
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PartID");
            String PartID = attachment.getPartID();
            if (PartID == null || PartID.isEmpty()) {
                node_Property.setTextContent(attachment.getAttachmentCID());
            } else {
                node_Property.setTextContent(PartID);
            }
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "DocumentType");
            node_Property.setTextContent(attachment.getDocumentType());
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "MimeType");
            node_Property.setTextContent(attachment.getMimeType());
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "filename");
            String filename = attachment.getFilename();
            if (filename == null || filename.isEmpty()) {
                node_Property.setTextContent(attachment.getAttachmentCID());
            } else {
                node_Property.setTextContent(filename);
            }
            node_PartProperties.appendChild(node_Property);
            String compressionType = attachment.getCompressionType();
            if (compressionType == null || compressionType.isEmpty()) continue;
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "CompressionType");
            node_Property.setTextContent(compressionType);
            node_PartProperties.appendChild(node_Property);
        }
        Element node_Security = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        node_Header.appendChild(node_Security);
        node_Security.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        node_Security.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "S12:mustUnderstand", "true");
        Element node_EncryptedAssertion = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "saml2:EncryptedAssertion");
        node_EncryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml2", "urn:oasis:names:tc:SAML:2.0:assertion");
        node_Security.appendChild(node_EncryptedAssertion);
        node_EncryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrE = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrE.setPrefix("wsu");
        attrE.setValue("assertion-id");
        node_EncryptedAssertion.setAttributeNodeNS(attrE);
        node_EncryptedAssertion.setIdAttributeNode(attrE, true);
        node_EncryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:assertion");
        Element node_encryptedData = (Element)doc.importNode(encryptedDataNode, true);
        node_EncryptedAssertion.appendChild(node_encryptedData);
        Element node_BinarySecurityToken = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        node_BinarySecurityToken.setTextContent(this.b64binarysecuritytoken);
        node_Security.appendChild(node_BinarySecurityToken);
        node_BinarySecurityToken.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrB.setPrefix("wsu");
        attrB.setValue(this.BinarySecurityToken_id);
        node_BinarySecurityToken.setAttributeNodeNS(attrB);
        node_BinarySecurityToken.setIdAttributeNode(attrB, true);
        node_BinarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        node_BinarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Element node_Body = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Body");
        node_Body.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrBB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrBB.setPrefix("wsu");
        attrBB.setValue("soap_body_id");
        node_Body.setAttributeNodeNS(attrBB);
        node_Body.setIdAttributeNode(attrBB, true);
        node_Envelope.appendChild(node_Body);
        MessageDigest node_MessagingDigest = this.calcDigest(node_Messaging, "SHA-1");
        String node_MessagingDigestString = b64oneline.encodeAsString(node_MessagingDigest.digest());
        MessageDigest node_EncryptedAssertionDigest = this.calcDigest(node_EncryptedAssertion, "SHA-1");
        String node_EncryptedAssertionDigestString = b64oneline.encodeAsString(node_EncryptedAssertionDigest.digest());
        MessageDigest node_BinarySecurityTokenDigest = this.calcDigest(node_BinarySecurityToken, "SHA-1");
        String node_BinarySecurityTokenDigestString = b64oneline.encodeAsString(node_BinarySecurityTokenDigest.digest());
        MessageDigest node_BodyDigest = this.calcDigest(node_Body, "SHA-1");
        String node_BodyDigestString = b64oneline.encodeAsString(node_BodyDigest.digest());
        Element node_Signature = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        node_Security.appendChild(node_Signature);
        node_Signature.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        Element node_SignedInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        node_Signature.appendChild(node_SignedInfo);
        Element node_CanonicalizationMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        node_SignedInfo.appendChild(node_CanonicalizationMethod);
        node_CanonicalizationMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element node_SignatureMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        node_SignedInfo.appendChild(node_SignatureMethod);
        node_SignatureMethod.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Element node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#messaging-id");
        Element node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        Element node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        Element node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_MessagingDigestString);
        node_Reference.appendChild(node_DigestValue);
        node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#assertion-id");
        node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_EncryptedAssertionDigestString);
        node_Reference.appendChild(node_DigestValue);
        node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#soap_body_id");
        node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_BodyDigestString);
        node_Reference.appendChild(node_DigestValue);
        node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#BinarySecurityToken-1");
        node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_BinarySecurityTokenDigestString);
        node_Reference.appendChild(node_DigestValue);
        for (int i = 0; i < attachments.size(); ++i) {
            GlenixSBRAttachment attachment = attachments.get(i);
            node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
            node_SignedInfo.appendChild(node_Reference);
            node_Reference.setAttribute("URI", "cid:" + attachment.getAttachmentCID());
            node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            node_Reference.appendChild(node_Transforms);
            node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
            node_Transforms.appendChild(node_Transform);
            node_Transform.setAttribute("Algorithm", "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform");
            node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
            node_Reference.appendChild(node_DigestMethod);
            node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
            node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
            String attachmentDigestString = b64oneline.encodeAsString(attachment.getAttachmentDigest().digest());
            node_DigestValue.setTextContent(attachmentDigestString);
            node_Reference.appendChild(node_DigestValue);
        }
        Element node_SignatureValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        node_Signature.appendChild(node_SignatureValue);
        Element node_KeyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        node_Signature.appendChild(node_KeyInfo);
        node_KeyInfo.setAttribute("Id", "KeyId-1");
        Element node_SecurityTokenReference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        node_KeyInfo.appendChild(node_SecurityTokenReference);
        node_Reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        node_SecurityTokenReference.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#" + this.BinarySecurityToken_id);
        node_Reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        MessageDigest signedInfoDigest = this.calcDigest(node_SignedInfo, "SHA-256");
        byte[] signedInfoDigestBytes = signedInfoDigest.digest();
        AlgorithmIdentifier sha256Aid = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        DigestInfo di = new DigestInfo(sha256Aid, signedInfoDigestBytes);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.privateKey);
        byte[] cipherText = cipher.doFinal(di.getEncoded("DER"));
        byte[] lineseparator = new byte[]{10};
        Base64 b64 = new Base64(64, lineseparator);
        String cipherString = b64.encodeAsString(cipherText);
        node_SignatureValue.setTextContent(cipherString.trim());
        return doc;
    }

    public Document buildPullDocument(Node encryptedDataNode, String messageId, String refToMessageId, String timestamp) throws Exception {
        if (this.productID == null || this.productID.isEmpty()) {
            throw new Exception("Error, productID is not set");
        }
        Base64 b64oneline = new Base64();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element node_Envelope = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Envelope");
        doc.appendChild(node_Envelope);
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:S12", "http://www.w3.org/2003/05/soap-envelope");
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:eb", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        Element node_Header = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Header");
        node_Envelope.appendChild(node_Header);
        Element node_Messaging = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "eb:Messaging");
        node_Header.appendChild(node_Messaging);
        node_Messaging.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "S12:mustUnderstand", "true");
        node_Messaging.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrM = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrM.setPrefix("wsu");
        attrM.setValue("messaging-id");
        node_Messaging.setAttributeNodeNS(attrM);
        node_Messaging.setIdAttributeNode(attrM, true);
        Element node_SignalMessage = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:SignalMessage");
        node_SignalMessage.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns2", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        node_Messaging.appendChild(node_SignalMessage);
        Element node_MessageInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageInfo");
        node_SignalMessage.appendChild(node_MessageInfo);
        Element node_Timestamp = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Timestamp");
        node_MessageInfo.appendChild(node_Timestamp);
        if (timestamp == null || timestamp.isEmpty()) {
            timestamp = this.generateTimestamp();
        }
        node_Timestamp.setTextContent(timestamp);
        if (messageId == null) {
            messageId = UUID.randomUUID().toString() + "@freeaccountingsoftware.com.au";
        }
        Element node_MessageId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageId");
        node_MessageId.setTextContent(messageId);
        node_MessageInfo.appendChild(node_MessageId);
        Element node_RefToMessageId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:RefToMessageId");
        node_RefToMessageId.setTextContent(refToMessageId);
        node_MessageInfo.appendChild(node_RefToMessageId);
        Element node_PullRequest = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PullRequest");
        node_SignalMessage.appendChild(node_PullRequest);
        Element node_RefToMessageId2 = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:RefToMessageId");
        node_RefToMessageId2.setTextContent(refToMessageId);
        node_PullRequest.appendChild(node_RefToMessageId2);
        Element node_Security = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        node_Header.appendChild(node_Security);
        node_Security.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        node_Security.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "S12:mustUnderstand", "true");
        Element node_EncryptedAssertion = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "saml2:EncryptedAssertion");
        node_EncryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml2", "urn:oasis:names:tc:SAML:2.0:assertion");
        node_Security.appendChild(node_EncryptedAssertion);
        node_EncryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrE = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrE.setPrefix("wsu");
        attrE.setValue("assertion-id");
        node_EncryptedAssertion.setAttributeNodeNS(attrE);
        node_EncryptedAssertion.setIdAttributeNode(attrE, true);
        node_EncryptedAssertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:assertion");
        Element node_encryptedData = (Element)doc.importNode(encryptedDataNode, true);
        node_EncryptedAssertion.appendChild(node_encryptedData);
        Element node_BinarySecurityToken = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        node_BinarySecurityToken.setTextContent(this.b64binarysecuritytoken);
        node_Security.appendChild(node_BinarySecurityToken);
        node_BinarySecurityToken.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrB.setPrefix("wsu");
        attrB.setValue(this.BinarySecurityToken_id);
        node_BinarySecurityToken.setAttributeNodeNS(attrB);
        node_BinarySecurityToken.setIdAttributeNode(attrB, true);
        node_BinarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        node_BinarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Element node_Body = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Body");
        node_Body.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrBB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrBB.setPrefix("wsu");
        attrBB.setValue("soap_body_id");
        node_Body.setAttributeNodeNS(attrBB);
        node_Body.setIdAttributeNode(attrBB, true);
        node_Envelope.appendChild(node_Body);
        MessageDigest node_MessagingDigest = this.calcDigest(node_Messaging, "SHA-1");
        String node_MessagingDigestString = b64oneline.encodeAsString(node_MessagingDigest.digest());
        MessageDigest node_EncryptedAssertionDigest = this.calcDigest(node_EncryptedAssertion, "SHA-1");
        String node_EncryptedAssertionDigestString = b64oneline.encodeAsString(node_EncryptedAssertionDigest.digest());
        MessageDigest node_BodyDigest = this.calcDigest(node_Body, "SHA-1");
        String node_BodyDigestString = b64oneline.encodeAsString(node_BodyDigest.digest());
        Element node_Signature = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        node_Security.appendChild(node_Signature);
        node_Signature.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        Element node_SignedInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        node_Signature.appendChild(node_SignedInfo);
        Element node_CanonicalizationMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        node_SignedInfo.appendChild(node_CanonicalizationMethod);
        node_CanonicalizationMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element node_SignatureMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        node_SignedInfo.appendChild(node_SignatureMethod);
        node_SignatureMethod.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Element node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#messaging-id");
        Element node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        Element node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        Element node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        Element node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_MessagingDigestString);
        node_Reference.appendChild(node_DigestValue);
        node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#assertion-id");
        node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_EncryptedAssertionDigestString);
        node_Reference.appendChild(node_DigestValue);
        node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        node_SignedInfo.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#soap_body_id");
        node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        node_Reference.appendChild(node_Transforms);
        node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        node_Transforms.appendChild(node_Transform);
        node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        node_Reference.appendChild(node_DigestMethod);
        node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        node_DigestValue.setTextContent(node_BodyDigestString);
        node_Reference.appendChild(node_DigestValue);
        Element node_SignatureValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        node_Signature.appendChild(node_SignatureValue);
        Element node_KeyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        node_Signature.appendChild(node_KeyInfo);
        node_KeyInfo.setAttribute("Id", "KeyId-1");
        Element node_SecurityTokenReference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        node_KeyInfo.appendChild(node_SecurityTokenReference);
        node_Reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        node_SecurityTokenReference.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#" + this.BinarySecurityToken_id);
        node_Reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        MessageDigest signedInfoDigest = this.calcDigest(node_SignedInfo, "SHA-256");
        byte[] signedInfoDigestBytes = signedInfoDigest.digest();
        AlgorithmIdentifier sha256Aid = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        DigestInfo di = new DigestInfo(sha256Aid, signedInfoDigestBytes);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.privateKey);
        byte[] cipherText = cipher.doFinal(di.getEncoded("DER"));
        byte[] lineseparator = new byte[]{10};
        Base64 b64 = new Base64(64, lineseparator);
        String cipherString = b64.encodeAsString(cipherText);
        node_SignatureValue.setTextContent(cipherString.trim());
        return doc;
    }

    public MessageDetails newMessageDetails() {
        return new MessageDetails();
    }

    public Document buildOtherSoapDocument(String messageIdValue, String fromPartyIdType, String fromPartyIdValue, String fromPartyRole, String toPartyIdType, String toPartyIdValue, String toPartyRole, MessageDetails messageDetails) throws Exception {
        if (this.productName == null || this.productName.isEmpty()) {
            throw new Exception("Error, productName is not set");
        }
        if (this.versionNumber == null || this.versionNumber.isEmpty()) {
            throw new Exception("Error, versionNumber is not set");
        }
        Base64 b64oneline = new Base64();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element node_Envelope = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Envelope");
        doc.appendChild(node_Envelope);
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:S12", "http://www.w3.org/2003/05/soap-envelope");
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        node_Envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:eb", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        Element node_Header = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Header");
        node_Envelope.appendChild(node_Header);
        Element node_Messaging = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "eb:Messaging");
        node_Header.appendChild(node_Messaging);
        node_Messaging.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "S12:mustUnderstand", "true");
        node_Messaging.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrM = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrM.setPrefix("wsu");
        attrM.setValue("messaging-id");
        node_Messaging.setAttributeNodeNS(attrM);
        node_Messaging.setIdAttributeNode(attrM, true);
        Element node_UserMessage = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:UserMessage");
        node_UserMessage.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns2", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        node_Messaging.appendChild(node_UserMessage);
        Element node_MessageInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageInfo");
        node_UserMessage.appendChild(node_MessageInfo);
        Element node_Timestamp = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Timestamp");
        node_MessageInfo.appendChild(node_Timestamp);
        String timestamp = this.generateTimestamp();
        node_Timestamp.setTextContent(timestamp);
        Element node_MessageId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageId");
        node_MessageId.setTextContent(messageIdValue);
        node_MessageInfo.appendChild(node_MessageId);
        Element node_PartyInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartyInfo");
        node_UserMessage.appendChild(node_PartyInfo);
        Element node_From = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:From");
        node_PartyInfo.appendChild(node_From);
        Element node_PartyId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartyId");
        node_PartyId.setTextContent(fromPartyIdValue);
        node_PartyId.setAttribute("type", fromPartyIdType);
        node_From.appendChild(node_PartyId);
        Element node_Role = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Role");
        node_Role.setTextContent(fromPartyRole);
        node_From.appendChild(node_Role);
        Element node_To = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:To");
        node_PartyInfo.appendChild(node_To);
        node_PartyId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartyId");
        node_PartyId.setTextContent(toPartyIdValue);
        node_PartyId.setAttribute("type", toPartyIdType);
        node_To.appendChild(node_PartyId);
        node_Role = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Role");
        node_Role.setTextContent(toPartyRole);
        node_To.appendChild(node_Role);
        Element node_CollaborationInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:CollaborationInfo");
        node_UserMessage.appendChild(node_CollaborationInfo);
        Element node_Service = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Service");
        node_Service.setTextContent(messageDetails.getService());
        node_CollaborationInfo.appendChild(node_Service);
        Element node_Action = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Action");
        node_Action.setTextContent(messageDetails.getAction());
        node_CollaborationInfo.appendChild(node_Action);
        if (messageDetails.getAgreementRef() != null) {
            Element node_AgreementRef = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:AgreementRef");
            node_AgreementRef.setTextContent(messageDetails.getAgreementRef());
            if (messageDetails.getPMode() != null) {
                node_AgreementRef.setAttribute("pmode", messageDetails.getPMode());
            }
            node_CollaborationInfo.appendChild(node_AgreementRef);
        }
        Element node_ConversationId = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:ConversationId");
        node_ConversationId.setTextContent(fromPartyIdValue + timestamp);
        node_CollaborationInfo.appendChild(node_ConversationId);
        Element node_MessageProperties = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:MessageProperties");
        node_UserMessage.appendChild(node_MessageProperties);
        Element node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
        node_Property.setAttribute("name", "GlenixProduct");
        node_Property.setTextContent(this.productName);
        node_MessageProperties.appendChild(node_Property);
        node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
        node_Property.setAttribute("name", "GlenixVersion");
        node_Property.setTextContent(this.versionNumber);
        node_MessageProperties.appendChild(node_Property);
        if (messageDetails.getPropABN() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropABN");
            node_Property.setTextContent(messageDetails.getPropABN());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropAction() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropAction");
            node_Property.setTextContent(messageDetails.getPropAction());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropAgentABN() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropAgentABN");
            node_Property.setTextContent(messageDetails.getPropAgentABN());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropService() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropService");
            node_Property.setTextContent(messageDetails.getPropService());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropTAN() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropTAN");
            node_Property.setTextContent(messageDetails.getPropTAN());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropWPN() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropWPN");
            node_Property.setTextContent(messageDetails.getPropWPN());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropRecordCount() >= 0) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropRecordCount");
            node_Property.setTextContent("" + messageDetails.getPropRecordCount());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropBusinessIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropBusinessIdentifier");
            node_Property.setTextContent(messageDetails.getPropBusinessIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropPublicKeyIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropPublicKeyIdentifier");
            node_Property.setTextContent(messageDetails.getPropPublicKeyIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropBusinessFileName() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropBusinessFileName");
            node_Property.setTextContent(messageDetails.getPropBusinessFileName());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropMinTransactionDate() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropMinTransactionDate");
            node_Property.setTextContent(messageDetails.getPropMinTransactionDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropMaxTransactionDate() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropMaxTransactionDate");
            node_Property.setTextContent(messageDetails.getPropMaxTransactionDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropCounterpartyIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropCounterpartyIdentifier");
            node_Property.setTextContent(messageDetails.getPropCounterpartyIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropCounterpartyIdentifierNotNull() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropCounterpartyIdentifierNotNull");
            node_Property.setTextContent(messageDetails.getPropCounterpartyIdentifierNotNull());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropDivisionIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropDivisionIdentifier");
            node_Property.setTextContent(messageDetails.getPropDivisionIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropDivisionIdentifierNotNull() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropDivisionIdentifierNotNull");
            node_Property.setTextContent(messageDetails.getPropDivisionIdentifierNotNull());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropJobIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropJobIdentifier");
            node_Property.setTextContent(messageDetails.getPropJobIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropJobIdentifierNotNull() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropJobIdentifierNotNull");
            node_Property.setTextContent(messageDetails.getPropJobIdentifierNotNull());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropAccountIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropAccountIdentifier");
            node_Property.setTextContent(messageDetails.getPropAccountIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropAccountIdentifierNotNull() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropAccountIdentifierNotNull");
            node_Property.setTextContent(messageDetails.getPropAccountIdentifierNotNull());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropProvisionIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropProvisionIdentifier");
            node_Property.setTextContent(messageDetails.getPropProvisionIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropProvisionIdentifierNotNull() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropProvisionIdentifierNotNull");
            node_Property.setTextContent(messageDetails.getPropProvisionIdentifierNotNull());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropProvisionIdentifierCsv() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropProvisionIdentifierCsv");
            node_Property.setTextContent(messageDetails.getPropProvisionIdentifierCsv());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropProvisionGrossBASClassification() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropProvisionGrossBASClassification");
            node_Property.setTextContent(messageDetails.getPropProvisionGrossBASClassification());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropReconcileCsv() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropReconcileCsv");
            node_Property.setTextContent(messageDetails.getPropReconcileCsv());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropSplitCsv() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropSplitCsv");
            node_Property.setTextContent(messageDetails.getPropSplitCsv());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropMinDocumentDate() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropMinDocumentDate");
            node_Property.setTextContent(messageDetails.getPropMinDocumentDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropMaxDocumentDate() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropMaxDocumentDate");
            node_Property.setTextContent(messageDetails.getPropMaxDocumentDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropActivityStatementNumber() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropActivityStatementNumber");
            node_Property.setTextContent(messageDetails.getPropActivityStatementNumber());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropSignedSoftwareSubscriptionIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropSignedSoftwareSubscriptionIdentifier");
            node_Property.setTextContent(messageDetails.getPropSignedSoftwareSubscriptionIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropBatchIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropBatchIdentifier");
            node_Property.setTextContent(messageDetails.getPropBatchIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropHomeOfficeIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropHomeOfficeIdentifier");
            node_Property.setTextContent(messageDetails.getPropHomeOfficeIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropTransactionNumber() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropTransactionNumber");
            node_Property.setTextContent(messageDetails.getPropTransactionNumber());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropTransactionType() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropTransactionType");
            node_Property.setTextContent(messageDetails.getPropTransactionType());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropTransactionStatus() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropTransactionStatus");
            node_Property.setTextContent(messageDetails.getPropTransactionStatus());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropProcessingOption() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropProcessingOption");
            node_Property.setTextContent(messageDetails.getPropProcessingOption());
            node_MessageProperties.appendChild(node_Property);
        }
        if (messageDetails.getPropCalculationRuleIdentifier() != null) {
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PropCalculationRuleIdentifier");
            node_Property.setTextContent(messageDetails.getPropCalculationRuleIdentifier());
            node_MessageProperties.appendChild(node_Property);
        }
        Element node_PayloadInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PayloadInfo");
        node_UserMessage.appendChild(node_PayloadInfo);
        for (int i = 0; i < messageDetails.getAttachmentCount(); ++i) {
            GlenixSBRAttachment attachment = messageDetails.getAttachment(i);
            Element node_PartInfo = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartInfo");
            node_PartInfo.setAttribute("href", "cid:" + attachment.getAttachmentCID());
            node_PayloadInfo.appendChild(node_PartInfo);
            Element node_Schema = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Schema");
            node_PartInfo.appendChild(node_Schema);
            Element node_PartProperties = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:PartProperties");
            node_PartInfo.appendChild(node_PartProperties);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "DocumentName");
            node_Property.setTextContent(attachment.getDocumentName());
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "PartID");
            String PartID = attachment.getPartID();
            if (PartID == null || PartID.isEmpty()) {
                node_Property.setTextContent(attachment.getAttachmentCID());
            } else {
                node_Property.setTextContent(PartID);
            }
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "DocumentType");
            String type = attachment.getDocumentType();
            if (type != null && !type.equals("")) {
                node_Property.setTextContent(type);
            } else if (i == 0) {
                node_Property.setTextContent("BASE");
            } else {
                node_Property.setTextContent("SCHEDULE");
            }
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "MimeType");
            node_Property.setTextContent(attachment.getMimeType());
            node_PartProperties.appendChild(node_Property);
            node_Property = doc.createElementNS("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "ns2:Property");
            node_Property.setAttribute("name", "filename");
            String filename = attachment.getFilename();
            if (filename == null || filename.isEmpty()) {
                node_Property.setTextContent(attachment.getAttachmentCID());
            } else {
                node_Property.setTextContent(filename);
            }
            node_PartProperties.appendChild(node_Property);
        }
        Element node_Security = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        node_Header.appendChild(node_Security);
        node_Security.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        node_Security.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "S12:mustUnderstand", "true");
        Element node_BinarySecurityToken = null;
        if (this.b64binarysecuritytoken != null) {
            node_BinarySecurityToken = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
            node_BinarySecurityToken.setTextContent(this.b64binarysecuritytoken);
            node_Security.appendChild(node_BinarySecurityToken);
            node_BinarySecurityToken.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            Attr attrB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            attrB.setPrefix("wsu");
            attrB.setValue(this.BinarySecurityToken_id);
            node_BinarySecurityToken.setAttributeNodeNS(attrB);
            node_BinarySecurityToken.setIdAttributeNode(attrB, true);
            node_BinarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            node_BinarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        }
        Element node_Body = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "S12:Body");
        node_Body.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Attr attrBB = doc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        attrBB.setPrefix("wsu");
        attrBB.setValue("soap_body_id");
        node_Body.setAttributeNodeNS(attrBB);
        node_Body.setIdAttributeNode(attrBB, true);
        node_Envelope.appendChild(node_Body);
        MessageDigest node_MessagingDigest = this.calcDigest(node_Messaging, "SHA-1");
        String node_MessagingDigestString = b64oneline.encodeAsString(node_MessagingDigest.digest());
        if (this.privateKey != null) {
            MessageDigest node_BodyDigest = this.calcDigest(node_Body, "SHA-1");
            String node_BodyDigestString = b64oneline.encodeAsString(node_BodyDigest.digest());
            Element node_Signature = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
            node_Security.appendChild(node_Signature);
            node_Signature.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            Element node_SignedInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
            node_Signature.appendChild(node_SignedInfo);
            Element node_CanonicalizationMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
            node_SignedInfo.appendChild(node_CanonicalizationMethod);
            node_CanonicalizationMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
            Element node_SignatureMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
            node_SignedInfo.appendChild(node_SignatureMethod);
            node_SignatureMethod.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            Element node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
            node_SignedInfo.appendChild(node_Reference);
            node_Reference.setAttribute("URI", "#messaging-id");
            Element node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            node_Reference.appendChild(node_Transforms);
            Element node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
            node_Transforms.appendChild(node_Transform);
            node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
            Element node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
            node_Reference.appendChild(node_DigestMethod);
            node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
            Element node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
            node_DigestValue.setTextContent(node_MessagingDigestString);
            node_Reference.appendChild(node_DigestValue);
            node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
            node_SignedInfo.appendChild(node_Reference);
            node_Reference.setAttribute("URI", "#soap_body_id");
            node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            node_Reference.appendChild(node_Transforms);
            node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
            node_Transforms.appendChild(node_Transform);
            node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
            node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
            node_Reference.appendChild(node_DigestMethod);
            node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
            node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
            node_DigestValue.setTextContent(node_BodyDigestString);
            node_Reference.appendChild(node_DigestValue);
            if (this.b64binarysecuritytoken != null && node_BinarySecurityToken != null) {
                MessageDigest node_BinarySecurityTokenDigest = this.calcDigest(node_BinarySecurityToken, "SHA-1");
                String node_BinarySecurityTokenDigestString = b64oneline.encodeAsString(node_BinarySecurityTokenDigest.digest());
                node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
                node_SignedInfo.appendChild(node_Reference);
                node_Reference.setAttribute("URI", "#BinarySecurityToken-1");
                node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
                node_Reference.appendChild(node_Transforms);
                node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
                node_Transforms.appendChild(node_Transform);
                node_Transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
                node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
                node_Reference.appendChild(node_DigestMethod);
                node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
                node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
                node_DigestValue.setTextContent(node_BinarySecurityTokenDigestString);
                node_Reference.appendChild(node_DigestValue);
            }
            for (int i = 0; i < messageDetails.getAttachmentCount(); ++i) {
                GlenixSBRAttachment attachment = messageDetails.getAttachment(i);
                node_Reference = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
                node_SignedInfo.appendChild(node_Reference);
                node_Reference.setAttribute("URI", "cid:" + attachment.getAttachmentCID());
                node_Transforms = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
                node_Reference.appendChild(node_Transforms);
                node_Transform = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
                node_Transforms.appendChild(node_Transform);
                node_Transform.setAttribute("Algorithm", "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform");
                node_DigestMethod = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
                node_Reference.appendChild(node_DigestMethod);
                node_DigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
                node_DigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
                String attachmentDigestString = b64oneline.encodeAsString(attachment.getAttachmentDigest().digest());
                node_DigestValue.setTextContent(attachmentDigestString);
                node_Reference.appendChild(node_DigestValue);
            }
            Element node_SignatureValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
            node_Signature.appendChild(node_SignatureValue);
            Element node_KeyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
            node_Signature.appendChild(node_KeyInfo);
            node_KeyInfo.setAttribute("Id", "KeyId-1");
            Element node_SecurityTokenReference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
            node_KeyInfo.appendChild(node_SecurityTokenReference);
            node_Reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
            node_SecurityTokenReference.appendChild(node_Reference);
            node_Reference.setAttribute("URI", "#" + this.BinarySecurityToken_id);
            node_Reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            MessageDigest signedInfoDigest = this.calcDigest(node_SignedInfo, "SHA-256");
            byte[] signedInfoDigestBytes = signedInfoDigest.digest();
            AlgorithmIdentifier sha256Aid = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
            DigestInfo di = new DigestInfo(sha256Aid, signedInfoDigestBytes);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, this.privateKey);
            byte[] cipherText = cipher.doFinal(di.getEncoded("DER"));
            byte[] lineseparator = new byte[]{10};
            Base64 b64 = new Base64(64, lineseparator);
            String cipherString = b64.encodeAsString(cipherText);
            node_SignatureValue.setTextContent(cipherString.trim());
        }
        return doc;
    }

    public GlenixSBRResponse dorequest_lodge_apache_batch_gzip(String urlString, InputStream docInputStream, GlenixSBRAttachment batchAttach, byte[] attachmentsBytes, OutputStream logFileOutputStream) throws Exception {
        String domain = "freeaccountingsoftware.com.au";
        String uuid = UUID.randomUUID().toString();
        String start_content_id = uuid + "@" + domain;
        String boundary = "----=_" + uuid;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(1024);
        conn.setRequestProperty("Content-Type", "multipart/related; boundary=\"" + boundary + "\"; start=\"<" + start_content_id + ">\"; type=\"application/soap+xml\"");
        conn.setRequestProperty("Accept", "*/*");
        OutputStream os = conn.getOutputStream();
        this.writeUTF8("--", os, logFileOutputStream);
        this.writeUTF8(boundary, os, logFileOutputStream);
        this.writeUTF8("\r\nContent-Type: application/soap+xml\r\nContent-Transfer-Encoding: binary\r\nContent-ID: <", os, logFileOutputStream);
        this.writeUTF8(start_content_id, os, logFileOutputStream);
        this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
        byte[] bs = new byte[1000];
        int readlen = 0;
        while ((readlen = docInputStream.read(bs)) >= 0) {
            this.writeBytes(bs, readlen, os, logFileOutputStream);
        }
        if (batchAttach != null && attachmentsBytes != null) {
            this.writeUTF8("\r\n--", os, logFileOutputStream);
            this.writeUTF8(boundary, os, logFileOutputStream);
            this.writeUTF8("\r\nContent-Type: ", os, logFileOutputStream);
            if (batchAttach.getCompressionType() != null && batchAttach.getCompressionType().equals("application/gzip")) {
                this.writeUTF8("application/gzip", os, logFileOutputStream);
            } else {
                this.writeUTF8(batchAttach.getMimeType(), os, logFileOutputStream);
            }
            this.writeUTF8("\r\nContent-Transfer-Encoding: binary\r\nContent-Disposition: attachment; filename=\"", os, logFileOutputStream);
            String filename = batchAttach.getFilename();
            if (filename == null || filename.isEmpty()) {
                this.writeUTF8(batchAttach.getAttachmentCID(), os, logFileOutputStream);
            } else {
                this.writeUTF8(filename, os, logFileOutputStream);
            }
            this.writeUTF8("\"\r\nContent-ID: <", os, logFileOutputStream);
            this.writeUTF8(batchAttach.getAttachmentCID(), os, logFileOutputStream);
            this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
            if (attachmentsBytes != null) {
                this.writeBytes(attachmentsBytes, attachmentsBytes.length, os, logFileOutputStream);
            }
            this.writeUTF8("\r\n", os, logFileOutputStream);
        }
        this.writeUTF8("--", os, logFileOutputStream);
        this.writeUTF8(boundary, os, logFileOutputStream);
        this.writeUTF8("--\r\n", os, logFileOutputStream);
        os.flush();
        if (logFileOutputStream != null) {
            logFileOutputStream.flush();
        }
        conn.connect();
        int responseCode = conn.getResponseCode();
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        InputStream is = conn.getInputStream();
        if (is == null) {
            is = conn.getErrorStream();
        }
        if (logFileOutputStream != null) {
            this.writeUTF8("\nRESPONSE:\n", logFileOutputStream, null);
        }
        GlenixSBRResponse glenixSBRResponse = new GlenixSBRResponse(responseCode, headerFields, is, logFileOutputStream);
        os.close();
        conn.disconnect();
        return glenixSBRResponse;
    }

    public GlenixSBRResponse dorequest_lodge_apache_batch(String urlString, InputStream docInputStream, GlenixSBRAttachment batchAttach, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        String domain = "freeaccountingsoftware.com.au";
        String uuid = UUID.randomUUID().toString();
        String start_content_id = uuid + "@" + domain;
        String boundary = "----=_" + uuid;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(1024);
        conn.setRequestProperty("Content-Type", "multipart/related; boundary=\"" + boundary + "\"; start=\"<" + start_content_id + ">\"; type=\"application/soap+xml\"");
        conn.setRequestProperty("Accept", "*/*");
        OutputStream os = conn.getOutputStream();
        this.writeUTF8("--", os, logFileOutputStream);
        this.writeUTF8(boundary, os, logFileOutputStream);
        this.writeUTF8("\r\nContent-Type: application/soap+xml\r\nContent-Transfer-Encoding: binary\r\nContent-ID: <", os, logFileOutputStream);
        this.writeUTF8(start_content_id, os, logFileOutputStream);
        this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
        byte[] bs = new byte[1000];
        int readlen = 0;
        while ((readlen = docInputStream.read(bs)) >= 0) {
            this.writeBytes(bs, readlen, os, logFileOutputStream);
        }
        if (batchAttach != null && attachments != null) {
            this.writeUTF8("\r\n--", os, logFileOutputStream);
            this.writeUTF8(boundary, os, logFileOutputStream);
            this.writeUTF8("\r\nContent-Type: ", os, logFileOutputStream);
            this.writeUTF8(batchAttach.getMimeType(), os, logFileOutputStream);
            this.writeUTF8("\r\nContent-Transfer-Encoding: binary\r\nContent-Disposition: attachment; filename=\"", os, logFileOutputStream);
            String filename = batchAttach.getFilename();
            if (filename == null || filename.isEmpty()) {
                this.writeUTF8(batchAttach.getAttachmentCID(), os, logFileOutputStream);
            } else {
                this.writeUTF8(filename, os, logFileOutputStream);
            }
            this.writeUTF8("\"\r\nContent-ID: <", os, logFileOutputStream);
            this.writeUTF8(batchAttach.getAttachmentCID(), os, logFileOutputStream);
            this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
            for (int i = 0; i < attachments.size(); ++i) {
                GlenixSBRAttachment attachment = attachments.get(i);
                this.writeUTF8("<Record_Delimiter DocumentID=\"", os, logFileOutputStream);
                this.writeUTF8(attachment.getDocumentID(), os, logFileOutputStream);
                this.writeUTF8("\" DocumentType=\"", os, logFileOutputStream);
                this.writeUTF8(attachment.getDocumentType(), os, logFileOutputStream);
                this.writeUTF8("\" DocumentName=\"", os, logFileOutputStream);
                this.writeUTF8(attachment.getDocumentName(), os, logFileOutputStream);
                this.writeUTF8("\" RelatedDocumentID=\"", os, logFileOutputStream);
                this.writeUTF8(attachment.getRelatedDocumentID(), os, logFileOutputStream);
                this.writeUTF8("\"/>\r\n", os, logFileOutputStream);
                InputStream is = attachment.getInputStream();
                while ((readlen = is.read(bs)) >= 0) {
                    this.writeBytes(bs, readlen, os, logFileOutputStream);
                }
                this.writeUTF8("\r\n", os, logFileOutputStream);
            }
        }
        this.writeUTF8("--", os, logFileOutputStream);
        this.writeUTF8(boundary, os, logFileOutputStream);
        this.writeUTF8("--\r\n", os, logFileOutputStream);
        os.flush();
        if (logFileOutputStream != null) {
            logFileOutputStream.flush();
        }
        conn.connect();
        int responseCode = conn.getResponseCode();
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        InputStream is = conn.getInputStream();
        if (is == null) {
            is = conn.getErrorStream();
        }
        if (logFileOutputStream != null) {
            this.writeUTF8("\nRESPONSE:\n", logFileOutputStream, null);
        }
        GlenixSBRResponse glenixSBRResponse = new GlenixSBRResponse(responseCode, headerFields, is, logFileOutputStream);
        os.close();
        conn.disconnect();
        return glenixSBRResponse;
    }

    public GlenixSBRResponse dorequest_lodge_apache(String urlString, InputStream docInputStream, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        InputStream is;
        Map<String, List<String>> headerFields;
        int responseCode;
        OutputStream os;
        HttpURLConnection conn;
        block25: {
            block24: {
                String domain = "freeaccountingsoftware.com.au";
                String uuid = UUID.randomUUID().toString();
                String start_content_id = uuid + "@" + domain;
                String boundary = "----=_" + uuid;
                boolean doapacheway = false;
                if (doapacheway) {
                    MultipartEntityBuilder meb = MultipartEntityBuilder.create();
                    meb.setBoundary(boundary);
                    FormBodyPartBuilder fbpb1 = FormBodyPartBuilder.create();
                    fbpb1.setName("soapenv");
                    fbpb1.addField("Content-Type", "application/soap+xml");
                    fbpb1.addField("Content-Transfer-Encoding", "binary");
                    fbpb1.addField("Content-ID", "<" + start_content_id + ">");
                    fbpb1.addField("Content-Disposition", "attachment; name=\"soapenv\"; filename=\"soapenv\"");
                    fbpb1.setBody(new InputStreamBody(docInputStream, "soapenv"));
                    FormBodyPart fbp1 = fbpb1.build();
                    meb.addPart(fbp1);
                    for (int i = 0; i < attachments.size(); ++i) {
                        GlenixSBRAttachment attachment = attachments.get(i);
                        FormBodyPartBuilder fbpb2 = FormBodyPartBuilder.create();
                        fbpb2.setName(attachment.getAttachmentCID());
                        fbpb2.addField("Content-Type", attachment.getMimeType());
                        fbpb2.addField("Content-Transfer-Encoding", "binary");
                        String filename = attachment.getFilename();
                        if (filename == null || filename.isEmpty()) {
                            fbpb2.addField("Content-Disposition", "attachment; filename=\"" + attachment.getAttachmentCID() + "\"");
                        } else {
                            fbpb2.addField("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                        }
                        fbpb2.addField("Content-ID", "<" + attachment.getAttachmentCID() + ">");
                        fbpb2.setBody(new InputStreamBody(attachment.getInputStream(), attachment.getAttachmentCID()));
                        FormBodyPart fbp2 = fbpb2.build();
                        meb.addPart(fbp2);
                    }
                    HttpEntity entity = meb.build();
                    DefaultHttpClient httpClient = new DefaultHttpClient();
                    HttpPost httpRequest = new HttpPost(urlString);
                    httpRequest.setHeader("Content-Type", "multipart/related; boundary=\"" + boundary + "\"; start=\"<" + start_content_id + ">\"; type=\"application/soap+xml\"");
                    httpRequest.setEntity(entity);
                    CloseableHttpResponse httpresponse = httpClient.execute(httpRequest);
                    return null;
                }
                URL url = new URL(urlString);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setChunkedStreamingMode(1024);
                conn.setRequestProperty("Content-Type", "multipart/related; boundary=\"" + boundary + "\"; start=\"<" + start_content_id + ">\"; type=\"application/soap+xml\"");
                conn.setRequestProperty("Accept", "*/*");
                os = conn.getOutputStream();
                this.writeUTF8("--", os, logFileOutputStream);
                this.writeUTF8(boundary, os, logFileOutputStream);
                this.writeUTF8("\r\nContent-Type: application/soap+xml\r\nContent-Transfer-Encoding: binary\r\nContent-ID: <", os, logFileOutputStream);
                this.writeUTF8(start_content_id, os, logFileOutputStream);
                this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
                byte[] bs = new byte[1000];
                int readlen = 0;
                while ((readlen = docInputStream.read(bs)) >= 0) {
                    this.writeBytes(bs, readlen, os, logFileOutputStream);
                }
                if (attachments != null) {
                    for (int i = 0; i < attachments.size(); ++i) {
                        GlenixSBRAttachment attachment = attachments.get(i);
                        this.writeUTF8("\r\n--", os, logFileOutputStream);
                        this.writeUTF8(boundary, os, logFileOutputStream);
                        this.writeUTF8("\r\nContent-Type: ", os, logFileOutputStream);
                        if (attachment.getCompressionType() != null && attachment.getCompressionType().equals("application/gzip")) {
                            this.writeUTF8("application/gzip", os, logFileOutputStream);
                        } else {
                            this.writeUTF8(attachment.getMimeType(), os, logFileOutputStream);
                        }
                        this.writeUTF8("\r\nContent-Transfer-Encoding: binary\r\nContent-Disposition: attachment; filename=\"", os, logFileOutputStream);
                        String filename = attachment.getFilename();
                        if (filename == null || filename.isEmpty()) {
                            this.writeUTF8(attachment.getAttachmentCID(), os, logFileOutputStream);
                        } else {
                            this.writeUTF8(filename, os, logFileOutputStream);
                        }
                        this.writeUTF8("\"\r\nContent-ID: <", os, logFileOutputStream);
                        this.writeUTF8(attachment.getAttachmentCID(), os, logFileOutputStream);
                        this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
                        InputStream is2 = attachment.getInputStream();
                        InputStream logIs = attachment.getLogInputStream();
                        if (logFileOutputStream != null && logIs != null) {
                            while ((readlen = logIs.read(bs)) >= 0) {
                                this.writeBytes(bs, readlen, logFileOutputStream, null);
                            }
                            while ((readlen = is2.read(bs)) >= 0) {
                                this.writeBytes(bs, readlen, os, null);
                            }
                            continue;
                        }
                        while ((readlen = is2.read(bs)) >= 0) {
                            this.writeBytes(bs, readlen, os, logFileOutputStream);
                        }
                    }
                }
                this.writeUTF8("\r\n--", os, logFileOutputStream);
                this.writeUTF8(boundary, os, logFileOutputStream);
                this.writeUTF8("--\r\n", os, logFileOutputStream);
                os.flush();
                if (logFileOutputStream != null) {
                    logFileOutputStream.flush();
                }
                conn.connect();
                responseCode = -1;
                try {
                    responseCode = conn.getResponseCode();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (logFileOutputStream == null) break block24;
                    PrintWriter pw = new PrintWriter(logFileOutputStream);
                    e.printStackTrace(pw);
                }
            }
            headerFields = conn.getHeaderFields();
            is = null;
            try {
                is = conn.getInputStream();
                try {
                    if (is == null) {
                        is = conn.getErrorStream();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (is != null) break block25;
                is = conn.getErrorStream();
            }
        }
        if (logFileOutputStream != null) {
            this.writeUTF8("\nRESPONSE:\n", logFileOutputStream, null);
        }
        GlenixSBRResponse glenixSBRResponse = new GlenixSBRResponse(responseCode, headerFields, is, logFileOutputStream);
        os.close();
        conn.disconnect();
        return glenixSBRResponse;
    }

    public GlenixSBRResponse dorequest_lodge_apache_gzip(String urlString, InputStream docInputStream, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        InputStream is;
        Map<String, List<String>> headerFields;
        int responseCode;
        OutputStream os;
        HttpURLConnection conn;
        block20: {
            block19: {
                String domain = "freeaccountingsoftware.com.au";
                String uuid = UUID.randomUUID().toString();
                String start_content_id = uuid + "@" + domain;
                String boundary = "----=_" + uuid;
                URL url = new URL(urlString);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setChunkedStreamingMode(1024);
                conn.setRequestProperty("Content-Type", "multipart/related; boundary=\"" + boundary + "\"; start=\"<" + start_content_id + ">\"; type=\"application/soap+xml\"");
                conn.setRequestProperty("Accept", "*/*");
                os = conn.getOutputStream();
                this.writeUTF8("--", os, logFileOutputStream);
                this.writeUTF8(boundary, os, logFileOutputStream);
                this.writeUTF8("\r\nContent-Type: application/soap+xml\r\nContent-Transfer-Encoding: binary\r\nContent-ID: <", os, logFileOutputStream);
                this.writeUTF8(start_content_id, os, logFileOutputStream);
                this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
                byte[] bs = new byte[1000];
                int readlen = 0;
                while ((readlen = docInputStream.read(bs)) >= 0) {
                    this.writeBytes(bs, readlen, os, logFileOutputStream);
                }
                if (attachments != null) {
                    for (int i = 0; i < attachments.size(); ++i) {
                        GlenixSBRAttachment attachment = attachments.get(i);
                        this.writeUTF8("\r\n--", os, logFileOutputStream);
                        this.writeUTF8(boundary, os, logFileOutputStream);
                        this.writeUTF8("\r\nContent-Type: ", os, logFileOutputStream);
                        if (attachment.getCompressionType() != null && attachment.getCompressionType().equals("application/gzip")) {
                            this.writeUTF8("application/gzip", os, logFileOutputStream);
                        } else {
                            this.writeUTF8(attachment.getMimeType(), os, logFileOutputStream);
                        }
                        this.writeUTF8("\r\nContent-Transfer-Encoding: binary\r\nContent-Disposition: attachment; filename=\"", os, logFileOutputStream);
                        String filename = attachment.getFilename();
                        if (filename == null || filename.isEmpty()) {
                            this.writeUTF8(attachment.getAttachmentCID(), os, logFileOutputStream);
                        } else {
                            this.writeUTF8(filename, os, logFileOutputStream);
                        }
                        this.writeUTF8("\"\r\nContent-ID: <", os, logFileOutputStream);
                        this.writeUTF8(attachment.getAttachmentCID(), os, logFileOutputStream);
                        this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
                        if (attachment.getCompressionType() != null && attachment.getCompressionType().equals("application/gzip")) {
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(os), "UTF-8");
                            byte[] bs2 = new byte[1000];
                            int readlen2 = 0;
                            InputStream is2 = attachment.getInputStream();
                            while ((readlen2 = is2.read(bs2)) >= 0) {
                                writer.write(new String(bs2, 0, readlen2));
                                if (logFileOutputStream == null) continue;
                                this.writeUTF8(new String(bs2, 0, readlen2), logFileOutputStream, null);
                            }
                            MessageDigest messageDigest = this.calcDigestBytes(output.toByteArray(), "SHA-1");
                            continue;
                        }
                        InputStream is3 = attachment.getInputStream();
                        while ((readlen = is3.read(bs)) >= 0) {
                            this.writeBytes(bs, readlen, os, logFileOutputStream);
                        }
                    }
                }
                this.writeUTF8("\r\n--", os, logFileOutputStream);
                this.writeUTF8(boundary, os, logFileOutputStream);
                this.writeUTF8("--\r\n", os, logFileOutputStream);
                os.flush();
                if (logFileOutputStream != null) {
                    logFileOutputStream.flush();
                }
                conn.connect();
                responseCode = -1;
                try {
                    responseCode = conn.getResponseCode();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (logFileOutputStream == null) break block19;
                    PrintWriter pw = new PrintWriter(logFileOutputStream);
                    e.printStackTrace(pw);
                }
            }
            headerFields = conn.getHeaderFields();
            is = null;
            try {
                is = conn.getInputStream();
                try {
                    if (is == null) {
                        is = conn.getErrorStream();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (is != null) break block20;
                is = conn.getErrorStream();
            }
        }
        if (logFileOutputStream != null) {
            this.writeUTF8("\nRESPONSE:\n", logFileOutputStream, null);
        }
        GlenixSBRResponse glenixSBRResponse = new GlenixSBRResponse(responseCode, headerFields, is, logFileOutputStream);
        os.close();
        conn.disconnect();
        return glenixSBRResponse;
    }

    public void writeUTF8(String content, OutputStream os, OutputStream logos) throws IOException {
        if (logos != null) {
            logos.write(content.getBytes("UTF-8"));
        }
        os.write(content.getBytes("UTF-8"));
    }

    public void writeBytes(byte[] content, int readlen, OutputStream os, OutputStream logos) throws IOException {
        if (logos != null) {
            logos.write(content, 0, readlen);
        }
        os.write(content, 0, readlen);
    }

    public GlenixSBRResponse dorequest_lodge_apache(String urlString, final Document doc, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer1 = tf.newTransformer();
        transformer1.setOutputProperty("omit-xml-declaration", "no");
        transformer1.setOutputProperty("method", "xml");
        transformer1.setOutputProperty("encoding", "UTF-8");
        transformer1.setOutputProperty("standalone", "yes");
        PipedInputStream docinpipe = new PipedInputStream();
        final PipedOutputStream docoutpipe = new PipedOutputStream(docinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    transformer1.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)docoutpipe, "UTF-8")));
                    docoutpipe.flush();
                    docoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return this.dorequest_lodge_apache(urlString, docinpipe, attachments, logFileOutputStream);
    }

    public GlenixSBRResponse dorequest_lodge_apache_batch(String urlString, final Document doc, GlenixSBRAttachment batchAttach, List<GlenixSBRAttachment> attachments, OutputStream logFileOutputStream) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer1 = tf.newTransformer();
        transformer1.setOutputProperty("omit-xml-declaration", "no");
        transformer1.setOutputProperty("method", "xml");
        transformer1.setOutputProperty("encoding", "UTF-8");
        transformer1.setOutputProperty("standalone", "yes");
        PipedInputStream docinpipe = new PipedInputStream();
        final PipedOutputStream docoutpipe = new PipedOutputStream(docinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    transformer1.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)docoutpipe, "UTF-8")));
                    docoutpipe.flush();
                    docoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return this.dorequest_lodge_apache_batch(urlString, docinpipe, batchAttach, attachments, logFileOutputStream);
    }

    public GlenixSBRResponse dorequest_lodge_apache_batch_gzip(String urlString, final Document doc, GlenixSBRAttachment batchAttach, byte[] attachmentsBytes, OutputStream logFileOutputStream) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer1 = tf.newTransformer();
        transformer1.setOutputProperty("omit-xml-declaration", "no");
        transformer1.setOutputProperty("method", "xml");
        transformer1.setOutputProperty("encoding", "UTF-8");
        transformer1.setOutputProperty("standalone", "yes");
        PipedInputStream docinpipe = new PipedInputStream();
        final PipedOutputStream docoutpipe = new PipedOutputStream(docinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    transformer1.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)docoutpipe, "UTF-8")));
                    docoutpipe.flush();
                    docoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return this.dorequest_lodge_apache_batch_gzip(urlString, docinpipe, batchAttach, attachmentsBytes, logFileOutputStream);
    }

    public GlenixSBRResponse dorequest_pull_apache(String urlString, InputStream docInputStream, OutputStream logFileOutputStream) throws Exception {
        String domain = "freeaccountingsoftware.com.au";
        String uuid = UUID.randomUUID().toString();
        String start_content_id = uuid + "@" + domain;
        String boundary = "----=_" + uuid;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(1024);
        conn.setRequestProperty("Content-Type", "multipart/related; boundary=\"" + boundary + "\"; start=\"<" + start_content_id + ">\"; type=\"application/soap+xml\"");
        conn.setRequestProperty("Accept", "*/*");
        if (logFileOutputStream != null) {
            this.writeUTF8("\nREQUEST:\n", logFileOutputStream, null);
        }
        OutputStream os = conn.getOutputStream();
        this.writeUTF8("--", os, logFileOutputStream);
        this.writeUTF8(boundary, os, logFileOutputStream);
        this.writeUTF8("\r\nContent-Type: application/soap+xml\r\nContent-Transfer-Encoding: binary\r\nContent-ID: <", os, logFileOutputStream);
        this.writeUTF8(start_content_id, os, logFileOutputStream);
        this.writeUTF8(">\r\n\r\n", os, logFileOutputStream);
        byte[] bs = new byte[1000];
        int readlen = 0;
        while ((readlen = docInputStream.read(bs)) >= 0) {
            this.writeBytes(bs, readlen, os, logFileOutputStream);
        }
        this.writeUTF8("\r\n--", os, logFileOutputStream);
        this.writeUTF8(boundary, os, logFileOutputStream);
        this.writeUTF8("--\r\n", os, logFileOutputStream);
        os.flush();
        if (logFileOutputStream != null) {
            logFileOutputStream.flush();
        }
        conn.connect();
        int responseCode = conn.getResponseCode();
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        InputStream is = conn.getInputStream();
        if (is == null) {
            is = conn.getErrorStream();
        }
        if (logFileOutputStream != null) {
            this.writeUTF8("\nRESPONSE:\n", logFileOutputStream, null);
        }
        GlenixSBRResponse glenixSBRResponse = new GlenixSBRResponse(responseCode, headerFields, is, logFileOutputStream);
        os.close();
        conn.disconnect();
        return glenixSBRResponse;
    }

    public GlenixSBRResponse dorequest_pull_apache(String urlString, final Document doc, OutputStream logFileOutputStream) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer1 = tf.newTransformer();
        transformer1.setOutputProperty("omit-xml-declaration", "no");
        transformer1.setOutputProperty("method", "xml");
        transformer1.setOutputProperty("encoding", "UTF-8");
        transformer1.setOutputProperty("standalone", "yes");
        PipedInputStream docinpipe = new PipedInputStream();
        final PipedOutputStream docoutpipe = new PipedOutputStream(docinpipe);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    transformer1.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)docoutpipe, "UTF-8")));
                    docoutpipe.flush();
                    docoutpipe.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return this.dorequest_pull_apache(urlString, docinpipe, logFileOutputStream);
    }

    public static void addKeyInfoElement(Document doc, String BinarySecurityToken_id) {
        Element node_Signature = GlenixAUSKey.getSignatureElement(doc);
        if (node_Signature == null) {
            return;
        }
        Element node_KeyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        node_Signature.appendChild(node_KeyInfo);
        node_KeyInfo.setAttribute("Id", "KeyId-1");
        Element node_SecurityTokenReference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
        node_KeyInfo.appendChild(node_SecurityTokenReference);
        Element node_Reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        node_SecurityTokenReference.appendChild(node_Reference);
        node_Reference.setAttribute("URI", "#" + BinarySecurityToken_id);
        node_Reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
    }

    public static Element getSignatureElement(Document doc) {
        try {
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            XPathExpression expr = xpath.compile("/*[local-name()='Envelope']/*[local-name()='Header']/*[local-name()='Security']/*[local-name()='Signature']");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            if (i < nodes.getLength()) {
                return (Element)nodes.item(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Element getSecurityElement(Document doc) {
        try {
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            XPathExpression expr = xpath.compile("/*[local-name()='Envelope']/*[local-name()='Header']/*[local-name()='Security']");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            if (i < nodes.getLength()) {
                return (Element)nodes.item(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Element getSignatureValueElement(Document doc) {
        try {
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            XPathExpression expr = xpath.compile("/*[local-name()='Envelope']/*[local-name()='Header']/*[local-name()='Security']/*[local-name()='Signature']/*[local-name()='SignatureValue']");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            if (i < nodes.getLength()) {
                return (Element)nodes.item(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getEncryptedData(Document doc) {
        try {
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            XPathExpression expr = xpath.compile("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='RequestSecurityTokenResponseCollection']/*[local-name()='RequestSecurityTokenResponse']/*[local-name()='RequestedSecurityToken']/*[local-name()='EncryptedAssertion']/*[local-name()='EncryptedData']");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            if (i < nodes.getLength()) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                DOMSource source2 = new DOMSource(nodes.item(i));
                StringWriter writer2 = new StringWriter();
                StreamResult result2 = new StreamResult(writer2);
                transformer.transform(source2, result2);
                return writer2.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Node getEncryptedDataNode(Document doc) {
        try {
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            XPathExpression expr = xpath.compile("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='RequestSecurityTokenResponseCollection']/*[local-name()='RequestSecurityTokenResponse']/*[local-name()='RequestedSecurityToken']/*[local-name()='EncryptedAssertion']/*[local-name()='EncryptedData']");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            if (i < nodes.getLength()) {
                return nodes.item(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void dorequest(String docstr) throws Exception {
        String line;
        if (this.stsurl == null || this.stsurl.isEmpty()) {
            throw new Exception("Cannot do request stsurl is null");
        }
        if (this.stsurlhost == null || this.stsurlhost.isEmpty()) {
            throw new Exception("Cannot do request stsurlhost is null");
        }
        byte[] postData = docstr.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        URL url = new URL(this.stsurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/soap+xml;charset=UTF-8;action=\"http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue\"");
        connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        connection.setRequestProperty("Host", this.stsurlhost);
        connection.setRequestProperty("Accept", "*/*");
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.write(postData);
        wr.flush();
        wr.close();
        connection.getOutputStream().flush();
        InputStream is = connection.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        while ((line = rd.readLine()) != null) {
            System.out.println(line);
        }
        rd.close();
        connection.getResponseCode();
        connection.disconnect();
    }

    public HttpResponse dorequest_apache(String docstr) throws Exception {
        if (this.stsurl == null || this.stsurl.isEmpty()) {
            throw new Exception("Cannot do request stsurl is null");
        }
        if (this.stsurlhost == null || this.stsurlhost.isEmpty()) {
            throw new Exception("Cannot do request stsurlhost is null");
        }
        docstr = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + docstr;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpRequest = new HttpPost(this.stsurl);
        httpRequest.setHeader("Host", this.stsurlhost);
        httpRequest.setHeader("Content-Type", "application/soap+xml;charset=UTF-8;action=\"http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue\"");
        StringEntity xmlEntity = new StringEntity(docstr);
        httpRequest.setEntity(xmlEntity);
        CloseableHttpResponse httpresponse = httpClient.execute(httpRequest);
        return httpresponse;
    }

    public void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        this.transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public byte[] decryptBytes(byte[] encBytes) throws Exception {
        if (this.privateKey == null) {
            throw new Exception("Error, private key not set cannot decrypt.");
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, this.privateKey);
        byte[] bytes = cipher.doFinal(encBytes);
        return bytes;
    }

    public PGPPublicKey convertToPGPPublicKey() throws Exception {
        return null;
    }

    public PGPPrivateKey convertToPGPPrivateKey() throws Exception {
        return null;
    }
}

