/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationBorderPane;
import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixApplication;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.Security;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Glenix
extends Application
implements GlenixApplication {
    public static String versionNumber = "3.0.17";
    public static String productName = "www.freeaccountingsoftware.com.au";
    public static String versionNumberSBR = "3.0";
    public static String softwareNameSBR = "www.freeaccountingsoftware.com.au";
    public static String companyNameSBR = "Free Accounting Pty Ltd";
    public static String csrEmailDomain = "freeaccountingsoftware.com.au";
    public static String messageDomain = "freeaccountingsoftware.com.au";
    public static String dspABN = "38111951645";
    public static String dspIdentifierType = "http://abr.gov.au/PartyIdType/ABN";
    public static String dspRole = "DigitalServiceProvider";
    public static String soap_service_register_profile = "http://www.freeaccountingsoftware.com.au/soap/register_profile";
    public static String soap_service_business_files = "http://www.freeaccountingsoftware.com.au/soap/business_files";
    public static String soap_service_usage = "http://www.freeaccountingsoftware.com.au/soap/usage";
    public static String soap_service_version = "http://www.freeaccountingsoftware.com.au/soap/version";
    public static String soap_action_submit = "Submit";
    public static String soap_legal_name_identifier = "Legal name";
    public static String soap_user_role_identifier = "User";
    public static String productIDSBR = "130486";
    public static String STSURL = "https://authentication.business.gov.au/R3.0/vanguard/S007v1.2/service.svc";
    public static String STSURLHOST = "authentication.business.gov.au";
    public static String STSEndpointRef = "https://ato.sbr.gov.au/services";
    public static String SingleSyncURL = "https://prod2.ato.sbr.gov.au/services/Single-sync";
    public static String BatchAsyncPushURL = "https://prod2.ato.sbr.gov.au/services/BulkBatch-async-push";
    public static String BatchAsyncPullURL = "https://prod2.ato.sbr.gov.au/services/BulkBatch-async-pull";
    public static String fasSoapURL = "https://v3.freeaccountingsoftware.com.au/soap";
    public static String fas3DesktopDownloadURL = "https://www.freeaccountingsoftware.com.au/FAS3Desktop.jar";
    public static String fas_identity_check_url = "https://v3.freeaccountingsoftware.com.au/identity_check/";
    public static String codeName = "FAS3 Desktop";
    private ApplicationController rc;
    private ApplicationBorderPane applicationBorderPane;
    public static boolean redirect_console = false;
    public static PrintStream console;
    private static File logFile;

    public void start(Stage stage) throws Exception {
        try {
            List args;
            Security.addProvider(new BouncyCastleProvider());
            Font.loadFont((String)this.getClass().getResource("/muli/Muli-Light.ttf").toExternalForm(), (double)15.0);
            Font.loadFont((String)this.getClass().getResource("/muli/Muli-Regular.ttf").toExternalForm(), (double)15.0);
            Font.loadFont((String)this.getClass().getResource("/muli/Muli-Bold.ttf").toExternalForm(), (double)15.0);
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
            Preferences preferences = Preferences.userNodeForPackage(Glenix.class);
            String stage_x = preferences.get("stage_x", null);
            Double left = primaryScreenBounds.getMinX();
            boolean userconfigleft = false;
            if (stage_x != null && !stage_x.isEmpty()) {
                try {
                    left = Double.parseDouble(stage_x);
                    userconfigleft = true;
                }
                catch (Exception e) {
                    left = null;
                }
                if (left == null) {
                    left = primaryScreenBounds.getMinX();
                    userconfigleft = false;
                }
            }
            Double width = 960.0;
            String stage_width = preferences.get("stage_width", null);
            if (stage_width != null && !stage_width.isEmpty()) {
                try {
                    width = Double.parseDouble(stage_width);
                }
                catch (Exception e) {
                    width = null;
                }
                if (width == null) {
                    width = 960.0;
                }
            }
            if (width > primaryScreenBounds.getWidth()) {
                width = primaryScreenBounds.getWidth();
                if (width < 100.0) {
                    width = 100.0;
                }
            } else if (!userconfigleft) {
                left = primaryScreenBounds.getWidth() - width;
            }
            stage.setX(left.doubleValue());
            stage.setWidth(width.doubleValue());
            String stage_y = preferences.get("stage_y", null);
            Double top = primaryScreenBounds.getMinY();
            if (stage_y != null && !stage_y.isEmpty()) {
                try {
                    top = Double.parseDouble(stage_y);
                }
                catch (Exception e) {
                    top = null;
                }
                if (top == null) {
                    top = primaryScreenBounds.getMinY();
                }
            }
            Double height = primaryScreenBounds.getHeight();
            String stage_height = preferences.get("stage_height", null);
            if (stage_height != null && !stage_height.isEmpty()) {
                try {
                    height = Double.parseDouble(stage_height);
                }
                catch (Exception e) {
                    height = null;
                }
                if (height == null) {
                    height = primaryScreenBounds.getHeight();
                }
            }
            if (height < 100.0) {
                height = 100.0;
            }
            stage.setY(top.doubleValue());
            stage.setHeight(height.doubleValue());
            Init.init();
            this.applicationBorderPane = new ApplicationBorderPane(stage, this);
            File installPath = this.applicationBorderPane.locateInstallDirectory();
            if (installPath != null && redirect_console) {
                File logfile = new File(installPath.getAbsolutePath() + "/FAS3Desktop_log.txt");
                Glenix.setLogFile(logfile);
            }
            Scene scene = new Scene((Parent)this.applicationBorderPane);
            stage.setScene(scene);
            stage.show();
            stage.setTitle("Free Accounting Software understands small business and very small business. " + this.getCodeName());
            stage.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number oldStageWidth, Number newStageWidth) {
                    Glenix.this.applicationBorderPane.setColumnsWidth(newStageWidth);
                }
            });
            this.applicationBorderPane.setColumnsWidth(stage.getWidth());
            this.applicationBorderPane.setCurrentFontSizeToConfigFontSize();
            this.applicationBorderPane.updateTheme();
            this.applicationBorderPane.gotoWelcomePage(false);
            Application.Parameters p = this.getParameters();
            if (p != null && (args = p.getRaw()).size() == 1) {
                this.applicationBorderPane.setMyBusinessFileToOpen((String)args.get(0));
            }
            KeyCodeCombination keyCombinationCtrlF = new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
            scene.getAccelerators().put((Object)keyCombinationCtrlF, (Object)new Runnable(){

                @Override
                public void run() {
                    Glenix.this.applicationBorderPane.focusSearch();
                }
            });
            KeyCodeCombination keyCodeCombinationCtrlPlus = new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_ANY});
            scene.getAccelerators().put((Object)keyCodeCombinationCtrlPlus, (Object)new Runnable(){

                @Override
                public void run() {
                    Glenix.this.applicationBorderPane.increaseFont();
                }
            });
            KeyCharacterCombination keyCharCombinationCtrlMinus = new KeyCharacterCombination("-", new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
            scene.getAccelerators().put((Object)keyCharCombinationCtrlMinus, (Object)new Runnable(){

                @Override
                public void run() {
                    Glenix.this.applicationBorderPane.decreaseFont();
                }
            });
            KeyCharacterCombination keyCharCombinationCtrlZero = new KeyCharacterCombination("0", new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
            scene.getAccelerators().put((Object)keyCharCombinationCtrlZero, (Object)new Runnable(){

                @Override
                public void run() {
                    Glenix.this.applicationBorderPane.resetFont();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getCodeName() {
        return codeName;
    }

    public static void main(String[] args) {
        File installFile;
        console = System.err;
        if ((args.length == 2 || args.length == 3) && args[0].equals("-install") && (installFile = new File(args[1])) != null && installFile.exists() && !installFile.isDirectory()) {
            try {
                Glenix.installJarFileFile(installFile);
                Runtime rt = Runtime.getRuntime();
                String[] cmdarray = new String[]{"java", "-jar", installFile.getAbsolutePath()};
                if (args.length == 3) {
                    cmdarray = new String[]{"java", "-jar", installFile.getAbsolutePath(), args[2]};
                }
                Process p = rt.exec(cmdarray);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            System.exit(0);
        }
        Glenix.launch((String[])args);
    }

    public static void setLogFile(File logFile) {
        try {
            Glenix.logFile = logFile;
            FileOutputStream fos = new FileOutputStream(logFile);
            PrintStream ps = new PrintStream(fos);
            System.setErr(ps);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.setErr(console);
        }
    }

    public static File getLogFile() {
        return logFile;
    }

    public void stop() {
        try {
            if (this.applicationBorderPane != null) {
                this.applicationBorderPane.closeGlenixFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.applicationBorderPane.setStatusBarMessage(e.getMessage());
            return;
        }
        System.exit(0);
    }

    public static File getThisJarFile() throws Exception {
        URL url = Glenix.class.getResource("Glenix.class");
        String jarFilePath = URLDecoder.decode(url.toString(), "UTF-8");
        if (jarFilePath == null) {
            return null;
        }
        File result = new File((jarFilePath = jarFilePath.replaceFirst("jar:file:", "").replace("!/au/com/glenix/Glenix.class", "")).trim());
        if (result.exists()) {
            return result;
        }
        url = Glenix.class.getProtectionDomain().getCodeSource().getLocation();
        return new File(url.toURI());
    }

    public static File installJarFile(File installDir) throws Exception {
        if (installDir == null) {
            throw new Exception("Error, cannot install jar file into null directory");
        }
        if (!installDir.exists() && !installDir.mkdirs()) {
            throw new Exception("Error, unable to create the install directory, " + installDir.getAbsolutePath());
        }
        if (!installDir.canWrite()) {
            throw new Exception("Error, unable to write to the install directory, " + installDir.getAbsolutePath());
        }
        File jarFile = Glenix.getThisJarFile();
        if (jarFile == null || !jarFile.exists()) {
            throw new Exception("Error, unable to locate source jar file");
        }
        File installFile = new File(installDir.getAbsoluteFile() + File.separator + "FAS3Desktop.jar");
        Files.copy(jarFile.toPath(), installFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        InputStream icoIs = Glenix.class.getResourceAsStream("/au/com/glenix/images/FAS3Desktop.ico");
        File installIco = null;
        if (icoIs != null && (installIco = new File(installDir.getAbsoluteFile() + File.separator + "FAS3Desktop.ico")) != null) {
            try {
                Files.copy(icoIs, installIco.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                installIco = null;
            }
        }
        return installFile;
    }

    public static void installJarFileFile(File installFile) throws Exception {
        if (installFile == null) {
            throw new Exception("Error, cannot install jar file into null file");
        }
        if (!installFile.exists() && !installFile.getParentFile().mkdirs()) {
            throw new Exception("Error, unable to create the install directory, " + installFile.getParentFile().getAbsolutePath());
        }
        if (!installFile.canWrite()) {
            throw new Exception("Error, unable to write to the install file, " + installFile.getAbsolutePath());
        }
        File jarFile = Glenix.getThisJarFile();
        if (jarFile == null || !jarFile.exists()) {
            throw new Exception("Error, unable to locate source jar file");
        }
        Files.copy(jarFile.toPath(), installFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        InputStream icoIs = Glenix.class.getResourceAsStream("/au/com/glenix/images/FAS3Desktop.ico");
        File installIco = null;
        if (icoIs != null && (installIco = new File(installFile.getParentFile().getAbsoluteFile() + File.separator + "FAS3Desktop.ico")) != null) {
            try {
                Files.copy(icoIs, installIco.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                installIco = null;
            }
        }
    }

    static {
        logFile = null;
    }
}

