/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.GSTObligation;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.Pair;

public class GSTObligationController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private GlenixLabelBlankNoYesCombo GoodsAndServicesTax_SelectedReportingOption_Code;
    @FXML
    private GlenixLabelBlankNoYesCombo GoodsAndServicesTax_LiabilityVariationReason_Code;
    @FXML
    private GlenixLabelLabel Calculation_GoodsAndServicesTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel ATO_GoodsAndServicesTax_Liability_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Estimate_GoodsAndServicesTax_Liability_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Variation_GoodsAndServicesTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel GoodsAndServicesTax_LiabilityInstalmentsTotal_Amount;
    @FXML
    private GlenixLabelLabel GoodsAndServicesTax_Payable_Amount;
    @FXML
    private GlenixLabelLabel GoodsAndServicesTax_ClaimableCredits_Amount;
    @FXML
    private GlenixLabelLabel WineEqualisationTax_ClaimableCredits_Amount;
    @FXML
    private GlenixLabelLabel WineEqualisationTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel LuxuryCarTax_ClaimableCredits_Amount;
    @FXML
    private GlenixLabelLabel LuxuryCarTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel FuelTax_ClaimableCredits_Amount;
    @FXML
    private GlenixLabelLabel FuelTax_OverclaimedCredits_Amount;
    @FXML
    private GlenixLabelLabel GST_DeferredLiabilityOnImportDuty_Amount;
    @FXML
    private Hyperlink show_calculation;
    @FXML
    private Hyperlink hide_calculation;
    @FXML
    private VBox gst_sales_calculation;
    @FXML
    private VBox gst_purchases_calculation;
    private DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private GSTObligation gstObligation = null;
    private ChangeListener<GSTObligation> changeListener = null;
    private String status;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        ChangeListener<Pair<String, String>> cl = new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                GSTObligationController.this.updateTotals();
                if (GSTObligationController.this.changeListener != null) {
                    GSTObligationController.this.changeListener.changed(null, (Object)GSTObligationController.this.gstObligation, (Object)GSTObligationController.this.gstObligation);
                }
            }
        };
        this.GoodsAndServicesTax_SelectedReportingOption_Code.setSingleChangeListener((ChangeListener<String>)cl);
        this.GoodsAndServicesTax_LiabilityVariationReason_Code.setSingleChangeListener((ChangeListener<String>)cl);
        this.Variation_GoodsAndServicesTax_Liability_Amount.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GSTObligationController.this.updateTotals();
                if (GSTObligationController.this.changeListener != null) {
                    GSTObligationController.this.changeListener.changed(null, (Object)GSTObligationController.this.gstObligation, (Object)GSTObligationController.this.gstObligation);
                }
            }
        });
        this.hide_calculation();
    }

    public void setDocumentStatus(String status) {
        this.status = status;
    }

    public void setGSTObligationModel(GSTObligation gstObligation) {
        this.gstObligation = gstObligation;
        String startDate = gstObligation.getStartDate();
        String endDate = gstObligation.getEndDate();
        if (startDate != null && endDate != null) {
            LocalDate ld = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
            String formattedStartDate = ld.format(this.outputDateFormatter);
            ld = LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE);
            String formattedEndDate = ld.format(this.outputDateFormatter);
            this.page_heading.setText("GST obligation from " + formattedStartDate + " to " + formattedEndDate);
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        String options = gstObligation.getAvailableReportingOptionsText();
        if (options != null && !options.isEmpty()) {
            String[] optionsarray;
            for (String anoption : optionsarray = options.split(",")) {
                if ("0".equals(anoption)) {
                    pairs.add(new Pair((Object)"0", (Object)"None"));
                    continue;
                }
                if ("1".equals(anoption)) {
                    pairs.add(new Pair((Object)"1", (Object)"1 - Calc GST And Report Quarterly"));
                    continue;
                }
                if ("2".equals(anoption)) {
                    pairs.add(new Pair((Object)"2", (Object)"2 - Calc GST Quarterly And Report Annually"));
                    continue;
                }
                if (!"3".equals(anoption)) continue;
                pairs.add(new Pair((Object)"3", (Object)"3 - Pay GST Instalment Amount Quarterly"));
            }
        } else {
            pairs.add(new Pair((Object)"0", (Object)"None"));
        }
        ObservableList olPairs = FXCollections.observableList(pairs);
        this.GoodsAndServicesTax_SelectedReportingOption_Code.setItems((ObservableList<Pair<String, String>>)olPairs);
        String selectedValue = gstObligation.getSelectedReportingOptionCode();
        this.GoodsAndServicesTax_SelectedReportingOption_Code.setGlenixElementValue(selectedValue);
        pairs = new ArrayList();
        pairs.add(new Pair((Object)"", (Object)""));
        pairs.add(new Pair((Object)"22", (Object)"22 - Current business structure not continuing"));
        pairs.add(new Pair((Object)"23", (Object)"23 - Significant change in trading conditions"));
        pairs.add(new Pair((Object)"24", (Object)"24 - Internal business restructure"));
        pairs.add(new Pair((Object)"25", (Object)"25 - Change in legislation or product mix"));
        pairs.add(new Pair((Object)"26", (Object)"26 - Financial market changes"));
        olPairs = FXCollections.observableList(pairs);
        this.GoodsAndServicesTax_LiabilityVariationReason_Code.setItems((ObservableList<Pair<String, String>>)olPairs);
        selectedValue = gstObligation.getLiabilityVariationReasonCode();
        this.GoodsAndServicesTax_LiabilityVariationReason_Code.setGlenixElementValue(selectedValue);
        this.updateTotals();
    }

    public void setSingleChangeListener(ChangeListener<GSTObligation> changeListener) {
        this.changeListener = changeListener;
    }

    public void updateTotals() {
        if (this.status != null && this.status.equals("lodge_complete")) {
            return;
        }
        String reportingOption = this.GoodsAndServicesTax_SelectedReportingOption_Code.getGlenixElementValue();
        String liabilityVariationCode = this.GoodsAndServicesTax_LiabilityVariationReason_Code.getGlenixElementValue();
        if (liabilityVariationCode == null || liabilityVariationCode.isEmpty()) {
            this.GoodsAndServicesTax_LiabilityInstalmentsTotal_Amount.setText(this.ATO_GoodsAndServicesTax_Liability_Amount.getGlenixElementValue());
            if (reportingOption == null || reportingOption.isEmpty() || reportingOption.equals("0") || reportingOption.equals("1") || reportingOption.equals("2")) {
                String val = this.Calculation_GoodsAndServicesTax_Liability_Amount.getGlenixElementValue();
                if (val == null || val.isEmpty()) {
                    this.GoodsAndServicesTax_Payable_Amount.setText("0");
                } else {
                    this.GoodsAndServicesTax_Payable_Amount.setText(val);
                }
                this.Variation_GoodsAndServicesTax_Liability_Amount.setDisable(true);
                this.Estimate_GoodsAndServicesTax_Liability_Amount.setDisable(true);
                this.GoodsAndServicesTax_LiabilityVariationReason_Code.setGlenixElementValue(null);
                this.GoodsAndServicesTax_LiabilityVariationReason_Code.setDisable(true);
            } else {
                String val = this.GoodsAndServicesTax_LiabilityInstalmentsTotal_Amount.getGlenixElementValue();
                if (val == null || val.isEmpty()) {
                    this.GoodsAndServicesTax_Payable_Amount.setText("0");
                } else {
                    this.GoodsAndServicesTax_Payable_Amount.setText(val);
                }
                this.GoodsAndServicesTax_LiabilityVariationReason_Code.setDisable(false);
            }
        } else {
            this.GoodsAndServicesTax_LiabilityInstalmentsTotal_Amount.setText(this.Variation_GoodsAndServicesTax_Liability_Amount.getGlenixElementValue());
            this.Variation_GoodsAndServicesTax_Liability_Amount.setDisable(false);
            this.Estimate_GoodsAndServicesTax_Liability_Amount.setDisable(false);
            if (reportingOption != null && (reportingOption.equals("1") || reportingOption.equals("2"))) {
                String val = this.Calculation_GoodsAndServicesTax_Liability_Amount.getGlenixElementValue();
                if (val == null || val.isEmpty()) {
                    this.GoodsAndServicesTax_Payable_Amount.setText("0");
                } else {
                    this.GoodsAndServicesTax_Payable_Amount.setText(val);
                }
                this.Variation_GoodsAndServicesTax_Liability_Amount.setDisable(true);
                this.Estimate_GoodsAndServicesTax_Liability_Amount.setDisable(true);
                this.GoodsAndServicesTax_LiabilityVariationReason_Code.setGlenixElementValue(null);
                this.GoodsAndServicesTax_LiabilityVariationReason_Code.setDisable(true);
            } else {
                String val = this.GoodsAndServicesTax_LiabilityInstalmentsTotal_Amount.getGlenixElementValue();
                if (val == null || val.isEmpty()) {
                    this.GoodsAndServicesTax_Payable_Amount.setText("0");
                } else {
                    this.GoodsAndServicesTax_Payable_Amount.setText(val);
                }
                this.GoodsAndServicesTax_LiabilityVariationReason_Code.setDisable(false);
            }
        }
    }

    private Double convertToDouble(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public Double getGoodsAndServicesTax_Payable_Amount() {
        return this.convertToDouble(this.GoodsAndServicesTax_Payable_Amount.getGlenixElementValue());
    }

    public Double getGoodsAndServicesTax_ClaimableCredits_Amount() {
        String reportingOption = this.GoodsAndServicesTax_SelectedReportingOption_Code.getGlenixElementValue();
        if (reportingOption == null || reportingOption.isEmpty() || reportingOption.equals("0") || reportingOption.equals("1") || reportingOption.equals("2")) {
            return this.convertToDouble(this.GoodsAndServicesTax_ClaimableCredits_Amount.getGlenixElementValue());
        }
        return 0.0;
    }

    public Double getWineEqualisationTax_ClaimableCredits_Amount() {
        return this.convertToDouble(this.WineEqualisationTax_ClaimableCredits_Amount.getGlenixElementValue());
    }

    public Double getWineEqualisationTax_Liability_Amount() {
        return this.convertToDouble(this.WineEqualisationTax_Liability_Amount.getGlenixElementValue());
    }

    public Double getLuxuryCarTax_ClaimableCredits_Amount() {
        return this.convertToDouble(this.LuxuryCarTax_ClaimableCredits_Amount.getGlenixElementValue());
    }

    public Double getLuxuryCarTax_Liability_Amount() {
        return this.convertToDouble(this.LuxuryCarTax_Liability_Amount.getGlenixElementValue());
    }

    public Double getFuelTax_ClaimableCredits_Amount() {
        return this.convertToDouble(this.FuelTax_ClaimableCredits_Amount.getGlenixElementValue());
    }

    public Double getFuelTax_OverclaimedCredits_Amount() {
        return this.convertToDouble(this.FuelTax_OverclaimedCredits_Amount.getGlenixElementValue());
    }

    public Double getGST_DeferredLiabilityOnImportDuty_Amount() {
        return this.convertToDouble(this.GST_DeferredLiabilityOnImportDuty_Amount.getGlenixElementValue());
    }

    @FXML
    public void show_calculation() {
        this.gst_purchases_calculation.setVisible(true);
        this.gst_sales_calculation.setVisible(true);
        this.show_calculation.setVisible(false);
        this.hide_calculation.setVisible(true);
        this.gst_purchases_calculation.setManaged(true);
        this.gst_sales_calculation.setManaged(true);
        this.hide_calculation.setManaged(true);
        this.hide_calculation.requestFocus();
        this.show_calculation.setManaged(false);
    }

    @FXML
    public void hide_calculation() {
        this.gst_purchases_calculation.setVisible(false);
        this.gst_sales_calculation.setVisible(false);
        this.show_calculation.setVisible(true);
        this.hide_calculation.setVisible(false);
        this.gst_purchases_calculation.setManaged(false);
        this.gst_sales_calculation.setManaged(false);
        this.show_calculation.setManaged(true);
        this.show_calculation.requestFocus();
        this.hide_calculation.setManaged(false);
    }
}

