/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountCombo;
import au.com.glenix.GlenixLabelProvisionCombo;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FuelTaxCreditEditController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private GlenixLabelAccountCombo fuelTaxCreditAccountIdentifier;
    @FXML
    private GlenixLabelProvisionCombo FTCProvisionIdentifier;
    @FXML
    private GlenixLabelProvisionCombo FTCOverclaimedProvisionIdentifier;
    private ApplicationController applicationController = null;
    private DocumentBuilder dBuilder;
    private FuelTaxCredit fuelTaxCredit = null;

    public FuelTaxCreditEditController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList3.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, el);
                        }
                    }
                }
            }
        }
    }

    public void setFuelTaxCreditElement(FuelTaxCredit fuelTaxCredit) throws Exception {
        if (fuelTaxCredit == null) {
            this.clearFuelTaxCreditElement();
            return;
        }
        this.fuelTaxCredit = fuelTaxCredit;
    }

    public void clearFuelTaxCreditElement() {
        this.fuelTaxCredit = null;
    }

    public void setAccountList(ObservableList<Transaction> tol) {
        this.fuelTaxCreditAccountIdentifier.setItems(tol);
    }

    public void setProvisionList(ObservableList<Transaction> tol) {
        this.FTCProvisionIdentifier.setItems(tol);
        this.FTCOverclaimedProvisionIdentifier.setItems(tol);
    }

    @FXML
    private void saveFuelTaxCredit() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.fuelTaxCredit == null) {
                this.fuelTaxCredit = this.applicationController.addFuelTaxCredit();
            }
            this.fuelTaxCredit.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            this.applicationController.saveFuelTaxCredit(this.fuelTaxCredit);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearFuelTaxCredit() {
        this.clearGlenixXBRL();
        this.clearFuelTaxCreditElement();
        this.error_message.setText("Fuel tax credit");
    }

    @FXML
    private void gotoFuelTaxCreditList() {
        this.applicationController.gotoFuelTaxCreditList();
    }

    @FXML
    private void gotoFuelTaxCreditTransactions() {
        try {
            this.applicationController.gotoFuelTaxCreditTransactionsE(null, this.fuelTaxCredit);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }
}

