/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixCertificate;
import au.com.glenix.trn.GlenixCertificateList;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import org.w3c.dom.Document;

public class FileAccessViewCertificateController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private TextArea public_certificate;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private ApplicationController xbrlFileController = null;
    @FXML
    private Label common_name;

    public FileAccessViewCertificateController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    public String getPublicKeyDerStr(GlenixCertificate gc) {
        String publicKeyDer = gc.getPublicCertificate();
        if (publicKeyDer != null && !publicKeyDer.isEmpty()) {
            return publicKeyDer;
        }
        publicKeyDer = gc.getPemEncodedPublicCertificate();
        if (publicKeyDer == null || publicKeyDer.isEmpty()) {
            return null;
        }
        publicKeyDer = publicKeyDer.replace("-----BEGIN CERTIFICATE-----\n", "");
        publicKeyDer = publicKeyDer.replace("-----END CERTIFICATE-----", "");
        publicKeyDer = publicKeyDer.replaceAll("\n", "");
        publicKeyDer = publicKeyDer.replaceAll("\r", "");
        publicKeyDer = publicKeyDer.trim();
        return publicKeyDer;
    }

    private PublicKey readPublicKey(String publicKeyStr) throws Exception {
        ByteArrayInputStream bis;
        if (publicKeyStr == null || publicKeyStr.isEmpty()) {
            throw new Exception("Error, public key string is empty cannot read public key.");
        }
        String tmpString = publicKeyStr.replaceAll("\n", "");
        tmpString = tmpString.replaceAll("\r", "");
        byte[] pubcertbytes = Base64.getDecoder().decode(tmpString);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certCollection = cf.generateCertificates(bis = new ByteArrayInputStream(pubcertbytes));
        Iterator<? extends Certificate> certIterator = certCollection.iterator();
        if (certIterator.hasNext()) {
            X509Certificate firstCert = (X509Certificate)certIterator.next();
            return firstCert.getPublicKey();
        }
        throw new Exception("Error, cannot extract public key from provided string.");
    }

    private void checkCertificate() {
        this.common_name.setText(null);
        if (this.glenixTrnXBRL == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        Business b = this.glenixTrnXBRL.getBusiness();
        if (b == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        String pemEncodedCert = this.public_certificate.getText();
        try {
            X509Certificate x = this.xbrlFileController.readX509CertificatePEM(pemEncodedCert);
            if (x == null) {
                this.error_message.setText("Invalid certificate");
                this.xbrlFileController.setStatusBarMessage("Invalid certificate");
            } else {
                String commonName = this.xbrlFileController.getX509CertificateCommonNameUnverified(x);
                if (commonName != null && !commonName.isEmpty() && !commonName.toLowerCase().contains("verified")) {
                    X509Certificate downloadedX;
                    boolean isSigned = this.xbrlFileController.x509CertificateIsSignedBoolean(x);
                    if (!isSigned && (downloadedX = this.xbrlFileController.updateSignedCertificate(x.getPublicKey())) != null) {
                        x = downloadedX;
                        isSigned = this.xbrlFileController.x509CertificateIsSignedBoolean(x);
                        String xStr = this.xbrlFileController.getPublicKeyPEM(x);
                        this.public_certificate.setText(xStr);
                    }
                    if (isSigned) {
                        this.common_name.setText(commonName + " (Identity verified)");
                        this.common_name.getStyleClass().removeAll((Object[])new String[]{"error"});
                        this.common_name.getStyleClass().add((Object)"success");
                    } else {
                        this.common_name.setText(commonName + " (NOT verified)");
                        this.common_name.getStyleClass().removeAll((Object[])new String[]{"success"});
                        this.common_name.getStyleClass().add((Object)"error");
                    }
                    this.error_message.setText(null);
                    this.xbrlFileController.setStatusBarMessage(null);
                } else {
                    this.common_name.setText("Invalid certificate");
                    this.common_name.getStyleClass().removeAll((Object[])new String[]{"success"});
                    this.common_name.getStyleClass().add((Object)"error");
                    this.error_message.setText("Invalid certificate");
                    this.xbrlFileController.setStatusBarMessage("Invalid certificate");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL, X509Certificate x509) {
        block6: {
            this.glenixTrnXBRL = glenixTrnXBRL;
            try {
                Business b;
                if (glenixTrnXBRL == null) break block6;
                Document doc = glenixTrnXBRL.buildDocument();
                if (doc != null) {
                    this.loadGlenixXBRL(doc, doc.getDocumentElement());
                }
                if ((b = glenixTrnXBRL.getBusiness()) == null) {
                    throw new Exception("Error, certificate list corruption.");
                }
                GlenixCertificateList gcl = b.getGlenixCertificateList();
                if (gcl == null) {
                    throw new Exception("Error, certificate list corruption.");
                }
                PublicKey gcPublicKey = x509.getPublicKey();
                if (gcPublicKey == null) break block6;
                for (int i = 0; i < gcl.getGlenixCertificateCount(); ++i) {
                    GlenixCertificate gclgc = gcl.getGlenixCertificate(i);
                    String gclpkStr = this.getPublicKeyDerStr(gclgc);
                    PublicKey gclPublicKey = this.readPublicKey(gclpkStr);
                    if (gclPublicKey == null || !Arrays.equals(gclPublicKey.getEncoded(), gcPublicKey.getEncoded())) continue;
                    this.public_certificate.setText(gclgc.getPemEncodedPublicCertificate());
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
        this.checkCertificate();
    }

    @FXML
    private void backToFileAccess() {
        try {
            this.xbrlFileController.gotoFileAccessE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

