/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixCertificate;
import au.com.glenix.trn.GlenixCertificateList;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Document;
import sun.security.x509.X500Name;

public class FileAccessController
extends GlenixBranchController {
    @FXML
    protected Label error_message;
    @FXML
    protected TableView certificate_table;
    @FXML
    protected TableColumn commonNameColumn;
    protected GlenixTrnXBRL glenixTrnXBRL = null;
    protected ApplicationController xbrlFileController = null;
    protected ObservableList<X509Certificate> gclObservableList = FXCollections.observableArrayList();

    public FileAccessController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.certificate_table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                X509Certificate x509;
                if (event.getClickCount() == 2 && !row.isEmpty() && (x509 = (X509Certificate)row.getItem()) != null) {
                    try {
                        this.gotoViewCertificate(x509);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_message.setText("Error, could not open file.");
                        this.xbrlFileController.setStatusBarMessage("Error, could not open file.");
                    }
                }
            });
            return row;
        });
        this.commonNameColumn.setCellFactory((Callback)new Callback<TableColumn<X509Certificate, X500Principal>, TableCell<X509Certificate, X500Principal>>(){

            public TableCell call(TableColumn<X509Certificate, X500Principal> param) {
                TableCell<X509Certificate, X500Principal> cell = new TableCell<X509Certificate, X500Principal>(){

                    public void updateItem(X500Principal item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            X509Certificate x = (X509Certificate)this.getTableRow().getItem();
                            try {
                                boolean isset = false;
                                String cn = FileAccessController.this.xbrlFileController.getX509CertificateCommonNameUnverified(x);
                                if (cn != null && !cn.isEmpty() && !cn.toLowerCase().contains("verified")) {
                                    boolean isSigned = false;
                                    try {
                                        FileAccessController.this.xbrlFileController.x509CertificateIsSigned(x);
                                        isSigned = true;
                                    }
                                    catch (Exception e) {
                                        isSigned = false;
                                    }
                                    cn = isSigned ? cn + " (Identity verified)" : cn + " (NOT verified)";
                                    this.setText(cn);
                                    isset = true;
                                }
                                if (!isset) {
                                    this.setText("Invalid");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                String name = FileAccessController.this.extractCommonName(item);
                                this.setText(name);
                            }
                        }
                    }
                };
                return cell;
            }
        });
    }

    protected void gotoViewCertificate(X509Certificate x509) {
        try {
            this.xbrlFileController.gotoFileAccessViewCertificateE(x509);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected X509Certificate readX509(String publicKeyStr) throws Exception {
        ByteArrayInputStream bis;
        if (publicKeyStr == null || publicKeyStr.isEmpty()) {
            throw new Exception("Error, public key string is empty cannot read public key.");
        }
        String tmpString = publicKeyStr.replaceAll("\n", "");
        tmpString = tmpString.replaceAll("\r", "");
        byte[] pubcertbytes = Base64.getDecoder().decode(tmpString);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certCollection = cf.generateCertificates(bis = new ByteArrayInputStream(pubcertbytes));
        Iterator<? extends Certificate> certIterator = certCollection.iterator();
        if (certIterator.hasNext()) {
            X509Certificate firstCert = (X509Certificate)certIterator.next();
            return firstCert;
        }
        throw new Exception("Error, cannot extract public key from provided string.");
    }

    public String getPublicKeyDerStr(String pemStr) {
        String publicKeyDer = pemStr.replace("-----BEGIN CERTIFICATE-----\n", "");
        publicKeyDer = publicKeyDer.replace("-----END CERTIFICATE-----", "");
        publicKeyDer = publicKeyDer.replaceAll("\n", "");
        publicKeyDer = publicKeyDer.replaceAll("\r", "");
        publicKeyDer = publicKeyDer.trim();
        return publicKeyDer;
    }

    protected String extractCommonName(X500Principal subjectPrincipal) {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            X500Name x500name = new X500Name(subjectPrincipal.getName());
            return x500name.getCommonName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setCertificateObservableList() {
        Business business = this.glenixTrnXBRL.getBusiness();
        if (business == null) {
            this.error_message.setText("There are no certificates with access to this file.");
            return;
        }
        GlenixCertificateList gcl = business.getGlenixCertificateList();
        if (gcl == null) {
            this.error_message.setText("There are no certificates with access to this file.");
            return;
        }
        this.gclObservableList.removeAll(this.gclObservableList);
        ArrayList<GlenixCertificate> gcal = gcl.getGlenixCertificateList();
        for (int i = 0; i < gcal.size(); ++i) {
            GlenixCertificate gc = gcal.get(i);
            String pemStr = gc.getPemEncodedPublicCertificate();
            String derStr = null;
            if (pemStr != null) {
                derStr = this.getPublicKeyDerStr(pemStr);
            }
            if (derStr == null) {
                derStr = gc.getPublicCertificate();
            }
            if (derStr == null || derStr.isEmpty()) continue;
            try {
                X509Certificate x509 = this.readX509(derStr);
                if (x509 == null) continue;
                this.gclObservableList.add((Object)x509);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.certificate_table.refresh();
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setCertificateObservableList();
            this.certificate_table.setItems(this.gclObservableList);
            this.certificate_table.refresh();
        }
    }

    @FXML
    protected void addAccessCertificate() {
        try {
            this.xbrlFileController.gotoFileAccessAddCertificateE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void deleteSelectedCertificates() {
        if (this.glenixTrnXBRL == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        Business b = this.glenixTrnXBRL.getBusiness();
        if (b == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        try {
            ObservableList selectedCerts = this.certificate_table.getSelectionModel().getSelectedItems();
            GlenixCertificateList gcl = b.getOrAddGlenixCertificateList();
            if (gcl != null && selectedCerts != null && selectedCerts.size() > 0) {
                this.xbrlFileController.deleteGlenixCertificatesX509((List<X509Certificate>)selectedCerts);
                this.setModel(this.xbrlFileController.getFileAccess());
            } else {
                String message = "Error, there are no selected certificates to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void addAccessForGlen() {
        if (this.glenixTrnXBRL == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        Business b = this.glenixTrnXBRL.getBusiness();
        if (b == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        String glenspublickey = "-----BEGIN CERTIFICATE-----\nMIICzzCCAbegAwIBAgIVAKfAm94O9avK3jbrekrACPP3mDJwMA0GCSqGSIb3DQEB\nCwUAMCExHzAdBgNVBAMMFkdsZW4gU3RlcGhlbiBIYXNzZWxtYW4wHhcNMTgwNzE3\nMDAwMDAwWhcNMjMwNzE3MDAwMDAwWjAhMR8wHQYDVQQDDBZHbGVuIFN0ZXBoZW4g\nSGFzc2VsbWFuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsW38ftSe\n/wY/3czkxdpj8P6QCrXtT4Iykwn6Cm7+oEKkcSBk8EtVWYcm/kS9lzhMK80cOLPs\nagDy99t//LmVGkfWzB4vktXEKzhSI8O23yZfihix2cABx+4g4jKcogXZ0nwFs+5y\nuOEiSJyji+1Uuq/cBK73Xk7A9H1iFeTrj6gFFFCvxAqwYza43Biu6l6RbsaKAgXE\nNMYTF+MLp9CU7hR+fqAelpXA48xf0hRV/8W0y56kfumjpIisA157XgrGmmI/wVf0\nbbneTfplFDJ+tf0hjlRHkVUSO7W3vHmBDqDQI/TtFXPVqeAXvIVmDfvA3YATma/L\nyWCkgKuAnYIJKwIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQCteKRHWo6Ev4XMBfyJ\nq7q1jiZNQqiazi/oi6ZsvcpdgMDP1Zr7YG4T3N71HNBjhzj9OVoN1Ne9Whgf6RNM\nBF8y13vNoI71dqo87GicR4qCE0ICzUKCl00RLR0KG/gO2aIeXYWQ6Ro1qmFVgCcc\ncYOCw1/ydlbpiHRIAD0+nKcXgsoGbbkMjZSS6IWahGSTsebkHfB46lirsH3znnu8\noY6yWwq3XtjbwmwYYBKVtPiCK3fV+5SoUTVFLWMt2VRwtywJ98sL2YFL6iX+CrMA\nMDxdcgNl4sUjv1PHGXKK9vj4/yRMClqDDb+YPVzq8e3u5lB6lyag26LFXB1B2Ati\n5Wm3\n-----END CERTIFICATE-----";
        try {
            this.xbrlFileController.addPublicKeyPem(glenspublickey);
            this.error_message.setText("Saved");
            this.xbrlFileController.setStatusBarMessage("Saved");
            this.xbrlFileController.gotoFileAccessE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

