/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import java.security.cert.X509Certificate;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import org.w3c.dom.Document;

public class FileAccessAddCertificateController
extends GlenixBranchController {
    @FXML
    protected Label error_message;
    @FXML
    protected TextArea public_certificate;
    protected GlenixTrnXBRL glenixTrnXBRL = null;
    protected ApplicationController xbrlFileController = null;
    @FXML
    protected Button addAccessCertificateButton;
    @FXML
    protected Label common_name;

    public FileAccessAddCertificateController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        Document doc;
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null && (doc = glenixTrnXBRL.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.addAccessCertificateButton.setDisable(true);
    }

    @FXML
    protected void checkCertificate() {
        this.common_name.setText(null);
        if (this.glenixTrnXBRL == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        Business b = this.glenixTrnXBRL.getBusiness();
        if (b == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        String pemEncodedCert = this.public_certificate.getText();
        try {
            X509Certificate x = this.xbrlFileController.readX509CertificatePEM(pemEncodedCert);
            if (x == null) {
                this.error_message.setText("Invalid certificate");
                this.xbrlFileController.setStatusBarMessage("Invalid certificate");
            } else {
                String commonName = this.xbrlFileController.getX509CertificateCommonNameUnverified(x);
                if (commonName != null && !commonName.isEmpty() && !commonName.toLowerCase().contains("verified")) {
                    X509Certificate downloadedX;
                    boolean isSigned = this.xbrlFileController.x509CertificateIsSignedBoolean(x);
                    if (!isSigned && (downloadedX = this.xbrlFileController.updateSignedCertificate(x.getPublicKey())) != null) {
                        x = downloadedX;
                        isSigned = this.xbrlFileController.x509CertificateIsSignedBoolean(x);
                        String xStr = this.xbrlFileController.getPublicKeyPEM(x);
                        this.public_certificate.setText(xStr);
                    }
                    if (isSigned) {
                        this.common_name.setText(commonName + " (Identity verified)");
                        this.common_name.getStyleClass().removeAll((Object[])new String[]{"error"});
                        this.common_name.getStyleClass().add((Object)"success");
                    } else {
                        this.common_name.setText(commonName + " (NOT verified)");
                        this.common_name.getStyleClass().removeAll((Object[])new String[]{"success"});
                        this.common_name.getStyleClass().add((Object)"error");
                    }
                    this.error_message.setText(null);
                    this.xbrlFileController.setStatusBarMessage(null);
                    this.addAccessCertificateButton.setDisable(false);
                } else {
                    this.common_name.setText("Invalid certificate");
                    this.common_name.getStyleClass().removeAll((Object[])new String[]{"success"});
                    this.common_name.getStyleClass().add((Object)"error");
                    this.addAccessCertificateButton.setDisable(true);
                    this.error_message.setText("Invalid certificate");
                    this.xbrlFileController.setStatusBarMessage("Invalid certificate");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void addAccessCertificate() {
        if (this.glenixTrnXBRL == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        Business b = this.glenixTrnXBRL.getBusiness();
        if (b == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        String pemEncodedCert = this.public_certificate.getText();
        try {
            this.xbrlFileController.addPublicKeyPem(pemEncodedCert);
            this.error_message.setText("Saved");
            this.xbrlFileController.setStatusBarMessage("Saved");
            this.public_certificate.setText(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void backToFileAccess() {
        try {
            this.xbrlFileController.gotoFileAccessE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

