/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.trn.FBTObligation;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelZeroDecimalNumber;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.util.Pair;

public class FBTObligationController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private GlenixLabelBlankNoYesCombo FringeBenefitsTax_LiabilityVariationReason_Code;
    @FXML
    private GlenixLabelLabel ATO_FringeBenefitsTax_Liability_Amount;
    @FXML
    private GlenixLabelZeroDecimalNumber Estimation_FringeBenefitsTax_Liability_Amount;
    @FXML
    private GlenixLabelZeroDecimalNumber Variation_FringeBenefitsTax_Liability_Amount;
    @FXML
    private GlenixLabelLabel FringeBenefitsTax_Payable_Amount;
    @FXML
    private GlenixLabelZeroDecimalNumber FringeBenefitsTax_ClaimableCredits_Amount;
    private DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private FBTObligation fbtObligation = null;
    private ChangeListener<FBTObligation> changeListener = null;
    private String status;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.FringeBenefitsTax_LiabilityVariationReason_Code.setSingleComboChangeListener(new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                FBTObligationController.this.updateTotals();
                if (FBTObligationController.this.changeListener != null) {
                    FBTObligationController.this.changeListener.changed(null, (Object)FBTObligationController.this.fbtObligation, (Object)FBTObligationController.this.fbtObligation);
                }
            }
        });
        ChangeListener<String> cl = new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FBTObligationController.this.updateTotals();
                if (FBTObligationController.this.changeListener != null) {
                    FBTObligationController.this.changeListener.changed(null, (Object)FBTObligationController.this.fbtObligation, (Object)FBTObligationController.this.fbtObligation);
                }
            }
        };
        this.Variation_FringeBenefitsTax_Liability_Amount.setSingleChangeListener(cl);
        this.FringeBenefitsTax_ClaimableCredits_Amount.setSingleChangeListener(cl);
    }

    public void setSingleChangeListener(ChangeListener<FBTObligation> changeListener) {
        this.changeListener = changeListener;
    }

    public void setFBTObligationModel(FBTObligation fbtObligation) {
        this.fbtObligation = fbtObligation;
        String startDate = fbtObligation.getStartDate();
        String endDate = fbtObligation.getEndDate();
        if (startDate != null && endDate != null) {
            LocalDate ld = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
            String formattedStartDate = ld.format(this.outputDateFormatter);
            ld = LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE);
            String formattedEndDate = ld.format(this.outputDateFormatter);
            this.page_heading.setText("FBT obligation from " + formattedStartDate + " to " + formattedEndDate);
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair((Object)"", (Object)""));
        pairs.add(new Pair((Object)"22", (Object)"22 - Current business structure not continuing"));
        pairs.add(new Pair((Object)"30", (Object)"30 - Change in fringe benefits for employees"));
        pairs.add(new Pair((Object)"31", (Object)"31 - Change in employees with fringe benefits"));
        pairs.add(new Pair((Object)"32", (Object)"32 - Fringe benefits rebate now claimed"));
        ObservableList olPairs = FXCollections.observableList(pairs);
        this.FringeBenefitsTax_LiabilityVariationReason_Code.setItems((ObservableList<Pair<String, String>>)olPairs);
        String selectedValue = fbtObligation.getLiabilityVariationReasonCode();
        this.FringeBenefitsTax_LiabilityVariationReason_Code.setGlenixElementValue(selectedValue);
    }

    public void setDocumentStatus(String status) {
        this.status = status;
    }

    public void updateTotals() {
        if (this.status != null && this.status.equals("lodge_complete")) {
            return;
        }
        String liabilityVariationCode = this.FringeBenefitsTax_LiabilityVariationReason_Code.getGlenixElementValue();
        if (liabilityVariationCode == null || liabilityVariationCode.isEmpty()) {
            this.FringeBenefitsTax_Payable_Amount.setText(this.ATO_FringeBenefitsTax_Liability_Amount.getText());
            this.Estimation_FringeBenefitsTax_Liability_Amount.setDisable(true);
            this.Variation_FringeBenefitsTax_Liability_Amount.setDisable(true);
        } else {
            this.FringeBenefitsTax_Payable_Amount.setText(this.Variation_FringeBenefitsTax_Liability_Amount.getText());
            this.Estimation_FringeBenefitsTax_Liability_Amount.setDisable(false);
            this.Variation_FringeBenefitsTax_Liability_Amount.setDisable(false);
        }
    }

    private Double convertToDouble(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public Double getFringeBenefitsTax_Payable_Amount() {
        return this.convertToDouble(this.FringeBenefitsTax_Payable_Amount.getGlenixElementValue());
    }

    public Double getFringeBenefitsTax_ClaimableCredits_Amount() {
        return this.convertToDouble(this.FringeBenefitsTax_ClaimableCredits_Amount.getGlenixElementValue());
    }
}

