/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.SearchListener;
import au.com.glenix.trn.EventItem;
import au.com.glenix.widget.GlenixBranchController;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class EventItemController
extends GlenixBranchController {
    @FXML
    private Hyperlink event_item_message;
    private String locations;
    private DocumentBuilder dBuilder;
    private EventItem eventItem = null;
    private SearchListener searchListener = null;

    public EventItemController() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(false);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            this.dBuilder = null;
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
    }

    public void setEventItemModel(EventItem eventItem) {
        this.event_item_message.setWrapText(true);
        this.eventItem = eventItem;
        if (eventItem == null) {
            this.event_item_message.setText(null);
        } else {
            String desc = eventItem.getParsedLongestDescription();
            String severity = eventItem.getSeverityCode();
            if (severity != null && !severity.isEmpty()) {
                desc = severity + ": " + desc;
            }
            String codeLocation = eventItem.getCodeLocation();
            this.locations = eventItem.getLocations();
            if (desc == null || desc.isEmpty()) {
                if (codeLocation == null || codeLocation.isEmpty()) {
                    this.event_item_message.setText(null);
                } else {
                    this.event_item_message.setText(codeLocation);
                }
            } else if (this.dBuilder == null) {
                if (codeLocation == null || codeLocation.isEmpty()) {
                    this.event_item_message.setText(desc);
                } else {
                    this.event_item_message.setText(desc + " " + codeLocation);
                }
            } else {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(desc.getBytes("UTF-8"));
                    Document doc = this.dBuilder.parse(bis);
                    if (codeLocation == null || codeLocation.isEmpty()) {
                        this.event_item_message.setText(doc.getDocumentElement().getTextContent());
                    } else {
                        this.event_item_message.setText(doc.getDocumentElement().getTextContent() + " " + codeLocation);
                    }
                }
                catch (Exception e) {
                    if (codeLocation == null || codeLocation.isEmpty()) {
                        this.event_item_message.setText(desc);
                    }
                    this.event_item_message.setText(desc + " " + codeLocation);
                }
            }
        }
        String severity = eventItem.getSeverityCode();
        if (severity == null || severity.equals("Information")) {
            this.event_item_message.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.event_item_message.getStyleClass().removeAll((Object[])new String[]{"warning"});
            this.event_item_message.getStyleClass().add((Object)"success");
        } else if (severity.equals("Warning")) {
            this.event_item_message.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.event_item_message.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.event_item_message.getStyleClass().add((Object)"warning");
        } else {
            this.event_item_message.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.event_item_message.getStyleClass().removeAll((Object[])new String[]{"warning"});
            this.event_item_message.getStyleClass().add((Object)"error");
        }
        this.event_item_message.setWrapText(true);
    }

    @FXML
    private void search() {
        if (this.searchListener == null) {
            return;
        }
        String fieldname = this.locations;
        int index = fieldname.lastIndexOf(":");
        if (index < 0) {
            return;
        }
        if ((index = (fieldname = fieldname.substring(index + 1)).indexOf("[")) >= 0) {
            fieldname = fieldname.substring(0, index);
        }
        this.searchListener.doSearch(fieldname);
    }

    public void setSearchListener(SearchListener searchListener) {
        this.searchListener = searchListener;
    }
}

