/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.CounterpartyPayrollDetails;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmployeeListController
extends GlenixBranchController {
    @FXML
    private TableView employeeTable;
    @FXML
    private TableColumn<Transaction, String> actionColumn;
    @FXML
    private Label error_message;
    private ObservableList<Transaction> transactionObservableList;
    private FilteredList<Transaction> filteredItems;
    private ApplicationController xbrlFileController = null;
    private GlenixTrnXBRL glenixTrnXBRL = null;

    public EmployeeListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.employeeTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        Transaction transaction = (Transaction)row.getItem();
                        if (transaction != null) {
                            Counterparty c = transaction.getCounterparty();
                            if (c != null) {
                                try {
                                    this.xbrlFileController.gotoCounterpartyPayrollDetailsEdit(c);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.error_message.setText("Error, could not go to employee page.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get counterparty.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get counterparty transaction.");
                        }
                    } else {
                        this.addEmployee();
                    }
                }
            });
            return row;
        });
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        super.buildGlenixXBRL(resultDoc, xbrlEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                super.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    @FXML
    private void addEmployee() {
        try {
            this.xbrlFileController.gotoCounterpartyPayrollDetailsEdit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load employee edit page.");
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setCounterpartyObservableList();
        }
    }

    private void setCounterpartyObservableList() {
        Business business = this.glenixTrnXBRL.getBusiness();
        if (business == null) {
            System.out.println("business counterparty ol is null in employee list");
            return;
        }
        ArrayList<Transaction> transactionArrayList = business.getTransactionArrayList();
        this.transactionObservableList = FXCollections.observableList(transactionArrayList);
        this.filteredItems = new FilteredList(this.transactionObservableList, p -> true);
        this.employeeTable.setItems(this.filteredItems);
    }

    public void updateFilter(String newValue) {
        this.filteredItems.setPredicate(transaction -> {
            if (newValue == null) {
                return true;
            }
            if (transaction == null) {
                return false;
            }
            CounterpartyPayrollDetails cpd = transaction.getCounterpartyPayrollDetails();
            return cpd != null;
        });
    }

    @FXML
    public void refreshTable() {
        this.updateFilter("A value required to make it work");
        this.employeeTable.refresh();
    }
}

