/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelText;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class EditProfileController
extends GlenixBranchController {
    @FXML
    private GlenixLabelText first_name;
    @FXML
    private GlenixLabelText other_given_names;
    @FXML
    private GlenixLabelText surname;
    @FXML
    private GlenixLabelText password;
    @FXML
    private GlenixLabelText registered_agent_number;
    @FXML
    private GlenixLabelText agent_ABN;
    @FXML
    private GlenixLabelText agent_ABN_branch_code;
    @FXML
    private Label error_message;
    private GlenixAUSKey gak = null;
    private GlenixFile gf;
    private DocumentBuilder dBuilder;
    private ApplicationController xbrlFileController = null;
    private Profile profile = null;

    public EditProfileController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.gak = new GlenixAUSKey();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    @FXML
    public void saveProfile() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.profile != null) {
                this.profile.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
                this.xbrlFileController.saveProfileFile();
                this.error_message.setText("Saved");
            } else {
                this.error_message.setText("Could not save no business masterfile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void gotoOutgoingMailServer() {
        try {
            this.xbrlFileController.gotoOutgoingMailServerE();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void viewPublicCertificate() {
        try {
            this.xbrlFileController.gotoViewProfileCertificateE();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void gotoVerifyIdentity() {
        try {
            this.xbrlFileController.gotoVerifyIdentityE();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void saveAndSendProfile() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.profile != null) {
                this.profile.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
                this.xbrlFileController.saveProfileFile();
                this.error_message.setText("Saved");
                this.sendProfileToFAS(this.gak, this.profile.getFullName());
            } else {
                this.error_message.setText("Could not save no business masterfile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendProfileToFAS(GlenixAUSKey gk, String commonName) throws Exception {
        Document profiledoc = this.profile.buildSignableDocument();
        GlenixSBRAttachment gatt = new GlenixSBRAttachment(profiledoc, "profile", gk.calcDigest(profiledoc.getDocumentElement(), "SHA-1"));
        gatt.setMimeType("text/xml");
        gatt.setDocumentType("PROFILE");
        gatt.setDocumentName("profile.xml");
        String messageId = this.generateMessageIdentifier();
        GlenixResult glenixResult = this.xbrlFileController.sendDocumentToFASResult(Glenix.soap_service_register_profile, "PROFILE", gatt);
        this.xbrlFileController.setStatusBarMessage("Interpreting response from FAS...");
        String resultCode = null;
        if (glenixResult != null) {
            resultCode = glenixResult.getResultCode();
        }
        if (resultCode == null) {
            throw new Exception("Error, unable to place order");
        }
        if (!resultCode.equals("OK")) {
            if (resultCode.equals("WARNVERSION")) {
                Platform.runLater(() -> {
                    this.error_message.setText("Warning: There is a new version of this software available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                    this.error_message.setVisible(true);
                    this.error_message.setManaged(true);
                });
                return;
            }
            if (resultCode.equals("WARNLICENSE")) {
                Platform.runLater(() -> {
                    this.error_message.setText("Warning: " + glenixResult.getResultDescription());
                    this.error_message.setVisible(true);
                    this.error_message.setManaged(true);
                });
                return;
            }
            if (resultCode.equals("WARNING")) {
                Platform.runLater(() -> {
                    this.error_message.setText("Warning: " + glenixResult.getResultDescription());
                    this.error_message.setVisible(true);
                    this.error_message.setManaged(true);
                });
                return;
            }
            if (resultCode.equals("ERRORLICENSE")) {
                throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
            }
            if (resultCode.equals("ERRORVERSION")) {
                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
            }
            if (!resultCode.equals("ERROR")) throw new Exception("Error, error code " + resultCode + ", description " + glenixResult.getResultDescription());
            throw new Exception("Error, error code " + resultCode + ", description " + glenixResult.getResultDescription());
        }
        try {
            this.error_message.setText("Profile updated.");
            this.xbrlFileController.setStatusBarMessage("Profile updated.");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

