/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.LayoutImageTitledPane;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.DocumentLayout;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocumentLayoutController
extends GlenixBranchController {
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private DocumentLayout documentLayout = null;
    private ApplicationController xbrlFileController = null;
    private DocumentBuilder dBuilder;
    @FXML
    private VBox addImagePosition;
    @FXML
    private GlenixFlowPane docLayoutFP;
    private ObservableList<String> imagefileslist;
    @FXML
    private Label error_message;

    public DocumentLayoutController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        super.buildGlenixXBRL(resultDoc, businessEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                org.w3c.dom.Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    org.w3c.dom.Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element el = (Element)node2;
                    super.loadGlenixXBRL(loadDoc, el);
                }
            }
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.documentLayout = glenixTrnXBRL.getDocumentLayout();
        } else {
            this.documentLayout = null;
        }
        ArrayList<Node> remove = new ArrayList<Node>();
        for (Node n : this.docLayoutFP.getChildren()) {
            if (!(n instanceof LayoutImageTitledPane)) continue;
            remove.add(n);
        }
        this.docLayoutFP.getChildren().removeAll(remove);
        ArrayList<Path> paths = null;
        try {
            paths = this.xbrlFileController.getFileList("images");
            if (paths != null) {
                ArrayList<String> fileNameStrings = new ArrayList<String>();
                for (Path p : paths) {
                    String pathStr = p.getFileName().toString();
                    if (pathStr.endsWith(".pgp")) {
                        pathStr = pathStr.substring(0, pathStr.length() - 4);
                    }
                    fileNameStrings.add(pathStr);
                }
                this.imagefileslist = FXCollections.observableList(fileNameStrings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.documentLayout != null) {
            List<GlenixElement> ges = this.documentLayout.getChildElementSet("layoutImage");
            for (GlenixElement ge : ges) {
                LayoutImageTitledPane sw = this.addLayoutImage();
                Document gedoc = this.dBuilder.newDocument();
                ge.appendToElement(gedoc);
                sw.getGlenixController().loadGlenixXBRL(gedoc, gedoc.getDocumentElement());
            }
        }
    }

    @FXML
    private LayoutImageTitledPane addLayoutImage() {
        try {
            final LayoutImageTitledPane sw = new LayoutImageTitledPane();
            sw.getGlenixController().initialize(null, null);
            if (this.imagefileslist != null) {
                sw.setImageFiles(this.imagefileslist);
            }
            ObservableList children = this.docLayoutFP.getChildren();
            int index = children.indexOf((Object)this.addImagePosition);
            this.docLayoutFP.getChildren().add(index, (Object)sw);
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    DocumentLayoutController.this.docLayoutFP.getChildren().remove((Object)sw);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            return null;
        }
    }

    @FXML
    private void save() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.glenixTrnXBRL != null) {
                if (this.documentLayout == null) {
                    Business b = this.glenixTrnXBRL.getBusiness();
                    this.documentLayout = b.addDocumentLayout();
                }
                this.documentLayout.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
                this.xbrlFileController.saveBusinessMasterFile();
                this.error_message.setText("Saved");
            } else {
                this.error_message.setText("Could not save no business masterfile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void gotoImageUpload() {
        try {
            this.xbrlFileController.gotoFileImagesList();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }
}

