/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.FileSystemAlreadyExistsException;
import java.util.ArrayList;
import java.util.UUID;
import javafx.fxml.FXML;
import javafx.scene.control.Label;

public class CsrController
extends GlenixBranchController {
    @FXML
    private GlenixLabelText first_name;
    @FXML
    private GlenixLabelText other_given_names;
    @FXML
    private GlenixLabelText surname;
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private GlenixLabelPassword confirm_password;
    @FXML
    private GlenixLabelText registered_agent_number;
    @FXML
    private GlenixLabelText agent_ABN;
    @FXML
    private GlenixLabelText agent_ABN_branch_code;
    @FXML
    private Label error_message;
    private GlenixAUSKey gak;
    private GlenixFile gf;
    private ApplicationController xbrlFileController = null;

    public CsrController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    protected GlenixSBRResponse sendCSR(ArrayList<GlenixSBRAttachment> gattl) throws Exception {
        throw new Exception("Error, CSR not implemented");
    }

    @FXML
    public void createProfile() {
        try {
            this.gak = new GlenixAUSKey();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            return;
        }
        String commonName = ((this.first_name.getText() + " " + this.other_given_names.getText()).trim() + " " + this.surname.getText()).trim();
        if (commonName.equalsIgnoreCase("")) {
            this.error_message.setText("Error, you have not filled in your name");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String passwordString = this.password.getText();
        if (passwordString == null || passwordString.equals("")) {
            this.error_message.setText("Error, password is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!CsrController.checkPasswordComplexity(passwordString)) {
            this.error_message.setText("Error, the entered password does not meet the minimum requirements.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String confirmPasswordString = this.confirm_password.getText();
        if (confirmPasswordString == null || confirmPasswordString.equals("")) {
            this.error_message.setText("Error, password confirmation is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!confirmPasswordString.equals(passwordString)) {
            this.error_message.setText("Error, password confirmation does not match entered password.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        try {
            int readlen;
            this.gak.generatePrivateKey(passwordString.toCharArray(), commonName);
            this.gak.generateCSR(commonName, null);
            GlenixSBRAttachment gatt = new GlenixSBRAttachment(this.gak.getCSRInputStream(), "CSR", this.gak.getCSRDigest(commonName));
            gatt.setMimeType("text/plain");
            gatt.setDocumentType("CSR");
            gatt.setDocumentName("CSR");
            ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
            gattl.add(gatt);
            GlenixSBRResponse glenixSBRResponse = this.sendCSR(gattl);
            glenixSBRResponse.parseResponse();
            InputStream certInputStream = glenixSBRResponse.getInputStreamByDocumentName("CERT");
            if (certInputStream == null) {
                throw new Exception("Error, unable to issue certificate. No response from certificate issuing server.");
            }
            byte[] tmpbuf = new byte[2000];
            String charset = "UTF-8";
            ByteArrayOutputStream certbuffer = new ByteArrayOutputStream();
            while ((readlen = certInputStream.read(tmpbuf)) > 0) {
                certbuffer.write(tmpbuf, 0, readlen);
            }
            certInputStream.close();
            certbuffer.flush();
            String pemFormatCert = new String(certbuffer.toByteArray(), "UTF-8");
            this.gak.setPublicKeyPEM(pemFormatCert);
            String fileDefaultName = commonName.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
            GlenixFile profileFile = this.xbrlFileController.getNewProfileFile(fileDefaultName);
            byte[] certbufferbytes = certbuffer.toByteArray();
            profileFile.saveBytes("public.pem", certbufferbytes, 0, certbufferbytes.length);
            String protectedPrivateKeyPEMString = this.gak.getProtectedPrivateKeyPEM();
            byte[] protectedPrivateKeyPEMBytes = protectedPrivateKeyPEMString.getBytes("UTF-8");
            profileFile.saveBytes("private.pem", protectedPrivateKeyPEMBytes, 0, protectedPrivateKeyPEMBytes.length);
            Profile profile = new Profile();
            profile.setFirstName(this.first_name.getText());
            profile.setOtherGivenNames(this.other_given_names.getText());
            profile.setLastName(this.surname.getText());
            profile.setAgentABN(this.agent_ABN.getText());
            profile.setAgentABNBranch(this.agent_ABN_branch_code.getText());
            profile.setAgentNumber(this.registered_agent_number.getText());
            profile.setProtectedPrivateKey(this.gak.getBase64ProtectedPrivateKeyOneLine());
            profile.setPublicKey(this.gak.getBase64PublicKeyOneLine());
            this.xbrlFileController.setProfileFile(profileFile, profile);
            this.xbrlFileController.saveProfileFile();
            this.xbrlFileController.setGlenixKey(this.gak);
            this.error_message.setText("Success");
            this.xbrlFileController.setStatusBarMessage("Success");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"success");
        }
        catch (FileSystemAlreadyExistsException e) {
            this.error_message.setText("Error, this is overwriting an existing FAS identity please choose a new file.");
            this.xbrlFileController.setStatusBarMessage("Error, this is overwriting an existing FAS identity please choose a new file.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            e.printStackTrace();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            } else {
                this.error_message.setText(e.toString());
                this.xbrlFileController.setStatusBarMessage(e.toString());
            }
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            e.printStackTrace();
        }
    }

    public static boolean checkPasswordComplexity(String password) {
        if (password == null || password.isEmpty() || password.length() < 6) {
            return false;
        }
        int score = 0;
        if (password.matches(".*[a-z]{1}.*")) {
            ++score;
        }
        if (password.matches(".*[A-Z].*")) {
            ++score;
        }
        if (password.matches(".*[0-9].*")) {
            ++score;
        }
        if (password.matches(".*[^a-zA-Z0-9].*")) {
            ++score;
        }
        return score >= 2;
    }
}

