/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CounterpartyTFNDListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    private TableView counterpartyTFNDTable;
    @FXML
    private TableColumn<SBRDocumentTFND0004, String> actionColumn;
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private TableColumn SBRDocumentStatus;
    @FXML
    private TableColumn SBRDocumentDateTime;
    @FXML
    private TableColumn TerminationC;
    @FXML
    private TableColumn ResidencyTaxPurposesPersonStatusC;
    @FXML
    private TableColumn PaymentBasisC;
    @FXML
    private TableColumn getTaxOffsetClaimTaxFreeThresholdI;
    @FXML
    private TableColumn IncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI;
    @FXML
    private TableColumn StudentLoanStudentFinancialSupplementSchemeI;
    private ApplicationController xbrlFileController = null;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private Counterparty counterparty = null;
    private ObservableList<SBRDocumentTFND0004> tfndObservableList;

    public CounterpartyTFNDListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.counterpartyTFNDTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        SBRDocumentTFND0004 sbrDocumentTFND004 = (SBRDocumentTFND0004)row.getItem();
                        if (sbrDocumentTFND004 != null) {
                            try {
                                this.xbrlFileController.gotoCounterpartyTFND(this.counterparty, sbrDocumentTFND004);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.error_message.setText(e.getMessage());
                            }
                        } else {
                            this.error_message.setText("Error, could not get TFN declaration.");
                        }
                    } else {
                        this.error_message.setText("Error, no selected TFN declaration.");
                    }
                }
            });
            return row;
        });
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        super.buildGlenixXBRL(resultDoc, transactionEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1) continue;
                        Element el = (Element)node3;
                        super.loadGlenixXBRL(loadDoc, el);
                    }
                }
            }
        }
    }

    @FXML
    private void editCounterparty() {
        try {
            this.xbrlFileController.gotoCounterpartyPayrollDetailsEdit(this.counterparty);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void addCounterpartyTFND() {
        try {
            this.xbrlFileController.gotoCounterpartyTFND(this.counterparty, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load counterparty TFN declaration page.");
        }
    }

    @FXML
    private void gotoCounterpartyList() {
        try {
            this.xbrlFileController.gotoCounterpartyList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load counterparty list page.");
        }
    }

    public void setCounterpartyElement(Counterparty counterparty) {
        this.counterparty = counterparty;
        this.setCounterpartyTFNDObservableList();
    }

    private void setCounterpartyTFNDObservableList() {
        ArrayList<SBRDocumentTFND0004> sbrDocumentTFND0004ArrayList = this.counterparty.getSBRDocumentTFND0004List();
        this.tfndObservableList = FXCollections.observableList(sbrDocumentTFND0004ArrayList);
        this.counterpartyTFNDTable.setItems(this.tfndObservableList);
    }

    public void refreshTable() {
        this.counterpartyTFNDTable.refresh();
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 15.0);
        gpw.setColumnLeftPosAndWidthMM(3, 35.0, 35.0);
        gpw.setColumnLeftPosAndWidthMM(4, 70.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(5, 90.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(6, 120.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(7, 140.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(8, 160.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(9, 180.0, 20.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (SBRDocumentTFND0004 t : this.tfndObservableList) {
            gpw.prepareString(2, t.getSBRDocumentStatus(), true, fontSize);
            gpw.prepareString(3, t.getPrettySBRDocumentDateTime(), true, fontSize);
            gpw.prepareString(4, t.getTerminationC(), true, fontSize);
            gpw.prepareString(5, t.getResidencyTaxPurposesPersonStatusC(), true, fontSize);
            gpw.prepareString(6, t.getPaymentBasisC(), true, fontSize);
            gpw.prepareString(7, t.getTaxOffsetClaimTaxFreeThresholdI(), true, fontSize);
            gpw.prepareString(8, t.getIncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI(), true, fontSize);
            gpw.prepareString(9, t.getStudentLoanStudentFinancialSupplementSchemeI(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.SBRDocumentStatus.getText(), true, fontSize);
        gpw.prepareString(3, this.SBRDocumentDateTime.getText(), true, fontSize);
        gpw.prepareString(4, this.TerminationC.getText(), true, fontSize);
        gpw.prepareString(5, this.ResidencyTaxPurposesPersonStatusC.getText(), true, fontSize);
        gpw.prepareString(6, this.PaymentBasisC.getText(), true, fontSize);
        gpw.prepareString(7, this.getTaxOffsetClaimTaxFreeThresholdI.getText(), true, fontSize);
        gpw.prepareString(8, this.IncomeTaxPayAsYouGoWithholdingStudyAndTrainingLoanRepaymentI.getText(), true, fontSize);
        gpw.prepareString(9, this.StudentLoanStudentFinancialSupplementSchemeI.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

