/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAUSKeyCombo;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.SBRDocumentTFND0004VBox;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelPassword;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CounterpartyTFNDController
extends GlenixBranchController {
    @FXML
    protected Label page_heading;
    @FXML
    protected Label error_message;
    @FXML
    protected Label warning_message;
    protected ApplicationController xbrlFileController = null;
    protected DocumentBuilder dBuilder;
    protected Counterparty counterparty = null;
    protected SBRDocumentTFND0004 sbrDocumentTFND0004 = null;
    @FXML
    protected GlenixLabelAUSKeyCombo ausKeyCombo;
    @FXML
    protected GlenixLabelPassword password;
    @FXML
    protected SBRDocumentTFND0004VBox sbrDocumentTFND0004VBox;
    @FXML
    protected Button saveButton;
    @FXML
    protected Button lodgeButton;
    @FXML
    protected Button newButton;
    @FXML
    protected Button backButton;
    @FXML
    protected Button backToListButton;
    @FXML
    protected Button gotoTFNDListButton;

    public CounterpartyTFNDController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void loadGlenixDefaults() throws Exception {
        if (this.ausKeyCombo != null) {
            List<GlenixElement> al = this.xbrlFileController.getAUSKeyCredentialList();
            ObservableList ol = FXCollections.observableArrayList(al);
            this.ausKeyCombo.setItems((ObservableList<GlenixElement>)ol);
        }
    }

    public void setCounterpartyElement(Counterparty counterparty, SBRDocumentTFND0004 sbrDocumentTFND0004) {
        this.counterparty = counterparty;
        this.sbrDocumentTFND0004 = sbrDocumentTFND0004;
    }

    public void setModel(Counterparty counterparty, SBRDocumentTFND0004 sbrDocumentTFND0004) {
        try {
            String alias;
            this.error_message.setText(null);
            String name = counterparty.getCounterpartyLegalName();
            if (name == null || name.isEmpty()) {
                this.page_heading.setText("Employee TFN declaration");
            } else {
                this.page_heading.setText("Employee TFN declaration for " + name);
            }
            this.sbrDocumentTFND0004VBox.setSBRDocumentTFND0004Model(sbrDocumentTFND0004);
            this.loadGlenixDefaults();
            String status = null;
            if (sbrDocumentTFND0004 != null) {
                status = sbrDocumentTFND0004.getSBRDocumentStatus();
            }
            if (status != null && status.equals("lodge_complete")) {
                this.saveButton.disableProperty().set(true);
                this.lodgeButton.disableProperty().set(true);
                if (this.ausKeyCombo != null) {
                    this.ausKeyCombo.setDisable(true);
                }
                this.password.setText(null);
                this.password.setDisable(true);
            } else {
                this.saveButton.disableProperty().set(false);
                this.lodgeButton.disableProperty().set(false);
                if (this.ausKeyCombo != null) {
                    this.ausKeyCombo.setDisable(false);
                    this.ausKeyCombo.setGlenixElementValue(null);
                }
                this.password.setText(null);
                this.password.setDisable(false);
            }
            if (sbrDocumentTFND0004 != null && (alias = sbrDocumentTFND0004.getCertAlias()) != null && this.ausKeyCombo != null) {
                this.ausKeyCombo.setGlenixElementValue(alias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void saveCounterpartyTFND() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            this.sbrDocumentTFND0004VBox.setSBRDocumentDateTimeToNow();
            this.sbrDocumentTFND0004VBox.buildGlenixXBRLSubPart(resultDoc, null);
            if (this.sbrDocumentTFND0004 == null) {
                this.sbrDocumentTFND0004 = this.counterparty.addNewSBRDocumentTFND0004();
            }
            this.sbrDocumentTFND0004.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            if (this.ausKeyCombo != null) {
                String credentialId = this.ausKeyCombo.getGlenixElementValue();
                this.sbrDocumentTFND0004.setCertAlias(credentialId);
            }
            this.xbrlFileController.saveCounterpartyTFND(this.counterparty, this.sbrDocumentTFND0004);
            this.error_message.setText("Saved");
            this.xbrlFileController.setStatusBarMessage("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoCounterpartyList() {
        this.xbrlFileController.gotoCounterpartyList();
    }

    @FXML
    private void gotoCounterpartyTFNDList() {
        try {
            this.xbrlFileController.gotoCounterpartyTFNDList(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoCounterpartyEdit() {
        try {
            this.xbrlFileController.gotoCounterpartyPayrollDetailsEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected boolean validate() throws Exception {
        String val;
        boolean result = this.sbrDocumentTFND0004VBox.validate();
        if (this.ausKeyCombo != null && ((val = this.ausKeyCombo.getGlenixElementValue()) == null || val.isEmpty())) {
            this.ausKeyCombo.setErrorDisplay("error");
            throw new Exception("Error, you have not selected an AUS key credential.");
        }
        val = this.password.getGlenixElementValue();
        if (val == null || val.isEmpty()) {
            this.password.setErrorDisplay("error");
            throw new Exception("Error, you have not entered your AUS key password.");
        }
        return result;
    }

    @FXML
    public void newCounterpartyTFND() {
        try {
            this.sbrDocumentTFND0004 = this.counterparty.addNewSBRDocumentTFND0004();
            this.sbrDocumentTFND0004VBox.newCounterpartyTFND();
            this.saveButton.disableProperty().set(false);
            this.lodgeButton.disableProperty().set(false);
            if (this.ausKeyCombo != null) {
                this.ausKeyCombo.setDisable(false);
                this.ausKeyCombo.setGlenixElementValue(null);
            }
            this.password.setDisable(false);
            this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
            this.xbrlFileController.setStatusBarMessage("New TFN declaration form created. Values copied.");
            this.xbrlFileController.scrollToTop();
        }
        catch (Exception e) {
            this.error_message.setText("Error, unable to create new TFN declaration: " + e.getMessage());
            this.xbrlFileController.setStatusBarMessage("Error, unable to create new TFN declaration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        this.sbrDocumentTFND0004VBox.setBusinessDetails(businessMasterFile);
    }

    public void setProfileDetails(Profile profileXBRL) {
        this.sbrDocumentTFND0004VBox.setProfileDetails(profileXBRL);
    }

    @FXML
    public void lodgeCounterpartyTFND() {
        this.lodgeButton.disableProperty().set(true);
        String status = null;
        if (this.sbrDocumentTFND0004 != null) {
            status = this.sbrDocumentTFND0004.getSBRDocumentStatus();
        }
        if (status != null && status.equals("lodge_complete")) {
            this.error_message.setText("Error, the document has been lodged you cannot relodge it");
            this.xbrlFileController.setStatusBarMessage("Error, the document has been lodged you cannot relodge it");
            this.lodgeButton.disableProperty().set(false);
            return;
        }
        try {
            this.validate();
            this.error_message.setText(null);
            this.xbrlFileController.setStatusBarMessage("Begin lodge...");
            if (this.sbrDocumentTFND0004 != null) {
                this.sbrDocumentTFND0004.removeEventMessages();
            }
            this.saveCounterpartyTFND();
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.password.setText(null);
            this.lodge(this.counterparty, this.sbrDocumentTFND0004, "lodge", credentialId, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.lodgeButton.disableProperty().set(false);
        }
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    private void lodge(final Counterparty counterparty, final SBRDocumentTFND0004 sbrDocumentTFND0004, final String action, final String credentialId, final String password) {
        final String tan = sbrDocumentTFND0004.getTaxAgentNumberId();
        final String agentABN = sbrDocumentTFND0004.getAgentAustralianBusinessNumberId();
        final String abn = sbrDocumentTFND0004.getAustralianBusinessNumberId();
        final String tfn = sbrDocumentTFND0004.getTaxFileNumberId();
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String maxError;
                    Document doc;
                    String filename;
                    String href;
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin TFN declaration " + action + "...");
                        CounterpartyTFNDController.this.warning_message.setText(null);
                        CounterpartyTFNDController.this.warning_message.setVisible(false);
                        CounterpartyTFNDController.this.warning_message.setManaged(false);
                    });
                    String service = "http://sbr.gov.au/ato/tfnd/2017";
                    String actionCode = "Validate.004.00";
                    if (action != null && action.equals("lodge")) {
                        actionCode = "Submit.004.00";
                    }
                    String usageMessageID = CounterpartyTFNDController.this.generateMessageIdentifier();
                    GlenixResult glenixResult = xbrlFileController.doUsageCheck(tan, agentABN, abn, null, service, actionCode, usageMessageID, null, null, -1);
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to check version or license information, cannot lodge");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                CounterpartyTFNDController.this.warning_message.setText("Warning: There is a new version available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                CounterpartyTFNDController.this.warning_message.setVisible(true);
                                CounterpartyTFNDController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                CounterpartyTFNDController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                CounterpartyTFNDController.this.warning_message.setVisible(true);
                                CounterpartyTFNDController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                CounterpartyTFNDController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                CounterpartyTFNDController.this.warning_message.setVisible(true);
                                CounterpartyTFNDController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this lodgement. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    xbrlFileController.loadAUSKeyCredential(credentialId);
                    xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                    xbrlFileController.extractAUSKeyCredentialX509Certificate();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Signing TFN declaration document..."));
                    Node encryptedDataNode = xbrlFileController.buildAndSendSTSDocument();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Building TFN declaration document..."));
                    Document attachdoc = sbrDocumentTFND0004.buildTFND0004Document();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Sending TFN declaration to ATO..."));
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement()));
                    gatt.setDocumentName("TFND");
                    gatt.setDocumentType("BASE");
                    gatt.setSchema("ato.tfnd.0004.2017.01.00.xsd");
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    gattl.add(gatt);
                    sbrDocumentTFND0004.setSBRDocumentDateTime();
                    String timestamp = sbrDocumentTFND0004.getSBRDocumentDateTimeString();
                    sbrDocumentTFND0004.generateTFNDMessageIdentifier();
                    String messageId = sbrDocumentTFND0004.getTFNDMessageIdentifier();
                    String identifier = sbrDocumentTFND0004.getTFND0004Identifier();
                    String logFileName = "TFND_" + identifier + "_prelodge.log";
                    if (action != null && action.equals("lodge")) {
                        logFileName = "TFND_" + identifier + "_lodge.log";
                    }
                    GlenixSBRResponse glenixSBRResponse = xbrlFileController.buildAndSendLodgeDocument(encryptedDataNode, tan, agentABN, abn, null, tfn, service, actionCode, messageId, timestamp, gattl, logFileName);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Interpreting response from ATO..."));
                    glenixSBRResponse.parseResponse();
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) != null && !filename.equals("OverallEventMessage")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        sbrDocumentTFND0004.loadSBROverallEventMessageDocument(doc, doc.getDocumentElement());
                    }
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("BusinessEventMessage") && !filename.equals("BaseEventMessage")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        sbrDocumentTFND0004.loadSBRBusinessEventMessageDocument(doc, doc.getDocumentElement());
                    }
                    String ts = glenixSBRResponse.getTimestamp();
                    sbrDocumentTFND0004.setLodgmentReceiptDatetime(ts);
                    boolean ok = false;
                    EventItems ei = sbrDocumentTFND0004.getBusinessEventItems();
                    if (ei != null && (maxError = ei.getMaximumSeverityCode()) != null && maxError.equals("Information")) {
                        Platform.runLater(() -> xbrlFileController.setStatusBarMessage("TFN declaration lodge complete."));
                        ok = true;
                        if (action != null && action.equals("lodge")) {
                            sbrDocumentTFND0004.setSBRDocumentStatus("lodge_complete");
                        } else {
                            sbrDocumentTFND0004.setSBRDocumentStatus("prelodge_complete");
                        }
                    }
                    if (!ok) {
                        Platform.runLater(() -> xbrlFileController.setStatusBarMessage("An error has occurred please check the messages."));
                        sbrDocumentTFND0004.setSBRDocumentStatus("created");
                    }
                    Platform.runLater(() -> {
                        block3: {
                            try {
                                xbrlFileController.saveCounterparty(counterparty);
                                if (CounterpartyTFNDController.this.counterparty == counterparty && CounterpartyTFNDController.this.sbrDocumentTFND0004 == sbrDocumentTFND0004) {
                                    CounterpartyTFNDController.this.setModel(counterparty, sbrDocumentTFND0004);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (CounterpartyTFNDController.this.counterparty != counterparty || CounterpartyTFNDController.this.sbrDocumentTFND0004 != sbrDocumentTFND0004) break block3;
                                CounterpartyTFNDController.this.error_message.setText(e.getMessage());
                                xbrlFileController.setStatusBarMessage(e.getMessage());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        if (CounterpartyTFNDController.this.counterparty == counterparty && CounterpartyTFNDController.this.sbrDocumentTFND0004 == sbrDocumentTFND0004) {
                            CounterpartyTFNDController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                finally {
                    xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                }
            }
        }).start();
    }
}

