/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelCounterpartySuperProductCombo;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class CounterpartySuperDetailsEditController
extends GlenixBranchController {
    @FXML
    private Label page_heading;
    @FXML
    private Label error_message;
    private ApplicationController xbrlFileController = null;
    private Counterparty counterparty = null;
    private DocumentBuilder dBuilder;
    @FXML
    private GlenixLabelCounterpartySuperProductCombo superProductCounterparty;

    public CounterpartySuperDetailsEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setCounterpartyElement(Counterparty counterparty) {
        this.clearGlenixXBRL();
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(null);
        this.counterparty = counterparty;
        if (counterparty == null) {
            this.page_heading.setText("Employee super details");
        } else {
            this.page_heading.setText("Employee super details - " + counterparty.getCounterpartyLegalName());
            try {
                Document tdoc = this.dBuilder.newDocument();
                counterparty.appendToElement(tdoc);
                this.loadGlenixXBRL(tdoc, tdoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    public void setCounterpartyList(ObservableList<Transaction> counterpartyObservableList) {
        this.superProductCounterparty.setItems(counterpartyObservableList);
    }

    @FXML
    private void gotoCounterpartyList() {
        this.xbrlFileController.gotoCounterpartyList();
    }

    @FXML
    private void gotoCounterpartyPayrollDetailsEdit() {
        try {
            this.xbrlFileController.gotoCounterpartyPayrollDetailsEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void saveCounterparty() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            this.counterparty.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            this.xbrlFileController.saveCounterparty(this.counterparty);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }
}

