/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class CounterpartyPayrollDetailsEditController
extends GlenixBranchController {
    @FXML
    private Label page_heading;
    @FXML
    private Label error_message;
    private ApplicationController xbrlFileController = null;
    private Counterparty counterparty = null;
    private DocumentBuilder dBuilder;

    public CounterpartyPayrollDetailsEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setCounterpartyElement(Counterparty counterparty) {
        this.clearGlenixXBRL();
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(null);
        this.counterparty = counterparty;
        if (counterparty == null) {
            this.page_heading.setText("Employee payroll details");
        } else {
            this.page_heading.setText("Employee payroll details - " + counterparty.getCounterpartyLegalName());
            try {
                Document cdoc = this.dBuilder.newDocument();
                counterparty.appendToElement(cdoc);
                this.loadGlenixXBRL(cdoc, cdoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    private void gotoCounterpartyList() {
        this.xbrlFileController.gotoCounterpartyList();
    }

    @FXML
    private void gotoCounterpartyEdit() {
        try {
            if (this.counterparty == null) {
                throw new Exception("Error, you have not selected a counterparty.");
            }
            this.xbrlFileController.gotoCounterpartyEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void saveCounterparty() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.counterparty == null) {
                throw new Exception("Error, need to create employee before editing payroll details.");
            }
            this.counterparty.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            this.xbrlFileController.saveCounterparty(this.counterparty);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void gotoCounterpartyTFNDList() {
        try {
            this.xbrlFileController.gotoCounterpartyTFNDList(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    @FXML
    private void gotoCounterpartyTFND() {
        try {
            if (this.counterparty == null) {
                throw new Exception("Error, employee not selected cannot go to TFN declaration");
            }
            if (this.counterparty.getCounterpartyPayrollDetails() == null) {
                throw new Exception("Error, payroll details not saved, cannot go to TFN declaration");
            }
            SBRDocumentTFND0004 sbrDocumentTFND0004 = this.counterparty.getLatestSBRDocumentTFND0004();
            this.xbrlFileController.gotoCounterpartyTFND(this.counterparty, sbrDocumentTFND0004);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    @FXML
    private void gotoCounterpartySuperDetailsEdit() {
        try {
            if (this.counterparty == null) {
                throw new Exception("Error, employee not selected cannot go to super details");
            }
            if (this.counterparty.getCounterpartyPayrollDetails() == null) {
                throw new Exception("Error, payroll details not saved, cannot go to super details");
            }
            this.xbrlFileController.gotoCounterpartySuperDetailsEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }

    @FXML
    private void deleteCounterpartyPayrollDetails() {
        try {
            if (this.counterparty == null) {
                throw new Exception("Error, employee not selected cannot delete payroll details");
            }
            if (this.counterparty.getCounterpartyPayrollDetails() == null) {
                throw new Exception("Error, payroll details not saved, cannot delete payroll details");
            }
            this.counterparty.deletePayrollDetails();
            this.xbrlFileController.saveCounterparty(this.counterparty);
            this.xbrlFileController.gotoCounterpartyEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
    }
}

