/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class CounterpartyEditController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    private ApplicationController xbrlFileController = null;
    private DocumentBuilder dBuilder;
    private Counterparty counterparty = null;

    public CounterpartyEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setCounterpartyElement(Counterparty counterparty) throws Exception {
        this.counterparty = counterparty;
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(null);
        this.clearGlenixXBRL();
        if (counterparty == null) {
            return;
        }
        Document cdoc = this.dBuilder.newDocument();
        counterparty.appendToElement(cdoc);
        this.loadGlenixXBRL(cdoc, cdoc.getDocumentElement());
    }

    @FXML
    private void saveCounterparty() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.counterparty == null) {
                this.counterparty = this.xbrlFileController.addCounterparty();
            }
            this.counterparty.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            this.xbrlFileController.saveCounterparty(this.counterparty);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void clearCounterparty() {
        try {
            this.setCounterpartyElement(null);
            this.error_message.setText("New counterparty");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoCounterpartyList() {
        this.xbrlFileController.gotoCounterpartyList();
    }

    @FXML
    private void gotoCounterpartyPayrollDetailsEdit() {
        if (this.counterparty == null) {
            this.error_message.setText("No counterparty created yet, please save first.");
            return;
        }
        try {
            this.xbrlFileController.gotoCounterpartyPayrollDetailsEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoSuperProductDetailsEdit() {
        if (this.counterparty == null) {
            this.error_message.setText("No counterparty created yet, please save first.");
            return;
        }
        try {
            this.xbrlFileController.gotoSuperProductDetailsEdit(this.counterparty);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

