/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixLabelThemeSelection;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelBlankYesNoCombo;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelYesNoCombo;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.fxml.FXML;
import javafx.scene.control.Label;

public class ConfigPageController
extends GlenixBranchController {
    private Preferences preferences = null;
    @FXML
    private GlenixLabelText auskey_file;
    @FXML
    private GlenixLabelText fasidentity_file;
    @FXML
    private GlenixLabelBlankYesNoCombo log_sbr_lodgements;
    @FXML
    private GlenixLabelThemeSelection theme;
    @FXML
    private GlenixLabelYesNoCombo keepDownloadedFiles;
    @FXML
    private GlenixLabelText downloadsDirectory;
    @FXML
    private Label error_message;
    @FXML
    private GlenixLabelBlankYesNoCombo skip_install_check;
    private ApplicationController xbrlFileController = null;

    public ConfigPageController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
        this.preferences = Preferences.userNodeForPackage(Glenix.class);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.auskey_file.setText(this.preferences.get("auskey_file", null));
            this.fasidentity_file.setText(this.preferences.get("fasidentity_file", null));
            this.log_sbr_lodgements.setGlenixElementValue(this.preferences.get("log_sbr_lodgements", null));
            this.theme.setGlenixElementValue(this.preferences.get("theme", "FAS"));
            this.skip_install_check.setGlenixElementValue(this.preferences.get("skip_install_check", null));
            this.keepDownloadedFiles.setGlenixElementValue(this.preferences.get("keep_downloaded_files", "true"));
            this.downloadsDirectory.setGlenixElementValue(this.preferences.get("downloads_directory", null));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void chooseFASIdentityFile() {
        try {
            File file = this.xbrlFileController.chooseFile();
            if (file == null || !file.exists() || !file.canRead()) {
                this.fasidentity_file.setText(null);
                return;
            }
            this.fasidentity_file.setText(file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void chooseAUSKeyFile() {
        try {
            File file = this.xbrlFileController.chooseFile();
            if (file == null || !file.exists() || !file.canRead()) {
                this.auskey_file.setText(null);
                return;
            }
            this.auskey_file.setText(file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void chooseDownloadsDirectory() {
        try {
            File file = this.xbrlFileController.chooseSaveLocation();
            if (!(file != null && file.exists() && file.canRead() && file.isDirectory())) {
                this.downloadsDirectory.setGlenixElementValue(null);
                return;
            }
            this.downloadsDirectory.setText(file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void saveConfig() {
        try {
            String val = this.auskey_file.getText();
            if (val == null) {
                val = "";
            }
            this.preferences.put("auskey_file", val);
            val = this.fasidentity_file.getText();
            if (val == null) {
                val = "";
            }
            this.preferences.put("fasidentity_file", val);
            val = this.log_sbr_lodgements.getGlenixElementValue();
            if (val == null || val.isEmpty()) {
                val = "false";
            }
            this.preferences.put("log_sbr_lodgements", val);
            val = this.theme.getGlenixElementValue();
            if (val == null || val.isEmpty()) {
                val = "FAS";
            }
            this.preferences.put("theme", val);
            val = this.skip_install_check.getGlenixElementValue();
            if (val == null || val.isEmpty()) {
                val = "false";
            }
            this.preferences.put("skip_install_check", val);
            Double x = this.xbrlFileController.getStageX();
            this.preferences.put("stage_x", "" + x);
            Double y = this.xbrlFileController.getStageY();
            this.preferences.put("stage_y", "" + y);
            Double width = this.xbrlFileController.getStageWidth();
            this.preferences.put("stage_width", "" + width);
            Double height = this.xbrlFileController.getStageHeight();
            this.preferences.put("stage_height", "" + height);
            int currentFontSize = this.xbrlFileController.getCurrentFontSize();
            this.preferences.put("font_size", "" + currentFontSize);
            val = this.keepDownloadedFiles.getGlenixElementValue();
            if (val == null || val.isEmpty()) {
                val = "false";
            }
            this.preferences.put("keep_downloaded_files", val);
            val = this.downloadsDirectory.getGlenixElementValue();
            if (val == null || val.isEmpty()) {
                val = "";
            }
            this.preferences.put("downloads_directory", val);
            this.preferences.flush();
            this.error_message.setText("Saved");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"success");
            this.xbrlFileController.unLoadAUSKey();
            this.xbrlFileController.updateTheme();
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (message == null) {
                message = "An error has occurred " + e.toString();
            }
            this.error_message.setText(message);
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
        }
    }

    public String getConfigValue(String field, String defaultValue) {
        return this.preferences.get(field, defaultValue);
    }

    public void setConfigValue(String field, String value) {
        if (field != null && field.equals("skip_install_check")) {
            this.skip_install_check.setGlenixElementValue(value);
            this.saveConfig();
        }
    }
}

