/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.NewProfileController;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelPassword;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import org.w3c.dom.Document;

public class ChangePasswordController
extends GlenixBranchController {
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private GlenixLabelPassword new_password;
    @FXML
    private GlenixLabelPassword confirm_password;
    @FXML
    private Label error_message;
    private Profile profile = null;
    private GlenixFile profileFile = null;
    private ApplicationController xbrlFileController = null;

    public ChangePasswordController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @FXML
    public void changePassword() {
        GlenixAUSKey gk = this.xbrlFileController.getGlenixKey();
        Profile p = this.xbrlFileController.getProfileXBRL();
        if (gk == null || p == null) {
            this.error_message.setText("Error, FAS identity file is not yet opened. You need to open your FAS identity file before changing the password.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String passwordString = this.password.getText();
        if (passwordString == null || passwordString.equals("")) {
            this.error_message.setText("Error, password is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!this.xbrlFileController.reverifyPassword(passwordString.toCharArray())) {
            this.error_message.setText("Error, existing password is not correct");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String newPasswordString = this.new_password.getText();
        if (newPasswordString == null || newPasswordString.equals("")) {
            this.error_message.setText("Error, the new password is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String confirmPasswordString = this.confirm_password.getText();
        if (confirmPasswordString == null || confirmPasswordString.equals("")) {
            this.error_message.setText("Error, new password confirmation is not set");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!confirmPasswordString.equals(newPasswordString)) {
            this.error_message.setText("Error, password confirmation does not match entered password.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        if (!NewProfileController.checkPasswordComplexity(newPasswordString)) {
            this.error_message.setText("Error, the entered new password does not meet the minimum complexity requirements.");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            return;
        }
        String oldPrivateKey = gk.getBase64ProtectedPrivateKeyOneLine();
        try {
            gk.generateProtectedPrivateKey(newPasswordString.toCharArray());
            this.profile.setProtectedPrivateKey(gk.getBase64ProtectedPrivateKeyOneLine());
            String protectedPrivateKeyPEMString = gk.getProtectedPrivateKeyPEM();
            byte[] protectedPrivateKeyPEMBytes = protectedPrivateKeyPEMString.getBytes("UTF-8");
            this.profileFile.reopenFile();
            this.profileFile.saveBytes("private.pem", protectedPrivateKeyPEMBytes, 0, protectedPrivateKeyPEMBytes.length);
            this.xbrlFileController.saveProfileFile();
            this.profileFile.closeFile();
            this.error_message.setText("Success");
            this.xbrlFileController.setStatusBarMessage("Success");
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"success");
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            } else {
                this.error_message.setText(e.toString());
                this.xbrlFileController.setStatusBarMessage(e.toString());
            }
            this.error_message.getStyleClass().clear();
            this.error_message.getStyleClass().add((Object)"error");
            e.printStackTrace();
            try {
                this.profile.setProtectedPrivateKey(oldPrivateKey);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void setModel(GlenixFile profileFile, Profile profileXBRL) throws Exception {
        Document doc;
        this.profile = profileXBRL;
        this.profileFile = profileFile;
        if (this.profile != null && (doc = this.profile.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }
}

