/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.BusinessMessageSignatureVBox;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixLabelMessageStatusCombo;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.MessageDetails;
import au.com.glenix.trn.BusinessMessage;
import au.com.glenix.trn.BusinessMessageFile;
import au.com.glenix.trn.BusinessMessageSignature;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.widget.GlenixLabelDateTimeLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelTextAreaVertical;
import au.com.glenix.widget.GlenixTitledPaneController;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.w3c.dom.Document;

public class BusinessMessageTitledPaneController
extends GlenixTitledPaneController {
    @FXML
    private GlenixLabelTextAreaVertical messageText;
    @FXML
    private GlenixLabelMessageStatusCombo messageStatus;
    @FXML
    private GlenixLabelTextAreaVertical declarationText;
    @FXML
    private GlenixLabelDateTimeLabel businessMessageTime;
    @FXML
    private GlenixLabelLabel messageFromName;
    @FXML
    private Label signatureVerifiedIndicator;
    @FXML
    private GlenixLabelLabel messageFromCertificateName;
    @FXML
    private Label error_text;
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private VBox dec_section;
    @FXML
    private VBox sign_section;
    @FXML
    private Hyperlink file_hyperlink;
    @FXML
    private Label worktime;
    private String filename;
    private BusinessMessage businessMessage = null;
    @FXML
    private VBox files_section;
    @FXML
    private VBox signatures_section;
    private ApplicationController applicationController;
    private boolean message_digest_match = false;

    public BusinessMessageTitledPaneController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.file_hyperlink.setOnAction(a -> {
            if (this.filename == null || this.filename.isEmpty()) {
                return;
            }
            try {
                File aFile = this.createTempFile(this.filename);
                if (aFile != null) {
                    if (!aFile.exists()) {
                        this.downloadFile(this.applicationController.getBusinessIdentifier(), this.filename, aFile);
                    }
                    if (aFile.exists()) {
                        this.applicationController.openFileE(aFile);
                        this.applicationController.setTitle("Temporary file for " + this.applicationController.getBusinessLegalName());
                        this.applicationController.setStatusBarMessage("Download complete file opened");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_text.setText(e.getMessage());
                this.applicationController.setStatusBarMessage(e.getMessage());
            }
        });
        this.messageStatus.setSingleComboChangeListener(new ChangeListener<Pair<String, String>>(){

            public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                BusinessMessageTitledPaneController.this.setMessageStatus((String)newValue.getKey());
            }
        });
    }

    public void setBusinessMessageElement(BusinessMessage businessMessage) {
        this.businessMessage = businessMessage;
        this.files_section.getChildren().clear();
        this.signatures_section.getChildren().clear();
        if (businessMessage == null) {
            this.messageText.setGlenixElementValue(null);
            this.worktime.setText(null);
        } else {
            this.messageText.setGlenixElementValue(businessMessage.getMessageText());
            this.messageStatus.setGlenixElementValue(businessMessage.getMessageStatus());
            this.declarationText.setGlenixElementValue(businessMessage.getDeclarationText());
            this.businessMessageTime.setGlenixElementValue(businessMessage.getBusinessMessageTime());
            if (this.messageFromName != null) {
                this.messageFromName.setGlenixElementValue(businessMessage.getMessageFromName());
            }
            for (int i = 0; i < businessMessage.getBusinessMessageFileCount(); ++i) {
                final BusinessMessageFile bmf = businessMessage.getBusinessMessageFile(i);
                Hyperlink link = new Hyperlink();
                link.setText(bmf.getMessageFileOriginalName());
                link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        BusinessMessageTitledPaneController.this.openFile("message_files/" + bmf.getMessageFileName(), bmf.getMessageFileOriginalName());
                    }
                });
                this.files_section.getChildren().add((Object)link);
            }
            this.verifyMessageSignature();
            String name = "Certificate name unknown";
            try {
                name = this.applicationController.getX509CertificateCommonName(businessMessage.getMessageFromCertificate());
            }
            catch (Exception e) {
                e.printStackTrace();
                name = "Certificate name unknown";
            }
            this.messageFromCertificateName.setGlenixElementValue(name);
            String decText = businessMessage.getDeclarationText();
            if (decText != null && !decText.isEmpty()) {
                this.addAllSignatures();
            } else {
                this.dec_section.getChildren().clear();
                this.sign_section.getChildren().clear();
            }
            this.filename = businessMessage.getSourceBusinessFileName();
            if (this.filename != null && !this.filename.isEmpty()) {
                this.file_hyperlink.setText("Open source MyBusiness.fas file, id = " + this.filename);
                this.file_hyperlink.setManaged(true);
                this.file_hyperlink.setVisible(true);
            } else {
                this.file_hyperlink.setText(null);
                this.file_hyperlink.setManaged(false);
                this.file_hyperlink.setVisible(false);
            }
            String tt = businessMessage.getFormattedWorkTime();
            if (tt == null) {
                this.worktime.setText(null);
                this.worktime.setManaged(false);
                this.worktime.setVisible(false);
            } else {
                this.worktime.setText("Time taken: " + tt);
                this.worktime.setManaged(true);
                this.worktime.setVisible(true);
            }
        }
    }

    private void addAllSignatures() {
        for (int i = 0; i < this.businessMessage.getBusinessMessageSignatureCount(); ++i) {
            BusinessMessageSignature bms = this.businessMessage.getBusinessMessageSignature(i);
            this.addSignatureVBox(bms);
        }
    }

    private void addSignatureVBox(BusinessMessageSignature bms) {
        boolean signVerified = this.verifyMessageSignatureSignature(bms);
        boolean idVerified = false;
        if (signVerified) {
            idVerified = true;
            try {
                X509Certificate x = this.applicationController.getSavedX509Certificate(bms.getMessageSignatureCertificate());
                this.applicationController.x509CertificateIsSigned(x);
                if (this.applicationController.publicKeyIsMine(x.getPublicKey())) {
                    this.sign_section.getChildren().clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                idVerified = false;
            }
        }
        try {
            BusinessMessageSignatureVBox bmsv = new BusinessMessageSignatureVBox();
            String signatureName = this.applicationController.getX509CertificateCommonName(bms.getMessageSignatureCertificate());
            bmsv.setModel(bms, signatureName);
            bmsv.setVerified(signVerified, idVerified);
            this.signatures_section.getChildren().add((Object)bmsv);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public String calcMessageDigest() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.businessMessage.getBusinessMessageTime());
        sb.append(this.businessMessage.getMessageFromName());
        sb.append(this.businessMessage.getMessageText());
        sb.append(this.businessMessage.getDeclarationText());
        MessageDigest md = this.applicationController.calculateSHA1DigestBytes(sb.toString().getBytes());
        Base64 b64oneline = new Base64();
        return b64oneline.encodeAsString(md.digest());
    }

    private void verifyMessageSignature() {
        boolean passed = false;
        boolean idVerified = false;
        try {
            String savedSigChecksum = this.businessMessage.getMessageDigest();
            String sigChecksum = this.calcMessageDigest();
            Base64 b64oneline = new Base64();
            if (savedSigChecksum != null && sigChecksum != null && sigChecksum.equals(savedSigChecksum)) {
                StringBuilder sb = new StringBuilder();
                sb.append(savedSigChecksum);
                boolean filepass = true;
                this.businessMessage.sortBusinessMessageFile();
                for (int j = 0; j < this.businessMessage.getBusinessMessageFileCount(); ++j) {
                    BusinessMessageFile bmf = this.businessMessage.getBusinessMessageFile(j);
                    String savedFileChecksum = bmf.getMessageFileDigest();
                    MessageDigest md = this.applicationController.calculateSHA1Digest("message_files/" + bmf.getMessageFileName());
                    String calcFileChecksum = b64oneline.encodeAsString(md.digest());
                    if (savedFileChecksum == null || calcFileChecksum == null || savedFileChecksum.isEmpty() || !savedFileChecksum.equals(calcFileChecksum)) {
                        filepass = false;
                        continue;
                    }
                    sb.append(savedFileChecksum);
                }
                if (!filepass) {
                    passed = false;
                } else {
                    this.message_digest_match = true;
                    String savedSignature = this.businessMessage.getMessageFromSignature();
                    String savedCert = this.businessMessage.getMessageFromCertificate();
                    if (savedSignature == null || savedCert == null) {
                        passed = false;
                    } else {
                        DERObjectIdentifier sha1ObjectIdentifier = new DERObjectIdentifier("1.3.14.3.2.26");
                        AlgorithmIdentifier sha1AlgoIdentifier = new AlgorithmIdentifier(sha1ObjectIdentifier, null);
                        DigestInfo di = new DigestInfo(sha1AlgoIdentifier, sb.toString().getBytes());
                        passed = this.applicationController.verifySignature(di.getEncoded(), savedSignature, savedCert);
                        if (passed) {
                            idVerified = true;
                            try {
                                X509Certificate x = this.applicationController.getSavedX509Certificate(savedCert);
                                this.applicationController.x509CertificateIsSigned(x);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                idVerified = false;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
        }
        this.setSignatureVerified(passed, idVerified);
    }

    public void openFile(String filename, String originalFilename) {
        try {
            InputStream is = this.applicationController.getFileDecrypt(filename);
            if (is != null) {
                int bytesRead;
                final File file = this.applicationController.createOtherFile(originalFilename);
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
                out.close();
                is.close();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Desktop.getDesktop().open(file);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_text.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setSignatureVerified(boolean signatureVerified, boolean idVerified) {
        if (signatureVerified && idVerified) {
            this.signatureVerifiedIndicator.setText("Signature valid, identity verfied");
            this.signatureVerifiedIndicator.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.signatureVerifiedIndicator.getStyleClass().add((Object)"success");
            return;
        }
        if (signatureVerified) {
            this.signatureVerifiedIndicator.setText("Signature valid but identity NOT verified");
            this.signatureVerifiedIndicator.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.signatureVerifiedIndicator.getStyleClass().add((Object)"error");
            return;
        }
        this.signatureVerifiedIndicator.setText("Signature NOT valid");
        this.signatureVerifiedIndicator.getStyleClass().removeAll((Object[])new String[]{"success"});
        this.signatureVerifiedIndicator.getStyleClass().add((Object)"error");
    }

    public String calcSignatureDigest(BusinessMessageSignature bms) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(bms.getMessageSignatureDateTime());
        MessageDigest md = this.applicationController.calculateSHA1DigestBytes(sb.toString().getBytes());
        Base64 b64oneline = new Base64();
        return b64oneline.encodeAsString(md.digest());
    }

    private void setMessageStatus(String value) {
        if (this.businessMessage == null) {
            return;
        }
        try {
            this.businessMessage.setMessageStatus(value);
            this.applicationController.saveBusinessMessage(this.businessMessage);
            if (value != null && (value.equals("user") || value.equals("client"))) {
                this.applicationController.alertUserStatusMessage(true);
            } else {
                this.applicationController.checkAlertUserStatusMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_text.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void signMessage() {
        try {
            String passwordString = this.password.getGlenixElementValue();
            if (passwordString == null || passwordString.isEmpty()) {
                throw new Exception("Error, you must re-enter your FAS identity password to sign a message");
            }
            boolean correct = this.applicationController.reverifyPassword(passwordString.toCharArray());
            if (!correct) {
                throw new Exception("Error, the entered password is not correct");
            }
            this.password.setGlenixElementValue(null);
            String messageDigest = this.businessMessage.getMessageDigest();
            StringBuilder digestSB = new StringBuilder();
            digestSB.append(messageDigest);
            for (int i = 0; i < this.businessMessage.getBusinessMessageFileCount(); ++i) {
                BusinessMessageFile bmf = this.businessMessage.getBusinessMessageFile(i);
                digestSB.append(bmf.getMessageFileDigest());
            }
            BusinessMessageSignature bms = new BusinessMessageSignature();
            bms.setMessageSignatureCertificate(this.applicationController.getBase64PublicKeyOneLine());
            Date date = new Date();
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String created_timestamp = isoFormat.format(date);
            bms.setMessageSignatureDateTime(created_timestamp);
            String digestString = this.calcSignatureDigest(bms);
            bms.setMessageSignatureDigest(digestString);
            digestSB.append(digestString);
            byte[] digestBytes = digestSB.toString().getBytes();
            String cipherString = this.applicationController.createSignatureBase64OneLine(digestBytes);
            bms.setMessageSignatureSignature(cipherString);
            this.businessMessage.addBusinessMessageSignature(bms);
            this.applicationController.saveBusinessMessageList();
            this.addSignatureVBox(bms);
            this.error_text.setText(null);
            this.applicationController.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_text.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    private boolean verifyMessageSignatureSignature(BusinessMessageSignature bms) {
        try {
            String messageDigest = this.businessMessage.getMessageDigest();
            StringBuilder digestSB = new StringBuilder();
            digestSB.append(messageDigest);
            for (int i = 0; i < this.businessMessage.getBusinessMessageFileCount(); ++i) {
                BusinessMessageFile bmf = this.businessMessage.getBusinessMessageFile(i);
                digestSB.append(bmf.getMessageFileDigest());
            }
            String calcedDigestString = this.calcSignatureDigest(bms);
            String savedDigestString = bms.getMessageSignatureDigest();
            if (!this.message_digest_match || calcedDigestString == null || savedDigestString == null || !savedDigestString.equals(calcedDigestString)) {
                return false;
            }
            digestSB.append(savedDigestString);
            String savedSignature = bms.getMessageSignatureSignature();
            String savedCert = bms.getMessageSignatureCertificate();
            if (savedSignature == null || savedCert == null) {
                return false;
            }
            DERObjectIdentifier sha1ObjectIdentifier = new DERObjectIdentifier("1.3.14.3.2.26");
            AlgorithmIdentifier sha1AlgoIdentifier = new AlgorithmIdentifier(sha1ObjectIdentifier, null);
            DigestInfo di = new DigestInfo(sha1AlgoIdentifier, digestSB.toString().getBytes());
            return this.applicationController.verifySignature(di.getEncoded(), savedSignature, savedCert);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_text.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
            return false;
        }
    }

    public File createTempFile(String fileName) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File file = tmpdir != null && !tmpdir.isEmpty() ? new File(tmpdir + "/fas_tmp_" + fileName + ".fas") : new File("fas_tmp_" + fileName + ".fas");
        file.deleteOnExit();
        return file;
    }

    private void downloadFile(String businessIdentifier, String businessFileName, File outFile) {
        Platform.runLater(() -> this.applicationController.setStatusBarMessage("Begin request file..."));
        try {
            MessageDetails md = new MessageDetails();
            md.setService(Glenix.soap_service_business_files);
            md.setAction("Get");
            md.setPropBusinessIdentifier(businessIdentifier);
            md.setPropBusinessFileName(businessFileName);
            GlenixSBRResponse response = this.applicationController.sendDocumentToFAS(md);
            response.parseResponse();
            Document doc = response.getDocumentByHref("res.xml");
            GlenixResult glenixResult = new GlenixResult();
            glenixResult.loadDocumentElement(doc, doc.getDocumentElement());
            Platform.runLater(() -> this.applicationController.setStatusBarMessage("Interpreting response from FAS..."));
            String resultCode = null;
            if (glenixResult != null) {
                resultCode = glenixResult.getResultCode();
            }
            if (resultCode == null) {
                throw new Exception("Error, unable to get file");
            }
            if (!resultCode.equals("OK")) {
                if (resultCode.equals("ERRORLICENSE")) {
                    throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                }
                if (resultCode.equals("ERRORVERSION")) {
                    throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                }
                if (resultCode.equals("ERROR")) {
                    throw new Exception("Error, unable to get file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                }
                throw new Exception("Error, unable to get file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
            }
            InputStream is = response.getInputStreamByHref("MyBusiness-download.fas");
            if (is != null) {
                FileOutputStream os = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                int readlen = 0;
                while ((readlen = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, readlen);
                }
                os.flush();
                ((OutputStream)os).close();
                Platform.runLater(() -> {
                    try {
                        this.applicationController.openFileE(outFile);
                        this.applicationController.setTitle("Temporary file for " + this.applicationController.getBusinessLegalName());
                        this.applicationController.setStatusBarMessage("Download complete file opened");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_text.setText(e.getMessage());
                        this.applicationController.setStatusBarMessage(e.getMessage());
                    }
                });
            }
            Platform.runLater(() -> {
                try {
                    this.error_text.setText("File received.");
                    this.applicationController.setStatusBarMessage("File received.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error_text.setText(e.getMessage());
                    this.applicationController.setStatusBarMessage(e.getMessage());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater(() -> {
                e.printStackTrace();
                this.error_text.setText(e.getMessage());
                this.applicationController.setStatusBarMessage(e.getMessage());
            });
        }
    }

    public boolean applyFilter(String filter) {
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        filter = filter.toLowerCase();
        String timeval = this.businessMessageTime.getDisplayValue();
        if (timeval != null && timeval.toLowerCase().contains(filter)) {
            return true;
        }
        return this.businessMessage.matchFilter(filter);
    }
}

