/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.BusinessMessageFileEditHBox;
import au.com.glenix.BusinessMessageTitledPane;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.MessageDetails;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.BusinessMessage;
import au.com.glenix.trn.BusinessMessageFile;
import au.com.glenix.trn.GlenixCertificate;
import au.com.glenix.trn.GlenixCertificateList;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDateVertical;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelTextAreaVertical;
import au.com.glenix.widget.GlenixLabelTimeVertical;
import au.com.glenix.widget.GlenixVBox;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessMessageListController
extends GlenixBranchController {
    @FXML
    private GlenixLabelTextAreaVertical messageText;
    @FXML
    private GlenixLabelTextAreaVertical declarationText;
    @FXML
    private GlenixLabelLabel messageFromName;
    @FXML
    private GlenixLabelPassword password;
    @FXML
    private GlenixLabelText filterText;
    @FXML
    private GlenixLabelCheckbox autosend;
    @FXML
    private GlenixLabelDateVertical startDate;
    @FXML
    private GlenixLabelTimeVertical startTime;
    @FXML
    private GlenixLabelTimeVertical endTime;
    @FXML
    private GlenixLabelTimeVertical breakTime;
    @FXML
    private GlenixLabelTimeVertical workTime;
    @FXML
    private HBox timesection;
    @FXML
    private VBox files_section;
    @FXML
    private VBox businessmessagesvbox;
    @FXML
    private GlenixVBox businessMessageEdit;
    @FXML
    private Label error_message;
    @FXML
    private Label warning_message;
    @FXML
    private Label page_heading;
    private ObservableList<GlenixCertificate> gclObservableList = FXCollections.observableArrayList();
    @FXML
    private ListView certificate_list;
    private ApplicationController xbrlFileController = null;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private GlenixTrnXBRL fileAccessTrnXBRL = null;
    private Profile profile = null;
    private DocumentBuilder dBuilder;
    private HashMap<String, BusinessMessage> bmh;
    private String businessIdentifier;

    public BusinessMessageListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.error_message.setText(e.getMessage());
        }
        this.certificate_list.setCellFactory((Callback)new Callback<ListView<GlenixCertificate>, ListCell<GlenixCertificate>>(){

            public ListCell call(ListView<GlenixCertificate> listView) {
                ListCell<GlenixCertificate> cell = new ListCell<GlenixCertificate>(){

                    public void updateItem(GlenixCertificate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            try {
                                X509Certificate x = BusinessMessageListController.this.xbrlFileController.getSavedX509Certificate(item.getPublicCertificate());
                                boolean isset = false;
                                String cn = BusinessMessageListController.this.xbrlFileController.getX509CertificateCommonNameUnverified(x);
                                if (cn != null && !cn.isEmpty() && !cn.toLowerCase().contains("verified")) {
                                    boolean isSigned = false;
                                    try {
                                        BusinessMessageListController.this.xbrlFileController.x509CertificateIsSigned(x);
                                        isSigned = true;
                                    }
                                    catch (Exception e) {
                                        isSigned = false;
                                    }
                                    cn = isSigned ? cn + " (Identity verified)" : cn + " (NOT verified)";
                                    this.setText(cn);
                                    isset = true;
                                }
                                if (!isset) {
                                    this.setText("Invalid");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.setText("Invalid");
                            }
                        }
                    }
                };
                return cell;
            }
        });
        this.certificate_list.setItems(this.gclObservableList);
        this.certificate_list.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.filterText.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> obs, String oldValue, String newValue) {
                BusinessMessageListController.this.filterMessages(newValue);
            }
        });
        this.autosend.setGlenixElementValue("true");
        this.startDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observableValue, LocalDate oldValue, LocalDate newValue) {
                BusinessMessageListController.this.updateWorkTime();
            }
        });
        this.startTime.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                BusinessMessageListController.this.updateWorkTime();
            }
        });
        this.endTime.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                BusinessMessageListController.this.updateWorkTime();
            }
        });
        this.breakTime.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                BusinessMessageListController.this.updateWorkTime();
            }
        });
    }

    public void filterMessages(String value) {
        for (Node n : this.businessmessagesvbox.getChildren()) {
            if (!(n instanceof BusinessMessageTitledPane)) continue;
            BusinessMessageTitledPane bmtp = (BusinessMessageTitledPane)n;
            bmtp.applyFilter(value);
        }
    }

    public String calcMessageDigest(BusinessMessage bm) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(bm.getBusinessMessageTime());
        sb.append(bm.getMessageFromName());
        sb.append(bm.getMessageText());
        sb.append(bm.getDeclarationText());
        MessageDigest md = this.xbrlFileController.calculateSHA1DigestBytes(sb.toString().getBytes());
        Base64 b64oneline = new Base64();
        return b64oneline.encodeAsString(md.digest());
    }

    @FXML
    private void addBusinessMessage() {
        try {
            BusinessMessage bm;
            String passwordString = this.password.getGlenixElementValue();
            if (passwordString == null || passwordString.isEmpty()) {
                throw new Exception("Error, you must re-enter your FAS identity password to save a message");
            }
            boolean correct = this.xbrlFileController.reverifyPassword(passwordString.toCharArray());
            if (!correct) {
                throw new Exception("Error, the entered password is not correct");
            }
            this.password.setGlenixElementValue(null);
            Document doc = this.dBuilder.newDocument();
            this.businessMessageEdit.buildGlenixXBRL(doc, null);
            Business b = this.glenixTrnXBRL.getBusiness();
            if (b != null && (bm = b.addBlankBusinessMessage()) != null) {
                bm.loadDocumentElement(doc, doc.getDocumentElement());
                Date date = new Date();
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTime(date);
                SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                String created_timestamp = isoFormat.format(date);
                bm.setBusinessMessageTime(created_timestamp);
                bm.setMessageDigest(this.calcMessageDigest(bm));
                bm.sortBusinessMessageFile();
                String messageDigest = bm.getMessageDigest();
                StringBuilder digestSB = new StringBuilder();
                digestSB.append(messageDigest);
                for (int i = 0; i < bm.getBusinessMessageFileCount(); ++i) {
                    BusinessMessageFile bmf = bm.getBusinessMessageFile(i);
                    digestSB.append(bmf.getMessageFileDigest());
                }
                byte[] digestBytes = digestSB.toString().getBytes();
                String cipherString = this.xbrlFileController.createSignatureBase64OneLine(digestBytes);
                bm.setMessageFromCertificate(this.xbrlFileController.getBase64PublicKeyOneLine());
                bm.setMessageFromSignature(cipherString);
                DERObjectIdentifier sha1ObjectIdentifier = new DERObjectIdentifier("1.3.14.3.2.26");
                AlgorithmIdentifier sha1AlgoIdentifier = new AlgorithmIdentifier(sha1ObjectIdentifier, null);
                DigestInfo di = new DigestInfo(sha1AlgoIdentifier, digestBytes);
                this.xbrlFileController.verifySignature(di.getEncoded(), cipherString, this.xbrlFileController.getBase64PublicKeyOneLine());
                LocalDate sd = this.startDate.getLocalDate();
                LocalTime st = this.startTime.getLocalTime();
                if (sd != null && st != null) {
                    LocalDateTime sdt = sd.atTime(st);
                    LocalTime et = this.endTime.getLocalTime();
                    if (et == null) {
                        et = LocalTime.now();
                        this.endTime.setLocalTime(et);
                        this.updateWorkTime();
                    }
                    LocalDateTime edt = sd.atTime(et);
                    if (!et.isAfter(st)) {
                        edt.plusDays(1L);
                    }
                    LocalTime bt = this.breakTime.getLocalTime();
                    LocalTime wt = this.workTime.getLocalTime();
                    bm.setMessageStartDateTime(sdt);
                    bm.setMessageEndDateTime(edt);
                    bm.setMessageBreakTime(bt);
                    bm.setMessageWorkTime(wt);
                }
                this.xbrlFileController.saveBusinessMessageList();
                this.xbrlFileController.restartFileOpenTime();
                LocalDateTime openTime = this.xbrlFileController.getFileOpenTime();
                if (openTime != null) {
                    this.startDate.setLocalDate(openTime.toLocalDate());
                    this.startTime.setLocalTime(openTime.toLocalTime());
                    this.endTime.setGlenixElementValue(null);
                    this.breakTime.setGlenixElementValue(null);
                } else {
                    this.startDate.setLocalDate(LocalDate.now());
                    this.startTime.setLocalTime(LocalTime.now());
                    this.endTime.setGlenixElementValue(null);
                    this.breakTime.setGlenixElementValue(null);
                }
                BusinessMessageTitledPane bmtp = this.addBusinessMessageTitledPane(false);
                bmtp.setBusinessMessageElement(bm);
                this.clearBusinessMessage();
                String id = bm.getBusinessMessageIdentifier();
                if (id != null && !id.isEmpty()) {
                    this.bmh.put(id, bm);
                }
                this.alertUserStatusMessage();
            }
            this.error_message.setText(null);
            this.xbrlFileController.setStatusBarMessage(null);
            String autosendStr = this.autosend.getGlenixElementValue();
            if (autosendStr != null && autosendStr.equals("true")) {
                this.sendFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void clearBusinessMessage() {
        this.files_section.getChildren().clear();
        this.messageText.setGlenixElementValue(null);
        this.declarationText.setGlenixElementValue(null);
        if (this.profile != null) {
            String fullname = this.profile.getFullName();
            GlenixAUSKey gk = this.xbrlFileController.getGlenixKey();
            try {
                String certCommonname = gk.getX509CertificateCommonName();
                if (!fullname.equals(certCommonname)) {
                    fullname = fullname + "(" + certCommonname + ")";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.messageFromName.setGlenixElementValue(fullname);
        }
    }

    @FXML
    private void addMessageFile() {
        try {
            File f = this.xbrlFileController.openOtherFile(null);
            if (f != null) {
                UUID uuid = UUID.randomUUID();
                String auuid = uuid.toString();
                FileInputStream is = new FileInputStream(f);
                this.xbrlFileController.makeFileDirectory("message_files");
                String filename = auuid + "_" + f.getName();
                this.xbrlFileController.saveFileEncryptStream("message_files/" + filename, is);
                BusinessMessageFileEditHBox bf = this.addBusinessMessageFileEditHBox();
                bf.setValues(auuid, filename, f.getName());
                MessageDigest md = this.xbrlFileController.calculateSHA1Digest("message_files/" + filename);
                Base64 b64oneline = new Base64();
                bf.setDigest(b64oneline.encodeAsString(md.digest()));
                this.error_message.setText("Saved " + f.getName());
                this.xbrlFileController.setStatusBarMessage("Saved " + f.getName());
            } else {
                this.error_message.setText("No file selected");
                this.xbrlFileController.setStatusBarMessage("No file selected");
            }
            this.error_message.setText(null);
            this.xbrlFileController.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        if (profile != null) {
            this.messageFromName.setGlenixElementValue(profile.getFullName());
        } else {
            this.messageFromName.setGlenixElementValue(null);
        }
        String agentABN = profile.getAgentABN();
        String agentNumber = profile.getAgentNumber();
        if (agentABN != null && !agentABN.isEmpty() || agentNumber != null && !agentNumber.isEmpty()) {
            this.timesection.setManaged(true);
            this.timesection.setVisible(true);
        } else {
            this.timesection.setManaged(false);
            this.timesection.setVisible(false);
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL, String businessIdentifier, GlenixTrnXBRL fileAccessTrnXBRL) throws Exception {
        this.fileAccessTrnXBRL = fileAccessTrnXBRL;
        this.glenixTrnXBRL = glenixTrnXBRL;
        this.businessIdentifier = businessIdentifier;
        this.bmh = new HashMap();
        ArrayList<Node> remove = new ArrayList<Node>();
        for (Node n : this.businessmessagesvbox.getChildren()) {
            if (!(n instanceof BusinessMessageTitledPane)) continue;
            remove.add(n);
        }
        this.businessmessagesvbox.getChildren().removeAll(remove);
        if (glenixTrnXBRL != null) {
            Business b;
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            if ((b = glenixTrnXBRL.getBusiness()) != null) {
                for (int i = 0; i < b.getBusinessMessageCount(); ++i) {
                    BusinessMessage bm = b.getBusinessMessage(i);
                    BusinessMessageTitledPane bmtp = this.addBusinessMessageTitledPane(false);
                    bmtp.setBusinessMessageElement(bm);
                    String id = bm.getBusinessMessageIdentifier();
                    if (id == null || id.isEmpty()) continue;
                    this.bmh.put(id, bm);
                }
            }
        }
        this.setCertificateObservableList();
        this.page_heading.setText("Messages - Software support and taxation services - " + this.xbrlFileController.getBusinessLegalName());
        this.filterMessages(this.filterText.getGlenixElementValue());
        LocalDateTime openTime = this.xbrlFileController.getFileOpenTime();
        if (openTime != null) {
            this.startDate.setLocalDate(openTime.toLocalDate());
            this.startTime.setLocalTime(openTime.toLocalTime());
        }
    }

    private void setCertificateObservableList() {
        if (this.fileAccessTrnXBRL == null) {
            this.error_message.setText("There are no certificates with access to this file.");
            return;
        }
        Business business = this.fileAccessTrnXBRL.getBusiness();
        if (business == null) {
            this.error_message.setText("There are no certificates with access to this file.");
            return;
        }
        GlenixCertificateList gcl = business.getGlenixCertificateList();
        if (gcl == null) {
            this.error_message.setText("There are no certificates with access to this file.");
            return;
        }
        this.gclObservableList.removeAll(this.gclObservableList);
        ArrayList<GlenixCertificate> gcal = gcl.getGlenixCertificateList();
        for (int i = 0; i < gcal.size(); ++i) {
            GlenixCertificate gc = gcal.get(i);
            this.gclObservableList.add((Object)gc);
        }
        this.certificate_list.refresh();
        this.certificate_list.getSelectionModel().selectAll();
        int fontsize = this.xbrlFileController.getCurrentFontSize();
        this.certificate_list.setPrefHeight((double)(gcal.size() * fontsize * 2 + 2));
    }

    public BusinessMessageTitledPane addBusinessMessageTitledPane(boolean last) {
        try {
            BusinessMessageTitledPane sw = new BusinessMessageTitledPane(this.xbrlFileController);
            sw.getGlenixController().initialize(null, null);
            if (last) {
                this.businessmessagesvbox.getChildren().add((Object)sw);
            } else {
                Node n;
                int index;
                ObservableList children = this.businessmessagesvbox.getChildren();
                for (index = 0; index < children.size() && !((n = (Node)children.get(index)) instanceof BusinessMessageTitledPane); ++index) {
                }
                this.businessmessagesvbox.getChildren().add(index, (Object)sw);
            }
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.error_message.setText(e.getMessage());
            return null;
        }
    }

    public BusinessMessageFileEditHBox addBusinessMessageFileEditHBox() {
        try {
            final BusinessMessageFileEditHBox sw = new BusinessMessageFileEditHBox(this.xbrlFileController);
            sw.getGlenixController().initialize(null, null);
            this.files_section.getChildren().add((Object)sw);
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    BusinessMessageListController.this.files_section.getChildren().remove((Object)sw);
                    String filename = sw.getMessageFileName();
                    if (filename != null && !filename.isEmpty()) {
                        try {
                            BusinessMessageListController.this.xbrlFileController.deleteFile("message_files/" + filename);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            BusinessMessageListController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                            BusinessMessageListController.this.error_message.setText(e.getMessage());
                        }
                    }
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.error_message.setText(e.getMessage());
            return null;
        }
    }

    private ArrayList<Business> buildBusinessArrayList(Document doc) {
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return null;
        }
        ArrayList<Business> result = new ArrayList<Business>();
        NodeList nodeList = root.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element businessEl;
            org.w3c.dom.Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (businessEl = (Element)node).getNamespaceURI() == null || !businessEl.getNamespaceURI().equals("http://www.glenix.com.au/") || businessEl.getLocalName() == null || !businessEl.getLocalName().equals("business")) continue;
            try {
                Business b = new Business();
                b.loadDocumentElement(doc, businessEl);
                result.add(b);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void alertUserStatusMessage() {
        boolean hasuser = false;
        for (BusinessMessage bm : this.bmh.values()) {
            String status = bm.getMessageStatus();
            if (status == null || !status.equals("user") && !status.equals("client")) continue;
            hasuser = true;
        }
        this.xbrlFileController.alertUserStatusMessage(hasuser);
    }

    @FXML
    public void getNewBusinessMessages() {
        final ApplicationController applicationController = this.xbrlFileController;
        if (this.businessIdentifier == null || this.businessIdentifier.isEmpty()) {
            applicationController.setStatusBarMessage("Business not set");
            this.error_message.setText("Error business not set");
            return;
        }
        final String aBusinessIdentifier = this.businessIdentifier;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        applicationController.setStatusBarMessage("Begin get messages...");
                        BusinessMessageListController.this.warning_message.setText(null);
                        BusinessMessageListController.this.warning_message.setVisible(false);
                        BusinessMessageListController.this.warning_message.setManaged(false);
                    });
                    MessageDetails md = new MessageDetails();
                    md.setService(Glenix.soap_service_business_files);
                    md.setAction("List");
                    md.setPropBusinessIdentifier(aBusinessIdentifier);
                    GlenixSBRResponse response = applicationController.sendDocumentToFAS(md);
                    response.parseResponse();
                    Document doc = response.getDocumentByHref("res.xml");
                    GlenixResult glenixResult = new GlenixResult();
                    glenixResult.loadDocumentElement(doc, doc.getDocumentElement());
                    Platform.runLater(() -> applicationController.setStatusBarMessage("Interpreting response from FAS..."));
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to send file");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                BusinessMessageListController.this.warning_message.setText("Warning: There is a new version of this software available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                BusinessMessageListController.this.warning_message.setVisible(true);
                                BusinessMessageListController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                BusinessMessageListController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                BusinessMessageListController.this.warning_message.setVisible(true);
                                BusinessMessageListController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                BusinessMessageListController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                BusinessMessageListController.this.warning_message.setVisible(true);
                                BusinessMessageListController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to get messages, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, unable to get messages, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    doc = response.getDocumentByHref("data.xml");
                    ArrayList barr = BusinessMessageListController.this.buildBusinessArrayList(doc);
                    for (Business b : barr) {
                        File testFile;
                        String fn = b.getBusinessFileName();
                        if (fn == null || fn.isEmpty() || applicationController.isCurrentFile(testFile = applicationController.getDownloadedFile(fn))) continue;
                        BusinessMessageListController.this.downloadFile(aBusinessIdentifier, fn);
                    }
                    Platform.runLater(() -> {
                        try {
                            BusinessMessageListController.this.error_message.setText("Get messages complete.");
                            applicationController.setStatusBarMessage("Get messages complete.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            BusinessMessageListController.this.error_message.setText(e.getMessage());
                            applicationController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        BusinessMessageListController.this.error_message.setText(e.getMessage());
                        applicationController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }

    public Document buildSignableDocument() throws Exception {
        Document document = this.dBuilder.newDocument();
        Element rootel = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        rootel.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(rootel);
        Element businessel = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        rootel.appendChild(businessel);
        Element gclel = document.createElementNS("http://www.glenix.com.au/", "gx:glenixCertificateList");
        businessel.appendChild(gclel);
        boolean hasrecipient = false;
        for (Object o : this.certificate_list.getSelectionModel().getSelectedItems()) {
            if (!(o instanceof GlenixCertificate)) continue;
            GlenixCertificate gc = (GlenixCertificate)o;
            gc.appendToElement(document, gclel);
            hasrecipient = true;
        }
        if (!hasrecipient) {
            throw new Exception("Error, no recipients for the file");
        }
        return document;
    }

    public void sendFile() {
        final ApplicationController applicationController = this.xbrlFileController;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        applicationController.setStatusBarMessage("Begin send file...");
                        BusinessMessageListController.this.warning_message.setText(null);
                        BusinessMessageListController.this.warning_message.setVisible(false);
                        BusinessMessageListController.this.warning_message.setManaged(false);
                    });
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    Document attachdoc = BusinessMessageListController.this.buildSignableDocument();
                    MessageDigest md = applicationController.calculateSHA1Digest(attachdoc.getDocumentElement());
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", md);
                    gattl.add(gatt);
                    File logFile = Glenix.getLogFile();
                    if (logFile != null) {
                        try {
                            FileInputStream logFileInputStream = new FileInputStream(logFile);
                            applicationController.saveFileEncryptStream("log.txt", logFileInputStream);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    byte[] myBusinessFasFileBytes = applicationController.getMyBusinessFasFileBytes();
                    MessageDigest md2 = applicationController.calculateSHA1DigestBytes(myBusinessFasFileBytes);
                    GlenixSBRAttachment gatt2 = new GlenixSBRAttachment(myBusinessFasFileBytes, "Attachment02", md2);
                    gatt2.setMimeType("application/gzip");
                    gatt2.setCompressionType("application/gzip");
                    gattl.add(gatt2);
                    GlenixResult glenixResult = applicationController.sendDocumentToFASResult(Glenix.soap_service_business_files, "Submit", gattl);
                    Platform.runLater(() -> applicationController.setStatusBarMessage("Interpreting response from FAS..."));
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to send file");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                BusinessMessageListController.this.warning_message.setText("Warning: There is a new version of this software available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                BusinessMessageListController.this.warning_message.setVisible(true);
                                BusinessMessageListController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                BusinessMessageListController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                BusinessMessageListController.this.warning_message.setVisible(true);
                                BusinessMessageListController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                BusinessMessageListController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                BusinessMessageListController.this.warning_message.setVisible(true);
                                BusinessMessageListController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to send file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, unable to send file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    Platform.runLater(() -> {
                        try {
                            BusinessMessageListController.this.error_message.setText("File sent.");
                            applicationController.setStatusBarMessage("File sent.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            BusinessMessageListController.this.error_message.setText(e.getMessage());
                            applicationController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        BusinessMessageListController.this.error_message.setText(e.getMessage());
                        applicationController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }

    private void getMessagesFromFile(File file, String businessFileName) throws Exception {
        GlenixFile gf = this.xbrlFileController.loadGlenixFile(file);
        try {
            Business fileBusiness;
            GlenixTrnXBRL fileXBRL = this.xbrlFileController.getBusinessMessageXBRLFromFile(gf);
            boolean dosave = false;
            if (fileXBRL != null && (fileBusiness = fileXBRL.getBusiness()) != null) {
                int count = fileBusiness.getBusinessMessageCount();
                for (int i = 0; i < count; ++i) {
                    BusinessMessage newbm;
                    BusinessMessage savedBM;
                    BusinessMessage bm = fileBusiness.getBusinessMessage(i);
                    String bmi = bm.getBusinessMessageIdentifier();
                    if (bmi == null || bmi.isEmpty() || (savedBM = this.bmh.get(bmi)) != null) continue;
                    Document doc = this.dBuilder.newDocument();
                    bm.appendToElement(doc);
                    Business b = this.glenixTrnXBRL.getBusiness();
                    if (b == null || (newbm = b.addBlankBusinessMessage()) == null) continue;
                    newbm.loadDocumentElement(doc, doc.getDocumentElement());
                    newbm.setSourceBusinessFileName(businessFileName);
                    dosave = true;
                    this.bmh.put(bmi, newbm);
                    Platform.runLater(() -> {
                        BusinessMessageTitledPane bmtp = this.addBusinessMessageTitledPane(false);
                        bmtp.setBusinessMessageElement(newbm);
                    });
                }
            }
            if (dosave) {
                this.xbrlFileController.saveBusinessMessageList();
            }
            Platform.runLater(() -> this.alertUserStatusMessage());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            gf.closeFile();
        }
    }

    private void downloadFile(String businessIdentifier, String businessFileName) {
        ApplicationController applicationController = this.xbrlFileController;
        Platform.runLater(() -> applicationController.setStatusBarMessage("Begin request file..."));
        try {
            File outFile;
            MessageDetails md = new MessageDetails();
            md.setService(Glenix.soap_service_business_files);
            md.setAction("Get");
            md.setPropBusinessIdentifier(businessIdentifier);
            md.setPropBusinessFileName(businessFileName);
            GlenixSBRResponse response = applicationController.sendDocumentToFAS(md);
            response.parseResponse();
            Document doc = response.getDocumentByHref("res.xml");
            GlenixResult glenixResult = new GlenixResult();
            glenixResult.loadDocumentElement(doc, doc.getDocumentElement());
            Platform.runLater(() -> applicationController.setStatusBarMessage("Interpreting response from FAS..."));
            String resultCode = null;
            if (glenixResult != null) {
                resultCode = glenixResult.getResultCode();
            }
            if (resultCode == null) {
                throw new Exception("Error, unable to get file");
            }
            if (!resultCode.equals("OK")) {
                if (resultCode.equals("ERRORLICENSE")) {
                    throw new Exception("Error, you do not have the required license to perform this action. You may need to contact Free Accounting Software on 1300 113 733.");
                }
                if (resultCode.equals("ERRORVERSION")) {
                    throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                }
                if (resultCode.equals("ERROR")) {
                    throw new Exception("Error, unable to get file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                }
                throw new Exception("Error, unable to get file, error code " + resultCode + ", description " + glenixResult.getResultDescription());
            }
            InputStream is = response.getInputStreamByHref("MyBusiness-download.fas");
            if (is != null && !applicationController.isCurrentFile(outFile = applicationController.getDownloadedFile(businessFileName))) {
                FileOutputStream os = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                int readlen = 0;
                while ((readlen = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, readlen);
                }
                os.flush();
                ((OutputStream)os).close();
                this.getMessagesFromFile(outFile, businessFileName);
            }
            Platform.runLater(() -> {
                try {
                    this.error_message.setText("File received.");
                    applicationController.setStatusBarMessage("File received.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error_message.setText(e.getMessage());
                    applicationController.setStatusBarMessage(e.getMessage());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater(() -> {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                applicationController.setStatusBarMessage(e.getMessage());
            });
        }
    }

    public Integer calculateQuantitySeconds() {
        LocalDate sd = this.startDate.getLocalDate();
        LocalTime st = this.startTime.getLocalTime();
        LocalTime et = this.endTime.getLocalTime();
        LocalTime bt = this.breakTime.getLocalTime();
        if (sd == null || st == null || et == null) {
            return null;
        }
        int breakseconds = 0;
        if (bt != null) {
            breakseconds = bt.getHour() * 3600 + bt.getMinute() * 60 + bt.getSecond();
        }
        if (et.compareTo(st) > 0) {
            return 3600 * (et.getHour() - st.getHour()) + 60 * (et.getMinute() - st.getMinute()) + et.getSecond() - st.getSecond() - breakseconds;
        }
        return 86400 + 3600 * (et.getHour() - st.getHour()) + 60 * (et.getMinute() - st.getMinute()) + et.getSecond() - st.getSecond() - breakseconds;
    }

    public void updateWorkTime() {
        Integer seconds = this.calculateQuantitySeconds();
        if (seconds == null) {
            this.workTime.setGlenixElementValue(null);
        } else {
            this.workTime.setTimeBySeconds(seconds);
        }
    }
}

