/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class BusinessMasterFileController
extends GlenixBranchController {
    protected BusinessMasterFile businessMasterFile = null;
    protected ApplicationController xbrlFileController = null;
    protected DocumentBuilder dBuilder;
    @FXML
    protected Label error_message;
    @FXML
    private GlenixLabelLabel businessIdentifier_label;

    public BusinessMasterFileController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setBusinessMasterFile(BusinessMasterFile businessMasterFile) throws Exception {
        this.error_message.setText(null);
        this.businessMasterFile = businessMasterFile;
        this.clearGlenixXBRL();
        if (businessMasterFile == null) {
            return;
        }
        Document doc = this.dBuilder.newDocument();
        businessMasterFile.appendToElement(doc);
        this.loadGlenixXBRL(doc, doc.getDocumentElement());
    }

    @FXML
    protected void regenerateBusinessIdentifier() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.businessMasterFile != null) {
                this.businessMasterFile.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
                this.businessMasterFile.assignNewUUIDToBusinessIdentifier();
                this.businessIdentifier_label.setGlenixElementValue(this.businessMasterFile.getBusinessIdentifier());
                this.xbrlFileController.saveBusinessMasterFile();
                this.error_message.setText("Saved");
            } else {
                this.error_message.setText("Could not save no business masterfile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    protected void saveBusinessMasterFile() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.businessMasterFile != null) {
                this.businessMasterFile.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
                this.businessMasterFile.assignUUIDToBusinessIdentifier();
                this.xbrlFileController.saveBusinessMasterFile(this.businessMasterFile);
                this.error_message.setText("Saved");
            } else {
                this.error_message.setText("Could not save, no business masterfile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void gotoDocumentLayout() {
        try {
            this.xbrlFileController.gotoDocumentLayout();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }
}

