/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionsTableController;
import au.com.glenix.trn.Transaction;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableRow;

public class BatchTransactionsTableController
extends TransactionsTableController {
    protected Transaction batchTransaction;

    public BatchTransactionsTableController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    protected void setupActionColumn() {
        this.transactionTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                block8: {
                    if (event.getClickCount() == 2) {
                        if (!row.isEmpty()) {
                            Transaction transaction = (Transaction)row.getItem();
                            if (transaction != null) {
                                try {
                                    String tt = transaction.getTransactionType();
                                    if (tt == null || tt.equals("pay_slip")) {
                                        this.xbrlFileController.gotoBatchPaySlipEdit(transaction, this.batchTransaction);
                                        break block8;
                                    }
                                    this.xbrlFileController.gotoTransactionEdit(transaction);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.error_message.setText("Error, could not go to transaction edit page.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get transaction.");
                            }
                        } else {
                            this.gotoNewBatchTransaction();
                        }
                    }
                }
            });
            return row;
        });
        this.transactionTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    protected boolean checkTransactionType(Transaction t) {
        if (t == null) {
            return false;
        }
        String ts = t.getTransactionStatus();
        return ts != null && !ts.equals("cancelled");
    }

    protected void updateFilter(String newValue) {
        this.filteredItems.setPredicate(t -> {
            if (!this.checkTransactionType((Transaction)t)) {
                return false;
            }
            String filterBatchIdentifier = this.batchTransaction.getBatchIdentifier();
            String thisBatchIdentifier = t.getBatchIdentifier();
            if (filterBatchIdentifier == null || filterBatchIdentifier.isEmpty()) {
                return false;
            }
            if (thisBatchIdentifier == null || thisBatchIdentifier.isEmpty()) {
                return false;
            }
            if (!thisBatchIdentifier.equals(filterBatchIdentifier)) {
                return false;
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = t.getTransactionComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = t.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.xbrlFileController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        });
        this.updateTotalAmount();
    }

    public void setTransactionObservableList(ObservableList<Transaction> transactionObservableList, Transaction batchTransaction) {
        this.batchTransaction = batchTransaction;
        this.transactionObservableList = transactionObservableList;
        this.filteredItems = new FilteredList(this.transactionObservableList, p -> true);
        this.transactionTable.setItems((ObservableList)this.filteredItems);
        this.updateFilter();
    }

    public void setTransactionListBatch(Transaction batchTransaction) {
        this.batchTransaction = batchTransaction;
        this.filteredItems = new FilteredList(this.transactionObservableList, p -> true);
        this.transactionTable.setItems((ObservableList)this.filteredItems);
        this.updateFilter();
    }

    @Override
    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
    }

    @Override
    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
    }

    @Override
    public void setAccountList(ObservableList<Transaction> accountObservableList) {
    }

    @FXML
    private void gotoNewBatchTransaction() {
        try {
            this.xbrlFileController.gotoBatchTransactionEdit((Transaction)null, this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load transaction edit page.");
        }
    }

    @FXML
    private void gotoNewBatchPaySlip() {
        try {
            this.xbrlFileController.gotoBatchPaySlipEdit((Transaction)null, this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load pay slip edit page.");
        }
    }

    @FXML
    private void gotoBatchEdit() {
        try {
            this.xbrlFileController.gotoBatchEdit(this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch edit page.");
        }
    }

    @FXML
    public void cancelSelectedTransactions() {
        try {
            ObservableList selectedTransactions;
            String batchStatus = this.batchTransaction.getBatchStatus();
            if (batchStatus != null) {
                if (batchStatus.equals("authorised")) {
                    throw new Exception("Error, you cannot modify a transaction on an authorised batch. You may want to change it back to created status first.");
                }
                if (batchStatus.equals("lodge_complete")) {
                    throw new Exception("Error, you cannot modify a transaction on a lodged batch. You may need to reverse the transaction and may need to lodge an update.");
                }
                if (!batchStatus.equals("created")) {
                    throw new Exception("Error, you cannot modify a transaction on this batch as the batch status is not 'created'. You may want to change it back to created status first.");
                }
            }
            if ((selectedTransactions = this.transactionTable.getSelectionModel().getSelectedItems()) != null && selectedTransactions.size() > 0) {
                int count = selectedTransactions.size();
                for (int i = 0; i < count; ++i) {
                    Transaction t = (Transaction)selectedTransactions.get(i);
                    t.setTransactionStatus("cancelled");
                }
                this.xbrlFileController.saveTransactions((Collection<Transaction>)selectedTransactions);
                this.updateFilter(null);
                this.refreshTable();
            } else {
                String message = "Error, there are no selected transactions to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void removeTransactionsFromBatch() {
        try {
            ObservableList selectedTransactions;
            String batchStatus = this.batchTransaction.getBatchStatus();
            if (batchStatus != null) {
                if (batchStatus.equals("authorised")) {
                    throw new Exception("Error, you cannot modify a transaction on an authorised batch. You may want to change it back to created status first.");
                }
                if (batchStatus.equals("lodge_complete")) {
                    throw new Exception("Error, you cannot modify a transaction on a lodged batch. You may need to reverse the transaction and may need to lodge an update.");
                }
                if (!batchStatus.equals("created")) {
                    throw new Exception("Error, you cannot modify a transaction on this batch as the batch status is not 'created'. You may want to change it back to created status first.");
                }
            }
            if ((selectedTransactions = this.transactionTable.getSelectionModel().getSelectedItems()) != null && selectedTransactions.size() > 0) {
                Transaction t;
                int i;
                int count = selectedTransactions.size();
                for (i = 0; i < count; ++i) {
                    t = (Transaction)selectedTransactions.get(i);
                    String tt = t.getTransactionType();
                    if (tt == null || !tt.equals("pay_slip")) continue;
                    throw new Exception("Error, you cannot remove a pay slip from the batch because all pay slips must be on a batch. Perhaps delete it.");
                }
                for (i = 0; i < count; ++i) {
                    t = (Transaction)selectedTransactions.get(i);
                    t.setBatchIdentifier(null);
                }
                this.xbrlFileController.saveTransactions((Collection<Transaction>)selectedTransactions);
                this.updateFilter(null);
                this.refreshTable();
            } else {
                String message = "Error, there are no selected transactions to remove from the batch.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        if (this.filteredItems != null) {
            for (Transaction t : this.filteredItems) {
                totalAmount = this.addDouble(totalAmount, t.getTotalAmount());
                totalProvisionAmount = this.addDouble(totalProvisionAmount, t.getTotalProvisionAmount());
                totalQuantity = this.addDouble(totalQuantity, t.getTotalQuantity());
            }
        }
        if (this.total_label != null) {
            this.total_label.setText("Total displayed amount: " + this.amountFormat.format(totalAmount));
        }
    }
}

