/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchTableController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    private DocumentBuilder dBuilder;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private Business business = null;
    @FXML
    private GlenixFlowPane fp1;
    @FXML
    private Label page_heading;
    @FXML
    private Label error_message;
    @FXML
    private TableView batchTable;
    @FXML
    private TableColumn<Transaction, String> actionColumn;
    @FXML
    private TableColumn batchPaymentDateAsDateColumn;
    @FXML
    private TableColumn batchPeriodStartAsDateColumn;
    @FXML
    private TableColumn batchPeriodEndAsDateColumn;
    @FXML
    private TableColumn batchCommentColumn;
    @FXML
    private TableColumn batchStatusColumn;
    private ObservableList<Transaction> transactionObservableList;
    private ApplicationController xbrlFileController = null;
    private String pattern = "dd MMM yyyy";
    private DateTimeFormatter displayDateFormatter;
    private Transaction batch = null;

    public BatchTableController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.batchTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        Transaction transaction = (Transaction)row.getItem();
                        if (transaction != null) {
                            try {
                                this.gotoBatchEdit(transaction);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.error_message.setText("Error, could not edit batch.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get batch for edit.");
                        }
                    } else {
                        this.newBatch();
                    }
                }
            });
            return row;
        });
        this.batchPaymentDateAsDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, LocalDate>, TableCell<Transaction, LocalDate>>(){

            public TableCell call(TableColumn<Transaction, LocalDate> param) {
                TableCell<Transaction, LocalDate> cell = new TableCell<Transaction, LocalDate>(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(BatchTableController.this.displayDateFormatter.format(item));
                        }
                    }
                };
                return cell;
            }
        });
        this.batchPeriodStartAsDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, LocalDate>, TableCell<Transaction, LocalDate>>(){

            public TableCell call(TableColumn<Transaction, LocalDate> param) {
                TableCell<Transaction, LocalDate> cell = new TableCell<Transaction, LocalDate>(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(BatchTableController.this.displayDateFormatter.format(item));
                        }
                    }
                };
                return cell;
            }
        });
        this.batchPeriodEndAsDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction, LocalDate>, TableCell<Transaction, LocalDate>>(){

            public TableCell call(TableColumn<Transaction, LocalDate> param) {
                TableCell<Transaction, LocalDate> cell = new TableCell<Transaction, LocalDate>(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(BatchTableController.this.displayDateFormatter.format(item));
                        }
                    }
                };
                return cell;
            }
        });
        this.batchTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        super.buildGlenixXBRL(resultDoc, xbrlEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                super.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setBatchObservableList();
        }
        this.page_heading.setText("Batches (payroll and other) - " + this.xbrlFileController.getBusinessLegalName());
    }

    private void gotoBatchEdit(Transaction batchTransaction) {
        try {
            this.xbrlFileController.gotoBatchEdit(batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void newBatch() {
        this.gotoBatchEdit(null);
    }

    @FXML
    public void gotoPaySlipsTransactions() {
        this.xbrlFileController.gotoPaySlipsTransactions();
    }

    private void setBatchObservableList() {
        Business business = this.glenixTrnXBRL.getBusiness();
        if (business == null) {
            return;
        }
        ArrayList<Transaction> transactionArrayList = business.getTransactionArrayList();
        transactionArrayList.sort(new Comparator<Transaction>(){

            @Override
            public int compare(Transaction t1, Transaction t2) {
                int res;
                int res2;
                Batch a1 = t1.getBatch();
                Batch a2 = t2.getBatch();
                if (a1 == null && a2 != null) {
                    return -1;
                }
                if (a2 == null && a1 != null) {
                    return 1;
                }
                if (a2 == null && a1 == null) {
                    return 0;
                }
                LocalDate date1 = a1.getBatchPaymentDateAsDate();
                LocalDate date2 = a2.getBatchPaymentDateAsDate();
                if (date1 == null && date2 != null) {
                    return 1;
                }
                if (date2 == null && date1 != null) {
                    return -1;
                }
                if (date1 != null && date2 != null && (res2 = date1.compareTo(date2)) != 0) {
                    return -res2;
                }
                String name1 = a1.getBatchComment();
                String name2 = a2.getBatchComment();
                if ((name1 == null || name1.isEmpty()) && name2 != null && !name2.isEmpty()) {
                    return 1;
                }
                if ((name2 == null || name2.isEmpty()) && name1 != null && !name1.isEmpty()) {
                    return -1;
                }
                if (name1 != null && name2 != null && (res = name1.compareToIgnoreCase(name2)) != 0) {
                    return -res;
                }
                return a2.toString().compareTo(a1.toString());
            }
        });
        this.transactionObservableList = FXCollections.observableList(transactionArrayList);
        this.batchTable.setItems(this.transactionObservableList);
    }

    public void refreshTable() {
        this.setBatchObservableList();
        this.batchTable.refresh();
    }

    @FXML
    private void deleteSelectedBatches() {
        try {
            ObservableList selectedBatchTransactions = this.batchTable.getSelectionModel().getSelectedItems();
            if (selectedBatchTransactions != null && selectedBatchTransactions.size() > 0) {
                this.xbrlFileController.deleteSelectedBatches((ObservableList<Transaction>)selectedBatchTransactions);
                this.xbrlFileController.saveBatches();
            } else {
                String message = "Error, there are no selected batches to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(7);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 28.0);
        gpw.setColumnLeftPosAndWidthMM(3, 48.0, 28.0);
        gpw.setColumnLeftPosAndWidthMM(4, 76.0, 28.0);
        gpw.setColumnLeftPosAndWidthMM(5, 104.0, 68.0);
        gpw.setColumnLeftPosAndWidthMM(6, 170.0, 30.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Transaction t : this.transactionObservableList) {
            gpw.prepareString(2, this.displayDateFormatter.format(t.getBatchPaymentDateAsDate()), true, fontSize);
            gpw.prepareString(3, this.displayDateFormatter.format(t.getBatchPeriodStartAsDate()), true, fontSize);
            gpw.prepareString(4, this.displayDateFormatter.format(t.getBatchPeriodEndAsDate()), true, fontSize);
            gpw.prepareString(5, t.getBatchComment(), true, fontSize);
            gpw.prepareString(6, t.getBatchStatus(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.batchPaymentDateAsDateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.batchPeriodStartAsDateColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.batchPeriodEndAsDateColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.batchCommentColumn.getText(), true, fontSize);
        gpw.prepareString(6, this.batchStatusColumn.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

