/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.EventItemsVBox;
import au.com.glenix.GlenixLabelAUSKeyCombo;
import au.com.glenix.GlenixMultiInputStreamEventDelimited;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.ElectronicContact;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.PEE0003Payee;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.ProfileElectronicContact;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelDateLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelLabelTwoDecimalDollarFormat;
import au.com.glenix.widget.GlenixLabelNoYesCombo;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixVBox;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchSTPLodgeController
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    @FXML
    protected Label page_heading;
    @FXML
    protected Label error_message;
    @FXML
    protected Label warning_message;
    @FXML
    protected Button lodgeBatchPEE0003Button;
    @FXML
    protected Button updateBatchPEE0003Button;
    @FXML
    protected Button pullMessagesButton;
    @FXML
    protected Button setAmendedPEE0003Button;
    protected Transaction batchTransaction = null;
    protected ApplicationController xbrlFileController;
    @FXML
    protected GlenixLabelAUSKeyCombo ausKeyCombo;
    @FXML
    protected GlenixLabelPassword password;
    @FXML
    protected GlenixLabelLabel agentAustralianBusinessNumberId;
    @FXML
    protected GlenixLabelLabel TaxAgentNumberId;
    @FXML
    protected GlenixLabelLabel SoftwareInformationBusinessManagementSystemId;
    @FXML
    protected GlenixLabelLabel AustralianBusinessNumberId;
    @FXML
    protected GlenixLabelLabel WithholdingPayerNumberId;
    @FXML
    protected GlenixLabelLabel OrganisationDetailsOrganisationBranchC;
    @FXML
    protected GlenixLabelLabel DetailsOrganisationalNameT;
    @FXML
    protected GlenixLabelLabel PersonUnstructuredNameFullNameT;
    @FXML
    protected GlenixLabelLabel ElectronicMailAddressT;
    @FXML
    protected GlenixLabelLabel TelephoneMinimalN;
    @FXML
    protected GlenixLabelLabel Line1T;
    @FXML
    protected GlenixLabelLabel Line2T;
    @FXML
    protected GlenixLabelLabel LocalityNameT;
    @FXML
    protected GlenixLabelLabel StateOrTerritoryC;
    @FXML
    protected GlenixLabelLabel PostcodeT;
    @FXML
    protected GlenixLabelCountryLabel CountryC;
    @FXML
    protected GlenixLabelDateLabel PaymentRecordTransactionD;
    @FXML
    protected GlenixLabelLabel InteractionRecordCt;
    @FXML
    protected GlenixLabelLabel MessageTimestampGenerationDt;
    @FXML
    protected GlenixLabelLabel InteractionTransactionId;
    @FXML
    protected GlenixLabelNoYesCombo AmendmentI;
    @FXML
    protected GlenixLabelLabelTwoDecimalDollarFormat PayAsYouGoWithholdingTaxWithheldA;
    @FXML
    protected GlenixLabelLabelTwoDecimalDollarFormat TotalGrossPaymentsWithholdingA;
    @FXML
    protected GlenixLabelLabel agentPersonUnstructuredNameFullNameT;
    @FXML
    protected GlenixLabelLabel agentElectronicMailAddressT;
    @FXML
    protected GlenixLabelLabel agentTelephoneMinimalN;
    @FXML
    protected GlenixLabelCheckbox agentStatementAcceptedI;
    @FXML
    protected GlenixVBox intermediarysection;
    @FXML
    protected GlenixLabelCheckbox StatementAcceptedI;
    @FXML
    protected GlenixLabelDate SignatureD;
    @FXML
    protected GlenixLabelText SignatoryIdentifierT;
    @FXML
    protected GlenixLabelDate agentSignatureD;
    @FXML
    protected GlenixLabelText agentSignatoryIdentifierT;
    @FXML
    protected Label rp_declaration_text;
    @FXML
    protected EventItemsVBox overalleventitemsvbox;
    @FXML
    protected EventItemsVBox businesseventitemsvbox;
    @FXML
    protected Hyperlink show_detail;
    @FXML
    protected Hyperlink hide_detail;
    @FXML
    protected GlenixLabelLabel batchStatus;
    @FXML
    protected GlenixLabelLabel batchMessageIdentifier;
    @FXML
    protected GlenixLabelLabel batchLodgeTimestamp;
    @FXML
    protected GlenixLabelLabel batchATOLodgeMessageIdentifier;
    @FXML
    protected GlenixLabelLabel batchATOLodgeTimestamp;
    @FXML
    protected GlenixLabelLabel batchPullMessageIdentifier;
    @FXML
    protected GlenixLabelLabel batchPullMessagesTimestamp;
    @FXML
    protected GlenixLabelLabel batchATOPullMessagesMessageIdentifier;
    @FXML
    protected GlenixLabelLabel batchATOPullMessagesTimestamp;
    @FXML
    private TitledPane batchtp;
    @FXML
    private TitledPane batchtpstatus;
    @FXML
    private TitledPane batchtpevent;

    public BatchSTPLodgeController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.batchtp.expandedProperty().setValue(Boolean.valueOf(false));
        this.batchtpstatus.expandedProperty().setValue(Boolean.valueOf(false));
        this.batchtpevent.expandedProperty().setValue(Boolean.valueOf(false));
        this.businesseventitemsvbox.show_detail();
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        super.buildGlenixXBRL(resultDoc, transactionEl);
    }

    public void buildGlenixXBRLTransaction(Document resultDoc, Element resultElement) throws Exception {
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        if (resultElement == null) {
            resultDoc.appendChild(transactionEl);
        } else {
            resultElement.appendChild(transactionEl);
        }
        super.buildGlenixXBRL(resultDoc, transactionEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1) continue;
                        Element el = (Element)node3;
                        super.loadGlenixXBRL(loadDoc, el);
                    }
                }
            }
        }
    }

    private Double totalOrZero(HashMap<String, Double> totals, String classification) {
        Double d = totals.get(classification);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private Double addTotalOrNull(Double total, HashMap<String, Double> totals, String classification) {
        Double d = totals.get(classification);
        if (d == null) {
            return total;
        }
        if (total == null) {
            return d;
        }
        return d + total;
    }

    public void setBatchTransactionElement(Transaction batchTransaction) {
        this.batchTransaction = batchTransaction;
        try {
            Document doc = batchTransaction.buildDocument();
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
            this.loadGlenixDefaults();
            Batch batch = batchTransaction.getBatch();
            if (batch == null) {
                this.page_heading.setText("Single Touch Payroll Lodge - " + this.xbrlFileController.getBusinessLegalName());
            } else {
                String comment = batch.getBatchComment();
                if (comment == null || comment.isEmpty()) {
                    this.page_heading.setText("Single Touch Payroll Lodge - " + this.xbrlFileController.getBusinessLegalName());
                } else {
                    this.page_heading.setText("Single Touch Payroll Lodge - " + comment + " - " + this.xbrlFileController.getBusinessLegalName());
                }
                String status = batch.getBatchStatus();
                if (status != null && (status.equals("lodge_complete") || status.equals("authorised_retrieving") || status.equals("retrieving"))) {
                    this.lodgeBatchPEE0003Button.disableProperty().set(true);
                    this.updateBatchPEE0003Button.disableProperty().set(true);
                    this.pullMessagesButton.disableProperty().set(true);
                    this.AmendmentI.disableProperty().set(true);
                    this.SignatureD.disableProperty().set(true);
                    this.SignatoryIdentifierT.disableProperty().set(true);
                    this.agentSignatureD.disableProperty().set(true);
                    this.agentSignatoryIdentifierT.disableProperty().set(true);
                    this.StatementAcceptedI.disableProperty().set(true);
                    this.agentStatementAcceptedI.disableProperty().set(true);
                    if (this.ausKeyCombo != null) {
                        this.ausKeyCombo.setDisable(true);
                    }
                    this.password.setText(null);
                    this.password.setDisable(true);
                } else {
                    this.lodgeBatchPEE0003Button.disableProperty().set(false);
                    this.updateBatchPEE0003Button.disableProperty().set(false);
                    this.pullMessagesButton.disableProperty().set(false);
                    this.AmendmentI.disableProperty().set(false);
                    this.SignatureD.disableProperty().set(false);
                    this.SignatoryIdentifierT.disableProperty().set(false);
                    this.agentSignatureD.disableProperty().set(false);
                    this.agentSignatoryIdentifierT.disableProperty().set(false);
                    this.StatementAcceptedI.disableProperty().set(false);
                    this.agentStatementAcceptedI.disableProperty().set(false);
                    if (this.ausKeyCombo != null) {
                        this.ausKeyCombo.setDisable(false);
                    }
                    this.password.setText(null);
                    this.password.setDisable(false);
                }
                if (this.ausKeyCombo != null) {
                    String credid = batch.getCertAlias();
                    this.ausKeyCombo.setGlenixElementValue(credid);
                }
                EventItems eventItems = batch.getBusinessEventItems();
                this.businesseventitemsvbox.setEventItemsModel(eventItems);
                eventItems = batch.getOverallEventItems();
                this.overalleventitemsvbox.setEventItemsModel(eventItems);
                this.batchtp.expandedProperty().setValue(Boolean.valueOf(false));
                this.batchtpstatus.expandedProperty().setValue(Boolean.valueOf(false));
                this.batchtpevent.expandedProperty().setValue(Boolean.valueOf(false));
                this.businesseventitemsvbox.show_detail();
                String batchIdentifier = batch.getBatchIdentifier();
                if (batchIdentifier != null) {
                    LocalDate declDate;
                    String declDateStr;
                    GlenixTrnXBRL transactions = this.xbrlFileController.getTransactions(batchIdentifier);
                    ArrayList<Transaction> batchTransactions = transactions.getTransactionArrayListByBatch(batchIdentifier);
                    int recordCount = 0;
                    Double totalGross = null;
                    Double totalTax = null;
                    for (Transaction t : batchTransactions) {
                        PEE0003Payee p = t.getTransactionPayEventEmp();
                        String tStatus = t.getTransactionStatus();
                        if (p == null || tStatus == null || !tStatus.equals("posted")) continue;
                        ++recordCount;
                        Double paySlipTotalGross = null;
                        Double paySlipTotalTax = null;
                        GlenixTrnXBRL provisionMaterfileTransactions = this.xbrlFileController.getGlenixTrnXBRLProvision();
                        HashMap<String, Double> totals = t.calculatePSTotals(provisionMaterfileTransactions);
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Employment_Allowances_Car");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Employment_Allowances_Transport");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Employment_Allowances_Laundry");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Employment_Allowances_Meals");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Employment_Allowances_Travel");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Individual_Non_Business_Employment_Allowances_Other");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Lump_Sum_A");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Lump_Sum_B");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Lump_Sum_E");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Community_Development_Employment_Project");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Labour_Hire_Arrangement_Payment_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Specified_By_Regulation_Payment_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Personal_Services_Income_Alienated_Attributed_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Voluntary_Agreement_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_B");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_D");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_N");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_O");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_P");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_R");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_S");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Superannuation_Employment_Termination_Taxable_Component_T");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "JPDA_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Working_Holiday_Maker_Gross");
                        paySlipTotalGross = this.addTotalOrNull(paySlipTotalGross, totals, "Foreign_Resident_Gross");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_Individual_Non_Business");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_Voluntary_Agreement");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_Labour_Hire");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_Specified");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_JPDA");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_Working_Holiday");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_Foreign_Resident");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_B");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_D");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_N");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_O");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_P");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_R");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_S");
                        paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_ETP_T");
                        if ((paySlipTotalTax = this.addTotalOrNull(paySlipTotalTax, totals, "PAYG_JPDA_Foreign_Withholding")) != null && paySlipTotalTax != 0.0) {
                            totalTax = totalTax == null ? paySlipTotalTax : Double.valueOf(totalTax + paySlipTotalTax);
                        }
                        if (paySlipTotalGross == null || paySlipTotalGross == 0.0) continue;
                        if (totalGross == null) {
                            totalGross = paySlipTotalGross;
                            continue;
                        }
                        totalGross = totalGross + paySlipTotalGross;
                    }
                    this.InteractionRecordCt.setGlenixElementValue("" + recordCount);
                    if (totalGross == null && totalTax == null) {
                        this.TotalGrossPaymentsWithholdingA.setGlenixElementValue(null);
                        this.PayAsYouGoWithholdingTaxWithheldA.setGlenixElementValue(null);
                        this.lodgeBatchPEE0003Button.disableProperty().set(true);
                    } else {
                        if (totalGross == null) {
                            this.TotalGrossPaymentsWithholdingA.setGlenixElementValue("0.00");
                        } else {
                            totalGross = (double)Math.round(totalGross * 100.0) / 100.0;
                            this.TotalGrossPaymentsWithholdingA.setGlenixElementValue("" + totalGross);
                        }
                        if (totalTax == null) {
                            this.PayAsYouGoWithholdingTaxWithheldA.setGlenixElementValue("0.00");
                        } else {
                            totalTax = (double)Math.round(totalTax * 100.0) / 100.0;
                            this.PayAsYouGoWithholdingTaxWithheldA.setGlenixElementValue("" + totalTax);
                        }
                        this.updateBatchPEE0003Button.disableProperty().set(true);
                    }
                    this.InteractionTransactionId.setGlenixElementValue(batchIdentifier);
                    String amendmentValue = this.AmendmentI.getGlenixElementValue();
                    if (amendmentValue == null || amendmentValue.isEmpty()) {
                        this.AmendmentI.setGlenixElementValue("false");
                    }
                    this.setMessageTimestamp();
                    String dateStr = this.batchTransaction.getBatchPaymentDate();
                    if (dateStr != null) {
                        this.PaymentRecordTransactionD.setGlenixElementValue(dateStr);
                    }
                    if ((declDateStr = (declDate = LocalDate.now()).format(DateTimeFormatter.ISO_DATE)) != null) {
                        if (this.intermediarysection.isVisible()) {
                            this.agentSignatureD.setGlenixElementValue(declDateStr);
                        } else {
                            this.agentSignatureD.setGlenixElementValue(null);
                        }
                        this.SignatureD.setGlenixElementValue(declDateStr);
                    }
                }
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void setMessageTimestamp() {
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String created_timestamp = isoFormat.format(date);
        this.MessageTimestampGenerationDt.setGlenixElementValue(created_timestamp);
    }

    @FXML
    protected void saveBatchTransaction() {
        try {
            this.setMessageTimestamp();
            Document resultDoc = this.dBuilder.newDocument();
            this.buildGlenixXBRLTransaction(resultDoc, null);
            if (this.batchTransaction == null) {
                this.batchTransaction = this.xbrlFileController.addBatchTransaction();
            }
            this.batchTransaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            if (this.ausKeyCombo != null) {
                String certAlias = this.ausKeyCombo.getGlenixElementValue();
                this.batchTransaction.setBatchCertAlias(certAlias);
            }
            this.xbrlFileController.saveBatches();
            this.error_message.setText("Saved");
            Document reloadDoc = this.batchTransaction.buildDocument();
            this.loadGlenixXBRL(reloadDoc, reloadDoc.getDocumentElement());
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    protected void clearBatchTransaction() {
        this.clearGlenixXBRL();
        this.setBatchTransactionElement(null);
        this.error_message.setText("New batch");
    }

    @FXML
    protected void gotoBatchEdit() {
        try {
            this.xbrlFileController.gotoBatchEdit(this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch edit page.");
        }
    }

    @FXML
    protected void gotoBatchList() {
        try {
            this.xbrlFileController.gotoBatches();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch list page.");
        }
    }

    @FXML
    protected void gotoBatchTransactions() {
        try {
            this.xbrlFileController.gotoBatchTransactions(this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch list page.");
        }
    }

    @FXML
    protected void setAmendedPEE0003() {
        try {
            if (this.batchTransaction != null) {
                Batch b = this.batchTransaction.getBatch();
                if (b != null) {
                    b.setAmendmentI("true");
                    b.setBatchStatus("created");
                }
                this.AmendmentI.setGlenixElementValue("true");
                this.batchStatus.setGlenixElementValue("created");
                this.StatementAcceptedI.setGlenixElementValue(null);
                this.agentStatementAcceptedI.setGlenixElementValue(null);
                this.setBatchTransactionElement(this.batchTransaction);
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    protected void authoriseBatchPEE0003() {
        try {
            if (this.batchTransaction != null) {
                Batch b = this.batchTransaction.getBatch();
                if (b == null) {
                    throw new Exception("Error, batch not found is it saved");
                }
                String status = b.getBatchStatus();
                if (status != null && !status.equals("created") && !status.equals("authorised")) {
                    throw new Exception("Error, the batch status is not created, cannot authorise");
                }
                this.batchStatus.setGlenixElementValue("authorised");
                this.setBatchTransactionElement(this.batchTransaction);
                this.saveBatchTransaction();
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void validateBatchPEE0003(Batch batch) throws Exception {
        String branch = batch.getOrganisationDetailsOrganisationBranchC();
        if (branch == null || branch.isEmpty()) {
            throw new Exception("Error, the branch number is required. Add the branch number on the Setup -> My business details page");
        }
        if (branch.startsWith("0")) {
            throw new Exception("Error, the branch number should not start with a zero. Fix this on the Setup -> My business details page");
        }
        String abn = batch.getAustralianBusinessNumberId();
        String wpn = batch.getWithholdingPayerNumberId();
        if ((abn == null || abn.isEmpty()) && (wpn == null || wpn.isEmpty())) {
            throw new Exception("Error, either the ABN or WPN needs to be set up. Fix this on the Setup -> My business details page");
        }
        String si = batch.getSoftwareInformationBusinessManagementSystemId();
        if (si == null || si.isEmpty()) {
            throw new Exception("Error, the software system ID needs to be set up. Fix this on the Setup -> My business details page");
        }
    }

    @FXML
    protected void lodgeBatchPEE0003() {
        try {
            this.saveBatchTransaction();
            if (this.batchTransaction == null) {
                this.error_message.setText("Error, batch not yet saved. Must save before lodge.");
                this.xbrlFileController.setStatusBarMessage("Error, batch not yet saved. Must save before lodge.");
                return;
            }
            Batch batch = this.batchTransaction.getBatch();
            if (batch == null) {
                throw new Exception("Error, batch is null cannot lodge.");
            }
            this.validateBatchPEE0003(batch);
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            batch.setCertAlias(credentialId);
            String passwordString = this.password.getText();
            this.password.setText(null);
            this.lodge("lodge", this.batchTransaction, credentialId, passwordString);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    protected void updateBatchPEE0003() {
        try {
            this.saveBatchTransaction();
            if (this.batchTransaction == null) {
                this.error_message.setText("Error, batch not yet saved. Must save before update.");
                this.xbrlFileController.setStatusBarMessage("Error, batch not yet saved. Must save before update.");
                return;
            }
            Batch batch = this.batchTransaction.getBatch();
            if (batch == null) {
                throw new Exception("Error, batch is null cannot update.");
            }
            this.validateBatchPEE0003(batch);
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            batch.setCertAlias(credentialId);
            String passwordString = this.password.getText();
            this.password.setText(null);
            this.lodge("update", this.batchTransaction, credentialId, passwordString);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    private void lodge(final String action, final Transaction batchTransaction, final String credentialId, final String password) {
        final String tan = this.TaxAgentNumberId.getText();
        final String agentABN = this.agentAustralianBusinessNumberId.getText();
        final String abn = this.AustralianBusinessNumberId.getText();
        final String wpn = this.WithholdingPayerNumberId.getText();
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin STP lodge...");
                        BatchSTPLodgeController.this.warning_message.setText(null);
                        BatchSTPLodgeController.this.warning_message.setVisible(false);
                        BatchSTPLodgeController.this.warning_message.setManaged(false);
                    });
                    String service = "http://sbr.gov.au/ato/payevnt/2018";
                    String actionCode = "Validate.003.00";
                    if (action != null && action.equals("lodge")) {
                        actionCode = "Submit.003.00";
                    } else if (action != null && action.equals("update")) {
                        actionCode = "Update.003.00";
                    }
                    Batch batch = batchTransaction.getBatch();
                    String batchIdentifier = batch.getBatchIdentifier();
                    if (batchIdentifier == null) {
                        throw new Exception("Error, batch identifier not set. Must save before lodge.");
                    }
                    String originalStatus = batch.getBatchStatus();
                    if (originalStatus != null && originalStatus.equals("lodge_complete")) {
                        throw new Exception("Error, the batch is already lodged.");
                    }
                    if (!(originalStatus == null || originalStatus.isEmpty() || originalStatus.equals("created") || originalStatus.equals("authorised"))) {
                        throw new Exception("Error, batch is not of created or authorised status. It needs to be created or authorised to send.");
                    }
                    Document resultDoc = batch.buildPEE0003Document();
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(resultDoc, "Attachment01", null);
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    gatt.setDocumentID("1.0");
                    gatt.setRelatedDocumentID("");
                    gatt.setDocumentType("PARENT");
                    gatt.setDocumentName("PAYEVNT");
                    gattl.add(gatt);
                    GlenixTrnXBRL transactions = xbrlFileController.getTransactions();
                    ArrayList<Transaction> batchTransactions = transactions.getTransactionArrayListByBatch(batchIdentifier);
                    int size = batchTransactions.size();
                    int record_count = 0;
                    for (int i = 0; i < size; ++i) {
                        Transaction t = batchTransactions.get(i);
                        PEE0003Payee p = t.getTransactionPayEventEmp();
                        if (p == null) continue;
                        String docId = "1." + (i + 1);
                        t.setDocumentID(docId);
                        String status = t.getTransactionStatus();
                        if (status == null || !status.equals("posted")) continue;
                        ++record_count;
                        Document empDoc = t.buildPEE0003EmpDocument();
                        GlenixSBRAttachment gatta = new GlenixSBRAttachment(empDoc, "Attachment01", null);
                        gatta.setDocumentID(docId);
                        gatta.setRelatedDocumentID("1.0");
                        gatta.setDocumentType("CHILD");
                        gatta.setDocumentName("PAYEVNTEMP");
                        gattl.add(gatta);
                    }
                    String usageMessageID = BatchSTPLodgeController.this.generateMessageIdentifier();
                    GlenixResult glenixResult = xbrlFileController.doUsageCheck(tan, agentABN, abn, null, service, actionCode, usageMessageID, null, null, record_count);
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to check version or license information, cannot lodge");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                BatchSTPLodgeController.this.warning_message.setText("Warning: There is a new version available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                BatchSTPLodgeController.this.warning_message.setVisible(true);
                                BatchSTPLodgeController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                BatchSTPLodgeController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                BatchSTPLodgeController.this.warning_message.setVisible(true);
                                BatchSTPLodgeController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                BatchSTPLodgeController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                BatchSTPLodgeController.this.warning_message.setVisible(true);
                                BatchSTPLodgeController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this lodgement. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP lodge - loading AUS key..."));
                    xbrlFileController.loadAUSKeyCredential(credentialId);
                    xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                    xbrlFileController.extractAUSKeyCredentialX509Certificate();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP lodge - signing request..."));
                    Node encryptedDataNode = xbrlFileController.buildAndSendSTSDocument();
                    batch.generateBatchMessageIdentifier();
                    String messageId = batch.getBatchMessageIdentifier();
                    batch.setBatchLodgeTimestamp();
                    String timestamp = batch.getBatchLodgeTimestamp();
                    Platform.runLater(() -> {
                        if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                            BatchSTPLodgeController.this.batchMessageIdentifier.setGlenixElementValue(messageId);
                            BatchSTPLodgeController.this.batchLodgeTimestamp.setGlenixElementValue(timestamp);
                        }
                        xbrlFileController.setStatusBarMessage("STP lodge - sending lodge document...");
                    });
                    String logFileName = "STP_" + batchIdentifier + "_lodge.log";
                    GlenixSBRResponse glenixSBRResponse = xbrlFileController.buildAndSendLodgeDocumentBatchGzip(encryptedDataNode, tan, agentABN, abn, wpn, null, service, actionCode, messageId, timestamp, gattl, logFileName);
                    glenixSBRResponse.parseResponse();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP lodge complete reading response..."));
                    String receipt = glenixSBRResponse.getReceipt();
                    if (receipt != null && !receipt.isEmpty()) {
                        if (originalStatus == null || originalStatus.isEmpty() || originalStatus.equals("created")) {
                            batch.setBatchStatus("sent");
                            Platform.runLater(() -> {
                                if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                    BatchSTPLodgeController.this.batchStatus.setGlenixElementValue("sent");
                                }
                            });
                        } else {
                            batch.setBatchStatus("authorised_sent");
                            Platform.runLater(() -> {
                                if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                    BatchSTPLodgeController.this.batchStatus.setGlenixElementValue("authorised_sent");
                                }
                            });
                        }
                        batch.removeAllEventMessages();
                        Platform.runLater(() -> {
                            if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                try {
                                    BatchSTPLodgeController.this.businesseventitemsvbox.setEventItemsModel(null);
                                    BatchSTPLodgeController.this.overalleventitemsvbox.setEventItemsModel(null);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    BatchSTPLodgeController.this.error_message.setText(e.getMessage());
                                    BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                                }
                            }
                        });
                    } else {
                        Platform.runLater(() -> {
                            if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                BatchSTPLodgeController.this.batchStatus.setGlenixElementValue(originalStatus);
                            }
                        });
                    }
                    String atoTimestamp = glenixSBRResponse.getTimestamp();
                    batch.setBatchATOLodgeTimestamp(atoTimestamp);
                    String atoMessageIdentifier = glenixSBRResponse.getMessageId();
                    batch.setBatchATOLodgeMessageIdentifier(atoMessageIdentifier);
                    Platform.runLater(() -> {
                        try {
                            xbrlFileController.saveBatches();
                            if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                BatchSTPLodgeController.this.batchATOLodgeTimestamp.setGlenixElementValue(atoTimestamp);
                                BatchSTPLodgeController.this.batchATOLodgeMessageIdentifier.setGlenixElementValue(atoMessageIdentifier);
                                Document reloadDoc = batchTransaction.buildDocument();
                                BatchSTPLodgeController.this.loadGlenixXBRL(reloadDoc, reloadDoc.getDocumentElement());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            BatchSTPLodgeController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                        xbrlFileController.setStatusBarMessage("STP lodge complete - you need to retrieve error messages to see if lodge was successful...");
                    });
                    int sleep_one = 60000;
                    if (record_count > 1000) {
                        sleep_one = 3600000;
                    } else if (record_count > 200) {
                        sleep_one = 600000;
                    } else if (record_count > 100) {
                        sleep_one = 120000;
                    }
                    int sleep_one_final = sleep_one;
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP send complete - waiting " + sleep_one_final / 1000 + " seconds then retrieving messages..."));
                    Thread.sleep(sleep_one);
                    String status = batchTransaction.getBatchStatus();
                    if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                        Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP send complete - retrieving messages..."));
                        BatchSTPLodgeController.this.pullMessages(batchTransaction, credentialId, password);
                        status = batchTransaction.getBatchStatus();
                        if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                            int sleep_two = 60000;
                            if (record_count > 1000) {
                                sleep_two = 1800000;
                            } else if (record_count > 200) {
                                sleep_two = 600000;
                            } else if (record_count > 100) {
                                sleep_two = 120000;
                            }
                            int sleep_two_final = sleep_two;
                            Platform.runLater(() -> xbrlFileController.appendStatusBarMessage("...waiting a further " + sleep_two_final / 1000 + " seconds then retrieving messages..."));
                            Thread.sleep(sleep_two);
                            status = batchTransaction.getBatchStatus();
                            if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                                Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP send complete - retrieving messages..."));
                                BatchSTPLodgeController.this.pullMessages(batchTransaction, credentialId, password);
                                status = batchTransaction.getBatchStatus();
                                if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                                    int sleep_three = 300000;
                                    if (record_count > 1000) {
                                        sleep_three = 3600000;
                                    } else if (record_count > 200) {
                                        sleep_three = 1200000;
                                    } else if (record_count > 100) {
                                        sleep_three = 600000;
                                    }
                                    int sleep_three_final = sleep_three;
                                    Platform.runLater(() -> xbrlFileController.appendStatusBarMessage("...waiting a further " + sleep_three_final / 60000 + " minutes then retrieving messages..."));
                                    Thread.sleep(sleep_three);
                                    status = batchTransaction.getBatchStatus();
                                    if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                                        Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP send complete - retrieving messages..."));
                                        BatchSTPLodgeController.this.pullMessages(batchTransaction, credentialId, password);
                                        status = batchTransaction.getBatchStatus();
                                        if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                                            int sleep_four = 300000;
                                            if (record_count > 1000) {
                                                sleep_four = 3600000;
                                            } else if (record_count > 200) {
                                                sleep_four = 1200000;
                                            } else if (record_count > 100) {
                                                sleep_four = 600000;
                                            }
                                            int sleep_four_final = sleep_four;
                                            Platform.runLater(() -> xbrlFileController.appendStatusBarMessage("...waiting a further " + sleep_four_final / 60000 + " minutes then retrieving messages..."));
                                            Thread.sleep(sleep_four);
                                            status = batchTransaction.getBatchStatus();
                                            if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                                                Platform.runLater(() -> xbrlFileController.setStatusBarMessage("STP send complete - retrieving messages..."));
                                                BatchSTPLodgeController.this.pullMessages(batchTransaction, credentialId, password);
                                                status = batchTransaction.getBatchStatus();
                                                if (status != null && (status.equals("sent") || status.equals("authorised_sent"))) {
                                                    Platform.runLater(() -> xbrlFileController.appendStatusBarMessage("...cannot retrieve messages after 4 attempts giving up. You will have to manually retrieve messages."));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        BatchSTPLodgeController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                }
                finally {
                    xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                }
            }
        }).start();
    }

    public void loadGlenixDefaults() throws Exception {
        if (this.ausKeyCombo != null) {
            List<GlenixElement> al = this.xbrlFileController.getAUSKeyCredentialList();
            ObservableList ol = FXCollections.observableArrayList(al);
            this.ausKeyCombo.setItems((ObservableList<GlenixElement>)ol);
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        String status = this.batchTransaction.getBatchStatus();
        if (status == null || status.isEmpty() || status.equals("created")) {
            this.StatementAcceptedI.setGlenixElementValue(null);
            if (businessMasterFile == null) {
                this.AustralianBusinessNumberId.setText(null);
                this.WithholdingPayerNumberId.setText(null);
                this.OrganisationDetailsOrganisationBranchC.setText(null);
                this.DetailsOrganisationalNameT.setText(null);
                this.Line1T.setText(null);
                this.Line2T.setText(null);
                this.LocalityNameT.setText(null);
                this.StateOrTerritoryC.setText(null);
                this.PostcodeT.setText(null);
                this.CountryC.setGlenixElementValue(null);
                this.PersonUnstructuredNameFullNameT.setText(null);
                this.TelephoneMinimalN.setText(null);
                this.ElectronicMailAddressT.setText(null);
                this.SoftwareInformationBusinessManagementSystemId.setText(null);
            } else {
                this.AustralianBusinessNumberId.setText(businessMasterFile.getBusinessABN());
                String wpn = businessMasterFile.getBusinessWPN();
                if (wpn != null && !wpn.isEmpty()) {
                    this.WithholdingPayerNumberId.setText("00" + wpn);
                } else {
                    this.WithholdingPayerNumberId.setText(null);
                }
                this.OrganisationDetailsOrganisationBranchC.setText(businessMasterFile.getBusinessABNBranch());
                this.DetailsOrganisationalNameT.setText(businessMasterFile.getBusinessLegalName());
                this.SoftwareInformationBusinessManagementSystemId.setText(businessMasterFile.getSoftwareInformationBusinessManagementSystemId());
                TFND0004AddressDetailsBusiness addr = businessMasterFile.getBusinessPostalAddress();
                if (addr != null) {
                    this.Line1T.setText(addr.getLine1T());
                    this.Line2T.setText(addr.getLine2T());
                    this.LocalityNameT.setText(addr.getLocalityNameT());
                    this.StateOrTerritoryC.setText(addr.getStateOrTerritoryC());
                    this.PostcodeT.setText(addr.getPostcodeT());
                    this.CountryC.setGlenixElementValue(addr.getCountryC());
                } else {
                    this.Line1T.setText(null);
                    this.Line2T.setText(null);
                    this.LocalityNameT.setText(null);
                    this.StateOrTerritoryC.setText(null);
                    this.PostcodeT.setText(null);
                    this.CountryC.setGlenixElementValue(null);
                }
                ElectronicContact ec = businessMasterFile.getBusinessElectronicContact();
                if (ec != null) {
                    this.PersonUnstructuredNameFullNameT.setText(ec.getPersonUnstructuredNameFullNameT());
                    String areaCode = ec.getTelephoneAreaC();
                    if (areaCode != null) {
                        this.TelephoneMinimalN.setText(areaCode + ec.getTelephoneMinimalN());
                    } else {
                        this.TelephoneMinimalN.setText(ec.getTelephoneMinimalN());
                    }
                    this.ElectronicMailAddressT.setText(ec.getElectronicMailAddressT());
                } else {
                    this.PersonUnstructuredNameFullNameT.setText(null);
                    this.TelephoneMinimalN.setText(null);
                    this.ElectronicMailAddressT.setText(null);
                }
            }
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        String status = this.batchTransaction.getBatchStatus();
        boolean displayAgentDeclaration = false;
        if (status == null || status.isEmpty() || status.equals("created")) {
            AgentDetails agentDetails = null;
            if (profileXBRL != null) {
                agentDetails = profileXBRL.getAgentDetails();
            }
            String agentABN = null;
            if (agentDetails != null) {
                agentABN = agentDetails.getAgentABN();
            }
            this.agentStatementAcceptedI.setGlenixElementValue(null);
            if (agentDetails == null || agentABN == null || agentABN.isEmpty()) {
                this.agentAustralianBusinessNumberId.setText(null);
                this.TaxAgentNumberId.setText(null);
                this.agentPersonUnstructuredNameFullNameT.setText(null);
                this.agentTelephoneMinimalN.setText(null);
                this.agentElectronicMailAddressT.setText(null);
                this.intermediarysection.setVisible(false);
                this.intermediarysection.setManaged(false);
                this.agentStatementAcceptedI.setGlenixElementValue(null);
                this.agentSignatureD.setGlenixElementValue(null);
                this.agentSignatoryIdentifierT.setGlenixElementValue(null);
            } else {
                if (agentABN == null || agentABN.isEmpty()) {
                    this.agentAustralianBusinessNumberId.setText(null);
                    this.agentSignatureD.setGlenixElementValue(null);
                } else {
                    this.agentAustralianBusinessNumberId.setText(agentDetails.getAgentABN());
                }
                String tan = agentDetails.getAgentNumber();
                if (tan == null || tan.isEmpty()) {
                    this.TaxAgentNumberId.setText(null);
                } else {
                    this.TaxAgentNumberId.setText(agentDetails.getAgentNumber());
                }
                ProfileElectronicContact ec = agentDetails.getAgentElectronicContact();
                if (ec != null) {
                    String name = ec.getPersonUnstructuredNameFullNameT();
                    if (name == null || name.isEmpty()) {
                        this.agentPersonUnstructuredNameFullNameT.setText(null);
                    } else {
                        this.agentPersonUnstructuredNameFullNameT.setText(name);
                    }
                    String areaCode = ec.getTelephoneAreaC();
                    String phone = ec.getTelephoneMinimalN();
                    if (areaCode != null && !areaCode.isEmpty()) {
                        phone = areaCode + phone;
                    }
                    if (phone == null || phone.isEmpty()) {
                        this.agentTelephoneMinimalN.setText(null);
                    } else {
                        this.agentTelephoneMinimalN.setText(phone);
                    }
                    String email = ec.getElectronicMailAddressT();
                    if (email == null || email.isEmpty()) {
                        this.agentElectronicMailAddressT.setText(null);
                    } else {
                        this.agentElectronicMailAddressT.setText(email);
                    }
                } else {
                    this.agentPersonUnstructuredNameFullNameT.setText(null);
                    this.agentTelephoneMinimalN.setText(null);
                    this.agentElectronicMailAddressT.setText(null);
                }
                displayAgentDeclaration = true;
            }
        } else {
            String agentABN;
            Batch b = this.batchTransaction.getBatch();
            if (b != null && (agentABN = b.getIntAustralianBusinessNumberId()) != null && !agentABN.isEmpty()) {
                displayAgentDeclaration = true;
            }
        }
        if (displayAgentDeclaration) {
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
            StringBuilder sb = new StringBuilder();
            sb.append("Declaration received from client:\n");
            sb.append("I, (name of business client) authorise (name of agent) to give the payroll report for <period> to the Commissioner of Taxation for (entity name). ");
            sb.append("I declare that the information provided for the preparation of this payroll report is true and correct. I am authorised to make this declaration.\n");
            sb.append("Signed: _____________________ Date: ___________\n");
            sb.append("Your client is required to retain the declaration (or a copy) for up to five years, depending on their circumstances.");
            this.rp_declaration_text.setText(sb.toString());
            this.StatementAcceptedI.setGlenixElementDescription("Tick this box if the client has signed the declaration.");
        } else {
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
            this.rp_declaration_text.setText("I declare the information transmitted in this payroll report is true and correct and I am authorised to make this declaration.");
            this.StatementAcceptedI.setGlenixElementDescription("Tick this box to sign this declaration with your full name entered below and your AUSkey selected below.");
        }
    }

    @FXML
    protected void pullMessages() {
        try {
            Batch batch = this.batchTransaction.getBatch();
            if (batch == null) {
                throw new Exception("Error, batch is null cannot pull messages.");
            }
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            batch.setCertAlias(credentialId);
            String passwordString = this.password.getText();
            this.password.setText(null);
            this.pullMessages(this.batchTransaction, credentialId, passwordString);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void pullMessages(final Transaction batchTransaction, final String credentialId, final String password) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Platform.runLater(() -> BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("STP begin retrieve messages..."));
                    Batch batch = batchTransaction.getBatch();
                    String batchIdentifier = batch.getBatchIdentifier();
                    if (batchIdentifier == null) {
                        throw new Exception("Error, batch identifier not set. Must save before message retrival.");
                    }
                    String originalStatus = batch.getBatchStatus();
                    if (originalStatus == null || !originalStatus.equals("sent") && !originalStatus.equals("authorised_sent")) {
                        throw new Exception("Error, batch is not sent. You need to send it to the ATO before retrieving messages.");
                    }
                    if (originalStatus.equals("sent")) {
                        batch.setBatchStatus("retrieving");
                    } else if (originalStatus.equals("authorised_sent")) {
                        batch.setBatchStatus("authorised_retrieving");
                    }
                    BatchSTPLodgeController.this.xbrlFileController.loadAUSKeyCredential(credentialId);
                    BatchSTPLodgeController.this.xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                    BatchSTPLodgeController.this.xbrlFileController.extractAUSKeyCredentialX509Certificate();
                    Platform.runLater(() -> BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("Retrieve messages - signing request to ATO"));
                    Node encryptedDataNode = BatchSTPLodgeController.this.xbrlFileController.buildAndSendSTSDocument();
                    String refToMessageId = batch.getBatchMessageIdentifier();
                    batch.generateBatchPullMessageIdentifier();
                    String messageId = batch.getBatchPullMessageIdentifier();
                    batch.setBatchPullMessagesTimestamp();
                    String timestamp = batch.getBatchPullMessagesTimestamp();
                    Platform.runLater(() -> {
                        if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                            BatchSTPLodgeController.this.batchPullMessageIdentifier.setGlenixElementValue(messageId);
                            BatchSTPLodgeController.this.batchPullMessagesTimestamp.setGlenixElementValue(timestamp);
                        }
                        BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("Retrieve messages - sending request to ATO");
                    });
                    String logFileName = "STP_" + batchIdentifier + "_pull.log";
                    GlenixSBRResponse glenixSBRResponse = BatchSTPLodgeController.this.xbrlFileController.buildAndSendPullDocument(encryptedDataNode, refToMessageId, messageId, timestamp, logFileName);
                    glenixSBRResponse.parseResponse();
                    Platform.runLater(() -> BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("Retrieve messages - reading response from ATO"));
                    boolean gotResult = false;
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        String documentName;
                        String href = glenixSBRResponse.nextPartHref();
                        if (href == null || (documentName = glenixSBRResponse.getPartProperty(href, "DocumentName")) == null || !documentName.equals("PAYEVNT")) continue;
                        String unzippedLogFileName = "STP_" + batchIdentifier + "_pull_payevnt_unzipped.log";
                        InputStream is = glenixSBRResponse.getInputStreamByHref(href);
                        BatchSTPLodgeController.this.xbrlFileController.logInputStream(is, unzippedLogFileName);
                        InputStream ismulti = glenixSBRResponse.getInputStreamByHref(href);
                        GlenixMultiInputStreamEventDelimited gmised = new GlenixMultiInputStreamEventDelimited(ismulti, -1, "Anything");
                        int count = 0;
                        String delimDocumentName = null;
                        String delimDocumentId = null;
                        String delimDocumentType = null;
                        String delimRelatedDocumentId = null;
                        while (!gmised.isClosed() || gmised.available() > 0) {
                            Document doc = BatchSTPLodgeController.this.dBuilder.parse(gmised);
                            if (++count == 1) {
                                batch.loadSBROverallEventMessageDocument(doc, doc.getDocumentElement());
                            } else if (count % 2 == 0) {
                                Element el = doc.getDocumentElement();
                                if (el != null) {
                                    delimDocumentName = el.getAttribute("DocumentName");
                                    delimDocumentId = el.getAttribute("DocumentID");
                                    delimDocumentType = el.getAttribute("DocumentType");
                                    delimRelatedDocumentId = el.getAttribute("RelatedDocumentID=");
                                } else {
                                    delimDocumentName = null;
                                    delimDocumentId = null;
                                    delimDocumentType = null;
                                    delimRelatedDocumentId = null;
                                }
                            } else if (delimDocumentType != null && delimDocumentType.equals("PARENT") && delimDocumentName != null && delimDocumentName.equals("PAYEVNT")) {
                                batch.loadSBRBusinessEventMessageDocument(doc, doc.getDocumentElement());
                                gotResult = true;
                            }
                            gmised.nextBoundary();
                        }
                    }
                    if (gotResult) {
                        String maxCode = batch.getOverallEventItems().getMaximumSeverityCode();
                        if (maxCode != null && maxCode.equals("Information")) {
                            batch.setBatchStatus("lodge_complete");
                            Platform.runLater(() -> {
                                BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("Retrieve messages - response received from ATO. OK response but check if any messages anyway.");
                                BatchSTPLodgeController.this.batchStatus.setGlenixElementValue("lodge_complete");
                            });
                        } else {
                            if (originalStatus.equals("sent")) {
                                batch.setBatchStatus("created");
                            } else if (originalStatus.equals("authorised_sent")) {
                                batch.setBatchStatus("authorised");
                            }
                            Platform.runLater(() -> {
                                BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("Retrieve messages - response received from ATO. There was an error check messages.");
                                if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                    if (originalStatus.equals("sent")) {
                                        BatchSTPLodgeController.this.batchStatus.setGlenixElementValue("created");
                                    } else if (originalStatus.equals("authorised_sent")) {
                                        BatchSTPLodgeController.this.batchStatus.setGlenixElementValue("authorised");
                                    }
                                }
                            });
                        }
                        String atoMessageIdentifier = glenixSBRResponse.getMessageId();
                        String atoMessageTimestamp = glenixSBRResponse.getTimestamp();
                        Platform.runLater(() -> {
                            try {
                                BatchSTPLodgeController.this.xbrlFileController.saveBatches();
                                if (BatchSTPLodgeController.this.batchTransaction != null && BatchSTPLodgeController.this.batchTransaction == batchTransaction) {
                                    BatchSTPLodgeController.this.batchATOPullMessagesMessageIdentifier.setGlenixElementValue(atoMessageIdentifier);
                                    BatchSTPLodgeController.this.batchATOPullMessagesTimestamp.setGlenixElementValue(atoMessageTimestamp);
                                    Document reloadDoc = batchTransaction.buildDocument();
                                    BatchSTPLodgeController.this.loadGlenixXBRL(reloadDoc, reloadDoc.getDocumentElement());
                                    BatchSTPLodgeController.this.setBatchTransactionElement(batchTransaction);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                BatchSTPLodgeController.this.error_message.setText(e.getMessage());
                                BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                            }
                        });
                    } else {
                        batch.setBatchStatus(originalStatus);
                        Platform.runLater(() -> {
                            if (glenixSBRResponse.getSignalMessageErrorSize() > 0) {
                                BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage("Error, get messages failed. SBR response: " + glenixSBRResponse.getSignalMessageDescription(0));
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Platform.runLater(() -> {
                        e.printStackTrace();
                        BatchSTPLodgeController.this.error_message.setText(e.getMessage());
                        BatchSTPLodgeController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                }
                finally {
                    BatchSTPLodgeController.this.xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                }
            }
        }).start();
    }
}

