/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchEditController
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    @FXML
    private Label page_heading;
    @FXML
    private Label error_message;
    @FXML
    private Button saveBatchTransactionButton;
    @FXML
    private Button clearBatchTransactionButton;
    private Transaction batchTransaction = null;
    private ApplicationController xbrlFileController;

    public BatchEditController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        super.buildGlenixXBRL(resultDoc, transactionEl);
    }

    public void buildGlenixXBRLTransaction(Document resultDoc, Element resultElement) throws Exception {
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        if (resultElement == null) {
            resultDoc.appendChild(transactionEl);
        } else {
            resultElement.appendChild(transactionEl);
        }
        super.buildGlenixXBRL(resultDoc, transactionEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1) continue;
                        Element el = (Element)node3;
                        super.loadGlenixXBRL(loadDoc, el);
                    }
                }
            }
        }
    }

    public void setBatchTransactionElement(Transaction batchTransaction) {
        this.batchTransaction = batchTransaction;
        Batch batch = null;
        if (batchTransaction != null) {
            batch = batchTransaction.getBatch();
        }
        if (batch == null) {
            this.page_heading.setText("Batch edit - " + this.xbrlFileController.getBusinessLegalName());
        } else {
            String comment = batch.getBatchComment();
            if (comment == null || comment.isEmpty()) {
                this.page_heading.setText("Batch edit - " + this.xbrlFileController.getBusinessLegalName());
            } else {
                this.page_heading.setText("Batch edit - " + comment + " - " + this.xbrlFileController.getBusinessLegalName());
            }
        }
    }

    @FXML
    public void gotoBatchSTPLodge() {
        try {
            this.xbrlFileController.gotoBatchSTPLodge(this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch STP lodge page.");
        }
    }

    @FXML
    private void saveBatchTransaction() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            this.buildGlenixXBRLTransaction(resultDoc, null);
            if (this.batchTransaction == null) {
                this.batchTransaction = this.xbrlFileController.addBatchTransaction();
            }
            this.batchTransaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            this.xbrlFileController.saveBatch(this.batchTransaction);
            this.error_message.setText("Saved");
            Document reloadDoc = this.batchTransaction.buildDocument();
            this.loadGlenixXBRL(reloadDoc, reloadDoc.getDocumentElement());
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void clearBatchTransaction() {
        this.clearGlenixXBRL();
        this.error_message.setText("New batch");
    }

    @FXML
    private void gotoBatchList() {
        try {
            this.xbrlFileController.gotoBatches();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch list page.");
        }
    }

    @FXML
    private void gotoBatchTransactions() {
        try {
            this.xbrlFileController.gotoBatchTransactions(this.batchTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load batch list page.");
        }
    }
}

