/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.AccountEditVBox;
import au.com.glenix.AccountListVBox;
import au.com.glenix.ActivityStatementListVBox;
import au.com.glenix.ActivityStatementVBox;
import au.com.glenix.BatchEditVBox;
import au.com.glenix.BatchSTPLodgeVBox;
import au.com.glenix.BatchTableVBox;
import au.com.glenix.BatchTransactionsTableVBox;
import au.com.glenix.BusinessMasterFileVBox;
import au.com.glenix.BusinessMessageEditTitledPane;
import au.com.glenix.BusinessMessageListVBox;
import au.com.glenix.ChangePasswordVBox;
import au.com.glenix.ConfigPageVBox;
import au.com.glenix.CounterpartyEditVBox;
import au.com.glenix.CounterpartyPayrollDetailsEditVBox;
import au.com.glenix.CounterpartySuperDetailsEditVBox;
import au.com.glenix.CounterpartyTFNDListVBox;
import au.com.glenix.CounterpartyTFNDVBox;
import au.com.glenix.CounterpartyVBox;
import au.com.glenix.DocumentLayoutVBox;
import au.com.glenix.EditProfileVBox;
import au.com.glenix.EmployeeListVBox;
import au.com.glenix.FileAccessAddCertificateVBox;
import au.com.glenix.FileAccessVBox;
import au.com.glenix.FileAccessViewCertificateVBox;
import au.com.glenix.FuelTaxCreditEditVBox;
import au.com.glenix.FuelTaxCreditListVBox;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixApplication;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixFileImagesVBox;
import au.com.glenix.GlenixFileListVBox;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.HomeOfficeEditVBox;
import au.com.glenix.HomeOfficeListVBox;
import au.com.glenix.ImportDataEditVBox;
import au.com.glenix.ImportDataImportFileFieldSelectVBox;
import au.com.glenix.ImportDataImportFileVBox;
import au.com.glenix.ImportDataListVBox;
import au.com.glenix.ImportDataVBox;
import au.com.glenix.IncomeAndExpenditureAccountDetailVBox;
import au.com.glenix.IncomeAndExpenditureProvisionDetailVBox;
import au.com.glenix.IncomeAndExpenditureVBox;
import au.com.glenix.InstallVBox;
import au.com.glenix.LargeOrderFormVBox;
import au.com.glenix.LibrariesLicenseTermsVBox;
import au.com.glenix.LicenseTermsVBox;
import au.com.glenix.LinkV2VBox;
import au.com.glenix.MessageDetails;
import au.com.glenix.NewFileVBox;
import au.com.glenix.NewProfileVBox;
import au.com.glenix.OpenProfileVBox;
import au.com.glenix.OutgoingMailServerVBox;
import au.com.glenix.PaySlipEditVBox;
import au.com.glenix.PostUnlockVBox;
import au.com.glenix.ProvisionEditVBox;
import au.com.glenix.ProvisionListVBox;
import au.com.glenix.ReceiveFilesVBox;
import au.com.glenix.SBREndUserAgreementVBox;
import au.com.glenix.SBRPrivacyStatementVBox;
import au.com.glenix.SuperProductDetailsEditVBox;
import au.com.glenix.SuperProductDetailsListVBox;
import au.com.glenix.SupportOrderFormVBox;
import au.com.glenix.TaxAgentOrderFormVBox;
import au.com.glenix.TaxReturnListVBox;
import au.com.glenix.TaxReturnTaxReturnVBox;
import au.com.glenix.TaxServicesOrderFormVBox;
import au.com.glenix.TransactionEditVBox;
import au.com.glenix.TransactionsTableASVBox;
import au.com.glenix.TransactionsTableFuelTaxCreditVBox;
import au.com.glenix.TransactionsTableHomeOfficeVBox;
import au.com.glenix.TransactionsTableImportDataVBox;
import au.com.glenix.TransactionsTableOtherPurchasesVBox;
import au.com.glenix.TransactionsTablePaySlipsVBox;
import au.com.glenix.TransactionsTableSalesVBox;
import au.com.glenix.TransactionsTableVBox;
import au.com.glenix.TrashTransactionTableVBox;
import au.com.glenix.VerifyFASIdentityVBox;
import au.com.glenix.ViewProfileCertificateVBox;
import au.com.glenix.WelcomePageVBox;
import au.com.glenix.trn.ASLStatement;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.ActivityStatementList;
import au.com.glenix.trn.ActivityStatementListResponse;
import au.com.glenix.trn.Address;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.BusinessIssue;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.BusinessMessage;
import au.com.glenix.trn.CGLS0006;
import au.com.glenix.trn.CGNFT0002;
import au.com.glenix.trn.CGTS0006;
import au.com.glenix.trn.CTR0009;
import au.com.glenix.trn.CTR0010;
import au.com.glenix.trn.CalculationRule;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.DDCTNS0001;
import au.com.glenix.trn.DIDS0002;
import au.com.glenix.trn.DIS0003;
import au.com.glenix.trn.DocumentLayout;
import au.com.glenix.trn.ElectronicContact;
import au.com.glenix.trn.FTER0002;
import au.com.glenix.trn.FuelTaxCredit;
import au.com.glenix.trn.GlenixCertificate;
import au.com.glenix.trn.GlenixCertificateList;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.HomeOffice;
import au.com.glenix.trn.IDS0006;
import au.com.glenix.trn.IDS0007;
import au.com.glenix.trn.IEE0003;
import au.com.glenix.trn.IITR0005;
import au.com.glenix.trn.IITR0006;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.LS0006;
import au.com.glenix.trn.LayoutImage;
import au.com.glenix.trn.NRFI0002;
import au.com.glenix.trn.PEE0003Allowance;
import au.com.glenix.trn.PEE0003Deduction;
import au.com.glenix.trn.PEE0003EmploymentTerminationPayment;
import au.com.glenix.trn.PEE0003IncomeFringeBenefitsReportable;
import au.com.glenix.trn.PEE0003IndividualNonBusiness;
import au.com.glenix.trn.PEE0003JointPetroleumDevelopmentAreaPayment;
import au.com.glenix.trn.PEE0003LabourHireArrangementPayment;
import au.com.glenix.trn.PEE0003Payee;
import au.com.glenix.trn.PEE0003RemunerationPAYGW;
import au.com.glenix.trn.PEE0003SpecifiedByRegulationPayment;
import au.com.glenix.trn.PEE0003SuperannuationContribution;
import au.com.glenix.trn.PEE0003UnusedAnnualOrLongServiceLeavePayment;
import au.com.glenix.trn.PEE0003VoluntaryAgreement;
import au.com.glenix.trn.PEE0003WorkingHolidayMaker;
import au.com.glenix.trn.PSS0002;
import au.com.glenix.trn.PTR0007;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.RDTIS0003;
import au.com.glenix.trn.RPTTAXPOS0001;
import au.com.glenix.trn.RS0002;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.trn.SMSF0008;
import au.com.glenix.trn.SMSF0009;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.trn.TRT0007;
import au.com.glenix.trn.TaxReturn;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.trn.TransactionPaySlipDetail;
import au.com.glenix.trn.WRE0003;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPane;
import com.opencsv.CSVReader;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.transform.Scale;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationController
extends GlenixBranchController {
    protected String glenix_versionNumber = "3.0.17";
    protected String glenix_productName = "www.freeaccountingsoftware.com.au";
    protected String glenix_versionNumberSBR = "3.0";
    protected String glenix_softwareNameSBR = "www.freeaccountingsoftware.com.au";
    protected String glenix_companyNameSBR = "Free Accounting Pty Ltd";
    protected String glenix_csrEmailDomain = "freeaccountingsoftware.com.au";
    protected String glenix_messageDomain = "freeaccountingsoftware.com.au";
    protected String glenix_dspABN = "38111951645";
    protected String glenix_dspIdentifierType = "http://abr.gov.au/PartyIdType/ABN";
    protected String glenix_dspRole = "DigitalServiceProvider";
    protected String glenix_soap_service_register_profile = "http://www.freeaccountingsoftware.com.au/soap/register_profile";
    protected String glenix_soap_service_usage = "http://www.freeaccountingsoftware.com.au/soap/usage";
    protected String glenix_soap_service_version = "http://www.freeaccountingsoftware.com.au/soap/version";
    protected String glenix_soap_service_certificate = "http://www.freeaccountingsoftware.com.au/soap/certificate";
    protected String glenix_soap_action_submit = "Submit";
    protected String glenix_soap_action_get = "Get";
    protected String glenix_soap_legal_name_identifier = "Legal name";
    protected String glenix_soap_user_role_identifier = "User";
    protected String glenix_productIDSBR = "130486";
    public String glenix_STSURL = "https://authentication.business.gov.au/R3.0/vanguard/S007v1.2/service.svc";
    public String glenix_STSURLHOST = "authentication.business.gov.au";
    protected String glenix_STSEndpointRef = "https://ato.sbr.gov.au/services";
    protected String glenix_SingleSyncURL = "https://prod2.ato.sbr.gov.au/services/Single-sync";
    protected String glenix_BatchAsyncPushURL = "https://prod2.ato.sbr.gov.au/services/BulkBatch-async-push";
    protected String glenix_BatchAsyncPullURL = "https://prod2.ato.sbr.gov.au/services/BulkBatch-async-pull";
    protected String glenix_fasSoapURL = "https://v3.freeaccountingsoftware.com.au/soap";
    protected String glenix_fas3DesktopDownloadURL = "https://www.freeaccountingsoftware.com.au/FAS3Desktop.jar";
    protected String glenix_codeName = "FAS3 Desktop";
    protected NewFileVBox newFileVBox = null;
    protected BusinessMasterFileVBox businessMasterFileVBox = null;
    protected DocumentLayoutVBox documentLayoutVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLBusinessMasterFile = null;
    protected TaxReturnListVBox taxReturnListVBox = null;
    protected IncomeAndExpenditureVBox incomeAndExpenditureVBox = null;
    protected IncomeAndExpenditureAccountDetailVBox incomeAndExpenditureAccountDetailVBox = null;
    protected IncomeAndExpenditureProvisionDetailVBox incomeAndExpenditureProvisionDetailVBox = null;
    protected ActivityStatementListVBox activityStatementListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLActivityStatementList = null;
    protected HashMap<String, ActivityStatementVBox> activityStatementVBoxHashMap = new HashMap();
    protected HashMap<String, GlenixTrnXBRL> glenixTrnXBRLActivityStatementHashMap = new HashMap();
    protected HashMap<String, ActivityStatement> activityStatementHashMap = new HashMap();
    protected CounterpartyVBox counterpartyVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLCounterparty = null;
    protected CounterpartyEditVBox counterpartyEditVBox = null;
    protected CounterpartyTFNDVBox counterpartyTFNDVBox = null;
    protected CounterpartyTFNDListVBox counterpartyTFNDListVBox = null;
    protected CounterpartyPayrollDetailsEditVBox counterpartyPayrollDetailsEditVBox = null;
    protected CounterpartySuperDetailsEditVBox counterpartySuperDetailsEditVBox = null;
    protected SuperProductDetailsListVBox superProductDetailsListVBox = null;
    protected SuperProductDetailsEditVBox superProductDetailsEditVBox = null;
    protected EmployeeListVBox employeeListVBox = null;
    protected ProvisionListVBox provisionListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLProvision = null;
    protected ProvisionEditVBox provisionEditVBox = null;
    protected AccountListVBox accountListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLAccount = null;
    protected AccountEditVBox accountEditVBox = null;
    protected HomeOfficeListVBox homeOfficeListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLHomeOffice = null;
    protected HomeOfficeEditVBox homeOfficeEditVBox = null;
    protected FuelTaxCreditListVBox fuelTaxCreditListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLFuelTaxCredit = null;
    protected FuelTaxCreditEditVBox fuelTaxCreditEditVBox = null;
    protected ImportDataListVBox importDataListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLImportData = null;
    protected ImportDataEditVBox importDataEditVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLBusinessIssue = null;
    protected BusinessMessageListVBox businessMessageListVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLBusinessMessage = null;
    protected BusinessMessageEditTitledPane businessMessageEditVBox = null;
    protected TransactionsTableVBox transactionsTableVBox = null;
    protected TransactionsTableSalesVBox transactionsTableSalesVBox = null;
    protected TransactionsTableASVBox transactionsTableASVBox = null;
    protected TransactionsTableOtherPurchasesVBox transactionsTableOtherPurchasesVBox = null;
    protected TransactionsTableHomeOfficeVBox transactionsTableHomeOfficeVBox = null;
    protected TransactionsTableFuelTaxCreditVBox transactionsTableFuelTaxCreditVBox = null;
    protected TransactionsTableImportDataVBox transactionsTableImportDataVBox = null;
    protected TransactionsTablePaySlipsVBox transactionsTablePaySlipsVBox = null;
    protected TrashTransactionTableVBox trashTransactionTableVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLTransactions = null;
    protected TransactionEditVBox transactionEditVBox = null;
    protected NewProfileVBox newProfileVBox;
    protected ChangePasswordVBox changePasswordVBox;
    protected LinkV2VBox linkV2VBox = null;
    protected OutgoingMailServerVBox outgoingMailServerVBox;
    protected ViewProfileCertificateVBox viewProfileCertificateVBox;
    protected VerifyFASIdentityVBox verifyFASIdentityVBox;
    protected FileAccessVBox fileAccessVBox;
    protected FileAccessAddCertificateVBox fileAccessAddCertificateVBox;
    protected FileAccessViewCertificateVBox fileAccessViewCertificateVBox;
    protected ImportDataVBox importDataVBox;
    protected ImportDataImportFileVBox importDataImportFileVBox = null;
    protected ImportDataImportFileFieldSelectVBox importDataImportFileFieldSelectVBox = null;
    protected WelcomePageVBox welcomePageVBox;
    protected GlenixTrnXBRL glenixTrnXBRLFileAccess = null;
    protected PaySlipEditVBox paySlipEditVBox = null;
    protected BatchTransactionsTableVBox batchTransactionsTableVBox = null;
    protected BatchTableVBox batchTableVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLBatches = null;
    protected BatchEditVBox batchEditVBox = null;
    protected BatchSTPLodgeVBox batchSTPLodgeVBox = null;
    protected GlenixTrnXBRL glenixTrnXBRLTaxReturn = null;
    protected TaxReturnTaxReturnVBox taxReturnTaxReturnVBox = null;
    protected GlenixFileListVBox fileListVBox = null;
    protected GlenixFileImagesVBox fileImagesVBox = null;
    protected ConfigPageVBox configPageVBox = null;
    protected DocumentBuilderFactory docFactory;
    protected DocumentBuilder docBuilder;
    protected String dataSource = null;
    protected Profile profileXBRL = null;
    protected Profile outgoingMailServerXBRL = null;
    protected OpenProfileVBox openProfileVBox = null;
    protected PostUnlockVBox postUnlockVBox = null;
    protected InstallVBox installVBox = null;
    protected PostUnlockVBox versionCheckVBox = null;
    protected EditProfileVBox editProfileVBox = null;
    protected TaxAgentOrderFormVBox taxAgentOrderFormVBox = null;
    protected ReceiveFilesVBox receiveFilesVBox = null;
    protected TaxServicesOrderFormVBox taxServicesOrderFormVBox = null;
    protected LargeOrderFormVBox largeOrderFormVBox = null;
    protected SupportOrderFormVBox supportOrderFormVBox = null;
    protected LicenseTermsVBox licenseTermsVBox = null;
    protected LibrariesLicenseTermsVBox librariesLicenseTermsVBox = null;
    protected SBRPrivacyStatementVBox sbrPrivacyStatementVBox = null;
    protected SBREndUserAgreementVBox sbrEndUserAgreementVBox = null;
    protected GlenixFile profileFile = null;
    protected GlenixAUSKey glenixKey = null;
    protected GlenixFile glenixFile = null;
    protected Stage stage;
    protected GlenixAUSKey glenixAUSKey = null;
    protected Transformer transformer;
    protected Image asterixIcon;
    protected ImageView asterixView;
    protected Image asterixIcon2;
    protected ImageView asterixView2;
    @FXML
    protected VBox file_content_display;
    @FXML
    protected Label status_bar_label;
    @FXML
    protected ScrollPane main_content_scroll_pane;
    @FXML
    protected Menu supportMenu;
    @FXML
    protected MenuItem gotoChangePasswordMenuItem;
    @FXML
    protected MenuItem gotoLinkV2MenuItem;
    @FXML
    protected MenuItem gotoOpenFileMenuItem;
    @FXML
    protected MenuItem gotoNewFileMenuItem;
    @FXML
    protected MenuItem saveFileAsMenuItem;
    @FXML
    protected MenuItem pdfCurrentPageMenuItem;
    @FXML
    protected MenuItem gotoSalesTransactionsMenuItem;
    @FXML
    protected MenuItem gotoOtherPurchasesTransactionsMenuItem;
    @FXML
    protected MenuItem gotoBatchesMenuItem;
    @FXML
    protected MenuItem gotoPaySlipsTransactionsMenuItem;
    @FXML
    protected MenuItem gotoTrashTransactionsMenuItem;
    @FXML
    protected MenuItem gotoActivityStatementListMenuItem;
    @FXML
    protected MenuItem gotoTaxReturnListMenuItem;
    @FXML
    protected MenuItem gotoCounterpartyListMenuItem;
    @FXML
    protected MenuItem gotoBusinessMessageListMenuItem;
    @FXML
    protected Menu reports;
    @FXML
    protected MenuItem gotoBusinessMasterFileMenuItem;
    @FXML
    protected MenuItem gotoIncomeAndExpenditureMenuItem;
    @FXML
    protected MenuItem gotoAccountListMenuItem;
    @FXML
    protected MenuItem gotoHomeOfficeListMenuItem;
    @FXML
    protected MenuItem gotoFuelTaxCreditListMenuItem;
    @FXML
    protected MenuItem gotoImportDataListMenuItem;
    @FXML
    protected MenuItem gotoProvisionListMenuItem;
    @FXML
    protected MenuItem gotoDocumentLayoutMenuItem;
    @FXML
    protected MenuItem gotoFileImagesListMenuItem;
    @FXML
    protected MenuItem gotoFileAccessMenuItem;
    @FXML
    protected MenuItem gotoFileListMenuItem;
    @FXML
    protected MenuItem gotoImportDataMenuItem;
    @FXML
    protected MenuItem gotoTaxAgentOrderFormMenuItem;
    @FXML
    protected MenuItem gotoTaxServicesOrderFormMenuItem;
    @FXML
    protected MenuItem gotoReceiveFilesMenuItem;
    @FXML
    protected MenuBar menu_bar;
    protected GlenixApplication glenix;
    protected FileChooser fileChooser = new FileChooser();
    protected DateTimeFormatter prettyDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    protected DateTimeFormatter basicTimeFormatter = DateTimeFormatter.ofPattern("H:mm");
    protected String myBusinessFileToOpen = null;
    protected LocalDateTime fileOpenTime = null;
    private boolean skipInstallCached = false;
    HashMap<String, String> rootStyles = new HashMap();
    private int currentFontSize = 13;
    private Number currentStageWidth;
    private int currentColumnCount = 0;
    String currentStatusBarMessage = null;
    private ArrayList<Node> searchResultNodes = new ArrayList();
    private int searchResultCurrentIndex = 0;
    Node searchResultActiveNode;
    @FXML
    private TextField searchText;
    private TitledPane searchTitledPane = null;
    private NumberFormat formatFiveDp = new DecimalFormat("0.00000");
    private NumberFormat formatTwoDp = new DecimalFormat("#,##0.00");
    private NumberFormat formatTwoDpDollars = new DecimalFormat("$#,##0.00");
    private HashSet<String> taxWithheldCodes;
    private HashMap<String, String> countries = new HashMap();

    public ApplicationController(Stage stage, GlenixApplication glenix) {
        this.glenix = glenix;
        this.stage = stage;
    }

    public void glenixInitialise() {
        Security.addProvider(new BouncyCastleProvider());
        Init.init();
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.docFactory = DocumentBuilderFactory.newInstance();
            this.docFactory.setNamespaceAware(true);
            this.docBuilder = this.docFactory.newDocumentBuilder();
            TransformerFactory tf = TransformerFactory.newInstance();
            this.transformer = tf.newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "no");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("standalone", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            this.gotoChangePasswordMenuItem.disableProperty().set(true);
            if (this.gotoLinkV2MenuItem != null) {
                this.gotoLinkV2MenuItem.disableProperty().set(true);
            }
            if (this.gotoTaxAgentOrderFormMenuItem != null) {
                this.gotoTaxAgentOrderFormMenuItem.disableProperty().set(true);
            }
            if (this.gotoReceiveFilesMenuItem != null) {
                this.gotoReceiveFilesMenuItem.disableProperty().set(true);
            }
            if (this.gotoOpenFileMenuItem != null) {
                this.gotoOpenFileMenuItem.disableProperty().set(true);
            }
            this.gotoNewFileMenuItem.disableProperty().set(true);
            this.setDisableFileMenuOptions(true);
            this.searchText.textProperty().addListener((observable, oldValue, newValue) -> this.resetSearch());
            KeyCodeCombination keyCombinationAltEnter = new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN});
            this.searchText.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>((KeyCombination)keyCombinationAltEnter){
                final /* synthetic */ KeyCombination val$keyCombinationAltEnter;
                {
                    this.val$keyCombinationAltEnter = keyCombination;
                }

                public void handle(KeyEvent event) {
                    if (this.val$keyCombinationAltEnter.match(event)) {
                        ApplicationController.this.searchForTextBack();
                    } else if (event.getCode() == KeyCode.ENTER) {
                        ApplicationController.this.searchForText();
                    }
                }
            });
            this.menu_bar.setUseSystemMenuBar(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
        this.asterixIcon = new Image(this.getClass().getResourceAsStream("images/redasterix.png"));
        this.asterixView = new ImageView(this.asterixIcon);
        this.asterixView.setFitWidth(16.0);
        this.asterixView.setFitHeight(16.0);
        this.asterixIcon2 = new Image(this.getClass().getResourceAsStream("images/redasterix.png"));
        this.asterixView2 = new ImageView(this.asterixIcon2);
        this.asterixView2.setFitWidth(16.0);
        this.asterixView2.setFitHeight(16.0);
    }

    public String getGlenixCodeName() {
        return this.glenix_codeName;
    }

    public String getVersionNumber() {
        return this.glenix_versionNumber;
    }

    public GlenixTrnXBRL getBusinessMessageXBRLFromFile(GlenixFile aGlenixFile) throws Exception {
        if (aGlenixFile == null) {
            throw new Exception("File not opened cannot get businessMessage.xml from file");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get businessMessage.xml from file");
        }
        Document cdoc = this.getDocumentDecryptFromFile("businessMessage.xml", aGlenixFile);
        GlenixTrnXBRL result = new GlenixTrnXBRL();
        result.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        return result;
    }

    public GlenixTrnXBRL getBusinessMasterFileXBRLFromFile(GlenixFile aGlenixFile) throws Exception {
        if (aGlenixFile == null) {
            throw new Exception("File not opened cannot get businessMasterFile.xml from file");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get businessMasterFile.xml from file");
        }
        Document cdoc = this.getDocumentDecryptFromFile("businessMasterFile.xml", aGlenixFile);
        GlenixTrnXBRL result = new GlenixTrnXBRL();
        result.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        return result;
    }

    public void invalidateBusinessMasterFileXBRLCache() throws Exception {
        throw new Exception("Error, invalidate business master file cache not implemented in desktop software");
    }

    public GlenixTrnXBRL getBusinessMasterFileXBRL() throws Exception {
        String id;
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot get businessMasterFile.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get businessMasterFile.xml");
        }
        if (this.glenixTrnXBRLBusinessMasterFile != null) {
            return this.glenixTrnXBRLBusinessMasterFile;
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("businessMasterFile.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
            throw e;
        }
        this.glenixTrnXBRLBusinessMasterFile = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLBusinessMasterFile.initBusiness();
        } else {
            this.glenixTrnXBRLBusinessMasterFile.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
        BusinessMasterFile bmf = this.glenixTrnXBRLBusinessMasterFile.getBusinessMasterFile();
        if (bmf != null && ((id = bmf.getBusinessIdentifier()) == null || id.isEmpty())) {
            bmf.assignUUIDToBusinessIdentifier();
            this.saveBusinessMasterFile();
        }
        return this.glenixTrnXBRLBusinessMasterFile;
    }

    public BusinessMasterFile addBusinessMasterFile() throws Exception {
        GlenixTrnXBRL bx = this.getBusinessMasterFileXBRL();
        if (bx == null) {
            throw new Exception("Error, unable to load business masterfile xml");
        }
        Business b = bx.getBusiness();
        if (b == null) {
            bx.initBusiness();
            b = bx.getBusiness();
        }
        if (b == null) {
            throw new Exception("Error, cannot get business");
        }
        BusinessMasterFile bmf = b.getBusinessMasterFile();
        if (bmf != null) {
            return bmf;
        }
        bmf = b.getOrAddBusinessMasterFile();
        if (bmf == null) {
            throw new Exception("Error, unable to create business master file");
        }
        bmf.assignNewUUIDToBusinessIdentifier();
        return bmf;
    }

    public BusinessMasterFile saveBusinessMasterFile(BusinessMasterFile businessMasterFile) throws Exception {
        this.saveBusinessMasterFile();
        return businessMasterFile;
    }

    @FXML
    public void gotoBusinessMasterFile() {
        try {
            if (this.businessMasterFileVBox == null) {
                this.businessMasterFileVBox = new BusinessMasterFileVBox(this);
            }
            this.businessMasterFileVBox.setBusinessMasterFile(this.getBusinessMasterFile());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
            return;
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.businessMasterFileVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoBusinessMasterFilePrintInvoice() throws Exception {
        throw new Exception("Error, bmf print invoice not implemented in desktop software");
    }

    @FXML
    public void gotoDocumentLayout() {
        try {
            if (this.documentLayoutVBox == null) {
                this.documentLayoutVBox = new DocumentLayoutVBox(this);
            }
            this.documentLayoutVBox.setModel(this.getBusinessMasterFileXBRL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
            return;
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.documentLayoutVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    public void saveFileAs() {
        try {
            if (this.glenixKey == null) {
                throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
            }
            GlenixFile thisGlenixFile = new GlenixFile(this.stage, this.getGlenixCodeName());
            byte[] profilePublicPem = this.getProfilePublicCertificatePemFile();
            thisGlenixFile.createNewFile("MyBusiness.fas", profilePublicPem);
            GlenixFile oldFile = this.getGlenixFile();
            thisGlenixFile.copyAllDataSources(oldFile, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
            this.setGlenixFile(thisGlenixFile);
            this.setStatusBarMessage("Saved to " + thisGlenixFile.getFileName());
            this.setTitle(null);
            this.getBusinessMasterFileXBRL();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage("Error, Save As failed. Please close and reopen the original file. " + e.getMessage());
            this.setTitle("Error, Save As failed. Please close and reopen the original file. " + e.getMessage());
        }
    }

    public GlenixFile loadGlenixFile(File file) throws Exception {
        GlenixFile gf = new GlenixFile(null, this.getGlenixCodeName());
        gf.openBusinessFileDoNotCreate(file);
        if (!gf.isOpen()) {
            throw new Exception("Error, file not opened");
        }
        return gf;
    }

    public void setTitle(String heading) {
        if (heading == null || heading.isEmpty()) {
            GlenixFile bgf;
            String filedesc = this.getGlenixCodeName();
            String bn = this.getBusinessLegalName();
            if (bn != null && !bn.isEmpty()) {
                filedesc = filedesc + " - " + bn;
            }
            if ((bgf = this.getGlenixFile()) != null) {
                String bfn = bgf.getFileName();
                if (bfn != null && !bfn.isEmpty()) {
                    filedesc = filedesc + " - " + bfn;
                }
            } else {
                Profile p = this.getProfileXBRL();
                if (p != null) {
                    filedesc = filedesc + " - " + p.getFullName();
                    String tan = p.getAgentNumber();
                    if (tan != null && !tan.isEmpty()) {
                        filedesc = filedesc + " (TAN: " + tan + ")";
                    } else {
                        String aabn = p.getAgentABN();
                        filedesc = filedesc + " (Agent ABN: " + aabn + ")";
                    }
                    GlenixFile gf = this.getProfileFile();
                    String fn = gf.getFileName();
                    if (fn != null && !fn.isEmpty()) {
                        filedesc = filedesc + " - " + fn;
                    }
                }
            }
            this.stage.setTitle(filedesc);
        } else {
            this.stage.setTitle(heading);
        }
    }

    public void openFileE(File file) throws Exception {
        this.closeGlenixFile();
        GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
        gf.openBusinessFileDoNotCreate(file);
        if (!gf.isOpen()) {
            throw new Exception("Error, file not opened");
        }
        this.setGlenixFile(gf);
        if (gf != null) {
            this.getBusinessMasterFileXBRL();
            this.gotoBusinessMessageList();
        }
        this.setTitle(null);
    }

    public void openFileE() throws Exception {
        this.closeGlenixFile();
        GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
        gf.openBusinessFileDoNotCreate("MyBusiness");
        if (!gf.isOpen()) {
            throw new Exception("Error, file not opened");
        }
        this.setGlenixFile(gf);
        if (gf != null) {
            this.getBusinessMasterFileXBRL();
            this.gotoBusinessMessageList();
        }
        this.setTitle(null);
    }

    @FXML
    private void openFile() {
        try {
            this.openFileE();
        }
        catch (Exception e) {
            try {
                this.closeGlenixFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public File chooseFile() {
        FileChooser fileChooser = new FileChooser();
        return fileChooser.showOpenDialog((Window)this.stage);
    }

    public File chooseSaveLocation() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        return directoryChooser.showDialog((Window)this.stage);
    }

    @FXML
    public void gotoNewFile() {
        try {
            this.gotoNewFileE(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoNewFileE(BusinessMasterFile businessMasterFile, String message) throws Exception {
        this.closeGlenixFile();
        if (this.newFileVBox == null) {
            this.newFileVBox = new NewFileVBox(this);
        } else {
            this.newFileVBox.clearGlenixXBRL();
        }
        this.newFileVBox.setMessage(message);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.newFileVBox);
        this.setStatusBarMessage(null);
    }

    public void loadActivityStatementList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load activityStatementList.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load activityStatementList.xml");
        }
        Document asldoc = null;
        try {
            asldoc = this.getDocumentDecrypt("activityStatementList.xml");
        }
        catch (NoSuchFileException nsfe) {
            asldoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            asldoc = null;
        }
        this.glenixTrnXBRLActivityStatementList = new GlenixTrnXBRL();
        if (asldoc == null) {
            this.glenixTrnXBRLActivityStatementList.initActivityStatementList();
        } else {
            this.glenixTrnXBRLActivityStatementList.loadDocumentElement(asldoc, asldoc.getDocumentElement());
        }
    }

    public void bustCacheActivityStatementList() {
        this.glenixTrnXBRLActivityStatementList = null;
    }

    public GlenixTrnXBRL getActivityStatementList() throws Exception {
        if (this.glenixTrnXBRLActivityStatementList == null) {
            this.loadActivityStatementList();
        }
        return this.glenixTrnXBRLActivityStatementList;
    }

    public boolean activityStatementListIsVisible() {
        if (this.file_content_display != null) {
            return this.file_content_display.getChildren().contains((Object)this.activityStatementListVBox);
        }
        return false;
    }

    @FXML
    public void gotoActivityStatementList() {
        try {
            if (this.activityStatementListVBox == null) {
                this.activityStatementListVBox = new ActivityStatementListVBox(this);
            }
            this.activityStatementListVBox.setModel(this.getActivityStatementList());
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.activityStatementListVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ASLStatement getASLStatement(String asNumber) throws Exception {
        if (this.glenixTrnXBRLActivityStatementList == null) {
            this.loadActivityStatementList();
        }
        if (this.glenixTrnXBRLActivityStatementList == null) {
            return null;
        }
        ActivityStatementList asl = this.glenixTrnXBRLActivityStatementList.getActivityStatementList();
        if (asl == null) {
            return null;
        }
        ActivityStatementListResponse aslr = asl.getActivityStatementListResponse();
        if (aslr == null) {
            return null;
        }
        return aslr.getASLStatementByAsNumber(asNumber);
    }

    public void printActivityStatementListDocument() throws Exception {
        if (this.glenixTrnXBRLActivityStatementList == null) {
            System.out.println("Activity statement document is null");
        }
        Document doc = this.glenixTrnXBRLActivityStatementList.buildDocument();
        this.printDocument(doc, System.out);
    }

    public void saveActivityStatement(GlenixTrnXBRL glenixTrnXBRLActivityStatement) throws Exception {
        if (glenixTrnXBRLActivityStatement == null) {
            throw new Exception("Error, cannot save activity statement. Requested activity statement is null");
        }
        Document asdoc = glenixTrnXBRLActivityStatement.buildDocument();
        String asNumber = "";
        ActivityStatement as = glenixTrnXBRLActivityStatement.getActivityStatement();
        if (as != null) {
            asNumber = as.getActivityStatementNumber();
        }
        this.saveFileEncrypt("activityStatement_" + asNumber + ".xml", asdoc);
    }

    public GlenixTrnXBRL loadActivityStatementCheckCacheNoDefault(String asNumber) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load activityStatement.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load activityStatement.xml");
        }
        GlenixTrnXBRL result = this.glenixTrnXBRLActivityStatementHashMap.get(asNumber);
        if (result != null) {
            return result;
        }
        Document asdoc = null;
        try {
            asdoc = this.getDocumentDecrypt("activityStatement_" + asNumber + ".xml");
        }
        catch (NoSuchFileException nsfe) {
            asdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            asdoc = null;
        }
        GlenixTrnXBRL glenixTrnXBRLActivityStatement = new GlenixTrnXBRL();
        ActivityStatement as = null;
        if (asdoc != null) {
            glenixTrnXBRLActivityStatement.loadDocumentElement(asdoc, asdoc.getDocumentElement());
            as = glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as != null) {
                this.activityStatementVBoxHashMap.remove(asNumber);
                this.glenixTrnXBRLActivityStatementHashMap.put(asNumber, glenixTrnXBRLActivityStatement);
                return glenixTrnXBRLActivityStatement;
            }
        }
        return null;
    }

    public GlenixTrnXBRL loadActivityStatement(String asNumber) throws Exception {
        Document doc;
        ActivityStatementList asl;
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load activityStatement.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load activityStatement.xml");
        }
        GlenixTrnXBRL result = this.glenixTrnXBRLActivityStatementHashMap.get(asNumber);
        if (result != null) {
            return result;
        }
        Document asdoc = null;
        try {
            asdoc = this.getDocumentDecrypt("activityStatement_" + asNumber + ".xml");
        }
        catch (NoSuchFileException nsfe) {
            asdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            asdoc = null;
        }
        GlenixTrnXBRL glenixTrnXBRLActivityStatement = new GlenixTrnXBRL();
        ActivityStatement as = null;
        if (asdoc != null) {
            glenixTrnXBRLActivityStatement.loadDocumentElement(asdoc, asdoc.getDocumentElement());
            as = glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as != null) {
                this.activityStatementVBoxHashMap.remove(asNumber);
                this.glenixTrnXBRLActivityStatementHashMap.put(asNumber, glenixTrnXBRLActivityStatement);
                return glenixTrnXBRLActivityStatement;
            }
        }
        if (this.glenixTrnXBRLActivityStatementList == null) {
            this.loadActivityStatementList();
        }
        if (this.glenixTrnXBRLActivityStatementList != null && (asl = this.glenixTrnXBRLActivityStatementList.getActivityStatementList()) != null && (doc = asl.generateSkeletonActivityStatement(asNumber)) != null) {
            glenixTrnXBRLActivityStatement.loadDocumentElementOverwrite(doc, doc.getDocumentElement());
            this.activityStatementVBoxHashMap.remove(asNumber);
            this.glenixTrnXBRLActivityStatementHashMap.put(asNumber, glenixTrnXBRLActivityStatement);
            return glenixTrnXBRLActivityStatement;
        }
        return null;
    }

    public void gotoActivityStatement(String asNumber) {
        try {
            ActivityStatementVBox activityStatementVBox = this.activityStatementVBoxHashMap.get(asNumber);
            if (activityStatementVBox == null) {
                activityStatementVBox = new ActivityStatementVBox(this);
                this.activityStatementVBoxHashMap.put(asNumber, activityStatementVBox);
            }
            GlenixTrnXBRL glenixTrnXBRLActivityStatement = this.loadActivityStatement(asNumber);
            activityStatementVBox.setModel(glenixTrnXBRLActivityStatement);
            activityStatementVBox.setProfileDetails(this.profileXBRL);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)activityStatementVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoActivityStatement(String asNumber, GlenixTrnXBRL glenixTrnXBRLActivityStatement) {
        try {
            ActivityStatementVBox activityStatementVBox = this.activityStatementVBoxHashMap.get(asNumber);
            if (activityStatementVBox == null) {
                activityStatementVBox = new ActivityStatementVBox(this);
                this.activityStatementVBoxHashMap.put(asNumber, activityStatementVBox);
            }
            activityStatementVBox.setModel(glenixTrnXBRLActivityStatement);
            activityStatementVBox.setProfileDetails(this.profileXBRL);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)activityStatementVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void loadConfigPage() {
        if (this.configPageVBox == null) {
            try {
                this.configPageVBox = new ConfigPageVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.configPageVBox);
    }

    @FXML
    public void gotoNewProfile() {
        try {
            if (this.newProfileVBox == null) {
                this.newProfileVBox = new NewProfileVBox(this);
            }
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.newProfileVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void gotoChangePassword() {
        try {
            if (this.changePasswordVBox == null) {
                this.changePasswordVBox = new ChangePasswordVBox(this);
            }
            this.changePasswordVBox.setModel(this.profileFile, this.profileXBRL);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.changePasswordVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void gotoLinkV2() {
        try {
            if (this.linkV2VBox == null) {
                this.linkV2VBox = new LinkV2VBox(this);
            }
            this.linkV2VBox.setModel(this.profileFile, this.profileXBRL);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.linkV2VBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void loadOutgoingMailServer() throws Exception {
        this.outgoingMailServerXBRL = new Profile();
        try {
            Document doc = this.getProfileDocumentDecrypt("outgoingMailServer.xml");
            if (doc != null) {
                this.outgoingMailServerXBRL.loadDocumentElement(doc, doc.getDocumentElement());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoOutgoingMailServerE() throws Exception {
        if (this.outgoingMailServerXBRL == null) {
            this.loadOutgoingMailServer();
        }
        if (this.outgoingMailServerVBox == null) {
            this.outgoingMailServerVBox = new OutgoingMailServerVBox(this);
        }
        this.outgoingMailServerVBox.setModel(this.outgoingMailServerXBRL);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.outgoingMailServerVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoViewProfileCertificateE() throws Exception {
        if (this.viewProfileCertificateVBox == null) {
            this.viewProfileCertificateVBox = new ViewProfileCertificateVBox(this);
        }
        this.viewProfileCertificateVBox.setModel(this.profileFile, this.profileXBRL);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.viewProfileCertificateVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    private void gotoViewProfileCertificate() {
        try {
            this.gotoViewProfileCertificateE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoVerifyIdentityE() throws Exception {
        if (this.verifyFASIdentityVBox == null) {
            this.verifyFASIdentityVBox = new VerifyFASIdentityVBox(this);
        }
        this.verifyFASIdentityVBox.setModel(this.profileFile, this.profileXBRL);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.verifyFASIdentityVBox);
        this.setStatusBarMessage(null);
    }

    public Document getDocumentDecrypt(String dataSource) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load " + dataSource);
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load " + dataSource);
        }
        try {
            if (!this.glenixFile.hasKey()) {
                PublicKey pk = this.glenixKey.getPublicKey();
                String base64EncKey = this.glenixFile.getBase64EncryptedKey(pk);
                if (base64EncKey == null) {
                    throw new Exception("Error, you do not have access to this file");
                }
                byte[] encKey = Base64.getDecoder().decode(base64EncKey);
                byte[] key = this.glenixKey.decryptBytes(encKey);
                this.glenixFile.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.glenixFile.getDocumentDecrypt(dataSource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
    }

    public Document getDocumentDecryptFromFile(String dataSource, GlenixFile aGlenixFile) throws Exception {
        if (aGlenixFile == null) {
            throw new Exception("File not provided cannot load " + dataSource + " from file.");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load " + dataSource + " from file.");
        }
        try {
            if (!aGlenixFile.hasKey()) {
                PublicKey pk = this.glenixKey.getPublicKey();
                String base64EncKey = aGlenixFile.getBase64EncryptedKey(pk);
                if (base64EncKey == null) {
                    throw new Exception("Error, you do not have access to this file");
                }
                byte[] encKey = Base64.getDecoder().decode(base64EncKey);
                byte[] key = this.glenixKey.decryptBytes(encKey);
                aGlenixFile.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aGlenixFile.getDocumentDecrypt(dataSource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
    }

    public void saveAndEncryptDoc(String dataSource, Document savedoc) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot save " + dataSource);
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot save " + dataSource);
        }
        if (!this.glenixFile.hasKey()) {
            PublicKey pk = this.glenixKey.getPublicKey();
            String base64EncKey = this.glenixFile.getBase64EncryptedKey(pk);
            if (base64EncKey == null) {
                throw new Exception("Error, you do not have access to this file");
            }
            byte[] encKey = Base64.getDecoder().decode(base64EncKey);
            byte[] key = this.glenixKey.decryptBytes(encKey);
            this.glenixFile.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        this.glenixFile.saveAndEncryptDoc(dataSource, savedoc);
    }

    public void loadFileAccess() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load glenixCertificateList.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load glenixCertificateList.xml");
        }
        Document gcdoc = null;
        try {
            gcdoc = this.getDocument("glenixCertificateList.xml");
        }
        catch (NoSuchFileException nsfe) {
            gcdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            gcdoc = null;
        }
        this.glenixTrnXBRLFileAccess = new GlenixTrnXBRL();
        if (gcdoc == null) {
            this.glenixTrnXBRLFileAccess.initBusiness();
        } else {
            try {
                this.glenixTrnXBRLFileAccess.loadDocumentElement(gcdoc, gcdoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.glenixTrnXBRLFileAccess.initBusiness();
                throw e;
            }
        }
    }

    public GlenixTrnXBRL getFileAccess() throws Exception {
        if (this.glenixTrnXBRLFileAccess == null) {
            this.loadFileAccess();
        }
        return this.glenixTrnXBRLFileAccess;
    }

    public void gotoFileAccessE() throws Exception {
        if (this.fileAccessVBox == null) {
            this.fileAccessVBox = new FileAccessVBox(this);
        }
        this.fileAccessVBox.setModel(this.getFileAccess());
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.fileAccessVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    private void gotoFileAccess() {
        try {
            this.gotoFileAccessE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoFileAccessAddCertificateE() throws Exception {
        if (this.fileAccessAddCertificateVBox == null) {
            this.fileAccessAddCertificateVBox = new FileAccessAddCertificateVBox(this);
        }
        this.fileAccessAddCertificateVBox.setModel(this.getFileAccess());
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.fileAccessAddCertificateVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    private void gotoFileAccessAddCertificate() {
        try {
            this.gotoFileAccessAddCertificateE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoImportDataE() throws Exception {
        if (this.importDataVBox == null) {
            this.importDataVBox = new ImportDataVBox(this);
        }
        this.importDataVBox.setModel(this.getBusinessMasterFileXBRL());
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.importDataVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    public void gotoImportData() {
        try {
            this.gotoImportDataE();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoImportDataImportFile() throws Exception {
        if (this.importDataImportFileVBox == null) {
            this.importDataImportFileVBox = new ImportDataImportFileVBox(this);
        }
        this.importDataImportFileVBox.setModel(this.getBusinessMasterFileXBRL());
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.importDataImportFileVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoFileAccessViewCertificateE(X509Certificate x509) throws Exception {
        if (this.fileAccessViewCertificateVBox == null) {
            this.fileAccessViewCertificateVBox = new FileAccessViewCertificateVBox(this);
        }
        this.fileAccessViewCertificateVBox.setModel(this.getFileAccess(), x509);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.fileAccessViewCertificateVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoWelcomePage(boolean skipInstall) {
        this.skipInstallCached = skipInstall;
        try {
            this.setStatusBarMessage(null);
            if (!this.skipInstallCached) {
                this.gotoInstallPage();
                return;
            }
            GlenixFile gf = this.loadFASIdentityFile();
            if (gf != null) {
                this.gotoOpenProfile(gf);
            } else {
                this.gotoNewProfile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void gotoFASIdentity() {
        if (this.profileXBRL != null) {
            this.gotoEditProfile();
        } else {
            this.gotoWelcomePage(this.skipInstallCached);
        }
    }

    public String getDownloadUrl() {
        return this.glenix_fas3DesktopDownloadURL;
    }

    @FXML
    public void gotoInstallPage() {
        if (this.installVBox == null) {
            try {
                this.installVBox = new InstallVBox(this, this.getDownloadUrl());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.installVBox.doVersionCheck();
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.installVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    public void gotoVersionCheckPage() {
        if (this.versionCheckVBox == null) {
            try {
                this.versionCheckVBox = new PostUnlockVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.versionCheckVBox);
        this.setStatusBarMessage(null);
    }

    @FXML
    public void gotoOpenProfile(GlenixFile gf) {
        if (this.openProfileVBox == null) {
            try {
                this.openProfileVBox = new OpenProfileVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.openProfileVBox.setGlenixFile(gf);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.openProfileVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void gotoPostUnlockPage() {
        this.setStatusBarMessage(null);
        if (this.myBusinessFileToOpen != null) {
            try {
                this.closeGlenixFile();
                GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
                File busfile = new File(this.myBusinessFileToOpen);
                if (busfile.exists()) {
                    gf.openBusinessFileDoNotCreate(busfile);
                    if (!gf.isOpen()) {
                        throw new Exception("Error, file not opened");
                    }
                    this.setGlenixFile(gf);
                    this.getBusinessMasterFileXBRL();
                    this.gotoBusinessMasterFile();
                    this.setTitle(null);
                    return;
                }
                this.setStatusBarMessage("The file, " + this.myBusinessFileToOpen + " does not exist");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setStatusBarMessage(e.getMessage());
            }
        }
        if (this.postUnlockVBox == null) {
            try {
                this.postUnlockVBox = new PostUnlockVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.postUnlockVBox.setModel(this.profileXBRL);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.postUnlockVBox);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void gotoEditProfile() {
        try {
            if (this.editProfileVBox == null) {
                this.editProfileVBox = new EditProfileVBox(this);
            }
            if (this.editProfileVBox != null) {
                this.editProfileVBox.setModel(this.profileXBRL);
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.editProfileVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoTaxAgentOrderForm() {
        try {
            if (this.taxAgentOrderFormVBox == null) {
                this.taxAgentOrderFormVBox = new TaxAgentOrderFormVBox(this);
            }
            if (this.taxAgentOrderFormVBox != null) {
                this.taxAgentOrderFormVBox.setModel(this.profileXBRL);
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.taxAgentOrderFormVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoReceiveFiles() {
        try {
            if (this.receiveFilesVBox == null) {
                this.receiveFilesVBox = new ReceiveFilesVBox(this);
            }
            if (this.receiveFilesVBox != null) {
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.receiveFilesVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoTaxServicesOrderForm() {
        try {
            if (this.taxServicesOrderFormVBox == null) {
                this.taxServicesOrderFormVBox = new TaxServicesOrderFormVBox(this);
            }
            if (this.taxServicesOrderFormVBox != null) {
                this.taxServicesOrderFormVBox.setModel(this.profileXBRL);
                this.taxServicesOrderFormVBox.setBusiness(this.glenixTrnXBRLBusinessMasterFile);
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.taxServicesOrderFormVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoLargeOrderForm() {
        try {
            if (this.largeOrderFormVBox == null) {
                this.largeOrderFormVBox = new LargeOrderFormVBox(this);
            }
            if (this.largeOrderFormVBox != null) {
                this.largeOrderFormVBox.setModel(this.profileXBRL);
                this.largeOrderFormVBox.setBusiness(this.glenixTrnXBRLBusinessMasterFile);
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.largeOrderFormVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoSupportOrderForm() {
        try {
            if (this.supportOrderFormVBox == null) {
                this.supportOrderFormVBox = new SupportOrderFormVBox(this);
            }
            if (this.supportOrderFormVBox != null) {
                this.supportOrderFormVBox.setModel(this.profileXBRL);
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.supportOrderFormVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoLicenseTerms() {
        try {
            if (this.licenseTermsVBox == null) {
                this.licenseTermsVBox = new LicenseTermsVBox(this);
            }
            if (this.licenseTermsVBox != null) {
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.licenseTermsVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoLibrariesLicenseTerms() {
        try {
            if (this.librariesLicenseTermsVBox == null) {
                this.librariesLicenseTermsVBox = new LibrariesLicenseTermsVBox();
            }
            if (this.librariesLicenseTermsVBox != null) {
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.librariesLicenseTermsVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoSBRPrivacyStatement() {
        try {
            if (this.sbrPrivacyStatementVBox == null) {
                this.sbrPrivacyStatementVBox = new SBRPrivacyStatementVBox();
            }
            if (this.sbrPrivacyStatementVBox != null) {
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.sbrPrivacyStatementVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoSBREndUserAgreement() {
        try {
            if (this.sbrEndUserAgreementVBox == null) {
                this.sbrEndUserAgreementVBox = new SBREndUserAgreementVBox();
            }
            if (this.sbrEndUserAgreementVBox != null) {
                this.invalidateComponentsCache();
                this.file_content_display.getChildren().clear();
                this.file_content_display.getChildren().add((Object)this.sbrEndUserAgreementVBox);
                this.setStatusBarMessage(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void processExit() {
        try {
            this.closeGlenixFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
            return;
        }
        System.exit(0);
    }

    public Profile getProfileXBRL() {
        return this.profileXBRL;
    }

    public GlenixFile getProfileFile() {
        return this.profileFile;
    }

    public void setProfileFile(GlenixFile profileFile, Profile profileXBRL) {
        this.profileFile = profileFile;
        this.profileXBRL = profileXBRL;
        if (profileXBRL == null) {
            this.gotoChangePasswordMenuItem.disableProperty().set(true);
            if (this.gotoLinkV2MenuItem != null) {
                this.gotoLinkV2MenuItem.disableProperty().set(true);
            }
            if (this.gotoTaxAgentOrderFormMenuItem != null) {
                this.gotoTaxAgentOrderFormMenuItem.disableProperty().set(true);
            }
            if (this.gotoReceiveFilesMenuItem != null) {
                this.gotoReceiveFilesMenuItem.disableProperty().set(true);
            }
            if (this.gotoOpenFileMenuItem != null) {
                this.gotoOpenFileMenuItem.disableProperty().set(true);
            }
            this.gotoNewFileMenuItem.disableProperty().set(true);
            this.setDisableFileMenuOptions(true);
        } else {
            this.gotoChangePasswordMenuItem.disableProperty().set(false);
            if (this.gotoLinkV2MenuItem != null) {
                this.gotoLinkV2MenuItem.disableProperty().set(false);
            }
            if (this.gotoTaxAgentOrderFormMenuItem != null) {
                this.gotoTaxAgentOrderFormMenuItem.disableProperty().set(false);
            }
            if (this.gotoReceiveFilesMenuItem != null) {
                this.gotoReceiveFilesMenuItem.disableProperty().set(false);
            }
            if (this.gotoOpenFileMenuItem != null) {
                this.gotoOpenFileMenuItem.disableProperty().set(false);
            }
            this.gotoNewFileMenuItem.disableProperty().set(false);
        }
        this.setTitle(null);
    }

    public void saveProfileFile() throws Exception {
        Document cdoc = this.profileXBRL.buildDocument();
        this.saveProfileFile("profile.xml", cdoc);
    }

    public void saveOutgoingMailServer() throws Exception {
        Document cdoc = this.outgoingMailServerXBRL.buildDocument();
        this.saveProfileFileEncrypt("outgoingMailServer.xml", cdoc);
    }

    public GlenixAUSKey getGlenixKey() {
        return this.glenixKey;
    }

    public void setGlenixKey(GlenixAUSKey glenixKey) {
        this.glenixKey = glenixKey;
        this.glenixKey.setProductName(this.glenix_productName);
        this.glenixKey.setVersionNumber(this.getVersionNumber());
    }

    public boolean reverifyPassword(char[] password) {
        if (this.glenixKey == null) {
            return false;
        }
        try {
            return this.glenixKey.verifyPassword(password);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public GlenixFile getGlenixFile() {
        return this.glenixFile;
    }

    public void closeAllPages() {
        this.newFileVBox = null;
        this.businessMasterFileVBox = null;
        this.glenixTrnXBRLBusinessMasterFile = null;
        this.taxReturnListVBox = null;
        this.incomeAndExpenditureVBox = null;
        this.incomeAndExpenditureAccountDetailVBox = null;
        this.incomeAndExpenditureProvisionDetailVBox = null;
        this.activityStatementListVBox = null;
        this.glenixTrnXBRLActivityStatementList = null;
        this.activityStatementVBoxHashMap = new HashMap();
        this.glenixTrnXBRLActivityStatementHashMap = new HashMap();
        this.activityStatementHashMap = new HashMap();
        this.counterpartyVBox = null;
        this.glenixTrnXBRLCounterparty = null;
        this.counterpartyEditVBox = null;
        this.counterpartyTFNDVBox = null;
        this.counterpartyTFNDListVBox = null;
        this.counterpartyPayrollDetailsEditVBox = null;
        this.counterpartySuperDetailsEditVBox = null;
        this.superProductDetailsListVBox = null;
        this.superProductDetailsEditVBox = null;
        this.employeeListVBox = null;
        this.provisionListVBox = null;
        this.glenixTrnXBRLProvision = null;
        this.provisionEditVBox = null;
        this.accountListVBox = null;
        this.glenixTrnXBRLAccount = null;
        this.accountEditVBox = null;
        this.homeOfficeListVBox = null;
        this.glenixTrnXBRLHomeOffice = null;
        this.homeOfficeEditVBox = null;
        this.fuelTaxCreditListVBox = null;
        this.glenixTrnXBRLFuelTaxCredit = null;
        this.fuelTaxCreditEditVBox = null;
        this.importDataListVBox = null;
        this.glenixTrnXBRLImportData = null;
        this.importDataEditVBox = null;
        this.glenixTrnXBRLBusinessIssue = null;
        this.businessMessageListVBox = null;
        this.glenixTrnXBRLBusinessMessage = null;
        this.businessMessageEditVBox = null;
        this.transactionsTableVBox = null;
        this.transactionsTableSalesVBox = null;
        this.transactionsTableASVBox = null;
        this.transactionsTableOtherPurchasesVBox = null;
        this.transactionsTableHomeOfficeVBox = null;
        this.transactionsTableFuelTaxCreditVBox = null;
        this.transactionsTableImportDataVBox = null;
        this.transactionsTablePaySlipsVBox = null;
        this.trashTransactionTableVBox = null;
        this.glenixTrnXBRLTransactions = null;
        this.transactionEditVBox = null;
        this.newProfileVBox = null;
        this.changePasswordVBox = null;
        this.outgoingMailServerVBox = null;
        this.viewProfileCertificateVBox = null;
        this.verifyFASIdentityVBox = null;
        this.fileAccessVBox = null;
        this.fileAccessAddCertificateVBox = null;
        this.fileAccessViewCertificateVBox = null;
        this.importDataVBox = null;
        this.glenixTrnXBRLFileAccess = null;
        this.paySlipEditVBox = null;
        this.batchTransactionsTableVBox = null;
        this.batchTableVBox = null;
        this.glenixTrnXBRLBatches = null;
        this.batchEditVBox = null;
        this.batchSTPLodgeVBox = null;
        this.glenixTrnXBRLTaxReturn = null;
        this.taxReturnTaxReturnVBox = null;
        this.fileListVBox = null;
        this.fileImagesVBox = null;
        this.configPageVBox = null;
    }

    public void closeGlenixFile() throws Exception {
        this.closeAllPages();
        this.setDisableFileMenuOptions(true);
        if (this.glenixFile != null) {
            this.glenixFile.closeFile();
            this.glenixFile = null;
        }
    }

    public LocalDateTime getFileOpenTime() {
        return this.fileOpenTime;
    }

    public void setGlenixFile(GlenixFile glenixFile) throws Exception {
        if (glenixFile == null) {
            this.closeGlenixFile();
        } else if (this.glenixFile != glenixFile) {
            if (this.glenixFile != null) {
                this.closeGlenixFile();
            }
            this.glenixFile = glenixFile;
            this.setDisableFileMenuOptions(false);
            this.restartFileOpenTime();
        }
    }

    public void restartFileOpenTime() {
        this.fileOpenTime = LocalDateTime.now();
    }

    public Document getDocument(String dataSource) throws Exception {
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            return null;
        }
        return gf.getDocument(dataSource);
    }

    public void setDisableFileMenuOptions(boolean disable) {
        if (this.saveFileAsMenuItem != null) {
            this.saveFileAsMenuItem.disableProperty().set(disable);
        }
        this.gotoSalesTransactionsMenuItem.disableProperty().set(disable);
        this.gotoOtherPurchasesTransactionsMenuItem.disableProperty().set(disable);
        this.gotoBatchesMenuItem.disableProperty().set(disable);
        if (this.gotoPaySlipsTransactionsMenuItem != null) {
            this.gotoPaySlipsTransactionsMenuItem.disableProperty().set(disable);
        }
        this.gotoTrashTransactionsMenuItem.disableProperty().set(disable);
        this.gotoActivityStatementListMenuItem.disableProperty().set(disable);
        if (this.gotoTaxReturnListMenuItem != null) {
            this.gotoTaxReturnListMenuItem.disableProperty().set(disable);
        }
        this.gotoCounterpartyListMenuItem.disableProperty().set(disable);
        if (this.gotoBusinessMessageListMenuItem != null) {
            this.gotoBusinessMessageListMenuItem.disableProperty().set(disable);
        }
        this.gotoIncomeAndExpenditureMenuItem.disableProperty().set(disable);
        this.gotoBusinessMasterFileMenuItem.disableProperty().set(disable);
        this.gotoAccountListMenuItem.disableProperty().set(disable);
        this.gotoHomeOfficeListMenuItem.disableProperty().set(disable);
        if (this.gotoFuelTaxCreditListMenuItem != null) {
            this.gotoFuelTaxCreditListMenuItem.disableProperty().set(disable);
        }
        if (this.gotoImportDataListMenuItem != null) {
            this.gotoImportDataListMenuItem.disableProperty().set(disable);
        }
        this.gotoProvisionListMenuItem.disableProperty().set(disable);
        if (this.gotoFileImagesListMenuItem != null) {
            this.gotoFileImagesListMenuItem.disableProperty().set(disable);
        }
        if (this.gotoDocumentLayoutMenuItem != null) {
            this.gotoDocumentLayoutMenuItem.disableProperty().set(disable);
        }
        this.gotoFileAccessMenuItem.disableProperty().set(disable);
        if (this.gotoFileListMenuItem != null) {
            this.gotoFileListMenuItem.disableProperty().set(disable);
        }
        this.gotoImportDataMenuItem.disableProperty().set(disable);
        this.gotoTaxServicesOrderFormMenuItem.disableProperty().set(disable);
    }

    public void saveNewFile() throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        GlenixFile thisGlenixFile = new GlenixFile(this.stage, this.getGlenixCodeName());
        byte[] profilePublicPem = this.getProfilePublicCertificatePemFile();
        thisGlenixFile.createNewFile("MyBusiness.fas", profilePublicPem);
        this.setGlenixFile(thisGlenixFile);
        this.setTitle(null);
    }

    public void addPublicKeyPem(String publicKeyPemStr) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        if (this.glenixFile == null) {
            throw new Exception("Error, you have not opened your business file.");
        }
        this.glenixFile.addPublicKeyPem(publicKeyPemStr, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        this.glenixTrnXBRLFileAccess = null;
    }

    public void deleteGlenixCertificatesX509(List<X509Certificate> selectedCerts) throws Exception {
        this.glenixFile.deleteGlenixCertificatesX509(selectedCerts, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        this.glenixTrnXBRLFileAccess = null;
    }

    public void deleteGlenixCertificates(List<GlenixCertificate> selectedCerts) throws Exception {
        this.glenixFile.deleteGlenixCertificates(selectedCerts, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        this.glenixTrnXBRLFileAccess = null;
    }

    public void saveFile(String dataSource, Document savedoc) throws Exception {
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        gf.saveFile(dataSource, savedoc);
    }

    public void saveProfileFile(String dataSource, Document savedoc) throws Exception {
        GlenixFile gf = this.getProfileFile();
        if (gf == null) {
            throw new Exception("Profile file not yet opened.");
        }
        gf.reopenFile();
        gf.saveFile(dataSource, savedoc);
        gf.closeFile();
    }

    public void saveProfileFileEncrypt(String dataSource, Document savedoc) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot encrypt saved data. Set key first.");
        }
        GlenixFile gf = this.getProfileFile();
        if (gf == null) {
            throw new Exception("Profile file not yet opened.");
        }
        gf.reopenFile();
        if (!gf.hasKey()) {
            PublicKey pk = this.glenixKey.getPublicKey();
            String base64EncKey = gf.getBase64EncryptedKey(pk);
            if (base64EncKey == null) {
                throw new Exception("Error, you do not have access to this file");
            }
            byte[] encKey = Base64.getDecoder().decode(base64EncKey);
            byte[] key = this.glenixKey.decryptBytes(encKey);
            gf.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        gf.saveAndEncryptDoc(dataSource, savedoc);
        gf.closeFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getProfileDocumentDecrypt(String dataSource) throws Exception {
        GlenixFile gf = this.getProfileFile();
        if (gf == null) {
            throw new Exception("Profile file not yet opened " + dataSource);
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load " + dataSource);
        }
        gf.reopenFile();
        if (!gf.hasKey()) {
            PublicKey pk = this.glenixKey.getPublicKey();
            String base64EncKey = gf.getBase64EncryptedKey(pk);
            if (base64EncKey == null) {
                throw new Exception("Error, you do not have access to this file");
            }
            byte[] encKey = Base64.getDecoder().decode(base64EncKey);
            byte[] key = this.glenixKey.decryptBytes(encKey);
            gf.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        Document result = null;
        try {
            result = gf.getDocumentDecrypt(dataSource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            gf.closeFile();
        }
        return result;
    }

    public Document getProfileDocument(String dataSource) throws Exception {
        GlenixFile gf = this.getProfileFile();
        if (gf == null) {
            return null;
        }
        gf.reopenFile();
        Document result = gf.getDocument(dataSource);
        gf.closeFile();
        return result;
    }

    public byte[] getProfilePublicCertificatePemFile() throws Exception {
        int len;
        GlenixFile gf = this.getProfileFile();
        if (gf == null) {
            throw new Exception("Profile file not yet opened.");
        }
        gf.reopenFile();
        InputStream is = gf.readDataSource("public.pem");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[500];
        while ((len = is.read(b)) >= 0) {
            bos.write(b, 0, len);
        }
        gf.closeFile();
        return bos.toByteArray();
    }

    public void saveFileEncrypt(String dataSource, Document savedoc) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot encrypt saved data. Set key first.");
        }
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        if (!gf.hasKey()) {
            PublicKey pk = this.glenixKey.getPublicKey();
            String base64EncKey = gf.getBase64EncryptedKey(pk);
            if (base64EncKey == null) {
                throw new Exception("Error, you do not have access to this file");
            }
            byte[] encKey = Base64.getDecoder().decode(base64EncKey);
            byte[] key = this.glenixKey.decryptBytes(encKey);
            gf.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        gf.saveAndEncryptDoc(dataSource, savedoc);
    }

    public void saveFileEncryptStream(String dataSource, InputStream is) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot encrypt saved data. Set key first.");
        }
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        if (!gf.hasKey()) {
            PublicKey pk = this.glenixKey.getPublicKey();
            String base64EncKey = gf.getBase64EncryptedKey(pk);
            if (base64EncKey == null) {
                throw new Exception("Error, you do not have access to this file");
            }
            byte[] encKey = Base64.getDecoder().decode(base64EncKey);
            byte[] key = this.glenixKey.decryptBytes(encKey);
            gf.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        gf.saveAndEncryptStream(dataSource, is, null);
    }

    public void makeFileDirectory(String dataSource) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot make directory. Set key first.");
        }
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        gf.makeDirectory(dataSource);
    }

    public void saveFileAs(String dataSource, Document savedoc) throws Exception {
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        gf.saveFileAs(dataSource, savedoc);
    }

    public InputStream readDataSource(String dataSource) throws Exception {
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        return gf.readDataSource(dataSource);
    }

    public InputStream readAndDecryptDataSource(String dataSource) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot decrypt read data. Set key first.");
        }
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        return gf.readAndDecryptDataSource(dataSource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
    }

    public InputStream readAndDecryptDataSourcePGP(String dataSource) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot decrypt read data. Set key first.");
        }
        GlenixFile gf = this.getGlenixFile();
        if (gf == null) {
            throw new Exception("File not yet opened.");
        }
        return gf.readAndDecryptDataSource(dataSource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
    }

    public void displayDataSourceDecrypt(String dataSource) throws Exception {
        Document doc = this.getDocumentDecrypt(dataSource);
        this.loadGlenixXBRL(doc, doc.getDocumentElement());
    }

    public String createSignatureBase64OneLine(byte[] digestBytes) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot create signature.");
        }
        return this.glenixKey.createSignatureBase64OneLine(digestBytes);
    }

    public String getBase64PublicKeyOneLine() throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot get certificate.");
        }
        return this.glenixKey.getBase64PublicKeyOneLine();
    }

    public boolean verifySignature(byte[] encodedDigest, String signatureBase64String, String certificateString) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot verify signature.");
        }
        return this.glenixKey.checkSignatureValue(encodedDigest, signatureBase64String, certificateString);
    }

    public String getX509CertificateCommonName(String certString) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot get certificate common name.");
        }
        return this.glenixKey.getX509CertificateCommonNameUnverified(certString);
    }

    public String getX509CertificateCommonNameUnverified(X509Certificate cert) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, glenix key not set cannot get certificate common name.");
        }
        return this.glenixKey.getX509CertificateCommonNameUnverified(cert);
    }

    public X509Certificate getSavedX509Certificate(String certString) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        if (this.glenixFile == null) {
            throw new Exception("Error, you have opened your business file.");
        }
        return this.glenixFile.getSavedX509Certificate(certString);
    }

    public X509Certificate readX509Certificate(String certString) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        return this.glenixKey.extractX509Certificate(certString);
    }

    public X509Certificate readX509CertificatePEM(String pemCertString) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        return this.glenixKey.extractX509CertificatePEM(pemCertString);
    }

    public void x509CertificateIsSigned(X509Certificate x) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        this.glenixKey.x509CertificateIsSigned(x);
    }

    public boolean x509CertificateIsSignedBoolean(X509Certificate x) {
        try {
            if (this.glenixKey == null) {
                throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
            }
            this.glenixKey.x509CertificateIsSigned(x);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getPublicKeyPEM(X509Certificate x509) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first.");
        }
        return this.glenixKey.getPublicKeyPEM(x509);
    }

    public boolean publicKeyIsMine(PublicKey publicKey) {
        if (this.glenixKey == null) {
            return false;
        }
        return this.glenixKey.matchPublicKey(publicKey);
    }

    public Business getBusiness() {
        if (this.glenixTrnXBRLBusinessMasterFile == null) {
            return null;
        }
        return this.glenixTrnXBRLBusinessMasterFile.getBusiness();
    }

    public BusinessMasterFile getBusinessMasterFile() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessMasterFile();
    }

    public String getBusinessLegalName() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessLegalName();
    }

    public String getBusinessTradingName() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessTradingName();
    }

    public String getBusinessDescription() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessDescription();
    }

    public String getBusinessIdentifier() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessIdentifier();
    }

    public String getBusinessABN() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessABN();
    }

    public String getBusinessABNBranch() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessABNBranch();
    }

    public String getBusinessTFN() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getBusinessTFN();
    }

    public String getLedgerStartDate() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getLedgerStartDate();
    }

    public String getLedgerEndDate() {
        Business business = this.getBusiness();
        if (business == null) {
            return null;
        }
        return business.getLedgerEndDate();
    }

    public LocalDate getLedgerStartDateAsDate() {
        String date = this.getLedgerStartDate();
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LocalDate getLedgerEndDateAsDate() {
        String date = this.getLedgerEndDate();
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GlenixFile getNewProfileFile() throws Exception {
        return this.getNewProfileFile("MyProfile");
    }

    public GlenixFile getNewProfileFile(String defaultFileName) throws Exception {
        GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
        gf.openFIDFileCreate(defaultFileName);
        return gf;
    }

    public GlenixFile getNewProfileFileDefaultLocation() throws Exception {
        File file = this.locateNewFASIdentityFile();
        File dir = file.getParentFile();
        if (dir == null) {
            return null;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
        gf.openFIDFileCreate(file);
        return gf;
    }

    public GlenixFile openProfileFile() throws Exception {
        GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
        gf.openProfileFileDoNotCreate("MyFasIdentity.fid");
        return gf;
    }

    public GlenixFile getNewBusinessFile() throws Exception {
        GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
        gf.openFileCreate("MyBusiness.fas");
        this.setGlenixFile(gf);
        this.setTitle(null);
        return gf;
    }

    public void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        this.transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public void unLoadAUSKey() {
        this.glenixAUSKey = null;
    }

    public void loadAUSKey() {
        String ausKeyFileStr = this.getConfigValue("auskey_file", null);
        if (ausKeyFileStr != null && !ausKeyFileStr.isEmpty()) {
            try {
                this.glenixAUSKey = new GlenixAUSKey();
                this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("win") >= 0) {
                String appdata = System.getenv("APPDATA");
                ausKeyFileStr = appdata + "\\AUSkey\\keystore.xml";
                try {
                    this.glenixAUSKey = new GlenixAUSKey();
                    this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                }
                catch (Exception e) {
                    ausKeyFileStr = appdata + "/AUSkey/keystore.xml";
                    try {
                        this.glenixAUSKey = new GlenixAUSKey();
                        this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                    }
                    catch (Exception eee) {
                        eee.printStackTrace();
                    }
                    e.printStackTrace();
                }
            } else if (os.indexOf("mac") >= 0) {
                String home = System.getProperty("user.home");
                ausKeyFileStr = home + "/library/Application Support/AUSkey/keystore.xml";
                try {
                    this.glenixAUSKey = new GlenixAUSKey();
                    this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                }
                catch (Exception e) {
                    ausKeyFileStr = home + "/library/application support/AUSkey/keystore.xml";
                    try {
                        this.glenixAUSKey = new GlenixAUSKey();
                        this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                    }
                    catch (Exception ee) {
                        e.printStackTrace();
                        ee.printStackTrace();
                    }
                }
            } else if (os.indexOf("bsd") >= 0 || os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0 || os.indexOf("sunos") >= 0) {
                String home = System.getProperty("user.home");
                ausKeyFileStr = home + "/AUSkey/keystore.xml";
                try {
                    this.glenixAUSKey = new GlenixAUSKey();
                    this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String appdata = System.getenv("APPDATA");
                ausKeyFileStr = appdata + File.separator + "AUSkey" + File.separator + "keystore.xml";
                try {
                    this.glenixAUSKey = new GlenixAUSKey();
                    this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                }
                catch (Exception e) {
                    String home = System.getProperty("user.home");
                    ausKeyFileStr = home + "/library/Application Support/AUSkey/keystore.xml";
                    try {
                        this.glenixAUSKey = new GlenixAUSKey();
                        this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                    }
                    catch (Exception ee) {
                        ausKeyFileStr = home + "/library/application support/AUSkey/keystore.xml";
                        try {
                            this.glenixAUSKey = new GlenixAUSKey();
                            this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                        }
                        catch (Exception eee) {
                            ausKeyFileStr = home + "/AUSkey/keystore.xml";
                            try {
                                this.glenixAUSKey = new GlenixAUSKey();
                                this.glenixAUSKey.loadAUSKey(ausKeyFileStr);
                            }
                            catch (Exception eeee) {
                                eeee.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        if (this.glenixAUSKey != null) {
            this.glenixAUSKey.setStsurl(this.glenix_STSURL);
            this.glenixAUSKey.setStsurlhost(this.glenix_STSURLHOST);
            this.glenixAUSKey.setProductID(this.glenix_productIDSBR);
            this.glenixAUSKey.setCompanyNameSBR(this.glenix_companyNameSBR);
            this.glenixAUSKey.setSoftwareNameSBR(this.glenix_softwareNameSBR);
            this.glenixAUSKey.setVersionNumberSBR(this.glenix_versionNumberSBR);
            this.glenixAUSKey.setProductName(this.glenix_productName);
            this.glenixAUSKey.setVersionNumber(this.getVersionNumber());
        }
    }

    public GlenixFile loadFASIdentityFile(String filenamepath) {
        try {
            File f = new File(filenamepath);
            if (f.exists() && f.canRead()) {
                GlenixFile gf = new GlenixFile(this.stage, this.getGlenixCodeName());
                gf.openProfileFileDoNotCreate(f);
                Document cdoc = gf.getDocument("profile.xml");
                if (cdoc != null) {
                    return gf;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
        return null;
    }

    public GlenixFile loadFASIdentityFile() {
        String fasIdentityFileStr = this.getConfigValue("fasidentity_file", null);
        if (fasIdentityFileStr != null && !fasIdentityFileStr.isEmpty()) {
            return this.loadFASIdentityFile(fasIdentityFileStr);
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            String appdata = System.getenv("APPDATA");
            fasIdentityFileStr = appdata + "\\FASidentity\\MyFasIdentity.fid";
            GlenixFile gf = this.loadFASIdentityFile(fasIdentityFileStr);
            if (gf != null) {
                return gf;
            }
            fasIdentityFileStr = appdata + "/FASidentity/MyFasIdentity.fid";
            return this.loadFASIdentityFile(fasIdentityFileStr);
        }
        if (os.indexOf("mac") >= 0) {
            String home = System.getProperty("user.home");
            fasIdentityFileStr = home + "/library/Application Support/FASidentity/MyFasIdentity.fid";
            return this.loadFASIdentityFile(fasIdentityFileStr);
        }
        if (os.indexOf("bsd") >= 0 || os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0 || os.indexOf("sunos") >= 0) {
            String home = System.getProperty("user.home");
            fasIdentityFileStr = home + "/FASidentity/MyFasIdentity.fid";
            return this.loadFASIdentityFile(fasIdentityFileStr);
        }
        String appdata = System.getenv("APPDATA");
        fasIdentityFileStr = appdata + File.separator + "FASidentity" + File.separator + "MyFasIdentity.fid";
        GlenixFile gf = this.loadFASIdentityFile(fasIdentityFileStr);
        if (gf != null) {
            return gf;
        }
        String home = System.getProperty("user.home");
        fasIdentityFileStr = home + "/library/Application Support/FASidentity/MyFasIdentity.fid";
        gf = this.loadFASIdentityFile(fasIdentityFileStr);
        if (gf != null) {
            return gf;
        }
        fasIdentityFileStr = home + "/library/application support/FASidentity/MyFasIdentity.fid";
        gf = this.loadFASIdentityFile(fasIdentityFileStr);
        if (gf != null) {
            return gf;
        }
        fasIdentityFileStr = home + "/FASidentity/MyFasIdentity.fid";
        gf = this.loadFASIdentityFile(fasIdentityFileStr);
        if (gf != null) {
            return gf;
        }
        return null;
    }

    private File locateNewFASIdentityFile() throws Exception {
        File dir;
        String fasIdentityFileStr = this.getConfigValue("fasidentity_file", null);
        if (fasIdentityFileStr != null && !fasIdentityFileStr.isEmpty()) {
            File f = new File(fasIdentityFileStr);
            if (f.exists()) {
                throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
            }
            return f;
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            String appdata = System.getenv("APPDATA");
            fasIdentityFileStr = appdata + "\\FASidentity\\MyFasIdentity.fid";
            File f = new File(fasIdentityFileStr);
            if (f.exists()) {
                throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
            }
            return f;
        }
        if (os.indexOf("mac") >= 0) {
            String home = System.getProperty("user.home");
            fasIdentityFileStr = home + "/library/Application Support/FASidentity/MyFasIdentity.fid";
            File f = new File(fasIdentityFileStr);
            if (f.exists()) {
                throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
            }
            return f;
        }
        if (os.indexOf("bsd") >= 0 || os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0 || os.indexOf("sunos") >= 0) {
            String home = System.getProperty("user.home");
            fasIdentityFileStr = home + "/FASidentity/MyFasIdentity.fid";
            File f = new File(fasIdentityFileStr);
            if (f.exists()) {
                throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
            }
            return f;
        }
        String appdata = System.getenv("APPDATA");
        if (appdata != null && !appdata.isEmpty() && (dir = new File(appdata)).exists()) {
            fasIdentityFileStr = appdata + File.separator + "FASidentity" + File.separator + "MyFasIdentity.fid";
            File f = new File(fasIdentityFileStr);
            if (f.exists()) {
                throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
            }
            return f;
        }
        String home = System.getProperty("user.home");
        if (home != null && !home.isEmpty()) {
            String homedir = home + "/library/Application Support";
            File dir2 = new File(homedir);
            if (dir2.exists()) {
                fasIdentityFileStr = home + "/library/Application Support/FASidentity/MyFasIdentity.fid";
                File f = new File(fasIdentityFileStr);
                if (f.exists()) {
                    throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
                }
                return f;
            }
            homedir = home + "/library/application support";
            dir2 = new File(homedir);
            if (dir2.exists()) {
                fasIdentityFileStr = home + "/library/application support/FASidentity/MyFasIdentity.fid";
                File f = new File(fasIdentityFileStr);
                if (f.exists()) {
                    throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
                }
                return f;
            }
            dir2 = new File(home);
            if (dir2.exists()) {
                fasIdentityFileStr = home + "/FASidentity/MyFasIdentity.fid";
                File f = new File(fasIdentityFileStr);
                if (f.exists()) {
                    throw new Exception("Error, the file already exists, refusing to overwrite existing file.");
                }
                return f;
            }
        }
        return null;
    }

    public File locateDownloadedFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            File dir = this.locateDownloadsDirectory();
            if (dir != null && dir.exists()) {
                File result = new File(dir.toPath().toString() + File.separator + fileName);
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isCurrentFile(File testFile) throws Exception {
        if (this.glenixFile == null) {
            return false;
        }
        return this.glenixFile.isThisFile(testFile);
    }

    public File getDownloadedFile(String fileName) {
        String tmpdir;
        if (fileName == null) {
            return null;
        }
        String keep = this.getConfigValue("keep_downloaded_files", "true");
        if (keep == null || !keep.equals("false")) {
            try {
                File dir = this.locateDownloadsDirectory();
                if (dir != null && dir.exists()) {
                    File result = new File(dir.toPath().toString() + File.separator + fileName);
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File file = (tmpdir = System.getProperty("java.io.tmpdir")) != null && !tmpdir.isEmpty() ? new File(tmpdir + "/fas_tmp_" + fileName + ".fas") : new File("fas_tmp_" + fileName + ".fas");
        file.deleteOnExit();
        return file;
    }

    private File locateDownloadsDirectory() throws Exception {
        String downloadsParentDirectoryStr;
        File check;
        File dir;
        String home;
        String appdata;
        String downloadsParentDirectoryStr2;
        File check2;
        String downloadsDirectoryStr = this.getConfigValue("downloads_directory", null);
        File result = null;
        if (downloadsDirectoryStr != null && !downloadsDirectoryStr.isEmpty()) {
            result = new File(downloadsDirectoryStr);
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (result == null && os.indexOf("win") >= 0 && (check2 = new File(downloadsParentDirectoryStr2 = (appdata = System.getenv("APPDATA")) + File.separator + "FASidentity")).exists()) {
            downloadsDirectoryStr = appdata + File.separator + "FASidentity" + File.separator + "Downloads";
            result = new File(downloadsDirectoryStr);
        }
        if (result == null && os.indexOf("mac") >= 0 && (check2 = new File(downloadsParentDirectoryStr2 = (home = System.getProperty("user.home")) + File.separator + "library" + File.separator + "Application Support" + File.separator + "FASidentity")).exists()) {
            downloadsDirectoryStr = home + File.separator + "library" + File.separator + "Application Support" + File.separator + "FASidentity" + File.separator + "Downloads";
            result = new File(downloadsDirectoryStr);
        }
        if (result == null && (os.indexOf("bsd") >= 0 || os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0 || os.indexOf("sunos") >= 0) && (check2 = new File(downloadsParentDirectoryStr2 = (home = System.getProperty("user.home")) + File.separator + "FASidentity")).exists()) {
            downloadsDirectoryStr = home + File.separator + "FASidentity" + File.separator + "Downloads";
            result = new File(downloadsDirectoryStr);
        }
        if (result == null && (appdata = System.getenv("APPDATA")) != null && !appdata.isEmpty() && (dir = new File(appdata)).exists() && (check = new File(downloadsParentDirectoryStr = appdata + File.separator + "FASidentity")).exists()) {
            downloadsDirectoryStr = appdata + File.separator + "FASidentity" + File.separator + "Downloads";
            result = new File(downloadsDirectoryStr);
        }
        if (result == null && (home = System.getProperty("user.home")) != null && !home.isEmpty()) {
            String downloadsParentDirectoryStr3;
            File check3;
            String homedir = home + File.separator + "library" + File.separator + "Application Support";
            File dir2 = new File(homedir);
            if (dir2.exists() && (check3 = new File(downloadsParentDirectoryStr3 = home + File.separator + "library" + File.separator + "Application Support" + File.separator + "FASidentity")).exists()) {
                downloadsDirectoryStr = home + File.separator + "library" + File.separator + "Application Support" + File.separator + "FASidentity" + File.separator + "Downloads";
                result = new File(downloadsDirectoryStr);
            }
            if (result == null) {
                homedir = home + File.separator + "library" + File.separator + "application support";
                dir2 = new File(homedir);
                if (dir2.exists() && (check3 = new File(downloadsParentDirectoryStr3 = home + File.separator + "library" + File.separator + "application support" + File.separator + "FASidentity")).exists()) {
                    downloadsDirectoryStr = home + File.separator + "library" + File.separator + "application support" + File.separator + "FASidentity" + File.separator + "Downloads";
                    result = new File(downloadsDirectoryStr);
                }
                if (result == null && (dir2 = new File(home)).exists() && (check3 = new File(downloadsParentDirectoryStr3 = home + File.separator + "FASidentity")).exists()) {
                    downloadsDirectoryStr = home + File.separator + "FASidentity" + File.separator + "Downloads";
                    result = new File(downloadsDirectoryStr);
                }
            }
        }
        if (result != null && !result.exists()) {
            Files.createDirectories(result.toPath(), new FileAttribute[0]);
        }
        return result;
    }

    public List<GlenixElement> getAUSKeyCredentialList() throws Exception {
        if (this.glenixAUSKey == null) {
            this.loadAUSKey();
        }
        if (this.glenixAUSKey == null) {
            throw new Exception("Error unable to load AUS key");
        }
        return this.glenixAUSKey.getCredentialList();
    }

    public void loadAUSKeyCredential(String credentialID) throws Exception {
        this.glenixAUSKey.loadCredential(credentialID);
    }

    public void unprotectAUSKeyCredentialPrivateKey(String password) throws Exception {
        this.glenixAUSKey.unprotectPrivateKey(password.toCharArray());
    }

    public void reprotectAUSKeyCredentialPrivateKey() {
        this.glenixAUSKey.reprotectPrivateKey();
    }

    public void extractAUSKeyCredentialX509Certificate() throws Exception {
        this.glenixAUSKey.extractX509Certificate();
    }

    public org.w3c.dom.Node buildAndSendSTSDocument() throws Exception {
        return this.glenixAUSKey.buildAndSendSTSDocument(this.glenix_STSURL, this.glenix_STSEndpointRef);
    }

    public MessageDigest calculateSHA1DigestBytes(byte[] bytes) throws Exception {
        if (this.glenixAUSKey == null) {
            return this.glenixKey.calcDigestBytes(bytes, "SHA-1");
        }
        return this.glenixAUSKey.calcDigestBytes(bytes, "SHA-1");
    }

    public MessageDigest calculateSHA1Digest(Element element) throws Exception {
        if (this.glenixAUSKey == null) {
            return this.glenixKey.calcDigest(element, "SHA-1");
        }
        return this.glenixAUSKey.calcDigest(element, "SHA-1");
    }

    public MessageDigest calculateSHA1DigestInclusive(Element element) throws Exception {
        if (this.glenixAUSKey == null) {
            return this.glenixKey.calcDigestInclusive(element, "SHA-1");
        }
        return this.glenixAUSKey.calcDigestInclusive(element, "SHA-1");
    }

    public MessageDigest calculateSHA1Digest(String dataSource) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Error, cannot calc digest on data source have not unlocked key");
        }
        if (this.glenixFile == null) {
            throw new Exception("Error, cannot calc digest on data source have opened file");
        }
        InputStream dataSourceInputStream = this.glenixFile.readAndDecryptDataSource(dataSource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        if (dataSourceInputStream == null) {
            throw new Exception("Error, cannot find data source " + dataSource);
        }
        return this.glenixKey.calcDigest(dataSourceInputStream, "SHA-1");
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    protected GlenixSBRResponse sendDocumentToURL(String url, String service, String actionCode, ArrayList<GlenixSBRAttachment> attachments) throws Exception {
        String id;
        BusinessMasterFile bmf;
        if (this.profileXBRL == null) {
            throw new Exception("Cannot lodge profile is not set");
        }
        if (this.glenixKey == null) {
            throw new Exception("Cannot lodge profile certificate is not set");
        }
        String commonName = "";
        String prefix = "";
        String tmp = this.profileXBRL.getFirstName();
        if (tmp != null && !tmp.isEmpty()) {
            commonName = commonName + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getOtherGivenNames()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getLastName()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
        }
        commonName = commonName.trim();
        MessageDetails md = this.glenixKey.newMessageDetails();
        md.setService(service);
        md.setAction(actionCode);
        if (attachments != null) {
            for (int i = 0; i < attachments.size(); ++i) {
                md.addAttachment(attachments.get(i));
            }
        }
        if (this.glenixTrnXBRLBusinessMasterFile != null && (bmf = this.glenixTrnXBRLBusinessMasterFile.getBusinessMasterFile()) != null && (id = bmf.getBusinessIdentifier()) != null) {
            md.setPropBusinessIdentifier(id);
        }
        String messageId = this.generateMessageIdentifier();
        Document doc = this.glenixKey.buildOtherSoapDocument(messageId, this.glenix_soap_legal_name_identifier, commonName, this.glenix_soap_user_role_identifier, this.glenix_dspIdentifierType, this.glenix_dspABN, this.glenix_dspRole, md);
        return this.glenixKey.dorequest_lodge_apache(url, doc, md.getAttachments(), null);
    }

    protected GlenixSBRResponse sendDocumentToFAS(String service, String actionCode, ArrayList<GlenixSBRAttachment> attachments) throws Exception {
        return this.sendDocumentToURL(this.glenix_fasSoapURL, service, actionCode, attachments);
    }

    protected GlenixSBRResponse sendDocumentToURL(String url, String service, String actionCode, GlenixSBRAttachment attachment) throws Exception {
        if (this.profileXBRL == null) {
            throw new Exception("Cannot lodge profile is not set");
        }
        if (this.glenixKey == null) {
            throw new Exception("Cannot lodge profile certificate is not set");
        }
        MessageDetails md = this.glenixKey.newMessageDetails();
        md.setService(service);
        md.setAction(actionCode);
        if (attachment != null) {
            md.addAttachment(attachment);
        }
        return this.sendDocumentToURL(url, md);
    }

    protected GlenixSBRResponse sendDocumentToFAS(String service, String actionCode, GlenixSBRAttachment attachment) throws Exception {
        return this.sendDocumentToURL(this.glenix_fasSoapURL, service, actionCode, attachment);
    }

    protected GlenixSBRResponse sendDocumentToURL(String url, MessageDetails messageDetails) throws Exception {
        if (this.profileXBRL == null) {
            throw new Exception("Cannot lodge profile is not set");
        }
        if (this.glenixKey == null) {
            throw new Exception("Cannot lodge profile certificate is not set");
        }
        String commonName = "";
        String prefix = "";
        String tmp = this.profileXBRL.getFirstName();
        if (tmp != null && !tmp.isEmpty()) {
            commonName = commonName + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getOtherGivenNames()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getLastName()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
        }
        commonName = commonName.trim();
        String messageId = this.generateMessageIdentifier();
        Document doc = this.glenixKey.buildOtherSoapDocument(messageId, this.glenix_soap_legal_name_identifier, commonName, this.glenix_soap_user_role_identifier, this.glenix_dspIdentifierType, this.glenix_dspABN, this.glenix_dspRole, messageDetails);
        return this.glenixKey.dorequest_lodge_apache(url, doc, messageDetails.getAttachments(), null);
    }

    protected GlenixSBRResponse sendDocumentToFAS(MessageDetails messageDetails) throws Exception {
        return this.sendDocumentToURL(this.glenix_fasSoapURL, messageDetails);
    }

    protected GlenixResult sendDocumentToURLResult(String url, String service, String actionCode, ArrayList<GlenixSBRAttachment> attachments) throws Exception {
        GlenixSBRResponse glenixSBRResponse = this.sendDocumentToURL(url, service, actionCode, attachments);
        glenixSBRResponse.parseResponse();
        glenixSBRResponse.resetPartIterator();
        while (glenixSBRResponse.hasNextPart()) {
            String href = glenixSBRResponse.nextPartHref();
            if (href == null) continue;
            Document doc = glenixSBRResponse.getDocumentByHref(href);
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(doc, doc.getDocumentElement());
            return gr;
        }
        return null;
    }

    protected GlenixResult sendDocumentToFASResult(String service, String actionCode, ArrayList<GlenixSBRAttachment> attachments) throws Exception {
        return this.sendDocumentToURLResult(this.glenix_fasSoapURL, service, actionCode, attachments);
    }

    protected GlenixResult sendDocumentToURLResult(String url, String service, String actionCode, GlenixSBRAttachment attachment) throws Exception {
        GlenixSBRResponse glenixSBRResponse = this.sendDocumentToURL(url, service, actionCode, attachment);
        glenixSBRResponse.parseResponse();
        glenixSBRResponse.resetPartIterator();
        while (glenixSBRResponse.hasNextPart()) {
            String href = glenixSBRResponse.nextPartHref();
            if (href == null) continue;
            Document doc = glenixSBRResponse.getDocumentByHref(href);
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(doc, doc.getDocumentElement());
            return gr;
        }
        return null;
    }

    protected GlenixResult sendDocumentToFASResult(String service, String actionCode, GlenixSBRAttachment attachment) throws Exception {
        return this.sendDocumentToURLResult(this.glenix_fasSoapURL, service, actionCode, attachment);
    }

    public byte[] getMyBusinessFasFileBytes() throws Exception {
        if (this.profileXBRL == null) {
            throw new Exception("Cannot get my business file, profile is not set");
        }
        if (this.glenixKey == null) {
            throw new Exception("Cannot get my business file, profile certificate is not set");
        }
        if (this.glenixFile == null) {
            throw new Exception("Cannot get my business file, file is not set");
        }
        return this.glenixFile.getFullFileBytes();
    }

    protected GlenixSBRResponse sendVersionCheckDocument(String messageId) throws Exception {
        GlenixAUSKey versionCheckKey = new GlenixAUSKey();
        versionCheckKey.setProductName(this.glenix_productName);
        versionCheckKey.setVersionNumber(this.getVersionNumber());
        MessageDetails md = versionCheckKey.newMessageDetails();
        md.setPropABN("UNKNOWN");
        md.setService(this.glenix_soap_service_version);
        md.setAction(this.glenix_soap_action_submit);
        Document doc = versionCheckKey.buildOtherSoapDocument(messageId, this.glenix_soap_legal_name_identifier, "UNKNOWN", this.glenix_soap_user_role_identifier, this.glenix_dspIdentifierType, this.glenix_dspABN, this.glenix_dspRole, md);
        return versionCheckKey.dorequest_lodge_apache(this.glenix_fasSoapURL, doc, null, null);
    }

    protected GlenixSBRResponse sendUsageDocument(String tan, String agentABN, String abn, String wpn, String service, String actionCode, String messageId, String trMessageId, String timestamp, int recordCount) throws Exception {
        if (this.profileXBRL == null) {
            throw new Exception("Cannot lodge profile is not set");
        }
        if (this.glenixKey == null) {
            throw new Exception("Cannot lodge profile certificate is not set");
        }
        String commonName = "";
        String prefix = "";
        String tmp = this.profileXBRL.getFirstName();
        if (tmp != null && !tmp.isEmpty()) {
            commonName = commonName + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getOtherGivenNames()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getLastName()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
        }
        commonName = commonName.trim();
        MessageDetails md = this.glenixKey.newMessageDetails();
        md.setPropTAN(tan);
        md.setPropAgentABN(agentABN);
        md.setPropABN(abn);
        md.setPropWPN(wpn);
        md.setService(this.glenix_soap_service_usage);
        md.setAction(this.glenix_soap_action_submit);
        md.setPropService(service);
        md.setPropAction(actionCode);
        if (service != null) {
            if (service.equals("http://sbr.gov.au/ato/tfnd/2017")) {
                int employeeCount = this.getEmployeeCount();
                md.setPropRecordCount(employeeCount);
            } else if (service.equals("http://sbr.gov.au/ato/payevnt/2018")) {
                md.setPropRecordCount(recordCount);
            }
        }
        Document doc = this.glenixKey.buildOtherSoapDocument(messageId, this.glenix_soap_legal_name_identifier, commonName, this.glenix_soap_user_role_identifier, this.glenix_dspIdentifierType, this.glenix_dspABN, this.glenix_dspRole, md);
        return this.glenixKey.dorequest_lodge_apache(this.glenix_fasSoapURL, doc, null, null);
    }

    public GlenixResult doVersionCheck(String messageId) {
        try {
            GlenixSBRResponse versionResponse = this.sendVersionCheckDocument(messageId);
            versionResponse.parseResponse();
            versionResponse.resetPartIterator();
            while (versionResponse.hasNextPart()) {
                String href = versionResponse.nextPartHref();
                if (href == null) continue;
                Document doc = versionResponse.getDocumentByHref(href);
                GlenixResult gr = new GlenixResult();
                gr.loadDocumentElement(doc, doc.getDocumentElement());
                return gr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public GlenixResult doUsageCheck(String tan, String agentABN, String abn, String wpn, String service, String actionCode, String messageId, String trMessageId, String timestamp, int recordCount) {
        try {
            GlenixSBRResponse usageResponse = this.sendUsageDocument(tan, agentABN, abn, wpn, service, actionCode, messageId, trMessageId, timestamp, recordCount);
            usageResponse.parseResponse();
            usageResponse.resetPartIterator();
            while (usageResponse.hasNextPart()) {
                String href = usageResponse.nextPartHref();
                if (href == null) continue;
                Document doc = usageResponse.getDocumentByHref(href);
                GlenixResult gr = new GlenixResult();
                gr.loadDocumentElement(doc, doc.getDocumentElement());
                return gr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlenixSBRResponse buildAndSendLodgeDocument(org.w3c.dom.Node encryptedDataNode, String tan, String agentABN, String abn, String wpn, String tfn, String service, String action, String messageId, String timestamp, ArrayList<GlenixSBRAttachment> gattl, String logfilename) throws Exception {
        String log_sbr_lodgements = this.getConfigValue("log_sbr_lodgements", "false");
        OutputStream logfileOutputStream = null;
        try {
            GlenixSBRResponse response;
            if (log_sbr_lodgements != null && log_sbr_lodgements.equals("true") && logfilename != null) {
                logfileOutputStream = this.glenixFile.getEncryptedOutputStream(logfilename);
            }
            GlenixSBRResponse glenixSBRResponse = response = this.glenixAUSKey.buildAndSendLodgeDocument(this.glenix_SingleSyncURL, encryptedDataNode, tan, agentABN, abn, wpn, tfn, service, action, messageId, timestamp, gattl, logfileOutputStream);
            return glenixSBRResponse;
        }
        finally {
            if (logfileOutputStream != null) {
                logfileOutputStream.flush();
                logfileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlenixSBRResponse buildAndSendLodgeDocumentBatchGzip(org.w3c.dom.Node encryptedDataNode, String tan, String agentABN, String abn, String wpn, String tfn, String service, String action, String messageId, String timestamp, ArrayList<GlenixSBRAttachment> gattl, String logfilename) throws Exception {
        String log_sbr_lodgements = this.getConfigValue("log_sbr_lodgements", "false");
        OutputStream logfileOutputStream = null;
        try {
            GlenixSBRResponse response;
            if (log_sbr_lodgements != null && log_sbr_lodgements.equals("true") && logfilename != null) {
                logfileOutputStream = this.glenixFile.getEncryptedOutputStream(logfilename);
            }
            GlenixSBRResponse glenixSBRResponse = response = this.glenixAUSKey.buildAndSendLodgeDocumentBatchGzip(this.glenix_BatchAsyncPushURL, encryptedDataNode, tan, agentABN, abn, wpn, tfn, service, action, messageId, timestamp, gattl, logfileOutputStream);
            return glenixSBRResponse;
        }
        finally {
            if (logfileOutputStream != null) {
                logfileOutputStream.flush();
                logfileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlenixSBRResponse buildAndSendPullDocument(org.w3c.dom.Node encryptedDataNode, String refToMessageId, String messageId, String timestamp, String logfilename) throws Exception {
        String log_sbr_lodgements = this.getConfigValue("log_sbr_lodgements", "false");
        OutputStream logfileOutputStream = null;
        try {
            if (log_sbr_lodgements != null && log_sbr_lodgements.equals("true") && logfilename != null) {
                logfileOutputStream = this.glenixFile.getEncryptedOutputStream(logfilename);
            }
            GlenixSBRResponse response = this.glenixAUSKey.buildAndSendPullDocument(this.glenix_BatchAsyncPullURL, encryptedDataNode, refToMessageId, messageId, timestamp, logfileOutputStream);
            if (logfileOutputStream != null) {
                logfileOutputStream.flush();
                logfileOutputStream.close();
            }
            GlenixSBRResponse glenixSBRResponse = response;
            return glenixSBRResponse;
        }
        finally {
            if (logfileOutputStream != null) {
                logfileOutputStream.flush();
                logfileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInputStream(InputStream inputStream, String logfilename) throws Exception {
        String log_sbr_lodgements = this.getConfigValue("log_sbr_lodgements", "false");
        try (OutputStream logfileOutputStream = null;){
            if (log_sbr_lodgements != null && log_sbr_lodgements.equals("true") && logfilename != null) {
                logfileOutputStream = this.glenixFile.getEncryptedOutputStream(logfilename);
            }
            if (logfileOutputStream != null) {
                int readlen = 0;
                byte[] readbytes = new byte[2000];
                while ((readlen = inputStream.read(readbytes)) > 0) {
                    logfileOutputStream.write(readbytes, 0, readlen);
                }
                logfileOutputStream.flush();
            }
        }
    }

    public void printInputStream(InputStream inputStream) throws Exception {
        int readlen = 0;
        byte[] readbytes = new byte[2000];
        System.out.println("PRINT INPUT STREAM START:");
        while ((readlen = inputStream.read(readbytes)) > 0) {
            System.out.print("Start:");
            System.out.print(new String(readbytes, 0, readlen));
            System.out.println(":End");
        }
    }

    public void deleteFile(String filePathString) throws Exception {
        if (filePathString == null || filePathString.isEmpty()) {
            return;
        }
        this.glenixFile.deleteFile(filePathString);
        this.glenixFile.forceSaveNow();
    }

    public void deleteSelectedFiles(ObservableList<Path> selectedFiles) throws Exception {
        if (selectedFiles == null || selectedFiles.size() == 0) {
            return;
        }
        for (Path path : selectedFiles) {
            this.glenixFile.deleteFile(path.toString());
        }
        this.glenixFile.forceSaveNow();
    }

    public void saveActivityStatementList(ActivityStatementList activityStatementList) throws Exception {
        Document asldoc = this.glenixTrnXBRLActivityStatementList.buildDocument();
        this.saveFileEncrypt("activityStatementList.xml", asldoc);
    }

    public void saveActivityStatementList(ActivityStatementList activityStatementList, ASLStatement aslStatement) throws Exception {
        Document asldoc = this.glenixTrnXBRLActivityStatementList.buildDocument();
        this.saveFileEncrypt("activityStatementList.xml", asldoc);
    }

    public GlenixSBRResponse saveActivityStatementListDownload(ActivityStatementList activityStatementList) throws Exception {
        throw new Exception("Save activity statement list and download is not implemented in fas desktop");
    }

    public GlenixSBRResponse saveActivityStatementListDownload(GlenixTrnXBRL activityStatementXBRL) throws Exception {
        throw new Exception("Save activity statement list and download is not implemented in fas desktop");
    }

    public GlenixSBRResponse saveAndPrelodgeActivityStatement(GlenixTrnXBRL activityStatementXBRL) throws Exception {
        throw new Exception("Save and prelodge activity statement is not implemented in fas desktop");
    }

    public GlenixSBRResponse saveAndLodgeActivityStatement(GlenixTrnXBRL activityStatementXBRL) throws Exception {
        throw new Exception("Save and lodge activity statement is not implemented in fas desktop");
    }

    public GlenixSBRResponse saveAndLodgeSTPBatch(Transaction batchTransaction) throws Exception {
        throw new Exception("Save and lodge STP batch is not implemented in fas desktop");
    }

    public GlenixSBRResponse saveAndUpdateSTPBatch(Transaction batchTransaction) throws Exception {
        throw new Exception("Save and update STP batch is not implemented in fas desktop");
    }

    public GlenixSBRResponse pullMessagesSTPBatch(Transaction batchTransaction) throws Exception {
        throw new Exception("Pull messages STP batch is not implemented in fas desktop");
    }

    public GlenixSBRResponse saveFileEncryptGetResponse(String dataSource, Document savedoc) throws Exception {
        throw new Exception("Save file encrypt get response is not implemented in fas desktop");
    }

    public void loadTransactions() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load transactions.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load transactions.xml");
        }
        Document trndoc = null;
        try {
            trndoc = this.getDocumentDecrypt("transactions.xml");
        }
        catch (NoSuchFileException nsfe) {
            trndoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            trndoc = null;
        }
        this.glenixTrnXBRLTransactions = new GlenixTrnXBRL();
        if (trndoc == null) {
            this.glenixTrnXBRLTransactions.initBusiness();
        } else {
            try {
                this.glenixTrnXBRLTransactions.loadDocumentElement(trndoc, trndoc.getDocumentElement());
                ArrayList<Transaction> ts = this.glenixTrnXBRLTransactions.getTransactionArrayList();
                for (Transaction t : ts) {
                    t.assignUUIDToTransactionNumber();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.glenixTrnXBRLTransactions.initBusiness();
                throw e;
            }
        }
    }

    public GlenixTrnXBRL getTransactions() throws Exception {
        if (this.glenixTrnXBRLTransactions == null) {
            this.loadTransactions();
        }
        return this.glenixTrnXBRLTransactions;
    }

    public GlenixTrnXBRL getTransactions(String counterpartyIdentifier, LocalDate transactionDate) throws Exception {
        if (this.glenixTrnXBRLTransactions == null) {
            this.loadTransactions();
        }
        return this.glenixTrnXBRLTransactions;
    }

    public GlenixTrnXBRL getTransactions(String batchIdentifier) throws Exception {
        if (this.glenixTrnXBRLTransactions == null) {
            this.loadTransactions();
        }
        return this.glenixTrnXBRLTransactions;
    }

    public GlenixTrnXBRL getTransactionsForHomeOffice(String homeOfficeIdentifier) throws Exception {
        if (this.glenixTrnXBRLTransactions == null) {
            this.loadTransactions();
        }
        return this.glenixTrnXBRLTransactions;
    }

    /*
     * Exception decompiling
     */
    @FXML
    public void gotoTransactions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void loadTransactionsVBox(TransactionsTableVBox vbox) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gotoSalesTransactionsE(Transaction editTransaction) throws Exception {
        if (this.transactionsTableSalesVBox == null) {
            this.transactionsTableSalesVBox = new TransactionsTableSalesVBox(this);
        }
        this.loadTransactionsVBox(this.transactionsTableSalesVBox);
        this.transactionsTableSalesVBox.clearTransaction();
        this.transactionsTableSalesVBox.setTransaction(editTransaction);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.transactionsTableSalesVBox);
        this.transactionsTableSalesVBox.updateFilter();
        this.transactionsTableSalesVBox.refreshTable();
    }

    @FXML
    public void gotoSalesTransactions() {
        try {
            this.gotoSalesTransactionsE(null);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public void gotoASTransactions(String asNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArrayList<Transaction.TransactionTransactionLine> markActivityStatementTransactions(String asNumber, ArrayList<String> asNumberList, LocalDate startDate, LocalDate endDate, ArrayList<String> gsttaxes, LocalDate paySlipStartDate, LocalDate paySlipEndDate, ArrayList<String> paygwtaxes) throws Exception {
        if (this.glenixTrnXBRLTransactions == null) {
            this.loadTransactions();
        }
        Business b = this.glenixTrnXBRLTransactions.getBusiness();
        return b.markActivityStatement(asNumber, asNumberList, startDate, endDate, gsttaxes, paySlipStartDate, paySlipEndDate, paygwtaxes);
    }

    public ArrayList<Transaction.TransactionTransactionLine> removeActivityStatementTransactions(String asNumber, String splitCsv) throws Exception {
        throw new Exception("Error, removeActivityStatementTransactions not implemented in desktop version");
    }

    public ArrayList<Transaction.TransactionTransactionLine> getActivityStatementTransactions(String asNumber) throws Exception {
        Business business;
        if (asNumber == null || asNumber.isEmpty()) {
            throw new Exception("AS number not set in get activity statement transactions.");
        }
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot get activity statement transactions");
        }
        if (this.glenixKey == null) {
            throw new Exception("FAS identity not opened cannot get activity statement transactions");
        }
        if (this.glenixTrnXBRLTransactions == null) {
            try {
                this.loadTransactions();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.glenixTrnXBRLTransactions != null && (business = this.glenixTrnXBRLTransactions.getBusiness()) != null) {
            ArrayList<Transaction.TransactionTransactionLine> transactionTransactionLineArrayList = null;
            if (business != null && asNumber != null && !asNumber.isEmpty()) {
                ArrayList<String> asNumberList = new ArrayList<String>();
                String originalASNumber = asNumber;
                while (originalASNumber != null && !originalASNumber.isEmpty()) {
                    ActivityStatement oas;
                    asNumberList.add(originalASNumber);
                    GlenixTrnXBRL oASXBRL = this.loadActivityStatement(originalASNumber);
                    originalASNumber = null;
                    if (oASXBRL == null || (oas = oASXBRL.getActivityStatement()) == null) continue;
                    originalASNumber = oas.getOriginalActivityStatementNumber();
                }
                transactionTransactionLineArrayList = business.getASTransactionTransactionLineArrayList(asNumberList);
            }
            return transactionTransactionLineArrayList;
        }
        return null;
    }

    public void gotoOtherPurchasesTransactionsE(Transaction editTransaction) throws Exception {
        if (this.transactionsTableOtherPurchasesVBox == null) {
            this.transactionsTableOtherPurchasesVBox = new TransactionsTableOtherPurchasesVBox(this);
        }
        this.loadTransactionsVBox(this.transactionsTableOtherPurchasesVBox);
        this.transactionsTableOtherPurchasesVBox.clearTransaction();
        this.transactionsTableOtherPurchasesVBox.setTransaction(editTransaction);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.transactionsTableOtherPurchasesVBox);
        this.transactionsTableOtherPurchasesVBox.updateFilter();
        this.transactionsTableOtherPurchasesVBox.refreshTable();
    }

    @FXML
    public void gotoOtherPurchasesTransactions() {
        try {
            this.gotoOtherPurchasesTransactionsE(null);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoHomeOfficeTransactionsE(Transaction editTransaction, HomeOffice homeOffice) throws Exception {
        if (this.transactionsTableHomeOfficeVBox == null) {
            this.transactionsTableHomeOfficeVBox = new TransactionsTableHomeOfficeVBox(this);
        }
        this.loadTransactionsVBox(this.transactionsTableHomeOfficeVBox);
        this.transactionsTableHomeOfficeVBox.clearTransaction();
        this.transactionsTableHomeOfficeVBox.setTransaction(editTransaction);
        homeOffice = this.getHomeOffice(homeOffice);
        this.transactionsTableHomeOfficeVBox.setHomeOffice(homeOffice);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.transactionsTableHomeOfficeVBox);
        this.transactionsTableHomeOfficeVBox.updateFilter();
        this.transactionsTableHomeOfficeVBox.refreshTable();
    }

    public void gotoHomeOfficeTransactionsE(Transaction editTransaction, String homeOfficeIdentifier) throws Exception {
        Transaction hot = this.getHomeOfficeTransaction(homeOfficeIdentifier);
        if (hot == null) {
            throw new Exception("Error, home office not found for the specified home office identifier");
        }
        HomeOffice ho = hot.getHomeOffice();
        if (ho == null) {
            throw new Exception("Error, home office not found for the specified home office identifier");
        }
        this.gotoHomeOfficeTransactionsE(editTransaction, ho);
    }

    public void gotoFuelTaxCreditTransactionsE(Transaction editTransaction, FuelTaxCredit fuelTaxCredit) throws Exception {
        if (this.transactionsTableFuelTaxCreditVBox == null) {
            this.transactionsTableFuelTaxCreditVBox = new TransactionsTableFuelTaxCreditVBox(this);
        }
        this.loadTransactionsVBox(this.transactionsTableFuelTaxCreditVBox);
        this.transactionsTableFuelTaxCreditVBox.clearTransaction();
        this.transactionsTableFuelTaxCreditVBox.setTransaction(editTransaction);
        this.transactionsTableFuelTaxCreditVBox.setFuelTaxCredit(fuelTaxCredit);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.transactionsTableFuelTaxCreditVBox);
        this.transactionsTableFuelTaxCreditVBox.updateFilter();
        this.transactionsTableFuelTaxCreditVBox.refreshTable();
    }

    public void gotoFuelTaxCreditTransactionsE(Transaction editTransaction, String fuelTaxCreditIdentifier) throws Exception {
        Transaction hot = this.getFuelTaxCreditTransaction(fuelTaxCreditIdentifier);
        if (hot == null) {
            throw new Exception("Error, fuel tax credit not found for the specified fuel tax credit identifier");
        }
        FuelTaxCredit ho = hot.getFuelTaxCredit();
        if (ho == null) {
            throw new Exception("Error, fuel tax credit not found for the specified fuel tax credit identifier");
        }
        this.gotoFuelTaxCreditTransactionsE(editTransaction, ho);
    }

    /*
     * Exception decompiling
     */
    public void gotoImportDataTransactionsE(Transaction editTransaction, List importDataTransactions, Transaction importDataTransaction) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FXML
    public void gotoPaySlipsTransactions() {
        try {
            if (this.transactionsTablePaySlipsVBox == null) {
                this.transactionsTablePaySlipsVBox = new TransactionsTablePaySlipsVBox(this);
            }
            this.loadTransactionsVBox(this.transactionsTablePaySlipsVBox);
            this.transactionsTablePaySlipsVBox.clearTransaction();
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.transactionsTablePaySlipsVBox);
            this.transactionsTablePaySlipsVBox.updateFilter();
            this.transactionsTablePaySlipsVBox.refreshTable();
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @FXML
    public void gotoTrashTransactions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArrayList<Transaction> getBatchTransactions(Transaction batchTransaction) throws Exception {
        if (batchTransaction == null) {
            return null;
        }
        String batchIdentifier = batchTransaction.getBatchIdentifier();
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            return null;
        }
        GlenixTrnXBRL trns = this.getTransactions();
        if (trns == null) {
            return null;
        }
        Business b = trns.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getTransactionArrayListByBatch(batchIdentifier);
    }

    /*
     * Exception decompiling
     */
    @FXML
    public void gotoBatchTransactions(Transaction batchTransaction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadBatches() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load batch.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load batch.xml");
        }
        Document batdoc = null;
        try {
            batdoc = this.getDocumentDecrypt("batch.xml");
        }
        catch (NoSuchFileException nsfe) {
            batdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            batdoc = null;
        }
        this.glenixTrnXBRLBatches = new GlenixTrnXBRL();
        if (batdoc == null) {
            this.glenixTrnXBRLBatches.initBusiness();
        } else {
            try {
                this.glenixTrnXBRLBatches.loadDocumentElement(batdoc, batdoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.glenixTrnXBRLBatches.initBusiness();
                throw e;
            }
        }
    }

    public GlenixTrnXBRL getBatches() throws Exception {
        if (this.glenixTrnXBRLBatches == null) {
            this.loadBatches();
        }
        return this.glenixTrnXBRLBatches;
    }

    @FXML
    public void gotoBatches() {
        try {
            if (this.batchTableVBox == null) {
                this.batchTableVBox = new BatchTableVBox(this);
            }
            this.batchTableVBox.setModel(this.getBatches());
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.batchTableVBox);
            this.batchTableVBox.refreshTable();
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoBatchEdit(Transaction batchTransaction) throws Exception {
        if (this.batchEditVBox == null) {
            this.batchEditVBox = new BatchEditVBox(this);
        }
        if (batchTransaction == null) {
            this.batchEditVBox.setBatchTransactionElement(null);
            this.batchEditVBox.clearBatchTransaction();
        } else {
            Document cdoc = batchTransaction.buildDocument();
            this.batchEditVBox.loadGlenixXBRL(cdoc, cdoc.getDocumentElement());
            this.batchEditVBox.setBatchTransactionElement(batchTransaction);
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.batchEditVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoBatchSTPLodge(Transaction batchTransaction) throws Exception {
        if (batchTransaction == null) {
            throw new Exception("Error, need to create a batch before you can lodge it as a Single Touch Payroll batch.");
        }
        if (this.batchSTPLodgeVBox == null) {
            this.batchSTPLodgeVBox = new BatchSTPLodgeVBox(this);
        }
        this.batchSTPLodgeVBox.setBatchTransactionElement(batchTransaction);
        BusinessMasterFile businessMasterFile = this.glenixTrnXBRLBusinessMasterFile.getBusinessMasterFile();
        this.batchSTPLodgeVBox.setBusinessDetails(businessMasterFile);
        this.batchSTPLodgeVBox.setProfileDetails(this.profileXBRL);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.batchSTPLodgeVBox);
        this.setStatusBarMessage(null);
    }

    public void printTransactionsDocument() throws Exception {
        if (this.glenixTrnXBRLTransactions == null) {
            System.out.println("Transactions document is null");
        }
        Document doc = this.glenixTrnXBRLTransactions.buildDocument();
        this.printDocument(doc, System.out);
    }

    public Transaction addTransaction() throws Exception {
        Transaction transaction = new Transaction();
        this.assignUUIDToTransactionNumber(transaction);
        return transaction;
    }

    public Transaction addBatchTransaction() throws Exception {
        return this.glenixTrnXBRLBatches.addBlankTransaction();
    }

    public Transaction getBatchTransaction(String batchIdentifier) throws Exception {
        if (this.glenixTrnXBRLBatches == null) {
            this.loadBatches();
        }
        if (this.glenixTrnXBRLBatches == null) {
            return null;
        }
        return this.glenixTrnXBRLBatches.getBatchTransaction(batchIdentifier);
    }

    public void deleteSelectedBatches(ObservableList<Transaction> selectedBatchTransactions) throws Exception {
        if (selectedBatchTransactions == null || selectedBatchTransactions.size() == 0) {
            return;
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction at : selectedBatchTransactions) {
            String batchStatus = at.getBatchStatus();
            if (batchStatus != null && !batchStatus.equals("created")) {
                throw new Exception("Error, cannot delete batch " + at.getBatchComment() + " because it has status " + batchStatus);
            }
            String ai = at.getBatchIdentifier();
            if (ai == null) continue;
            ais.add(ai);
            if (!trns.usesBatchIdentifier(ai)) continue;
            throw new Exception("Error, cannot delete batch " + at.getBatchComment() + " because it has a transaction");
        }
        GlenixTrnXBRL accs = this.getBatches();
        if (accs == null) {
            throw new Exception("Error, cannot delete batches, unable to load the batch list");
        }
        for (String ai : ais) {
            accs.deleteBatch(ai);
        }
    }

    public void saveTransactionList() throws Exception {
        Document trndoc = this.glenixTrnXBRLTransactions.buildDocument();
        this.saveFileEncrypt("transactions.xml", trndoc);
    }

    public void saveTransactions(Set<Transaction> transactions) throws Exception {
        GlenixTrnXBRL gtrn = this.getTransactions();
        if (gtrn == null) {
            throw new Exception("Error, cannot get transaction list");
        }
        Set<Transaction> newtrns = gtrn.getTransactionsNew(transactions);
        if (newtrns.size() > 0) {
            gtrn.addTransactions(newtrns);
        }
        try {
            this.saveTransactionList();
        }
        catch (Exception e) {
            Business b;
            if (newtrns.size() > 0 && (b = gtrn.getBusiness()) != null) {
                b.removeTransactions(newtrns);
            }
            throw e;
        }
    }

    public void saveTransactions(Collection<Transaction> transactions) throws Exception {
        if (transactions == null) {
            return;
        }
        HashSet<Transaction> trns = new HashSet<Transaction>();
        for (Transaction t : transactions) {
            trns.add(t);
        }
        if (trns.size() > 0) {
            this.saveTransactions((Set<Transaction>)trns);
        }
    }

    public void saveTransaction(Transaction transaction) throws Exception {
        HashSet<Transaction> transactions = new HashSet<Transaction>();
        if (transaction != null) {
            transactions.add(transaction);
        }
        this.saveTransactions((Set<Transaction>)transactions);
    }

    public void saveTransactionCacheHomeOffice(Transaction transaction, String homeOfficeIdentifier) throws Exception {
        this.saveTransaction(transaction);
    }

    public void saveBatch(Transaction batchTransaction) throws Exception {
        Document batdoc = this.glenixTrnXBRLBatches.buildDocument();
        this.saveFileEncrypt("batch.xml", batdoc);
    }

    public void saveBatches() throws Exception {
        Document batdoc = this.glenixTrnXBRLBatches.buildDocument();
        this.saveFileEncrypt("batch.xml", batdoc);
    }

    /*
     * Exception decompiling
     */
    public void gotoTransactionEdit(Transaction transaction) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gotoBatchPaySlipEdit(Transaction transaction, String batchIdentifier) throws Exception {
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            throw new Exception("Error, batch identifier not set cannot go to transaction edit page.");
        }
        GlenixTrnXBRL bats = this.getBatches();
        if (bats == null) {
            throw new Exception("Error, cannot get batches.");
        }
        Transaction b = bats.getBatchTransaction(batchIdentifier);
        if (b == null) {
            throw new Exception("Error, cannot find batch, cannot go to transaction edit page.");
        }
        this.gotoBatchPaySlipEdit(transaction, b);
    }

    public void gotoBatchTransactionEdit(Transaction transaction, String batchIdentifier) throws Exception {
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            throw new Exception("Error, batch identifier not set cannot go to transaction edit page.");
        }
        if (this.glenixTrnXBRLBatches == null) {
            this.loadBatches();
        }
        if (this.glenixTrnXBRLBatches == null) {
            throw new Exception("Error, there are no batches.");
        }
        Transaction b = this.glenixTrnXBRLBatches.getBatchTransaction(batchIdentifier);
        if (b == null) {
            throw new Exception("Error, cannot find batch, cannot go to transaction edit page.");
        }
        this.gotoBatchTransactionEdit(transaction, b);
    }

    /*
     * Exception decompiling
     */
    public void gotoBatchTransactionEdit(Transaction transaction, Transaction batchTransaction) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void gotoBatchPaySlipEdit(Transaction transaction, Transaction batchTransaction) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadCounterpartyList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load counterparty.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load counterparty.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("counterparty.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLCounterparty = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLCounterparty.initCounterpartyList();
        } else {
            this.glenixTrnXBRLCounterparty.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getCounterpartyTransactionList() throws Exception {
        if (this.glenixTrnXBRLCounterparty == null) {
            this.loadCounterpartyList();
        }
        return this.glenixTrnXBRLCounterparty;
    }

    @FXML
    public void gotoCounterpartyList() {
        try {
            if (this.counterpartyVBox == null) {
                this.counterpartyVBox = new CounterpartyVBox(this);
            }
            this.counterpartyVBox.setModel(this.getCounterpartyTransactionList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.counterpartyVBox);
        this.counterpartyVBox.refreshTable();
        this.setStatusBarMessage(null);
    }

    private int getEmployeeCount() {
        try {
            if (this.glenixTrnXBRLCounterparty == null) {
                this.loadCounterpartyList();
            }
            if (this.glenixTrnXBRLCounterparty == null) {
                return 0;
            }
            return this.glenixTrnXBRLCounterparty.getEmployeeCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void assignUUIDToCounterpartyIdentifier(Counterparty counterparty) throws Exception {
        counterparty.assignUUIDToCounterpartyIdentifier();
    }

    public Counterparty addCounterparty() throws Exception {
        Counterparty counterparty = new Counterparty();
        this.assignUUIDToCounterpartyIdentifier(counterparty);
        return counterparty;
    }

    public void deleteSelectedCounterparties(ObservableList<Transaction> selectedCounterpartyTransactions) throws Exception {
        if (selectedCounterpartyTransactions == null || selectedCounterpartyTransactions.size() == 0) {
            return;
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction at : selectedCounterpartyTransactions) {
            String ai = at.getCounterpartyIdentifier();
            if (ai == null) continue;
            ais.add(ai);
            if (!trns.usesCounterpartyIdentifier(ai)) continue;
            throw new Exception("Error, cannot delete counterparty " + at.getCounterpartyLegalName() + " because it is used in a transaction");
        }
        GlenixTrnXBRL accs = this.getCounterpartyTransactionList();
        if (accs == null) {
            throw new Exception("Error, cannot delete counterparties, unable to load the counterparty list");
        }
        for (String ai : ais) {
            accs.deleteCounterparty(ai);
        }
    }

    public void saveCounterpartyList() throws Exception {
        Document cdoc = this.glenixTrnXBRLCounterparty.buildDocument();
        this.saveFileEncrypt("counterparty.xml", cdoc);
    }

    public void saveCounterparty(Counterparty counterparty) throws Exception {
        GlenixTrnXBRL hox = this.getCounterpartyTransactionList();
        if (hox == null) {
            throw new Exception("Error, cannot get counterparty list");
        }
        Transaction t = hox.getCounterpartyTransaction(counterparty);
        if (t == null) {
            t = new Transaction();
            t.setCounterparty(counterparty);
            hox.addTransaction(t);
        }
        try {
            this.saveCounterpartyList();
        }
        catch (Exception e) {
            Business b = hox.getBusiness();
            if (b != null) {
                b.removeCounterpartyTransaction(counterparty);
            }
            throw e;
        }
    }

    public void saveCounterpartyTFND(Counterparty counterparty, SBRDocumentTFND0004 sbrDocumentTFND) throws Exception {
        this.saveCounterpartyList();
    }

    public GlenixTrnXBRL getGlenixTrnXBRLCounterparty() throws Exception {
        if (this.glenixTrnXBRLCounterparty == null) {
            this.loadCounterpartyList();
        }
        return this.glenixTrnXBRLCounterparty;
    }

    public Transaction getCounterpartyTransaction(String counterpartyIdentifier) throws Exception {
        GlenixTrnXBRL counterpartyTrnXBRL = this.getGlenixTrnXBRLCounterparty();
        if (counterpartyTrnXBRL == null) {
            return null;
        }
        return counterpartyTrnXBRL.getCounterpartyTransaction(counterpartyIdentifier);
    }

    public Counterparty getCounterparty(Counterparty counterparty) throws Exception {
        return counterparty;
    }

    public void gotoCounterpartyEdit(Counterparty counterparty) throws Exception {
        if (this.counterpartyEditVBox == null) {
            this.counterpartyEditVBox = new CounterpartyEditVBox(this);
        }
        counterparty = this.getCounterparty(counterparty);
        this.counterpartyEditVBox.setCounterpartyElement(counterparty);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.counterpartyEditVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoCounterpartyPayrollDetailsEdit(Counterparty counterparty) throws Exception {
        if (counterparty == null) {
            throw new Exception("Error, cannot edit payroll details without creating employee first.");
        }
        if (this.counterpartyPayrollDetailsEditVBox == null) {
            this.counterpartyPayrollDetailsEditVBox = new CounterpartyPayrollDetailsEditVBox(this);
        }
        counterparty = this.getCounterparty(counterparty);
        this.counterpartyPayrollDetailsEditVBox.setCounterpartyElement(counterparty);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.counterpartyPayrollDetailsEditVBox);
        this.setStatusBarMessage(null);
    }

    /*
     * Exception decompiling
     */
    public void gotoCounterpartySuperDetailsEdit(Counterparty counterparty) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gotoSuperProductDetailsEdit(Counterparty counterparty) throws Exception {
        if (counterparty == null) {
            throw new Exception("Error, cannot edit super details without creating counterparty first.");
        }
        if (this.superProductDetailsEditVBox == null) {
            this.superProductDetailsEditVBox = new SuperProductDetailsEditVBox(this);
        }
        counterparty = this.getCounterparty(counterparty);
        this.superProductDetailsEditVBox.setCounterpartyElement(counterparty);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.superProductDetailsEditVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoCounterpartyTFNDList(Counterparty counterparty) throws Exception {
        if (counterparty == null) {
            throw new Exception("Error, counterparty is required");
        }
        if (this.counterpartyTFNDListVBox == null) {
            this.counterpartyTFNDListVBox = new CounterpartyTFNDListVBox(this);
        }
        counterparty = this.getCounterparty(counterparty);
        this.counterpartyTFNDListVBox.setCounterpartyElement(counterparty);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.counterpartyTFNDListVBox);
        this.setStatusBarMessage(null);
    }

    public void gotoCounterpartyTFND(Counterparty counterparty, SBRDocumentTFND0004 sbrDocumentTFND0004) throws Exception {
        if (counterparty == null) {
            throw new Exception("Error, cannot edit/create TFN declaration without creating employee first.");
        }
        if (this.counterpartyTFNDVBox == null) {
            this.counterpartyTFNDVBox = new CounterpartyTFNDVBox(this);
        }
        counterparty = this.getCounterparty(counterparty);
        if (sbrDocumentTFND0004 != null) {
            String id = sbrDocumentTFND0004.getTFND0004Identifier();
            SBRDocumentTFND0004 tfnd = counterparty.getSBRDocumentTFND0004(id);
            if (tfnd == null) {
                throw new Exception("Error, cannot find the TFN declaration specified");
            }
            sbrDocumentTFND0004 = tfnd;
        }
        this.counterpartyTFNDVBox.setCounterpartyElement(counterparty, sbrDocumentTFND0004);
        this.counterpartyTFNDVBox.setModel(counterparty, sbrDocumentTFND0004);
        GlenixTrnXBRL bmfx = this.getBusinessMasterFileXBRL();
        if (bmfx == null) {
            throw new Exception("Error, cannot get business master file");
        }
        BusinessMasterFile businessMasterFile = bmfx.getBusinessMasterFile();
        this.counterpartyTFNDVBox.setBusinessDetails(businessMasterFile);
        this.counterpartyTFNDVBox.setProfileDetails(this.profileXBRL);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.counterpartyTFNDVBox);
        this.setStatusBarMessage(null);
    }

    public void loadProvisionList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load provision.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load provision.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("provision.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLProvision = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLProvision.initProvisionList();
        } else {
            this.glenixTrnXBRLProvision.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getGlenixTrnXBRLProvision() throws Exception {
        if (this.glenixTrnXBRLProvision == null) {
            this.loadProvisionList();
        }
        return this.glenixTrnXBRLProvision;
    }

    @FXML
    public void gotoProvisionList() {
        try {
            if (this.provisionListVBox == null) {
                this.provisionListVBox = new ProvisionListVBox(this);
            }
            this.provisionListVBox.setModel(this.getGlenixTrnXBRLProvision());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.provisionListVBox);
        this.provisionListVBox.refreshTable();
        this.setStatusBarMessage(null);
    }

    public void assignUUIDToProvisionIdentifier(Provision provision) throws Exception {
        provision.assignUUIDToProvisionIdentifier();
    }

    public Provision addProvision() throws Exception {
        Provision provision = new Provision();
        this.assignUUIDToProvisionIdentifier(provision);
        return provision;
    }

    public void deleteSelectedProvisions(ObservableList<Transaction> selectedProvisionTransactions) throws Exception {
        if (selectedProvisionTransactions == null || selectedProvisionTransactions.size() == 0) {
            return;
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction at : selectedProvisionTransactions) {
            String ai = at.getProvisionIdentifier();
            if (ai == null) continue;
            ais.add(ai);
            if (!trns.usesProvisionIdentifier(ai)) continue;
            throw new Exception("Error, cannot delete provsion " + at.getProvisionName() + " because it is used in a transaction");
        }
        GlenixTrnXBRL accs = this.getGlenixTrnXBRLProvision();
        if (accs == null) {
            throw new Exception("Error, cannot delete provsion, unable to load the provsion list");
        }
        for (String ai : ais) {
            accs.deleteProvision(ai);
        }
    }

    public void saveProvisionList() throws Exception {
        Document cdoc = this.glenixTrnXBRLProvision.buildDocument();
        this.saveFileEncrypt("provision.xml", cdoc);
    }

    public void saveProvision(Provision provision) throws Exception {
        GlenixTrnXBRL hox = this.getGlenixTrnXBRLProvision();
        if (hox == null) {
            throw new Exception("Error, cannot get provision list");
        }
        Transaction t = hox.getProvisionTransaction(provision);
        if (t == null) {
            t = new Transaction();
            TransactionLine tl = t.addBlankTransactionLine();
            tl.setProvision(provision);
            hox.addTransaction(t);
        }
        try {
            this.saveProvisionList();
        }
        catch (Exception e) {
            Business b = hox.getBusiness();
            if (b != null) {
                b.removeProvisionTransaction(provision);
            }
            throw e;
        }
    }

    public Transaction getProvisionTransaction(String provisionIdentifier) throws Exception {
        GlenixTrnXBRL provisionTrnXBRL = this.getGlenixTrnXBRLProvision();
        if (provisionTrnXBRL == null) {
            return null;
        }
        return provisionTrnXBRL.getProvisionTransaction(provisionIdentifier);
    }

    public Provision getProvision(Provision provision) throws Exception {
        return provision;
    }

    public void gotoProvisionEdit(Provision provision) throws Exception {
        if (this.provisionEditVBox == null) {
            this.provisionEditVBox = new ProvisionEditVBox(this);
        }
        provision = this.getProvision(provision);
        this.provisionEditVBox.setProvisionElement(provision);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.provisionEditVBox);
        this.setStatusBarMessage(null);
    }

    protected void loadAccountList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load account.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load account.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("account.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLAccount = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLAccount.initAccountList();
        } else {
            this.glenixTrnXBRLAccount.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getAccountTransactionList() throws Exception {
        if (this.glenixTrnXBRLAccount == null) {
            this.loadAccountList();
        }
        return this.glenixTrnXBRLAccount;
    }

    @FXML
    public void gotoAccountList() {
        try {
            if (this.accountListVBox == null) {
                this.accountListVBox = new AccountListVBox(this);
            }
            this.accountListVBox.setModel(this.getAccountTransactionList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.accountListVBox);
        this.accountListVBox.refreshTable();
        this.setStatusBarMessage(null);
    }

    public void assignUUIDToAccountIdentifier(Account account) throws Exception {
        account.assignUUIDToAccountIdentifier();
    }

    public Account addAccount() throws Exception {
        Account account = new Account();
        this.assignUUIDToAccountIdentifier(account);
        return account;
    }

    public void deleteSelectedAccounts(ObservableList<Transaction> selectedAccountTransactions) throws Exception {
        if (selectedAccountTransactions == null || selectedAccountTransactions.size() == 0) {
            return;
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction at : selectedAccountTransactions) {
            String ai = at.getAccountIdentifier();
            if (ai == null) continue;
            ais.add(ai);
            if (!trns.usesAccountIdentifier(ai)) continue;
            throw new Exception("Error, cannot delete account " + at.getAccountName() + " because it is used in a transaction");
        }
        GlenixTrnXBRL accs = this.getAccountTransactionList();
        if (accs == null) {
            throw new Exception("Error, cannot delete accounts, unable to load the account list");
        }
        for (String ai : ais) {
            accs.deleteAccount(ai);
        }
    }

    public void saveAccountList() throws Exception {
        Document cdoc = this.glenixTrnXBRLAccount.buildDocument();
        this.saveFileEncrypt("account.xml", cdoc);
    }

    public void saveAccount(Account account) throws Exception {
        GlenixTrnXBRL hox = this.getAccountTransactionList();
        if (hox == null) {
            throw new Exception("Error, cannot get account list");
        }
        Transaction t = hox.getAccountTransaction(account);
        if (t == null) {
            t = new Transaction();
            TransactionLine tl = t.addBlankTransactionLine();
            tl.setAccount(account);
            hox.addTransaction(t);
        }
        try {
            this.saveAccountList();
        }
        catch (Exception e) {
            Business b = hox.getBusiness();
            if (b != null) {
                b.removeAccountTransaction(account);
            }
            throw e;
        }
    }

    protected void loadHomeOfficeList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load homeOffice.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load homeOffice.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("homeOffice.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLHomeOffice = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLHomeOffice.initHomeOfficeList();
        } else {
            this.glenixTrnXBRLHomeOffice.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getHomeOfficeTransactionList() throws Exception {
        if (this.glenixTrnXBRLHomeOffice == null) {
            this.loadHomeOfficeList();
        }
        return this.glenixTrnXBRLHomeOffice;
    }

    @FXML
    public void gotoHomeOfficeList() {
        try {
            if (this.homeOfficeListVBox == null) {
                this.homeOfficeListVBox = new HomeOfficeListVBox(this);
            }
            this.homeOfficeListVBox.setModel(this.getHomeOfficeTransactionList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.homeOfficeListVBox);
        this.homeOfficeListVBox.refreshTable();
        this.setStatusBarMessage(null);
    }

    public HomeOffice addHomeOffice() throws Exception {
        HomeOffice homeOffice = new HomeOffice();
        homeOffice.assignUUIDToHomeOfficeIdentifier();
        return homeOffice;
    }

    public GlenixTrnXBRL deleteSelectedHomeOffices(ObservableList<Transaction> selectedHomeOfficeTransactions) throws Exception {
        if (selectedHomeOfficeTransactions == null || selectedHomeOfficeTransactions.size() == 0) {
            return this.getHomeOfficeTransactionList();
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction at : selectedHomeOfficeTransactions) {
            String ai = at.getHomeOfficeIdentifier();
            if (ai == null) continue;
            ais.add(ai);
            if (!trns.usesHomeOfficeIdentifier(ai)) continue;
            throw new Exception("Error, cannot delete home office because it is used in a transaction");
        }
        GlenixTrnXBRL accs = this.getHomeOfficeTransactionList();
        if (accs == null) {
            throw new Exception("Error, cannot delete homeOffices, unable to load the homeOffice list");
        }
        for (String ai : ais) {
            accs.deleteHomeOffice(ai);
        }
        this.saveHomeOfficeList();
        return this.getHomeOfficeTransactionList();
    }

    public void saveHomeOfficeList() throws Exception {
        Document cdoc = this.glenixTrnXBRLHomeOffice.buildDocument();
        this.saveFileEncrypt("homeOffice.xml", cdoc);
    }

    public void saveHomeOffice(HomeOffice homeOffice, Transaction transaction) throws Exception {
        GlenixTrnXBRL hox;
        if (transaction != null) {
            homeOffice.setHomeOfficeTransactionNumber(transaction.getTransactionNumber());
            this.saveTransaction(transaction);
        }
        if ((hox = this.getHomeOfficeTransactionList()) == null) {
            throw new Exception("Error, cannot get home office list");
        }
        Transaction t = hox.getHomeOfficeTransaction(homeOffice);
        if (t == null) {
            t = new Transaction();
            TransactionLine tl = t.addBlankTransactionLine();
            tl.setHomeOffice(homeOffice);
            hox.addTransaction(t);
        }
        try {
            this.saveHomeOfficeList();
        }
        catch (Exception e) {
            Business b = hox.getBusiness();
            if (b != null) {
                b.removeHomeOfficeTransaction(homeOffice);
            }
            throw e;
        }
    }

    protected void loadFuelTaxCreditList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load fuelTaxCredit.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load fuelTaxCredit.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("fuelTaxCredit.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLFuelTaxCredit = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLFuelTaxCredit.initFuelTaxCreditList();
        } else {
            this.glenixTrnXBRLFuelTaxCredit.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getFuelTaxCreditTransactionList() throws Exception {
        if (this.glenixTrnXBRLFuelTaxCredit == null) {
            this.loadFuelTaxCreditList();
        }
        return this.glenixTrnXBRLFuelTaxCredit;
    }

    @FXML
    public void gotoFuelTaxCreditList() {
        try {
            if (this.fuelTaxCreditListVBox == null) {
                this.fuelTaxCreditListVBox = new FuelTaxCreditListVBox(this);
            }
            this.fuelTaxCreditListVBox.setModel(this.getFuelTaxCreditTransactionList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.fuelTaxCreditListVBox);
        this.fuelTaxCreditListVBox.refreshTable();
        this.setStatusBarMessage(null);
    }

    public void assignUUIDToFuelTaxCreditIdentifier(FuelTaxCredit ftc) throws Exception {
        ftc.assignUUIDToFuelTaxCreditIdentifier();
    }

    public FuelTaxCredit addFuelTaxCredit() throws Exception {
        FuelTaxCredit ftc = new FuelTaxCredit();
        ftc.assignUUIDToFuelTaxCreditIdentifier();
        return ftc;
    }

    public void deleteSelectedFuelTaxCredits(ObservableList<Transaction> selectedFuelTaxCreditTransactions) throws Exception {
        if (selectedFuelTaxCreditTransactions == null || selectedFuelTaxCreditTransactions.size() == 0) {
            return;
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction at : selectedFuelTaxCreditTransactions) {
            String ai = at.getFuelTaxCreditIdentifier();
            if (ai == null) continue;
            ais.add(ai);
            if (!trns.usesFuelTaxCreditIdentifier(ai)) continue;
            throw new Exception("Error, cannot delete fuel tax credit because it is used in a transaction");
        }
        GlenixTrnXBRL accs = this.getFuelTaxCreditTransactionList();
        if (accs == null) {
            throw new Exception("Error, cannot delete fuel tax credit, unable to load the fuel tax credit list");
        }
        for (String ai : ais) {
            accs.deleteFuelTaxCredit(ai);
        }
    }

    public void saveFuelTaxCreditList() throws Exception {
        Document cdoc = this.glenixTrnXBRLFuelTaxCredit.buildDocument();
        this.saveFileEncrypt("fuelTaxCredit.xml", cdoc);
    }

    public void saveFuelTaxCredit(FuelTaxCredit fuelTaxCredit) throws Exception {
        GlenixTrnXBRL hox = this.getFuelTaxCreditTransactionList();
        if (hox == null) {
            throw new Exception("Error, cannot get home office list");
        }
        Transaction t = hox.getFuelTaxCreditTransaction(fuelTaxCredit);
        if (t == null) {
            t = new Transaction();
            TransactionLine tl = t.addBlankTransactionLine();
            tl.setFuelTaxCredit(fuelTaxCredit);
            hox.addTransaction(t);
        }
        try {
            this.saveFuelTaxCreditList();
        }
        catch (Exception e) {
            Business b = hox.getBusiness();
            if (b != null) {
                b.removeFuelTaxCreditTransaction(fuelTaxCredit);
            }
            throw e;
        }
    }

    protected void loadImportDataList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load importData.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load importData.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("importData.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLImportData = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLImportData.initImportDataList();
        } else {
            this.glenixTrnXBRLImportData.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getImportDataTransactionList() throws Exception {
        if (this.glenixTrnXBRLImportData == null) {
            this.loadImportDataList();
        }
        return this.glenixTrnXBRLImportData;
    }

    public GlenixTrnXBRL getImportDataTransactionList(LocalDate minDate, LocalDate maxDate) throws Exception {
        return this.getImportDataTransactionList();
    }

    /*
     * Exception decompiling
     */
    @FXML
    public void gotoImportDataList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addImportDataTransaction(Transaction importDataTransaction) throws Exception {
        if (importDataTransaction != null) {
            this.glenixTrnXBRLImportData.addTransaction(importDataTransaction);
        }
    }

    public void addImportDataTransactions(List<Transaction> importDataTransactionList) throws Exception {
        for (Transaction t : importDataTransactionList) {
            this.glenixTrnXBRLImportData.addTransaction(t);
        }
    }

    public void deleteSelectedImportData(Set<Transaction.TransactionTransactionLine> selectedImportDataTransactions) throws Exception {
        if (selectedImportDataTransactions == null || selectedImportDataTransactions.size() == 0) {
            return;
        }
        ArrayList<String> ais = new ArrayList<String>();
        GlenixTrnXBRL trns = this.getTransactions();
        for (Transaction.TransactionTransactionLine at : selectedImportDataTransactions) {
            String ai = at.getImportDataIdentifier();
            if (ai == null) continue;
            ais.add(ai);
        }
        GlenixTrnXBRL accs = this.getImportDataTransactionList();
        if (accs == null) {
            throw new Exception("Error, cannot delete import data, unable to load the import data list");
        }
        for (String ai : ais) {
            accs.deleteImportData(ai);
        }
    }

    public void deleteSelectedImportData(String importDataIdentifier) throws Exception {
        if (importDataIdentifier == null || importDataIdentifier.isEmpty()) {
            return;
        }
        GlenixTrnXBRL accs = this.getImportDataTransactionList();
        if (accs == null) {
            throw new Exception("Error, cannot delete import data, unable to load the import data list");
        }
        accs.deleteImportData(importDataIdentifier);
    }

    public void saveImportData(Transaction importDataTransaction) throws Exception {
        Document cdoc = this.glenixTrnXBRLImportData.buildDocument();
        this.saveFileEncrypt("importData.xml", cdoc);
    }

    public void saveImportDataTransactions(Collection<Transaction> importDataTransactions) throws Exception {
        Document cdoc = this.glenixTrnXBRLImportData.buildDocument();
        this.saveFileEncrypt("importData.xml", cdoc);
    }

    public void postImportDataTransactions(Set<Transaction> importDataTransactions) throws Exception {
        this.glenixTrnXBRLImportData.deleteTransactions(importDataTransactions);
        if (this.glenixTrnXBRLTransactions == null) {
            this.loadTransactions();
        }
        this.glenixTrnXBRLTransactions.addTransactions(importDataTransactions);
        Document cdoc = this.glenixTrnXBRLImportData.buildDocument();
        this.saveFileEncrypt("importData.xml", cdoc);
        Document trndoc = this.glenixTrnXBRLTransactions.buildDocument();
        this.saveFileEncrypt("transactions.xml", trndoc);
    }

    protected void loadBusinessIssueList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load businessIssue.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load businessIssue.xml");
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("businessIssue.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLBusinessIssue = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLBusinessIssue.initBusinessIssueList();
        } else {
            this.glenixTrnXBRLBusinessIssue.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getBusinessIssueList() throws Exception {
        if (this.glenixTrnXBRLBusinessIssue == null) {
            this.loadBusinessIssueList();
        }
        return this.glenixTrnXBRLBusinessIssue;
    }

    public BusinessIssue addBusinessIssue() throws Exception {
        return this.glenixTrnXBRLBusinessIssue.addBlankBusinessIssue();
    }

    public void saveBusinessIssueList() throws Exception {
        Document cdoc = this.glenixTrnXBRLBusinessIssue.buildDocument();
        this.saveFileEncrypt("businessIssue.xml", cdoc);
    }

    protected GlenixSBRResponse sendSignedCertificateRequest(String messageId, String publicKeyIdentifier) throws Exception {
        if (this.profileXBRL == null) {
            throw new Exception("Cannot lodge profile is not set, cannot send cert request");
        }
        if (this.glenixKey == null) {
            throw new Exception("Cannot lodge profile certificate is not set, cannot send cert request");
        }
        String commonName = "";
        String prefix = "";
        String tmp = this.profileXBRL.getFirstName();
        if (tmp != null && !tmp.isEmpty()) {
            commonName = commonName + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getOtherGivenNames()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
            prefix = " ";
        }
        if ((tmp = this.profileXBRL.getLastName()) != null && !tmp.isEmpty()) {
            commonName = commonName + prefix + tmp;
        }
        commonName = commonName.trim();
        MessageDetails md = this.glenixKey.newMessageDetails();
        md.setPropPublicKeyIdentifier(publicKeyIdentifier);
        md.setService(this.glenix_soap_service_certificate);
        md.setAction(this.glenix_soap_action_submit);
        Document doc = this.glenixKey.buildOtherSoapDocument(messageId, this.glenix_soap_legal_name_identifier, commonName, this.glenix_soap_user_role_identifier, this.glenix_dspIdentifierType, this.glenix_dspABN, this.glenix_dspRole, md);
        return this.glenixKey.dorequest_lodge_apache(this.glenix_fasSoapURL, doc, null, null);
    }

    public String getPublicKeyIdentifier() throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get public key identifier");
        }
        PublicKey pk = this.glenixKey.getPublicKey();
        if (pk == null) {
            throw new Exception("Cannot get public key");
        }
        MessageDigest md = this.glenixKey.calcDigestBytes(pk.getEncoded(), "SHA-1");
        String publicKeyIdentifier = Base64.getEncoder().withoutPadding().encodeToString(md.digest());
        return publicKeyIdentifier.replace('+', '-').replace('/', '_');
    }

    public String getPublicKeyDer() throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get public key DER");
        }
        return this.glenixKey.getBase64PublicKeyOneLine();
    }

    public GlenixSBRResponse getSignedCertificate(String messageId, PublicKey pk) throws Exception {
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get signed cert");
        }
        MessageDigest md = this.glenixKey.calcDigestBytes(pk.getEncoded(), "SHA-1");
        String publicKeyIdentifier = Base64.getEncoder().withoutPadding().encodeToString(md.digest());
        publicKeyIdentifier = publicKeyIdentifier.replace('+', '-').replace('/', '_');
        return this.sendSignedCertificateRequest(messageId, publicKeyIdentifier);
    }

    public X509Certificate updateSignedCertificate(PublicKey myPublicKey, PublicKey pk) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot get signed certs");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get signed certs");
        }
        X509Certificate result = null;
        byte[] certBytes = this.getSignedCertificateBytes(pk);
        if (certBytes != null) {
            this.glenixFile.updateCertificate(pk, certBytes);
            if (myPublicKey != null && pk.equals(myPublicKey)) {
                result = this.glenixKey.setPublicKeyBase64(new String(certBytes).trim());
            }
        }
        return result;
    }

    public X509Certificate updateSignedCertificate(PublicKey pk) throws Exception {
        return this.updateSignedCertificate(null, pk);
    }

    public void updateSignedCertificates() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot get signed certs");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot get signed certs");
        }
        PublicKey myPublicKey = this.glenixKey.getPublicKey();
        for (int i = 0; i < this.glenixFile.getCertificateCount(); ++i) {
            PublicKey pk = this.glenixFile.getPublicKey(i);
            this.updateSignedCertificate(myPublicKey, pk);
        }
    }

    public byte[] getSignedCertificateBytes(PublicKey pk) throws Exception {
        String messageId = this.generateMessageIdentifier();
        GlenixSBRResponse resp = this.getSignedCertificate(messageId, pk);
        resp.parseResponse();
        try {
            InputStream is = resp.getInputStreamByHref("data.txt");
            if (is != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                int len = 0;
                while ((len = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, len);
                }
                return baos.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void loadBusinessMessageList() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load businessMessage.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load businessMessage.xml");
        }
        try {
            this.updateSignedCertificates();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document cdoc = null;
        try {
            cdoc = this.getDocumentDecrypt("businessMessage.xml");
        }
        catch (NoSuchFileException nsfe) {
            cdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            cdoc = null;
        }
        this.glenixTrnXBRLBusinessMessage = new GlenixTrnXBRL();
        if (cdoc == null) {
            this.glenixTrnXBRLBusinessMessage.initBusinessMessageList();
        } else {
            this.glenixTrnXBRLBusinessMessage.loadDocumentElement(cdoc, cdoc.getDocumentElement());
        }
    }

    public GlenixTrnXBRL getBusinessMessageList() throws Exception {
        if (this.glenixTrnXBRLBusinessMessage == null) {
            this.loadBusinessMessageList();
        }
        return this.glenixTrnXBRLBusinessMessage;
    }

    @FXML
    public void gotoBusinessMessageList() {
        try {
            BusinessMasterFile bmf;
            if (this.businessMessageListVBox == null) {
                this.businessMessageListVBox = new BusinessMessageListVBox(this);
            }
            if ((bmf = this.getBusinessMasterFile()) == null) {
                throw new Exception("Error, cannot go to messages list as business master file not set");
            }
            String bi = bmf.getBusinessIdentifier();
            if (bi == null || bi.isEmpty()) {
                throw new Exception("Error, cannot go to messages list as business identifier not set");
            }
            if (this.glenixTrnXBRLFileAccess == null) {
                try {
                    this.loadFileAccess();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.businessMessageListVBox.setModel(this.getBusinessMessageList(), bi, this.glenixTrnXBRLFileAccess);
            this.businessMessageListVBox.setProfile(this.profileXBRL);
            this.businessMessageListVBox.getNewBusinessMessages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.businessMessageListVBox);
        this.setStatusBarMessage(null);
    }

    public void saveBusinessMessageList() throws Exception {
        Document cdoc = this.glenixTrnXBRLBusinessMessage.buildDocument();
        this.saveFileEncrypt("businessMessage.xml", cdoc);
    }

    public void saveBusinessMessage(BusinessMessage businessMessage) throws Exception {
        this.saveBusinessMessageList();
    }

    public void saveBusinessMasterFile() throws Exception {
        Document cdoc = this.glenixTrnXBRLBusinessMasterFile.buildDocument();
        this.saveFileEncrypt("businessMasterFile.xml", cdoc);
        this.setTitle(null);
    }

    public void saveTaxReturn() throws Exception {
        Document cdoc = this.glenixTrnXBRLTaxReturn.buildDocument();
        this.saveFileEncrypt("taxReturn.xml", cdoc);
    }

    public GlenixTrnXBRL getGlenixTrnXBRLAccount() throws Exception {
        if (this.glenixTrnXBRLAccount == null) {
            this.loadAccountList();
        }
        return this.glenixTrnXBRLAccount;
    }

    public Transaction getAccountTransaction(String accountIdentifier) throws Exception {
        GlenixTrnXBRL accountTrnXBRL = this.getGlenixTrnXBRLAccount();
        if (accountTrnXBRL == null) {
            return null;
        }
        return accountTrnXBRL.getAccountTransaction(accountIdentifier);
    }

    public Account getAccount(Account account) throws Exception {
        return account;
    }

    /*
     * Exception decompiling
     */
    public void gotoAccountEdit(Account account) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gotoCalculationRuleEdit(Account account, int index) throws Exception {
        throw new Exception("Error, calculation rule not implemented in desktop");
    }

    public void gotoCalculationRuleList(Account account) throws Exception {
        throw new Exception("Error, calculation rule not implemented in desktop");
    }

    public void saveCalculationRule(Account account, CalculationRule calculationRule) throws Exception {
        throw new Exception("Error, calculation rule not implemented in desktop");
    }

    public void deleteSelectedCalculationRules(Account account, ObservableList<Account.AccountCalculationRule> selectedCalculationRules) throws Exception {
        throw new Exception("Error, calculation rule not implemented in desktop");
    }

    public void applyCalculationRule(Transaction transaction) throws Exception {
        throw new Exception("Error, calculation rule not implemented in desktop");
    }

    public Transaction getTransactionByTransactionNumber(String transactionNumber) throws Exception {
        GlenixTrnXBRL trns = this.getTransactions();
        if (trns == null) {
            return null;
        }
        Business b = trns.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getTransactionByTransactionNumber(transactionNumber);
    }

    public GlenixTrnXBRL getGlenixTrnXBRLHomeOffice() throws Exception {
        if (this.glenixTrnXBRLHomeOffice == null) {
            this.loadHomeOfficeList();
        }
        return this.glenixTrnXBRLHomeOffice;
    }

    public Transaction getHomeOfficeTransaction(String homeOfficeIdentifier) throws Exception {
        GlenixTrnXBRL homeOfficeTrnXBRL = this.getGlenixTrnXBRLHomeOffice();
        if (homeOfficeTrnXBRL == null) {
            return null;
        }
        return homeOfficeTrnXBRL.getHomeOfficeTransaction(homeOfficeIdentifier);
    }

    public HomeOffice getHomeOffice(HomeOffice homeOffice) throws Exception {
        return homeOffice;
    }

    /*
     * Exception decompiling
     */
    public void gotoHomeOfficeEdit(HomeOffice homeOffice) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GlenixTrnXBRL getGlenixTrnXBRLFuelTaxCredit() throws Exception {
        if (this.glenixTrnXBRLFuelTaxCredit == null) {
            this.loadFuelTaxCreditList();
        }
        return this.glenixTrnXBRLFuelTaxCredit;
    }

    public Transaction getFuelTaxCreditTransaction(String fuelTaxCreditIdentifier) throws Exception {
        GlenixTrnXBRL fuelTaxCreditTrnXBRL = this.getGlenixTrnXBRLFuelTaxCredit();
        if (fuelTaxCreditTrnXBRL == null) {
            return null;
        }
        return fuelTaxCreditTrnXBRL.getFuelTaxCreditTransaction(fuelTaxCreditIdentifier);
    }

    /*
     * Exception decompiling
     */
    public void gotoFuelTaxCreditEdit(FuelTaxCredit fuelTaxCredit) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GlenixTrnXBRL getGlenixTrnXBRLImportData() throws Exception {
        if (this.glenixTrnXBRLImportData == null) {
            this.loadImportDataList();
        }
        return this.glenixTrnXBRLImportData;
    }

    public Transaction getImportDataTransaction(String importDataIdentifier) throws Exception {
        GlenixTrnXBRL importDataTrnXBRL = this.getGlenixTrnXBRLImportData();
        if (importDataTrnXBRL == null) {
            return null;
        }
        return importDataTrnXBRL.getImportDataTransaction(importDataIdentifier);
    }

    public void gotoImportDataEdit(List<Transaction.TransactionTransactionLine> transactionTransactionLineList, Transaction.TransactionTransactionLine importDataTransactionTransactionLine, ImportData importData) throws Exception {
        if (this.importDataEditVBox == null) {
            try {
                if (this.glenixTrnXBRLImportData == null) {
                    this.loadImportDataList();
                }
                this.importDataEditVBox = new ImportDataEditVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (importData == null) {
            this.importDataEditVBox.setImportDataElement(transactionTransactionLineList, importDataTransactionTransactionLine, null);
            this.importDataEditVBox.clearImportData();
        } else {
            this.importDataEditVBox.setImportDataElement(transactionTransactionLineList, importDataTransactionTransactionLine, importData);
            Document cdoc = importData.buildDocument();
            this.importDataEditVBox.loadGlenixXBRL(cdoc, cdoc.getDocumentElement());
        }
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.importDataEditVBox);
        this.setStatusBarMessage(null);
    }

    public void loadTaxReturn() throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load taxReturn.xml");
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load taxReturn.xml");
        }
        Document trdoc = null;
        try {
            trdoc = this.getDocumentDecrypt("taxReturn.xml");
        }
        catch (NoSuchFileException nsfe) {
            trdoc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            trdoc = null;
        }
        this.glenixTrnXBRLTaxReturn = new GlenixTrnXBRL();
        if (trdoc == null) {
            this.glenixTrnXBRLTaxReturn.initBusiness();
        } else {
            try {
                this.glenixTrnXBRLTaxReturn.loadDocumentElement(trdoc, trdoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.glenixTrnXBRLTaxReturn.initBusiness();
                throw e;
            }
        }
    }

    @FXML
    public void gotoTaxReturnList() {
        try {
            if (this.taxReturnListVBox == null) {
                this.taxReturnListVBox = new TaxReturnListVBox(this);
            }
            if (this.glenixTrnXBRLTaxReturn == null) {
                this.loadTaxReturn();
            }
            this.taxReturnListVBox.setModel(this.glenixTrnXBRLTaxReturn);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.taxReturnListVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoIncomeAndExpenditure() {
        try {
            if (this.incomeAndExpenditureVBox == null) {
                this.incomeAndExpenditureVBox = new IncomeAndExpenditureVBox(this);
                String fromDateStr = this.getBusinessMasterFile().getLedgerStartDate();
                this.incomeAndExpenditureVBox.setFromDate(fromDateStr);
                String toDateStr = this.getBusinessMasterFile().getLedgerEndDate();
                this.incomeAndExpenditureVBox.setToDate(toDateStr);
            }
            String filterText = this.incomeAndExpenditureVBox.getFilterText();
            LocalDate fromDate = this.incomeAndExpenditureVBox.getFromDate();
            LocalDate toDate = this.incomeAndExpenditureVBox.getToDate();
            List<Transaction> summaryTransaction = this.getAccountProvisionTotals(filterText, fromDate, toDate, null, null);
            this.incomeAndExpenditureVBox.setSummaryTransaction(summaryTransaction);
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.incomeAndExpenditureVBox);
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gotoProfitAndLoss(LocalDate startDate, LocalDate endDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        throw new Exception("Error, goto profit and loss not implemented in FAS desktop");
    }

    /*
     * Exception decompiling
     */
    public void gotoIncomeAndExpenditureAccountDetail(String accountIdentifier, String filterText, LocalDate fromDate, LocalDate toDate) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gotoIncomeAndExpenditureProvisionDetail(String provisionIdentifier, String filterText, LocalDate fromDate, LocalDate toDate) throws Exception {
        Transaction pt;
        if (this.incomeAndExpenditureProvisionDetailVBox == null) {
            this.incomeAndExpenditureProvisionDetailVBox = new IncomeAndExpenditureProvisionDetailVBox(this);
        }
        if ((pt = this.getProvisionTransaction(provisionIdentifier)) == null) {
            throw new Exception("Error, invalid account");
        }
        if (filterText != null) {
            if (filterText.isEmpty()) {
                filterText = null;
            } else {
                filterText = filterText.toLowerCase();
                String pName = pt.getProvisionName();
                if (pName.toLowerCase().contains(filterText)) {
                    filterText = null;
                }
            }
        }
        ArrayList<Transaction.TransactionTransactionLine> transactionLineList = this.getTransactionLineListByProvision(provisionIdentifier, null, null, null);
        this.incomeAndExpenditureProvisionDetailVBox.setTransactionLineList(provisionIdentifier, null);
        this.incomeAndExpenditureProvisionDetailVBox.setFilterText(filterText);
        this.incomeAndExpenditureProvisionDetailVBox.setFromDate(fromDate);
        this.incomeAndExpenditureProvisionDetailVBox.setToDate(toDate);
        this.incomeAndExpenditureProvisionDetailVBox.setTransactionLineList(provisionIdentifier, transactionLineList);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.incomeAndExpenditureProvisionDetailVBox);
        this.setStatusBarMessage(null);
    }

    private TaxReturnTaxReturnVBox getTaxReturnTaxReturnVBox() throws Exception {
        if (this.taxReturnTaxReturnVBox == null) {
            if (this.glenixTrnXBRLTaxReturn == null) {
                this.loadTaxReturn();
            }
            this.taxReturnTaxReturnVBox = new TaxReturnTaxReturnVBox(this);
        }
        return this.taxReturnTaxReturnVBox;
    }

    private void gotoTaxReturnTaxReturnVBox(TaxReturnTaxReturnVBox trvb) {
        BusinessMasterFile businessMasterFile = this.glenixTrnXBRLBusinessMasterFile.getBusinessMasterFile();
        trvb.setBusinessDetails(businessMasterFile);
        trvb.setProfileDetails(this.profileXBRL);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)trvb);
        this.setStatusBarMessage(null);
    }

    public void gotoTaxReturnCGNFT0002(TaxReturn taxReturn, CGNFT0002 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelCGNFT0002(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnCTR0009(TaxReturn taxReturn, CTR0009 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelCTR0009(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnCTR0010(TaxReturn taxReturn, CTR0010 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelCTR0010(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnIITR0005(TaxReturn taxReturn, IITR0005 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelIITR0005(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnIITR0006(TaxReturn taxReturn, IITR0006 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelIITR0006(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnPTR0007(TaxReturn taxReturn, PTR0007 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelPTR0007(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnTRT0007(TaxReturn taxReturn, TRT0007 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelTRT0007(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnSMSF0008(TaxReturn taxReturn, SMSF0008 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelSMSF0008(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnSMSF0009(TaxReturn taxReturn, SMSF0009 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelSMSF0009(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnRS0002(TaxReturn taxReturn, RS0002 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelRS0002(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnCGTS0006(TaxReturn taxReturn, CGTS0006 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelCGTS0006(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnDIDS0002(TaxReturn taxReturn, DIDS0002 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelDIDS0002(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnNRFI0002(TaxReturn taxReturn, NRFI0002 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelNRFI0002(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnPSS0002(TaxReturn taxReturn, PSS0002 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelPSS0002(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnWRE0003(TaxReturn taxReturn, WRE0003 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelWRE0003(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnIDS0006(TaxReturn taxReturn, IDS0006 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelIDS0006(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnIDS0007(TaxReturn taxReturn, IDS0007 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelIDS0007(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnCGLS0006(TaxReturn taxReturn, CGLS0006 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelCGLS0006(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnDIS0003(TaxReturn taxReturn, DIS0003 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelDIS0003(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnLS0006(TaxReturn taxReturn, LS0006 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelLS0006(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnRDTIS0003(TaxReturn taxReturn, RDTIS0003 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelRDTIS0003(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnIEE0003(TaxReturn taxReturn, IEE0003 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelIEE0003(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnFTER0002(TaxReturn taxReturn, FTER0002 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelFTER0002(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnDDCTNS0001(TaxReturn taxReturn, DDCTNS0001 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelDDCTNS0001(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    public void gotoTaxReturnRPTTAXPOS0001(TaxReturn taxReturn, RPTTAXPOS0001 schedule) throws Exception {
        TaxReturnTaxReturnVBox trvb = this.getTaxReturnTaxReturnVBox();
        trvb.setModelRPTTAXPOS0001(taxReturn, schedule);
        this.gotoTaxReturnTaxReturnVBox(trvb);
    }

    @FXML
    public void gotoFileList() {
        try {
            if (this.fileListVBox == null) {
                this.fileListVBox = new GlenixFileListVBox(this);
            }
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.fileListVBox);
            this.fileListVBox.refreshTable();
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoFileImagesList() {
        try {
            if (this.fileImagesVBox == null) {
                this.fileImagesVBox = new GlenixFileImagesVBox(this);
            }
            this.invalidateComponentsCache();
            this.file_content_display.getChildren().clear();
            this.file_content_display.getChildren().add((Object)this.fileImagesVBox);
            this.fileImagesVBox.refreshTable();
            this.setStatusBarMessage(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<Path> getFileList(String directory) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot get file list");
        }
        return this.glenixFile.getFileList(directory);
    }

    public ArrayList<Path> getFileList() throws Exception {
        return this.getFileList(null);
    }

    public InputStream getFileDecrypt(String dataSource) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("File not opened cannot load " + dataSource);
        }
        if (this.glenixKey == null) {
            throw new Exception("Key not opened cannot load " + dataSource);
        }
        return this.readAndDecryptDataSource(dataSource);
    }

    public static ObservableList<Counterparty> getCounterpartyObservableList(ObservableList<Transaction> transactionObservableList) {
        ObservableList counterpartyObservableList = FXCollections.observableArrayList();
        for (Transaction t : transactionObservableList) {
            Counterparty c2 = t.getCounterparty();
            if (c2 == null) continue;
            counterpartyObservableList.add((Object)c2);
        }
        transactionObservableList.addListener(c -> {
            while (c.next()) {
                Counterparty cc;
                if (c.wasAdded()) {
                    for (Transaction tt : c.getAddedSubList()) {
                        cc = tt.getCounterparty();
                        if (cc == null) continue;
                        counterpartyObservableList.add((Object)cc);
                    }
                }
                if (!c.wasRemoved()) continue;
                for (Transaction tt : c.getRemoved()) {
                    cc = tt.getCounterparty();
                    if (cc == null) continue;
                    counterpartyObservableList.remove((Object)cc);
                }
            }
        });
        return counterpartyObservableList;
    }

    private void updateStyles() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.rootStyles.keySet()) {
            String val = this.rootStyles.get(key);
            sb.append(key);
            sb.append(":");
            sb.append(val);
            sb.append("; ");
        }
        this.getPane().setStyle(sb.toString());
    }

    public void setDisplayToCurrentFontSize() {
        this.rootStyles.put("-fx-font-size", this.currentFontSize + "px");
        if (this.currentStageWidth != null) {
            int oldCols = this.currentColumnCount;
            this.setColumnsCount();
            if (this.currentColumnCount != oldCols) {
                this.setColumnsWidth();
            }
        }
        this.updateStyles();
    }

    public int getCurrentFontSize() {
        return this.currentFontSize;
    }

    public void increaseFont() {
        ++this.currentFontSize;
        if (this.currentFontSize > 30) {
            this.currentFontSize = 30;
        }
        this.setDisplayToCurrentFontSize();
    }

    public void decreaseFont() {
        --this.currentFontSize;
        if (this.currentFontSize < 4) {
            this.currentFontSize = 4;
        }
        this.setDisplayToCurrentFontSize();
    }

    public void resetFont() {
        this.currentFontSize = 13;
        this.setDisplayToCurrentFontSize();
    }

    public void setCurrentFontSizeToConfigFontSize() {
        String fontSizeStr = this.getConfigValue("font_size", "13");
        this.currentFontSize = 13;
        if (fontSizeStr != null && !fontSizeStr.isEmpty()) {
            try {
                this.currentFontSize = Integer.parseInt(fontSizeStr);
            }
            catch (Exception e) {
                this.currentFontSize = 13;
            }
        }
        if (this.currentFontSize < 4) {
            this.currentFontSize = 4;
        } else if (this.currentFontSize > 30) {
            this.currentFontSize = 30;
        }
        this.setDisplayToCurrentFontSize();
    }

    private void setColumnsCount() {
        if (this.currentStageWidth == null) {
            return;
        }
        int font_size = this.currentFontSize;
        if (font_size < 4) {
            font_size = 4;
        }
        int preferred_column_width = 400 * (font_size - (13 - font_size)) / 13;
        int stage_width = this.currentStageWidth.intValue();
        int fullwidth = stage_width - 40 - 20;
        int columns = (int)Math.floor(fullwidth / preferred_column_width);
        if (columns > this.getMaxColumns(this.currentStageWidth)) {
            columns = this.getMaxColumns(this.currentStageWidth);
        }
        if (columns < 1) {
            columns = 1;
        }
        this.currentColumnCount = columns;
    }

    public void setColumnsWidth(Number newStageWidth) {
        this.currentStageWidth = newStageWidth;
        this.setColumnsCount();
        this.setColumnsWidth();
        this.updateStyles();
    }

    private void setColumnsWidth() {
        int margin = 10;
        int spacing = 10;
        int row_spacing = 10;
        int more_row_spacing = 20;
        int scrollbar_width = this.currentFontSize + 10;
        int titledPanePadding = 5;
        int trletterwidth = this.currentFontSize * 5;
        int stage_width = this.currentStageWidth.intValue();
        int fullwidth = stage_width - margin * 2 - scrollbar_width;
        int fullwidthtextfieldwidth = (int)(0.4 * (double)(fullwidth - scrollbar_width));
        int fullwidthlabelwidth = fullwidth - fullwidthtextfieldwidth;
        int titledpanewidth = (int)Math.floor((fullwidth - scrollbar_width - spacing * (this.currentColumnCount - 1)) / this.currentColumnCount) - 1;
        int titledpanecontentwidth = titledpanewidth - titledPanePadding * 2;
        int textfieldwidth = (int)Math.floor(0.4 * (double)titledpanecontentwidth);
        int labelwidth = titledpanecontentwidth - textfieldwidth;
        int trlabelwidth = titledpanecontentwidth - textfieldwidth - trletterwidth;
        int wideTextfieldwidth = (int)Math.floor(0.6 * (double)titledpanecontentwidth);
        int narrowLabelwidth = titledpanecontentwidth - wideTextfieldwidth;
        int narrowTrlabelwidth = titledpanecontentwidth - wideTextfieldwidth - trletterwidth;
        int fullwidthlessonecolwidth = (int)Math.floor(fullwidth - spacing - titledpanewidth) - 1;
        this.rootStyles.put("-glenix-titledpane-width", titledpanewidth + "px");
        this.rootStyles.put("-glenix-titledpane-padding", titledPanePadding + "px");
        this.rootStyles.put("-glenix-titledpane-content-width", titledpanecontentwidth + "px");
        this.rootStyles.put("-glenix-text-field-width", textfieldwidth + "px");
        this.rootStyles.put("-glenix-label-width", labelwidth + "px");
        this.rootStyles.put("-glenix-tr-label-width", trlabelwidth + "px");
        this.rootStyles.put("-glenix-tr-label-letter-width", trletterwidth + "px");
        this.rootStyles.put("-glenix-wide-text-field-width", wideTextfieldwidth + "px");
        this.rootStyles.put("-glenix-narrow-label-width", narrowLabelwidth + "px");
        this.rootStyles.put("-glenix-narrow-tr-label-width", narrowTrlabelwidth + "px");
        this.rootStyles.put("-glenix-titledpane-spacing", spacing + "px");
        this.rootStyles.put("-glenix-row-spacing", row_spacing + "px");
        this.rootStyles.put("-glenix-more-row-spacing", more_row_spacing + "px");
        this.rootStyles.put("-glenix-main-content-margin", margin + "px");
        this.rootStyles.put("-glenix-full-width", fullwidth + "px");
        this.rootStyles.put("-glenix-full-width-text-field-width", fullwidthtextfieldwidth + "px");
        this.rootStyles.put("-glenix-full-width-label-width", fullwidthlabelwidth + "px");
        this.rootStyles.put("-glenix-full-width-less-narrow-label-width", fullwidth - narrowLabelwidth + "px");
        if (this.currentColumnCount == 1) {
            this.rootStyles.put("-glenix-width-less-titledpane-width", titledpanewidth + "px");
            this.rootStyles.put("-glenix-header-entry-width", titledpanewidth + "px");
            this.rootStyles.put("-glenix-detail-entry-width", titledpanewidth + "px");
        } else {
            this.rootStyles.put("-glenix-width-less-titledpane-width", fullwidthlessonecolwidth + "px");
            int headerwidth = titledpanewidth * 3 / 4;
            this.rootStyles.put("-glenix-header-entry-width", headerwidth + "px");
            int detailwidth = (int)Math.floor(fullwidth - spacing - headerwidth) - 1 - scrollbar_width;
            this.rootStyles.put("-glenix-detail-entry-width", detailwidth + "px");
        }
    }

    public void updateTheme() {
        this.rootStyles.put("-glenix-disabled-fx-opacity", "0.8");
        this.rootStyles.put("-fx-font-smoothing-type", "lcd");
        String theme = this.getConfigValue("theme", "FAS");
        if (theme != null && theme.equals("FAS")) {
            this.rootStyles.put("-fx-background-color", "#FFFFFF");
            this.rootStyles.put("-fx-text-fill", "#000000");
            this.rootStyles.put("-main-body-fx-background-color", "#f2f7fc");
            this.rootStyles.put("-main-body-fx-border-color", "#011b72");
            this.rootStyles.put("-footer-fx-text-fill", "#011b72");
            this.rootStyles.put("-footer-fx-stroke", "#011b72");
            this.rootStyles.put("-menu-fx-border-color", "#011b72");
            this.rootStyles.put("-menu-fx-background-color", "#dfeaf7");
            this.rootStyles.put("-menu-fx-background-darker-color", "#bacce0");
            this.rootStyles.put("-glenix-hyperlink-text-color", "#003594");
            this.rootStyles.put("-glenix-text-fill", "#000000");
            this.rootStyles.put("-glenix-background-color", "#FFFFFF");
        } else if (theme != null && theme.equals("reverse")) {
            this.rootStyles.put("-fx-background-color", "#000000");
            this.rootStyles.put("-fx-text-fill", "#FFFFFF");
            this.rootStyles.put("-main-body-fx-background-color", "#000000");
            this.rootStyles.put("-main-body-fx-border-color", "#BACAFF");
            this.rootStyles.put("-footer-fx-text-fill", "#BACAFF");
            this.rootStyles.put("-footer-fx-stroke", "#BACAFF");
            this.rootStyles.put("-menu-fx-border-color", "#BACAFF");
            this.rootStyles.put("-menu-fx-background-color", "#222222");
            this.rootStyles.put("-menu-fx-background-darker-color", "#111111");
            this.rootStyles.put("-glenix-hyperlink-text-color", "#BACAFF");
            this.rootStyles.put("-glenix-text-fill", "#FFFFFF");
            this.rootStyles.put("-glenix-background-color", "#000000");
        } else {
            this.rootStyles.put("-fx-background-color", "#FFFFFF");
            this.rootStyles.put("-fx-text-fill", "#000000");
            this.rootStyles.put("-main-body-fx-background-color", "#fff7FB");
            this.rootStyles.put("-main-body-fx-border-color", "#A35779");
            this.rootStyles.put("-footer-fx-text-fill", "#A35779");
            this.rootStyles.put("-footer-fx-stroke", "#A35779");
            this.rootStyles.put("-menu-fx-border-color", "#A35779");
            this.rootStyles.put("-menu-fx-background-color", "#e7bed1");
            this.rootStyles.put("-menu-fx-background-darker-color", "#dea0bd");
            this.rootStyles.put("-glenix-hyperlink-text-color", "#003594");
            this.rootStyles.put("-glenix-text-fill", "#000000");
            this.rootStyles.put("-glenix-background-color", "#FFFFFF");
        }
        this.updateStyles();
    }

    public String getConfigValue(String field, String defaultValue) {
        if (this.configPageVBox == null) {
            try {
                this.configPageVBox = new ConfigPageVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.configPageVBox == null) {
            return null;
        }
        return this.configPageVBox.getConfigValue(field, defaultValue);
    }

    public void setConfigValue(String field, String value) {
        if (this.configPageVBox == null) {
            try {
                this.configPageVBox = new ConfigPageVBox(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.configPageVBox == null) {
            return;
        }
        this.configPageVBox.setConfigValue(field, value);
    }

    public void setStatusBarMessage(String message) {
        this.currentStatusBarMessage = message;
        this.status_bar_label.setText(message);
    }

    public void appendStatusBarMessage(String message) {
        if (this.currentStatusBarMessage != null && !this.currentStatusBarMessage.isEmpty()) {
            this.currentStatusBarMessage = this.currentStatusBarMessage + " " + message;
            this.status_bar_label.setText(this.currentStatusBarMessage);
        } else {
            this.currentStatusBarMessage = message;
            this.status_bar_label.setText(message);
        }
    }

    public void scrollToTop() {
        if (this.main_content_scroll_pane != null) {
            this.main_content_scroll_pane.setVvalue(0.0);
        }
    }

    public File openImportFile() throws Exception {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter4 = new FileChooser.ExtensionFilter("Known file types (.xbrlgl, .fas, .xml)", new String[]{"*.xbrlgl", "*.fas", "*.xml"});
        fileChooser.getExtensionFilters().add((Object)extFilter4);
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("XBRLGL files (*.xbrlgl)", new String[]{"*.xbrlgl"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("FAS files (*.fas)", new String[]{"*.fas"});
        fileChooser.getExtensionFilters().add((Object)extFilter3);
        FileChooser.ExtensionFilter extFilter5 = new FileChooser.ExtensionFilter("XML files (*.xml)", new String[]{"*.xml"});
        fileChooser.getExtensionFilters().add((Object)extFilter5);
        FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("All files (*.*)", new String[]{"*.*"});
        fileChooser.getExtensionFilters().add((Object)extFilter2);
        fileChooser.setTitle("Open your file to import data from");
        return fileChooser.showOpenDialog((Window)this.stage);
    }

    public void importFasV2ExportFile(File file) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        try {
            if (this.glenixTrnXBRLProvision == null) {
                this.loadProvisionList();
            }
            this.glenixTrnXBRLProvision.loadFasV2ProvisionList(doc);
            this.saveProvisionList();
            if (this.glenixTrnXBRLAccount == null) {
                this.loadAccountList();
            }
            this.glenixTrnXBRLAccount.loadFasV2AccountList(doc);
            this.glenixTrnXBRLAccount.loadFasV2AccountListMeasurable(doc);
            this.saveAccountList();
            if (this.glenixTrnXBRLCounterparty == null) {
                this.loadCounterpartyList();
            }
            this.glenixTrnXBRLCounterparty.loadFasV2CounterypartyList(doc);
            this.saveCounterpartyList();
            if (this.glenixTrnXBRLBatches == null) {
                this.loadBatches();
            }
            Business b = this.glenixTrnXBRLBusinessMasterFile.getBusiness();
            String ledgerStartDateStr = b.getLedgerStartDate();
            String ledgerEndDateStr = b.getLedgerEndDate();
            this.glenixTrnXBRLBatches.loadFasV2Batches(doc, ledgerStartDateStr, ledgerEndDateStr);
            if (this.glenixTrnXBRLTransactions == null) {
                this.loadTransactions();
            }
            this.glenixTrnXBRLTransactions.loadFasV2Transactions(doc, ledgerStartDateStr, ledgerEndDateStr, false);
            this.saveTransactions(this.glenixTrnXBRLTransactions.getTransactionArrayList());
            this.glenixTrnXBRLBatches.loadFasV2AddPaySlipBatches(doc, ledgerStartDateStr, ledgerEndDateStr);
            this.saveBatches();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void importFasFile(File file) throws Exception {
        void var12_29;
        Document hoxDoc;
        Transaction ft;
        if (this.glenixFile == null) {
            throw new Exception("Error, you have not opened a MyBusiness.fas file");
        }
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first");
        }
        GlenixFile importFile = new GlenixFile(null, null);
        importFile.openBusinessFileDoNotCreate(file);
        PublicKey pk = this.glenixKey.getPublicKey();
        String base64EncKey = importFile.getBase64EncryptedKey(pk);
        if (base64EncKey == null) {
            throw new Exception("Error, you do not have access to the file you are importing");
        }
        byte[] encKey = Base64.getDecoder().decode(base64EncKey);
        byte[] key = this.glenixKey.decryptBytes(encKey);
        importFile.setKey(key, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        Document counterpartyDoc = null;
        try {
            counterpartyDoc = importFile.getDocumentDecrypt("counterparty.xml", this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (counterpartyDoc != null) {
            GlenixTrnXBRL hox = this.getCounterpartyTransactionList();
            if (hox == null) {
                throw new Exception("Error, importing counterparty but cannot get file counterparty list");
            }
            GlenixTrnXBRL gt = new GlenixTrnXBRL();
            gt.loadDocumentElement(counterpartyDoc, counterpartyDoc.getDocumentElement());
            Business b = gt.getBusiness();
            if (b != null) {
                for (Transaction transaction : b.getTransactionArrayList()) {
                    Counterparty counterparty = transaction.getCounterparty();
                    if (counterparty == null) continue;
                    Transaction ft2 = hox.getCounterpartyTransaction(counterparty);
                    if (ft2 == null) {
                        ft2 = new Transaction();
                        ft2.setCounterparty(counterparty);
                        hox.addTransaction(ft2);
                        continue;
                    }
                    Counterparty fc = ft2.getCounterparty();
                    if (fc == null) continue;
                    Document hoxDoc2 = this.docBuilder.newDocument();
                    counterparty.appendToElement(hoxDoc2);
                    fc.loadDocumentElement(hoxDoc2, hoxDoc2.getDocumentElement());
                }
            }
            this.saveCounterpartyList();
        }
        Document accountDoc = null;
        try {
            accountDoc = importFile.getDocumentDecrypt("account.xml", this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception gt) {
            // empty catch block
        }
        if (accountDoc != null) {
            GlenixTrnXBRL hox = this.getAccountTransactionList();
            if (hox == null) {
                throw new Exception("Error, importing account but cannot get file account list");
            }
            GlenixTrnXBRL gt = new GlenixTrnXBRL();
            gt.loadDocumentElement(accountDoc, accountDoc.getDocumentElement());
            Business b = gt.getBusiness();
            if (b != null) {
                for (Transaction transaction : b.getTransactionArrayList()) {
                    for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
                        Account importA;
                        TransactionLine tl = transaction.getTransactionLine(i);
                        if (tl == null || (importA = tl.getAccount()) == null) continue;
                        ft = hox.getAccountTransaction(importA);
                        if (ft == null) {
                            ft = new Transaction();
                            TransactionLine ftl = ft.addBlankTransactionLine();
                            ftl.setAccount(importA);
                            hox.addTransaction(ft);
                            continue;
                        }
                        Account fa = ft.getAccount();
                        if (fa == null) continue;
                        hoxDoc = this.docBuilder.newDocument();
                        importA.appendToElement(hoxDoc);
                        fa.loadDocumentElement(hoxDoc, hoxDoc.getDocumentElement());
                    }
                }
            }
            this.saveAccountList();
        }
        Document provisionDoc = null;
        try {
            provisionDoc = importFile.getDocumentDecrypt("provision.xml", this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception gt) {
            // empty catch block
        }
        if (provisionDoc != null) {
            GlenixTrnXBRL hox = this.getGlenixTrnXBRLProvision();
            if (hox == null) {
                throw new Exception("Error, importing provision but cannot get file provision list");
            }
            GlenixTrnXBRL gt = new GlenixTrnXBRL();
            gt.loadDocumentElement(provisionDoc, provisionDoc.getDocumentElement());
            Business business = gt.getBusiness();
            if (business != null) {
                for (Transaction t : business.getTransactionArrayList()) {
                    for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                        Provision importP;
                        TransactionLine tl = t.getTransactionLine(i);
                        if (tl == null || (importP = tl.getProvision()) == null) continue;
                        Provision ftp = hox.getProvisionTransactionProvision(importP);
                        if (ftp == null) {
                            Transaction ft3 = new Transaction();
                            TransactionLine ftl = ft3.addBlankTransactionLine();
                            ftl.setProvision(importP);
                            hox.addTransaction(ft3);
                            continue;
                        }
                        hoxDoc = this.docBuilder.newDocument();
                        importP.appendToElement(hoxDoc);
                        ftp.loadDocumentElement(hoxDoc, hoxDoc.getDocumentElement());
                    }
                }
            }
            this.saveProvisionList();
        }
        Document batchDoc = null;
        try {
            batchDoc = importFile.getDocumentDecrypt("batch.xml", this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception gt) {
            // empty catch block
        }
        if (batchDoc != null) {
            GlenixTrnXBRL hox = this.getBatches();
            if (hox == null) {
                throw new Exception("Error, importing batch but cannot get file batch list");
            }
            GlenixTrnXBRL glenixTrnXBRL = new GlenixTrnXBRL();
            glenixTrnXBRL.loadDocumentElement(batchDoc, batchDoc.getDocumentElement());
            Business business = glenixTrnXBRL.getBusiness();
            if (business != null) {
                for (Transaction t : business.getTransactionArrayList()) {
                    Batch importP = t.getBatch();
                    if (importP == null) continue;
                    ft = hox.getBatchTransaction(importP);
                    if (ft == null) {
                        ft = new Transaction();
                        ft.setBatch(importP);
                        hox.addTransaction(ft);
                        continue;
                    }
                    Document hoxDoc3 = this.docBuilder.newDocument();
                    importP.appendToElement(hoxDoc3);
                    Batch fb = ft.getBatch();
                    fb.loadDocumentElement(hoxDoc3, hoxDoc3.getDocumentElement());
                }
            }
            this.saveBatches();
        }
        Document activityStatementDoc = null;
        try {
            activityStatementDoc = importFile.getDocumentDecrypt("activityStatementList.xml", this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (activityStatementDoc != null) {
            ActivityStatementList activityStatementList;
            GlenixTrnXBRL glenixTrnXBRL = this.getActivityStatementList();
            if (glenixTrnXBRL == null) {
                throw new Exception("Error, importing activityStatement but cannot get file activityStatementList");
            }
            GlenixTrnXBRL glenixTrnXBRL2 = new GlenixTrnXBRL();
            glenixTrnXBRL2.loadDocumentElement(activityStatementDoc, activityStatementDoc.getDocumentElement());
            Business b = glenixTrnXBRL2.getBusiness();
            if (b != null && (activityStatementList = b.getActivityStatementList()) != null) {
                Business hoxb = glenixTrnXBRL.getBusiness();
                ActivityStatementList hoxAsl = hoxb.getActivityStatementList();
                if (hoxAsl != null) {
                    Document aslDoc = this.docBuilder.newDocument();
                    activityStatementList.appendToElement(aslDoc);
                    hoxAsl.loadDocumentElement(aslDoc, aslDoc.getDocumentElement());
                } else {
                    hoxb.setActivityStatementList(activityStatementList);
                }
                this.saveActivityStatementList(activityStatementList);
                ActivityStatementListResponse activityStatementListResponse = activityStatementList.getActivityStatementListResponse();
                if (activityStatementListResponse != null) {
                    for (ASLStatement asls : activityStatementListResponse.getASLStatementList()) {
                        String asnumber = asls.getActivityStatementNumber();
                        if (asnumber == null || asnumber.isEmpty()) continue;
                        String assource = "activityStatement_" + asnumber + ".xml";
                        Document asdoc = null;
                        try {
                            asdoc = importFile.getDocumentDecrypt(assource, this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
                            GlenixTrnXBRL glenixTrnXBRLActivityStatement = this.loadActivityStatement(asnumber);
                            if (glenixTrnXBRLActivityStatement == null) {
                                this.saveFileEncrypt("activityStatement_" + asnumber + ".xml", asdoc);
                            } else {
                                glenixTrnXBRLActivityStatement.loadDocumentElement(asdoc, asdoc.getDocumentElement());
                                Document loadedDoc = glenixTrnXBRLActivityStatement.buildDocument();
                                this.saveFileEncrypt("activityStatement_" + asnumber + ".xml", loadedDoc);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (asdoc == null) continue;
                        this.saveFileEncrypt(assource, asdoc);
                    }
                }
                this.glenixTrnXBRLActivityStatementHashMap = new HashMap();
            }
        }
        Object var12_27 = null;
        try {
            Document document = importFile.getDocumentDecrypt("transactions.xml", this.glenixKey.convertToPGPPrivateKey(), this.glenixKey.convertToPGPPublicKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (var12_29 != null) {
            GlenixTrnXBRL glenixTrnXBRL = this.getTransactions();
            if (glenixTrnXBRL == null) {
                throw new Exception("Error, importing transaction but cannot get file transaction list");
            }
            Business hoxb = glenixTrnXBRL.getBusiness();
            if (hoxb == null) {
                throw new Exception("Error, importing transaction but cannot get file business");
            }
            LocalDate start = hoxb.getLedgerStartDateAsDate();
            LocalDate end = hoxb.getLedgerEndDateAsDate();
            GlenixTrnXBRL gt = new GlenixTrnXBRL();
            gt.loadDocumentElement((Document)var12_29, var12_29.getDocumentElement());
            Business b = gt.getBusiness();
            if (b != null) {
                for (Transaction t : b.getTransactionArrayList()) {
                    LocalDate tdate = t.getTransactionDateAsDate();
                    if (tdate == null || start != null && start.isAfter(tdate) || end != null && end.isBefore(tdate)) continue;
                    Transaction ft4 = hoxb.getTransaction(t);
                    if (ft4 == null) {
                        hoxb.addTransaction(t);
                        continue;
                    }
                    Document tDoc = this.docBuilder.newDocument();
                    t.appendToElement(tDoc);
                    ft4.loadDocumentElement(tDoc, tDoc.getDocumentElement());
                }
            }
            this.saveTransactionList();
        }
        importFile.closeFile();
    }

    public void importXmlFile_all(File file) throws Exception {
        throw new Exception("Error, import all xml not implemented in desktop version");
    }

    public void importXmlFile_counterparty(File file) throws Exception {
        if (this.glenixFile == null) {
            throw new Exception("Error, you have not opened a MyBusiness.fas file");
        }
        if (this.glenixKey == null) {
            throw new Exception("Error, you have not unlocked your FAS identity, unlock your FAS identity first");
        }
        Document counterpartyDoc = this.docBuilder.parse(file);
        if (counterpartyDoc == null) {
            throw new Exception("Cannot open file");
        }
        GlenixTrnXBRL hox = this.getCounterpartyTransactionList();
        if (hox == null) {
            throw new Exception("Error, importing counterparty but cannot get file counterparty list");
        }
        GlenixTrnXBRL gt = new GlenixTrnXBRL();
        gt.loadDocumentElement(counterpartyDoc, counterpartyDoc.getDocumentElement());
        Business b = gt.getBusiness();
        if (b != null) {
            for (Transaction t : b.getTransactionArrayList()) {
                Counterparty importC = t.getCounterparty();
                if (importC == null) continue;
                Transaction ft = hox.getCounterpartyTransaction(importC);
                if (ft == null) {
                    ft = new Transaction();
                    ft.setCounterparty(importC);
                    hox.addTransaction(ft);
                    continue;
                }
                Counterparty fc = ft.getCounterparty();
                if (fc == null) continue;
                Document hoxDoc = this.docBuilder.newDocument();
                importC.appendToElement(hoxDoc);
                fc.loadDocumentElement(hoxDoc, hoxDoc.getDocumentElement());
            }
        }
        this.saveCounterpartyList();
    }

    public void importXmlFile_account(File file) throws Exception {
        Document accountDoc = this.docBuilder.parse(file);
        if (accountDoc == null) {
            throw new Exception("Cannot read file");
        }
        GlenixTrnXBRL hox = this.getAccountTransactionList();
        if (hox == null) {
            throw new Exception("Error, importing account but cannot get file account list");
        }
        GlenixTrnXBRL gt = new GlenixTrnXBRL();
        gt.loadDocumentElement(accountDoc, accountDoc.getDocumentElement());
        Business b = gt.getBusiness();
        if (b != null) {
            for (Transaction t : b.getTransactionArrayList()) {
                for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                    Account importA;
                    TransactionLine tl = t.getTransactionLine(i);
                    if (tl == null || (importA = tl.getAccount()) == null) continue;
                    Transaction ft = hox.getAccountTransaction(importA);
                    if (ft == null) {
                        ft = new Transaction();
                        TransactionLine ftl = ft.addBlankTransactionLine();
                        ftl.setAccount(importA);
                        hox.addTransaction(ft);
                        continue;
                    }
                    Account fa = ft.getAccount();
                    if (fa == null) continue;
                    Document hoxDoc = this.docBuilder.newDocument();
                    importA.appendToElement(hoxDoc);
                    fa.loadDocumentElement(hoxDoc, hoxDoc.getDocumentElement());
                }
            }
        }
        this.saveAccountList();
    }

    public void importXmlFile_provision(File file) throws Exception {
        Document provisionDoc = this.docBuilder.parse(file);
        if (provisionDoc == null) {
            throw new Exception("Error, cannot read file");
        }
        GlenixTrnXBRL hox = this.getGlenixTrnXBRLProvision();
        if (hox == null) {
            throw new Exception("Error, importing provision but cannot get file provision list");
        }
        GlenixTrnXBRL gt = new GlenixTrnXBRL();
        gt.loadDocumentElement(provisionDoc, provisionDoc.getDocumentElement());
        Business b = gt.getBusiness();
        if (b != null) {
            for (Transaction t : b.getTransactionArrayList()) {
                for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                    Provision importP;
                    TransactionLine tl = t.getTransactionLine(i);
                    if (tl == null || (importP = tl.getProvision()) == null) continue;
                    Provision ftp = hox.getProvisionTransactionProvision(importP);
                    if (ftp == null) {
                        Transaction ft = new Transaction();
                        TransactionLine ftl = ft.addBlankTransactionLine();
                        ftl.setProvision(importP);
                        hox.addTransaction(ft);
                        continue;
                    }
                    Document hoxDoc = this.docBuilder.newDocument();
                    importP.appendToElement(hoxDoc);
                    ftp.loadDocumentElement(hoxDoc, hoxDoc.getDocumentElement());
                }
            }
        }
        this.saveProvisionList();
    }

    public void importXmlFile_batch(File file) throws Exception {
        Document batchDoc = this.docBuilder.parse(file);
        if (batchDoc == null) {
            throw new Exception("Error cannot read file");
        }
        GlenixTrnXBRL hox = this.getBatches();
        if (hox == null) {
            throw new Exception("Error, importing batch but cannot get file batch list");
        }
        GlenixTrnXBRL gt = new GlenixTrnXBRL();
        gt.loadDocumentElement(batchDoc, batchDoc.getDocumentElement());
        Business b = gt.getBusiness();
        if (b != null) {
            for (Transaction t : b.getTransactionArrayList()) {
                Batch importP = t.getBatch();
                if (importP == null) continue;
                Transaction ft = hox.getBatchTransaction(importP);
                if (ft == null) {
                    ft = new Transaction();
                    ft.setBatch(importP);
                    hox.addTransaction(ft);
                    continue;
                }
                Document hoxDoc = this.docBuilder.newDocument();
                importP.appendToElement(hoxDoc);
                Batch fb = ft.getBatch();
                fb.loadDocumentElement(hoxDoc, hoxDoc.getDocumentElement());
            }
        }
        this.saveBatches();
    }

    public void importXmlFile_activityStatementList(File file) throws Exception {
        ActivityStatementList activityStatementList;
        Document activityStatementDoc = this.docBuilder.parse(file);
        if (activityStatementDoc == null) {
            throw new Exception("Error, cannot read file");
        }
        GlenixTrnXBRL hox = this.getActivityStatementList();
        if (hox == null) {
            throw new Exception("Error, importing activityStatement but cannot get file activityStatementList");
        }
        GlenixTrnXBRL gt = new GlenixTrnXBRL();
        gt.loadDocumentElement(activityStatementDoc, activityStatementDoc.getDocumentElement());
        Business b = gt.getBusiness();
        if (b != null && (activityStatementList = b.getActivityStatementList()) != null) {
            Business hoxb = hox.getBusiness();
            ActivityStatementList hoxAsl = hoxb.getActivityStatementList();
            if (hoxAsl != null) {
                Document aslDoc = this.docBuilder.newDocument();
                activityStatementList.appendToElement(aslDoc);
                hoxAsl.loadDocumentElement(aslDoc, aslDoc.getDocumentElement());
            } else {
                hoxb.setActivityStatementList(activityStatementList);
            }
            this.saveActivityStatementList(activityStatementList);
        }
    }

    public void importXmlFile_activityStatement(File file, String asNumber) throws Exception {
        Document asdoc = this.docBuilder.parse(file);
        if (asdoc == null) {
            throw new Exception("Error, cannot parse file");
        }
        GlenixTrnXBRL glenixTrnXBRLActivityStatement = this.loadActivityStatement(asNumber);
        if (glenixTrnXBRLActivityStatement == null) {
            this.saveFileEncrypt("activityStatement_" + asNumber + ".xml", asdoc);
            return;
        }
        glenixTrnXBRLActivityStatement.loadDocumentElement(asdoc, asdoc.getDocumentElement());
        Document loadedDoc = glenixTrnXBRLActivityStatement.buildDocument();
        this.saveFileEncrypt("activityStatement_" + asNumber + ".xml", loadedDoc);
        this.glenixTrnXBRLActivityStatementHashMap = new HashMap();
    }

    public void importXmlFile_transactions(File file) throws Exception {
        Document transactionsDoc = this.docBuilder.parse(file);
        if (transactionsDoc == null) {
            throw new Exception("Error, cannot parse transactions file");
        }
        GlenixTrnXBRL hox = this.getTransactions();
        if (hox == null) {
            throw new Exception("Error, importing transaction but cannot get file transaction list");
        }
        Business hoxb = hox.getBusiness();
        if (hoxb == null) {
            throw new Exception("Error, importing transaction but cannot get file business");
        }
        LocalDate start = hoxb.getLedgerStartDateAsDate();
        LocalDate end = hoxb.getLedgerEndDateAsDate();
        GlenixTrnXBRL gt = new GlenixTrnXBRL();
        gt.loadDocumentElement(transactionsDoc, transactionsDoc.getDocumentElement());
        Business b = gt.getBusiness();
        if (b != null) {
            for (Transaction t : b.getTransactionArrayList()) {
                LocalDate tdate = t.getTransactionDateAsDate();
                if (tdate == null || start != null && start.isAfter(tdate) || end != null && end.isBefore(tdate)) continue;
                Transaction ft = hoxb.getTransaction(t);
                if (ft == null) {
                    hoxb.addTransaction(t);
                    continue;
                }
                Document tDoc = this.docBuilder.newDocument();
                t.appendToElement(tDoc);
                ft.loadDocumentElement(tDoc, tDoc.getDocumentElement());
            }
        }
        this.saveTransactionList();
    }

    public File createPDFFile(String defaultName) throws IOException {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.pdf"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        fileChooser.setInitialFileName(defaultName + ".pdf");
        return fileChooser.showSaveDialog((Window)this.stage);
    }

    public File createODTFile(String defaultName) throws IOException {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("ODT files (*.odt)", new String[]{"*.odt"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        fileChooser.setInitialFileName(defaultName + ".odt");
        return fileChooser.showSaveDialog((Window)this.stage);
    }

    public File createOtherFile(String defaultNameWithExt) throws IOException {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(defaultNameWithExt);
        return fileChooser.showSaveDialog((Window)this.stage);
    }

    public File openOtherFile(String defaultNameWithExt) throws IOException {
        FileChooser fileChooser = new FileChooser();
        if (defaultNameWithExt != null && !defaultNameWithExt.isEmpty()) {
            fileChooser.setInitialFileName(defaultNameWithExt);
        }
        return fileChooser.showOpenDialog((Window)this.stage);
    }

    public void showDocument(String path) {
        this.glenix.getHostServices().showDocument(path);
    }

    public void printNode(Node node) throws Exception {
        Printer thePrinter = Printer.getDefaultPrinter();
        if (thePrinter == null) {
            ObservableSet printers = Printer.getAllPrinters();
            Iterator iterator = printers.iterator();
            while (iterator.hasNext()) {
                Printer printer;
                thePrinter = printer = (Printer)iterator.next();
            }
        }
        if (thePrinter == null) {
            throw new Exception("Error, cannot find a printer");
        }
        PageLayout pageLayout = thePrinter.createPageLayout(Paper.A4, PageOrientation.PORTRAIT, Printer.MarginType.DEFAULT);
        double scaleX = pageLayout.getPrintableWidth() / node.getBoundsInParent().getWidth();
        double scaleY = pageLayout.getPrintableHeight() / node.getBoundsInParent().getHeight();
        node.getTransforms().add((Object)new Scale(scaleX, scaleY));
        PrinterJob job = PrinterJob.createPrinterJob((Printer)thePrinter);
        if (job == null) {
            throw new Exception("Error, printer job cannot be started");
        }
        job.showPrintDialog((Window)this.stage);
        job.printPage(node);
        job.endJob();
    }

    @FXML
    private void pdfCurrentPage() {
        this.pdfCurrentPage(false);
    }

    @FXML
    private void pdfCurrentPageWithBlanks() {
        this.pdfCurrentPage(true);
    }

    private void pdfCurrentPage(boolean includeBlanks) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "report" : "report_" + reportName.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
            GlenixPDFWrapper gpw = null;
            for (Node node : this.file_content_display.getChildren()) {
                GlenixController gc;
                if (!(node instanceof GlenixPane) || (gc = ((GlenixPane)node).getGlenixController()) == null) continue;
                gpw = gc.buildPDF(includeBlanks);
                String elementDescription = gc.getGlenixElementDescription();
                if (elementDescription == null) break;
                reportName = reportName + "_" + elementDescription.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
                break;
            }
            if (gpw == null) {
                throw new Exception("Error, unable to generate pdf for this page");
            }
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            gpw.savePdfReport(file);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public Double getStageX() {
        return this.stage.getX();
    }

    public Double getStageY() {
        return this.stage.getY();
    }

    public Double getStageWidth() {
        return this.stage.getWidth();
    }

    public Double getStageHeight() {
        return this.stage.getHeight();
    }

    private void searchForTextNode(Node node, String searchText, boolean checkvisible) throws Exception {
        if (checkvisible && !node.isVisible()) {
            return;
        }
        if (node instanceof Label) {
            String text = ((Label)node).getText();
            if (text != null && !text.isEmpty() && text.toLowerCase().contains(searchText)) {
                node.getStyleClass().add((Object)"searchresult");
                this.searchResultNodes.add(node);
            }
        } else {
            GlenixPane gp;
            Pane fp;
            ObservableList oln;
            if (node instanceof Pane && (oln = (fp = (Pane)node).getChildren()).size() > 0) {
                for (Node childNode : oln) {
                    this.searchForTextNode(childNode, searchText, true);
                }
            }
            if (node instanceof ScrollPane) {
                Node contentNode = ((ScrollPane)node).getContent();
                if (contentNode != null) {
                    this.searchForTextNode(contentNode, searchText, true);
                }
            } else if (node instanceof TitledPane) {
                Node contentNode;
                String text = ((TitledPane)node).getText();
                if (text != null && !text.isEmpty() && text.toLowerCase().contains(searchText)) {
                    node.getStyleClass().add((Object)"searchresulttitle");
                    this.searchResultNodes.add(node);
                }
                if ((contentNode = ((TitledPane)node).getContent()) != null) {
                    this.searchForTextNode(contentNode, searchText, false);
                }
            } else if (node instanceof GlenixPane && (gp = (GlenixPane)node).hasSearchText(searchText)) {
                node.getStyleClass().add((Object)"searchresult");
                this.searchResultNodes.add(node);
            }
        }
    }

    private Double getNodeTop(Node node, Node ancestorNode) {
        if (node == ancestorNode) {
            return 0.0;
        }
        Parent parentNode = node.getParent();
        Double result = node.getBoundsInParent().getMinY();
        if (parentNode == ancestorNode || ancestorNode == null) {
            return result;
        }
        return result + this.getNodeTop((Node)parentNode, ancestorNode);
    }

    public void focusSearch() {
        this.searchText.requestFocus();
    }

    public void resetSearch() {
        for (Node n : this.searchResultNodes) {
            n.getStyleClass().removeAll((Object[])new String[]{"searchresult"});
            n.getStyleClass().removeAll((Object[])new String[]{"searchresultactive"});
            n.getStyleClass().removeAll((Object[])new String[]{"searchresulttitle"});
            n.getStyleClass().removeAll((Object[])new String[]{"searchresulttitleactive"});
        }
        this.searchResultNodes.clear();
        this.searchText.getStyleClass().removeAll((Object[])new String[]{"textFieldError"});
        if (this.searchTitledPane != null) {
            this.searchTitledPane.expandedProperty().setValue(Boolean.valueOf(false));
            this.searchTitledPane = null;
        }
    }

    public void setSearchText(String searchText) {
        this.searchText.setText(searchText);
    }

    @FXML
    public void searchForText() {
        this.searchForTextCount(1);
    }

    @FXML
    public void searchForTextBack() {
        this.searchForTextCount(-1);
    }

    private void searchForTextCount(int count) {
        if (this.searchResultNodes != null && this.searchResultNodes.size() > 0) {
            this.searchResultCurrentIndex += count;
            if (this.searchResultCurrentIndex < 0) {
                this.searchResultCurrentIndex = this.searchResultNodes.size() - 1;
            } else if (this.searchResultCurrentIndex >= this.searchResultNodes.size()) {
                this.searchResultCurrentIndex = 0;
            }
            this.scrollToNode(this.searchResultNodes.get(this.searchResultCurrentIndex));
            return;
        }
        String searchTextStr = this.searchText.getText();
        if (searchTextStr == null || searchTextStr.isEmpty()) {
            return;
        }
        this.resetSearch();
        try {
            this.searchForTextNode((Node)this.file_content_display, searchTextStr.toLowerCase(), true);
            if (this.searchResultNodes.size() > 0) {
                this.searchResultCurrentIndex = 0;
                this.scrollToNode(this.searchResultNodes.get(this.searchResultCurrentIndex));
            } else {
                this.searchText.getStyleClass().add((Object)"textFieldError");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scrollToNode(Node node) {
        if (node != null) {
            if (this.searchTitledPane != null) {
                this.searchTitledPane.expandedProperty().setValue(Boolean.valueOf(false));
                this.searchTitledPane = null;
            }
            Node parentNode = node;
            while ((parentNode = parentNode.getParent()) != null) {
                if (!(parentNode instanceof TitledPane) || ((TitledPane)parentNode).isExpanded()) continue;
                ((TitledPane)parentNode).expandedProperty().setValue(Boolean.valueOf(true));
                this.searchTitledPane = (TitledPane)parentNode;
            }
            if (this.searchResultActiveNode != null) {
                if (this.searchResultActiveNode instanceof TitledPane) {
                    this.searchResultActiveNode.getStyleClass().removeAll((Object[])new String[]{"searchresulttitleactive"});
                } else {
                    this.searchResultActiveNode.getStyleClass().removeAll((Object[])new String[]{"searchresultactive"});
                }
            }
            if (node instanceof TitledPane) {
                node.getStyleClass().add((Object)"searchresulttitleactive");
            } else {
                node.getStyleClass().add((Object)"searchresultactive");
            }
            this.searchResultActiveNode = node;
            Double top = this.getNodeTop(node, (Node)this.file_content_display);
            if (this.main_content_scroll_pane != null) {
                Double totalHeight = this.main_content_scroll_pane.getContent().getBoundsInLocal().getHeight();
                this.main_content_scroll_pane.setVvalue(top / totalHeight);
            } else {
                Node anode = node;
                while ((anode = anode.getParent()) != null && !(anode instanceof ScrollPane)) {
                }
                if (anode != null && anode instanceof ScrollPane) {
                    ScrollPane sp = (ScrollPane)anode;
                    Double totalHeight = sp.getContent().getBoundsInLocal().getHeight();
                    sp.setVvalue(top / totalHeight);
                }
            }
        }
    }

    public File getThisJarFile() throws Exception {
        URL url = Glenix.class.getResource("Glenix.class");
        String jarFilePath = URLDecoder.decode(url.toString(), "UTF-8");
        if (jarFilePath == null) {
            return null;
        }
        File result = new File((jarFilePath = jarFilePath.replaceFirst("jar:file:", "").replace("!/au/com/glenix/Glenix.class", "")).trim());
        if (result.exists()) {
            return result;
        }
        url = Glenix.class.getProtectionDomain().getCodeSource().getLocation();
        return new File(url.toURI());
    }

    public File installJarFile(File installDir) throws Exception {
        if (installDir == null) {
            throw new Exception("Error, cannot install jar file into null directory");
        }
        if (!installDir.exists() && !installDir.mkdirs()) {
            throw new Exception("Error, unable to create the install directory, " + installDir.getAbsolutePath());
        }
        if (!installDir.canWrite()) {
            throw new Exception("Error, unable to write to the install directory, " + installDir.getAbsolutePath());
        }
        File installFile = Glenix.installJarFile(installDir);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            String home = System.getProperty("user.home");
            File desktopDir = new File(home + "\\Desktop");
            if (!desktopDir.exists()) {
                throw new Exception("Error, unable to find Desktop directory");
            }
            File createShortcutFile = File.createTempFile("FAS3DInstall", ".vbs");
            createShortcutFile.deleteOnExit();
            FileWriter fileWriter = new FileWriter(createShortcutFile);
            if (fileWriter == null) {
                throw new Exception("Error, unable to build Desktop shortcut install script");
            }
            fileWriter.write("Set WshShell = WScript.CreateObject(\"WScript.Shell\")\n");
            fileWriter.write("Set myShortCut = WshShell.CreateShortcut(\"" + desktopDir.getAbsolutePath() + "\\FAS3Desktop (Free Accounting Software).lnk\")\n");
            fileWriter.write("myShortCut.IconLocation = \"" + installDir.getAbsolutePath() + "\\FAS3Desktop.ico\"\n");
            fileWriter.write("myShortCut.TargetPath = \"javaw\"\n");
            fileWriter.write("myShortCut.Arguments = \"-jar \"\"" + installDir.getAbsolutePath() + "\\FAS3Desktop.jar\"\"\"\n");
            fileWriter.write("myShortCut.Save\n");
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            Runtime rt = Runtime.getRuntime();
            String[] cmdarray = new String[]{"cscript", createShortcutFile.getAbsolutePath()};
            Process p = rt.exec(cmdarray);
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new Exception("Error, unable to build Desktop shortcut");
            }
            String appdata = System.getenv("APPDATA");
            if (appdata != null && !appdata.isEmpty()) {
                String startProgDirStr = appdata + "\\Microsoft\\Windows\\Start Menu\\Programs";
                File startProgDir = new File(startProgDirStr);
                if (!startProgDir.exists()) {
                    throw new Exception("Error, unable to find start menu directory");
                }
                if (!startProgDir.isDirectory()) {
                    throw new Exception("Error, the start menu directory is not a directory");
                }
                createShortcutFile = File.createTempFile("FAS3DInstallpt2", ".vbs");
                createShortcutFile.deleteOnExit();
                fileWriter = new FileWriter(createShortcutFile);
                if (fileWriter == null) {
                    throw new Exception("Error, unable to build start menu install script");
                }
                fileWriter.write("Set WshShell = WScript.CreateObject(\"WScript.Shell\")\n");
                fileWriter.write("Set myShortCut = WshShell.CreateShortcut(\"" + startProgDir.getAbsolutePath() + "\\FAS3Desktop (Free Accounting Software).lnk\")\n");
                fileWriter.write("myShortCut.IconLocation = \"" + installDir.getAbsolutePath() + "\\FAS3Desktop.ico\"\n");
                fileWriter.write("myShortCut.TargetPath = javaw\n");
                fileWriter.write("myShortCut.Arguments = \"-jar \"\"" + installDir.getAbsolutePath() + "\\FAS3Desktop.jar\"\"\"\n");
                fileWriter.write("myShortCut.Save\n");
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                rt = Runtime.getRuntime();
                cmdarray = new String[]{"cscript", createShortcutFile.getAbsolutePath()};
                p = rt.exec(cmdarray);
                p.waitFor();
                if (p.exitValue() != 0) {
                    throw new Exception("Error, unable to build start menu shortcut");
                }
            }
        }
        return installFile;
    }

    public File getInstalledJarFile(String path) throws Exception {
        if (path != null && !path.isEmpty()) {
            return new File(path + File.separator + "FAS3Desktop.jar");
        }
        File dir = this.locateInstallDirectory();
        if (dir == null) {
            throw new Exception("Error, unable to locate install directory");
        }
        return new File(dir.getAbsoluteFile() + File.separator + "FAS3Desktop.jar");
    }

    public File locateInstallFile() throws Exception {
        File installDir = this.locateInstallDirectory();
        if (installDir == null) {
            return null;
        }
        return new File(installDir.getAbsolutePath() + File.separator + "FAS3Desktop.jar");
    }

    public File locateInstallDirectory() throws Exception {
        File dir;
        File f;
        String fasInstallDirStr = this.getConfigValue("fasinstall_dir", null);
        if (fasInstallDirStr != null && !fasInstallDirStr.isEmpty() && (f = new File(fasInstallDirStr)).exists()) {
            return f;
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            String appdata = System.getenv("APPDATA");
            fasInstallDirStr = appdata + File.separator + "FASidentity";
            return new File(fasInstallDirStr);
        }
        if (os.indexOf("mac") >= 0) {
            String home = System.getProperty("user.home");
            fasInstallDirStr = home + "/library/Application Support/FASidentity";
            return new File(fasInstallDirStr);
        }
        if (os.indexOf("bsd") >= 0 || os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0 || os.indexOf("sunos") >= 0) {
            String home = System.getProperty("user.home");
            fasInstallDirStr = home + "/FASidentity";
            return new File(fasInstallDirStr);
        }
        String appdata = System.getenv("APPDATA");
        if (appdata != null && !appdata.isEmpty() && (dir = new File(appdata)).exists()) {
            fasInstallDirStr = appdata + File.separator + "FASidentity";
            return new File(fasInstallDirStr);
        }
        String home = System.getProperty("user.home");
        if (home != null && !home.isEmpty()) {
            String homedir = home + "/library/Application Support";
            File dir2 = new File(homedir);
            if (dir2.exists()) {
                fasInstallDirStr = home + "/library/Application Support/FASidentity";
                return new File(fasInstallDirStr);
            }
            homedir = home + "/library/application support";
            dir2 = new File(homedir);
            if (dir2.exists()) {
                fasInstallDirStr = home + "/library/application support/FASidentity";
                return new File(fasInstallDirStr);
            }
            dir2 = new File(home);
            if (dir2.exists()) {
                fasInstallDirStr = home + "/FASidentity";
                return new File(fasInstallDirStr);
            }
        }
        return null;
    }

    public boolean hasGST(String basClassification) {
        if (basClassification == null || basClassification.isEmpty()) {
            return false;
        }
        return basClassification.equals("GST_Taxable_Sales") || basClassification.equals("Sales_Adjustments") || basClassification.equals("Capital_Purchases") || basClassification.equals("Non_Capital_Purchases") || basClassification.equals("Purchase_Adjustments");
    }

    private String formatFiveDp(Double rate) {
        if (rate == null) {
            return null;
        }
        return this.formatFiveDp.format(rate);
    }

    private String formatTwoDp(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.formatTwoDp.format(amount);
    }

    private String formatTwoDpDollars(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.formatTwoDpDollars.format(amount);
    }

    private String formatMoney(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.formatTwoDpDollars(amount);
    }

    private String formatMoney(String amountStr) {
        if (amountStr == null || amountStr.isEmpty()) {
            return amountStr;
        }
        try {
            Double d = Double.parseDouble(amountStr);
            return this.formatTwoDpDollars(d);
        }
        catch (Exception e) {
            return amountStr;
        }
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    private Double subtractDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return -dd.doubleValue();
        }
        return d - dd;
    }

    public void buildPDFGenericInvoice(File file, Transaction transaction, String documentName, String documentHeading, String documentHeadingNoGST) throws Exception {
        String termsAndConditions;
        String paymentInstructions;
        String transactionComment;
        String paymentTerms;
        String date;
        Counterparty c;
        Transaction ct;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        String gstreg = "false";
        boolean displayGST = true;
        Business b = this.getBusiness();
        BusinessMasterFile bmf = null;
        DocumentLayout documentLayout = null;
        if (b != null) {
            documentLayout = b.getDocumentLayout();
            if (documentLayout != null) {
                int count = documentLayout.getLayoutImageCount();
                for (int i = 0; i < count; ++i) {
                    InputStream is;
                    LayoutImage li = documentLayout.getLayoutImage(i);
                    String filename = li.getImageFileName();
                    if (filename == null || filename.isEmpty() || (is = this.getFileDecrypt(filename = "images/" + filename)) == null) continue;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    byte[] readBytes = new byte[1024];
                    int readLen = 0;
                    int totalRead = 0;
                    while ((readLen = is.read(readBytes)) >= 0) {
                        buffer.write(readBytes, 0, readLen);
                        totalRead += readLen;
                    }
                    if (totalRead <= 0) continue;
                    buffer.flush();
                    gpw.addImage(buffer.toByteArray(), li.getImageFileName(), li.getImageLocation(), li.getImageWidthAsDouble(), li.getImageHeightAsDouble());
                }
            }
            bmf = b.getBusinessMasterFile();
        }
        gpw.addPDPage();
        gpw.setColumns(9);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 30.0, 80.0);
        gpw.setColumnLeftPosAndWidthMM(3, 140.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(4, 174.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(5, 20.0, 102.0);
        gpw.setColumnLeftPosAndWidthMM(6, 126.0, 22.0);
        gpw.setColumnLeftPosAndWidthMM(7, 152.0, 22.0);
        gpw.setColumnLeftPosAndWidthMM(8, 178.0, 22.0);
        if (gpw.muliBoldFont != null) {
            gpw.setColumnFont(0, gpw.muliBoldFont);
        } else {
            gpw.setColumnFont(0, PDType1Font.HELVETICA_BOLD);
        }
        if (gpw.muliLightFont != null) {
            gpw.setColumnFont(1, gpw.muliLightFont);
            gpw.setColumnFont(2, gpw.muliLightFont);
            gpw.setColumnFont(3, gpw.muliLightFont);
            gpw.setColumnFont(4, gpw.muliLightFont);
            gpw.setColumnFont(5, gpw.muliLightFont);
            gpw.setColumnFont(6, gpw.muliLightFont);
            gpw.setColumnFont(7, gpw.muliLightFont);
            gpw.setColumnFont(8, gpw.muliLightFont);
        } else {
            gpw.setColumnFont(1, PDType1Font.HELVETICA);
            gpw.setColumnFont(2, PDType1Font.HELVETICA);
            gpw.setColumnFont(3, PDType1Font.HELVETICA);
            gpw.setColumnFont(4, PDType1Font.HELVETICA);
            gpw.setColumnFont(5, PDType1Font.HELVETICA);
            gpw.setColumnFont(6, PDType1Font.HELVETICA);
            gpw.setColumnFont(7, PDType1Font.HELVETICA);
            gpw.setColumnFont(8, PDType1Font.HELVETICA);
        }
        if (bmf != null) {
            String prefix;
            StringBuilder otherSB;
            ElectronicContact ec;
            String displayName;
            gstreg = bmf.getBusinessIsRegisteredForGST();
            if (gstreg != null && gstreg.equals("false")) {
                displayGST = false;
                gpw.setColumnLeftPosAndWidthMM(5, 20.0, 154.0);
            }
            if ((displayName = bmf.getBusinessTradingName()) == null || displayName.isEmpty()) {
                displayName = bmf.getBusinessLegalName();
            }
            if (displayName != null && !displayName.isEmpty()) {
                gpw.prepareString(0, displayName, true, 14.0);
                gpw.drawStrings();
            }
            TFND0004AddressDetailsBusiness addr = bmf.getBusinessPostalAddress();
            String val = null;
            if (addr != null) {
                val = addr.getLine1T();
            }
            if ((val == null || val.isEmpty()) && (addr = bmf.getBusinessBusinessAddress()) != null) {
                val = addr.getLine1T();
            }
            if (val != null && !val.isEmpty()) {
                StringBuilder fullSB = new StringBuilder();
                fullSB.append(val);
                val = addr.getLine2T();
                if (val != null && !val.isEmpty()) {
                    fullSB.append(", ");
                    fullSB.append(val);
                }
                String prefix2 = ", ";
                val = addr.getLocalityNameT();
                if (val != null && !val.isEmpty()) {
                    fullSB.append(prefix2);
                    fullSB.append(val);
                    prefix2 = " ";
                }
                if ((val = addr.getStateOrTerritoryC()) != null && !val.isEmpty()) {
                    fullSB.append(prefix2);
                    fullSB.append(val);
                    prefix2 = " ";
                }
                if ((val = addr.getPostcodeT()) != null && !val.isEmpty()) {
                    fullSB.append(prefix2);
                    fullSB.append(val);
                    prefix2 = " ";
                }
                if ((val = addr.getCountryC()) != null && !val.isEmpty() && !val.equals("au")) {
                    String name = this.getCountryName(val);
                    fullSB.append(prefix2);
                    fullSB.append(name);
                }
                if ((val = fullSB.toString()) != null && !val.isEmpty()) {
                    gpw.prepareString(1, val, true, 12.0);
                }
            }
            if ((ec = bmf.getBusinessElectronicContact()) != null) {
                String ac;
                otherSB = new StringBuilder();
                prefix = "";
                val = ec.getTelephoneMinimalN();
                if (val != null && !val.isEmpty() && (ac = ec.getTelephoneAreaC()) != null && !ac.isEmpty()) {
                    val = ac + " " + val;
                }
                if (val != null && !val.isEmpty()) {
                    otherSB.append("Tel: " + val);
                    prefix = " ";
                }
                if ((val = ec.getElectronicMailAddressT()) != null && !val.isEmpty()) {
                    otherSB.append(prefix);
                    otherSB.append(val);
                    prefix = " ";
                }
                if ((val = otherSB.toString()) != null && !val.isEmpty()) {
                    gpw.prepareString(1, val, true, 12.0);
                }
            }
            otherSB = new StringBuilder();
            prefix = "";
            val = bmf.getBusinessWebsite();
            if (val != null && !val.isEmpty()) {
                otherSB.append(val);
                prefix = " ";
            }
            if ((val = bmf.getBusinessABN()) != null && !val.isEmpty()) {
                otherSB.append(prefix);
                otherSB.append("ABN: " + val);
                prefix = " ";
            }
            if ((val = otherSB.toString()) != null && !val.isEmpty()) {
                gpw.prepareString(1, val, true, 12.0);
            }
        }
        gpw.drawStrings(20.0);
        String heading = documentHeading;
        if (!displayGST) {
            heading = documentHeadingNoGST;
        }
        gpw.prepareString(0, heading, true, 16.0, "centre");
        gpw.drawStrings(20.0);
        String ci = transaction.getCounterpartyIdentifier();
        if (ci != null && !ci.isEmpty() && (ct = this.getCounterpartyTransaction(ci)) != null && (c = ct.getCounterparty()) != null) {
            String cname = c.getCounterpartyTradingName();
            if (cname == null || cname.isEmpty()) {
                cname = c.getCounterpartyLegalName();
            }
            if (cname != null && !cname.isEmpty()) {
                if (gpw.muliBoldFont != null) {
                    gpw.setColumnFont(2, gpw.muliBoldFont);
                } else {
                    gpw.setColumnFont(2, PDType1Font.HELVETICA_BOLD);
                }
                gpw.prepareString(2, cname, true, 12.0);
                if (gpw.muliLightFont != null) {
                    gpw.setColumnFont(2, gpw.muliLightFont);
                } else {
                    gpw.setColumnFont(2, PDType1Font.HELVETICA);
                }
            }
            Address addr = c.getCounterpartyAddress();
            String val = null;
            if (addr != null) {
                val = addr.getAddressLine1();
                if (val != null && !val.isEmpty()) {
                    gpw.prepareString(2, val, true, 12.0);
                }
                if ((val = addr.getAddressLine2()) != null && !val.isEmpty()) {
                    gpw.prepareString(2, val, true, 12.0);
                }
                String prefix = "";
                StringBuilder addrSB = new StringBuilder();
                val = addr.getAddressLocality();
                if (val != null && !val.isEmpty()) {
                    addrSB.append(val);
                    prefix = " ";
                }
                if ((val = addr.getAddressState()) != null && !val.isEmpty()) {
                    addrSB.append(prefix);
                    addrSB.append(val);
                    prefix = " ";
                }
                if ((val = addr.getAddressPostcode()) != null && !val.isEmpty()) {
                    addrSB.append(prefix);
                    addrSB.append(val);
                    prefix = " ";
                }
                if ((val = addr.getAddressCountry()) != null && !val.isEmpty()) {
                    addrSB.append(prefix);
                    addrSB.append(val);
                }
                if ((val = addrSB.toString()) != null && !val.isEmpty()) {
                    gpw.prepareString(2, val, true, 12.0);
                }
            }
        }
        Double totalAmount = null;
        Double totalGST = null;
        int lineCount = transaction.getTransactionLineCount();
        for (int i = 0; i < lineCount; ++i) {
            Transaction pt;
            TransactionLine tl = transaction.getTransactionLine(i);
            String pi = tl.getProvisionIdentifier();
            if (pi != null && !pi.isEmpty() && (pt = this.getProvisionTransaction(pi)) != null && this.hasGST(pt.getProvisionGrossBASClassification())) {
                totalGST = this.addDouble(totalGST, tl.getProvisionAmountAsDouble());
            }
            totalAmount = this.addDouble(totalAmount, tl.getAmountAsDouble());
        }
        gpw.prepareString(3, documentName + " date", true, 12.0);
        LocalDate ld = transaction.getTransactionDateAsDate();
        if (ld != null && (date = ld.format(this.prettyDateFormatter)) != null && !date.isEmpty()) {
            gpw.prepareString(4, date, true, 12.0, "right");
        }
        int[] cols = new int[]{3, 4};
        gpw.ruleOff(cols);
        gpw.prepareString(3, "Total amount", true, 12.0);
        if (totalAmount == null) {
            gpw.prepareString(4, " ", true, 12.0, "right");
        } else {
            gpw.prepareString(4, this.formatMoney(totalAmount), true, 12.0, "right");
        }
        gpw.ruleOff(cols);
        if (displayGST) {
            gpw.prepareString(3, "Includes GST", true, 12.0);
            if (totalGST == null) {
                gpw.prepareString(4, "$0.00", true, 12.0, "right");
            } else {
                gpw.prepareString(4, this.formatMoney(totalGST), true, 12.0, "right");
            }
        }
        gpw.drawStrings(20.0);
        if (documentLayout != null && (paymentTerms = documentLayout.getPaymentTermsStatement()) != null && !paymentTerms.isEmpty()) {
            gpw.prepareString(0, paymentTerms, true, 12.0, "centre");
            gpw.drawStrings(20.0);
        }
        if ((transactionComment = transaction.getTransactionComment()) != null && !transactionComment.isEmpty()) {
            gpw.prepareString(0, transactionComment, true, 12.0);
            gpw.drawStrings(20.0);
        }
        if (gpw.muliBoldFont != null) {
            gpw.setColumnFont(5, gpw.muliBoldFont);
            gpw.setColumnFont(6, gpw.muliBoldFont);
            gpw.setColumnFont(7, gpw.muliBoldFont);
            gpw.setColumnFont(8, gpw.muliBoldFont);
        } else {
            gpw.setColumnFont(5, PDType1Font.HELVETICA_BOLD);
            gpw.setColumnFont(6, PDType1Font.HELVETICA_BOLD);
            gpw.setColumnFont(7, PDType1Font.HELVETICA_BOLD);
            gpw.setColumnFont(8, PDType1Font.HELVETICA_BOLD);
        }
        gpw.prepareString(5, "Description", true, 12.0);
        if (displayGST) {
            gpw.prepareString(6, "Ex. GST", true, 12.0, "right");
            gpw.prepareString(7, "GST", true, 12.0, "right");
        }
        gpw.prepareString(8, "Amount", true, 12.0, "right");
        if (gpw.muliLightFont != null) {
            gpw.setColumnFont(5, gpw.muliLightFont);
            gpw.setColumnFont(6, gpw.muliLightFont);
            gpw.setColumnFont(7, gpw.muliLightFont);
            gpw.setColumnFont(8, gpw.muliLightFont);
        } else {
            gpw.setColumnFont(5, PDType1Font.HELVETICA);
            gpw.setColumnFont(6, PDType1Font.HELVETICA);
            gpw.setColumnFont(7, PDType1Font.HELVETICA);
            gpw.setColumnFont(8, PDType1Font.HELVETICA);
        }
        gpw.drawStrings(5.0);
        for (int i = 0; i < lineCount; ++i) {
            TransactionLine tl = transaction.getTransactionLine(i);
            gpw.prepareString(5, tl.getLineCommentString(), true, 12.0);
            Double amount = tl.getAmountAsDouble();
            if (displayGST) {
                Transaction pt;
                Double pd = null;
                String pi = tl.getProvisionIdentifier();
                if (pi != null && !pi.isEmpty() && (pt = this.getProvisionTransaction(pi)) != null && this.hasGST(pt.getProvisionGrossBASClassification())) {
                    pd = tl.getProvisionAmountAsDouble();
                }
                if (pd != null) {
                    if (amount != null) {
                        gpw.prepareString(6, this.formatMoney(amount - pd), true, 12.0, "right");
                    }
                    gpw.prepareString(7, this.formatMoney(pd), true, 12.0, "right");
                }
            }
            if (amount != null) {
                gpw.prepareString(8, this.formatMoney(amount), true, 12.0, "right");
            }
            gpw.drawStrings(5.0);
        }
        if (gpw.muliBoldFont != null) {
            gpw.setColumnFont(5, gpw.muliBoldFont);
            gpw.setColumnFont(8, gpw.muliBoldFont);
        } else {
            gpw.setColumnFont(5, PDType1Font.HELVETICA_BOLD);
            gpw.setColumnFont(8, PDType1Font.HELVETICA_BOLD);
        }
        gpw.prepareString(5, documentName + " total", true, 12.0);
        gpw.prepareString(8, this.formatMoney(totalAmount), true, 12.0, "right");
        if (gpw.muliLightFont != null) {
            gpw.setColumnFont(5, gpw.muliLightFont);
            gpw.setColumnFont(8, gpw.muliLightFont);
        } else {
            gpw.setColumnFont(5, PDType1Font.HELVETICA);
            gpw.setColumnFont(8, PDType1Font.HELVETICA);
        }
        gpw.drawStrings(20.0);
        if (documentLayout != null && (paymentInstructions = documentLayout.getPaymentInstructions()) != null && !paymentInstructions.isEmpty()) {
            gpw.prepareString(1, paymentInstructions, true, 12.0);
            gpw.drawStrings(20.0);
        }
        if (documentLayout != null && (termsAndConditions = documentLayout.getTermsAndConditions()) != null && !termsAndConditions.isEmpty()) {
            gpw.prepareString(1, termsAndConditions, true, 12.0);
            gpw.drawStrings(20.0);
        }
        gpw.addFooter();
        gpw.savePdfReport(file);
    }

    public void buildPDFSalesInvoice(File file, Transaction transaction) throws Exception {
        this.buildPDFGenericInvoice(file, transaction, "Invoice", "Tax Invoice", "Invoice");
    }

    public void pdfSalesInvoice(Transaction transaction) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "Sales_Invoice" : "Sales_Invoice_from_" + reportName.replace(" ", "_").trim();
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            this.buildPDFSalesInvoice(file, transaction);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void buildPDFCashReceived(File file, Transaction transaction) throws Exception {
        this.buildPDFGenericInvoice(file, transaction, "Invoice", "Tax Invoice", "Invoice");
    }

    public void pdfCashReceived(Transaction transaction) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "Cash_Received" : "Cash_Received_from_" + reportName.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            this.buildPDFCashReceived(file, transaction);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void buildPDFCashPayment(File file, Transaction transaction) throws Exception {
        this.buildPDFGenericInvoice(file, transaction, "Invoice", "Tax Invoice", "Invoice");
    }

    public void pdfCashPayment(Transaction transaction) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "Cash_Payment" : "Cash_Payment_from_" + reportName.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            this.buildPDFCashPayment(file, transaction);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void buildPDFPurchaseInvoice(File file, Transaction transaction) throws Exception {
        this.buildPDFGenericInvoice(file, transaction, "Invoice", "Tax Invoice", "Invoice");
    }

    public void pdfPurchaseInvoice(Transaction transaction) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "Purchase_Invoice" : "Purchase_Invoice_from_" + reportName.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            this.buildPDFPurchaseInvoice(file, transaction);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void buildPDFGeneralJournal(File file, Transaction transaction) throws Exception {
        this.buildPDFGenericInvoice(file, transaction, "General journal", "Journal", "Journal");
    }

    public void pdfGeneralJournal(Transaction transaction) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "General_Journal" : "General_Journal_from_" + reportName.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            this.buildPDFPurchaseInvoice(file, transaction);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void pdfBusinessLicenseFeeInvoice() throws Exception {
        throw new Exception("Error, business license fee invoice not implemented in desktop version");
    }

    public void pdfPaySlip(Transaction transaction) {
        try {
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "Pay_slip" : "Pay_slip_from_" + reportName.replace(". ", "_").replace(" ", "_").replace(".", "_").trim();
            final File file = this.createPDFFile(reportName);
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            this.buildPDFPaySlip(file, transaction);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    public void buildPDFPaySlip(File file, Transaction transaction) {
        if (this.taxWithheldCodes == null) {
            this.taxWithheldCodes = new HashSet();
            this.taxWithheldCodes.add("PAYG_Individual_Non_Business");
            this.taxWithheldCodes.add("PAYG_Voluntary_Agreement");
            this.taxWithheldCodes.add("PAYG_Labour_Hire");
            this.taxWithheldCodes.add("PAYG_Specified");
            this.taxWithheldCodes.add("PAYG_JPDA");
            this.taxWithheldCodes.add("PAYG_JPDA_Foreign_Withholding");
            this.taxWithheldCodes.add("PAYG_Working_Holiday");
            this.taxWithheldCodes.add("PAYG_Foreign_Resident");
            this.taxWithheldCodes.add("Foreign_Tax_Withheld");
            this.taxWithheldCodes.add("PAYG_ETP_B");
            this.taxWithheldCodes.add("PAYG_ETP_D");
            this.taxWithheldCodes.add("PAYG_ETP_N");
            this.taxWithheldCodes.add("PAYG_ETP_O");
            this.taxWithheldCodes.add("PAYG_ETP_P");
            this.taxWithheldCodes.add("PAYG_ETP_R");
            this.taxWithheldCodes.add("PAYG_ETP_S");
            this.taxWithheldCodes.add("PAYG_ETP_T");
        }
        try {
            Double pa;
            Transaction pt;
            String psclass;
            Transaction pt2;
            Transaction at;
            String ai;
            String type;
            String desc;
            TransactionLine tl;
            int i;
            String date;
            Counterparty c;
            Transaction ct;
            String reportName = this.getBusinessLegalName();
            reportName = reportName == null ? "Pay_Slip" : "Pay_Slip_from_" + reportName.replace(" ", "_").trim();
            if (file == null) {
                throw new Exception("Error, unable to create pdf file");
            }
            GlenixPDFWrapper gpw = new GlenixPDFWrapper();
            gpw.setColumns(14);
            gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
            gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
            gpw.setColumnLeftPosAndWidthMM(2, 30.0, 80.0);
            gpw.setColumnLeftPosAndWidthMM(3, 140.0, 30.0);
            gpw.setColumnLeftPosAndWidthMM(4, 174.0, 26.0);
            gpw.setColumnLeftPosAndWidthMM(5, 20.0, 20.0);
            gpw.setColumnLeftPosAndWidthMM(6, 40.0, 10.0);
            gpw.setColumnLeftPosAndWidthMM(7, 50.0, 10.0);
            gpw.setColumnLeftPosAndWidthMM(8, 60.0, 10.0);
            gpw.setColumnLeftPosAndWidthMM(9, 70.0, 15.0);
            gpw.setColumnLeftPosAndWidthMM(10, 87.0, 43.0);
            gpw.setColumnLeftPosAndWidthMM(11, 134.0, 66.0);
            gpw.setColumnLeftPosAndWidthMM(12, 134.0, 40.0);
            gpw.setColumnLeftPosAndWidthMM(13, 174.0, 26.0);
            if (gpw.muliBoldFont != null) {
                gpw.setColumnFont(0, gpw.muliBoldFont);
            } else {
                gpw.setColumnFont(0, PDType1Font.HELVETICA_BOLD);
            }
            if (gpw.muliLightFont != null) {
                gpw.setColumnFont(1, gpw.muliLightFont);
                gpw.setColumnFont(2, gpw.muliLightFont);
                gpw.setColumnFont(3, gpw.muliLightFont);
                gpw.setColumnFont(4, gpw.muliLightFont);
                gpw.setColumnFont(5, gpw.muliLightFont);
                gpw.setColumnFont(6, gpw.muliLightFont);
                gpw.setColumnFont(7, gpw.muliLightFont);
                gpw.setColumnFont(8, gpw.muliLightFont);
                gpw.setColumnFont(9, gpw.muliLightFont);
                gpw.setColumnFont(10, gpw.muliLightFont);
                gpw.setColumnFont(11, gpw.muliLightFont);
                gpw.setColumnFont(12, gpw.muliLightFont);
            } else {
                gpw.setColumnFont(1, PDType1Font.HELVETICA);
                gpw.setColumnFont(2, PDType1Font.HELVETICA);
                gpw.setColumnFont(3, PDType1Font.HELVETICA);
                gpw.setColumnFont(4, PDType1Font.HELVETICA);
                gpw.setColumnFont(5, PDType1Font.HELVETICA);
                gpw.setColumnFont(6, PDType1Font.HELVETICA);
                gpw.setColumnFont(7, PDType1Font.HELVETICA);
                gpw.setColumnFont(8, PDType1Font.HELVETICA);
                gpw.setColumnFont(9, PDType1Font.HELVETICA);
                gpw.setColumnFont(10, PDType1Font.HELVETICA);
                gpw.setColumnFont(11, PDType1Font.HELVETICA);
                gpw.setColumnFont(12, PDType1Font.HELVETICA);
            }
            Business b = this.getBusiness();
            BusinessMasterFile bmf = null;
            DocumentLayout documentLayout = null;
            if (b != null) {
                documentLayout = b.getDocumentLayout();
                if (documentLayout != null) {
                    int count = documentLayout.getLayoutImageCount();
                    for (int i2 = 0; i2 < count; ++i2) {
                        InputStream is;
                        LayoutImage li = documentLayout.getLayoutImage(i2);
                        String filename = li.getImageFileName();
                        if (filename == null || filename.isEmpty() || (is = this.getFileDecrypt(filename = "images/" + filename)) == null) continue;
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] readBytes = new byte[1024];
                        int readLen = 0;
                        int totalRead = 0;
                        while ((readLen = is.read(readBytes)) >= 0) {
                            buffer.write(readBytes, 0, readLen);
                            totalRead += readLen;
                        }
                        if (totalRead <= 0) continue;
                        buffer.flush();
                        gpw.addImage(buffer.toByteArray(), li.getImageFileName(), li.getImageLocation(), li.getImageWidthAsDouble(), li.getImageHeightAsDouble());
                    }
                }
                bmf = b.getBusinessMasterFile();
            }
            gpw.addPDPage();
            if (bmf != null) {
                String prefix;
                StringBuilder otherSB;
                ElectronicContact ec;
                String displayName = bmf.getBusinessTradingName();
                if (displayName == null || displayName.isEmpty()) {
                    displayName = bmf.getBusinessLegalName();
                }
                if (displayName != null && !displayName.isEmpty()) {
                    gpw.prepareString(0, displayName, true, 14.0);
                    gpw.drawStrings();
                }
                TFND0004AddressDetailsBusiness addr = bmf.getBusinessPostalAddress();
                String val = null;
                if (addr != null) {
                    val = addr.getLine1T();
                }
                if ((val == null || val.isEmpty()) && (addr = bmf.getBusinessBusinessAddress()) != null) {
                    val = addr.getLine1T();
                }
                if (val != null && !val.isEmpty()) {
                    StringBuilder fullSB = new StringBuilder();
                    fullSB.append(val);
                    val = addr.getLine2T();
                    if (val != null && !val.isEmpty()) {
                        fullSB.append(", ");
                        fullSB.append(val);
                    }
                    String prefix2 = ", ";
                    val = addr.getLocalityNameT();
                    if (val != null && !val.isEmpty()) {
                        fullSB.append(prefix2);
                        fullSB.append(val);
                        prefix2 = " ";
                    }
                    if ((val = addr.getStateOrTerritoryC()) != null && !val.isEmpty()) {
                        fullSB.append(prefix2);
                        fullSB.append(val);
                        prefix2 = " ";
                    }
                    if ((val = addr.getPostcodeT()) != null && !val.isEmpty()) {
                        fullSB.append(prefix2);
                        fullSB.append(val);
                        prefix2 = " ";
                    }
                    if ((val = addr.getCountryC()) != null && !val.isEmpty() && !val.equals("au")) {
                        String name = this.getCountryName(val);
                        fullSB.append(prefix2);
                        fullSB.append(name);
                    }
                    if ((val = fullSB.toString()) != null && !val.isEmpty()) {
                        gpw.prepareString(1, val, true, 12.0);
                    }
                }
                if ((ec = bmf.getBusinessElectronicContact()) != null) {
                    String ac;
                    otherSB = new StringBuilder();
                    prefix = "";
                    val = ec.getTelephoneMinimalN();
                    if (val != null && !val.isEmpty() && (ac = ec.getTelephoneAreaC()) != null && !ac.isEmpty()) {
                        val = ac + " " + val;
                    }
                    if (val != null && !val.isEmpty()) {
                        otherSB.append("Tel: " + val);
                        prefix = " ";
                    }
                    if ((val = ec.getElectronicMailAddressT()) != null && !val.isEmpty()) {
                        otherSB.append(prefix);
                        otherSB.append(val);
                        prefix = " ";
                    }
                    if ((val = otherSB.toString()) != null && !val.isEmpty()) {
                        gpw.prepareString(1, val, true, 12.0);
                    }
                }
                otherSB = new StringBuilder();
                prefix = "";
                val = bmf.getBusinessWebsite();
                if (val != null && !val.isEmpty()) {
                    otherSB.append(val);
                    prefix = " ";
                }
                if ((val = bmf.getBusinessABN()) != null && !val.isEmpty()) {
                    otherSB.append(prefix);
                    otherSB.append("ABN: " + val);
                    prefix = " ";
                }
                if ((val = otherSB.toString()) != null && !val.isEmpty()) {
                    gpw.prepareString(1, val, true, 12.0);
                }
            }
            gpw.drawStrings(20.0);
            String heading = "Pay Slip";
            gpw.prepareString(0, heading, true, 16.0, "centre");
            gpw.drawStrings(20.0);
            String ci = transaction.getCounterpartyIdentifier();
            if (ci != null && !ci.isEmpty() && (ct = this.getCounterpartyTransaction(ci)) != null && (c = ct.getCounterparty()) != null) {
                String cname = c.getCounterpartyLegalName();
                if (cname != null && !cname.isEmpty()) {
                    if (gpw.muliBoldFont != null) {
                        gpw.setColumnFont(2, gpw.muliBoldFont);
                    } else {
                        gpw.setColumnFont(2, PDType1Font.HELVETICA_BOLD);
                    }
                    gpw.prepareString(2, cname, true, 12.0);
                    if (gpw.muliLightFont != null) {
                        gpw.setColumnFont(2, gpw.muliLightFont);
                    } else {
                        gpw.setColumnFont(2, PDType1Font.HELVETICA);
                    }
                }
                Address addr = c.getCounterpartyAddress();
                String val = null;
                if (addr != null) {
                    val = addr.getAddressLine1();
                    if (val != null && !val.isEmpty()) {
                        gpw.prepareString(2, val, true, 12.0);
                    }
                    if ((val = addr.getAddressLine2()) != null && !val.isEmpty()) {
                        gpw.prepareString(2, val, true, 12.0);
                    }
                    String prefix = "";
                    StringBuilder addrSB = new StringBuilder();
                    val = addr.getAddressLocality();
                    if (val != null && !val.isEmpty()) {
                        addrSB.append(val);
                        prefix = " ";
                    }
                    if ((val = addr.getAddressState()) != null && !val.isEmpty()) {
                        addrSB.append(prefix);
                        addrSB.append(val);
                        prefix = " ";
                    }
                    if ((val = addr.getAddressPostcode()) != null && !val.isEmpty()) {
                        addrSB.append(prefix);
                        addrSB.append(val);
                        prefix = " ";
                    }
                    if ((val = addr.getAddressCountry()) != null && !val.isEmpty()) {
                        addrSB.append(prefix);
                        addrSB.append(val);
                    }
                    if ((val = addrSB.toString()) != null && !val.isEmpty()) {
                        gpw.prepareString(2, val, true, 12.0);
                    }
                }
            }
            Double totalAmount = null;
            Double totalEarnings = null;
            Double totalTax = null;
            Double totalOther = null;
            int lineCount = transaction.getTransactionLineCount();
            for (int i3 = 0; i3 < lineCount; ++i3) {
                TransactionLine tl2 = transaction.getTransactionLine(i3);
                Double amount = tl2.getAmountAsDouble();
                totalAmount = this.addDouble(totalAmount, amount);
                String type2 = null;
                String ai2 = tl2.getAccountIdentifier();
                if (ai2 != null) {
                    Transaction at2 = this.getAccountTransaction(ai2);
                    type2 = at2.getAccountPaymentDeductionType();
                }
                Double provisionAmount = null;
                String pi = tl2.getProvisionIdentifier();
                String psclass2 = null;
                if (pi != null) {
                    Transaction pt3 = this.getProvisionTransaction(pi);
                    psclass2 = pt3.getProvisionTaxPSClassification();
                }
                if (psclass2 != null && !psclass2.isEmpty() && this.taxWithheldCodes.contains(psclass2) && (provisionAmount = tl2.getProvisionAmountAsDouble()) != null) {
                    if (amount != null) {
                        amount = amount - provisionAmount;
                    }
                    totalTax = this.addDouble(totalTax, provisionAmount);
                }
                if (type2 != null && type2.equals("earnings")) {
                    totalEarnings = this.addDouble(totalEarnings, amount);
                    continue;
                }
                totalOther = this.addDouble(totalOther, amount);
            }
            TransactionPaySlipDetail paySlipDetail = transaction.getTransactionPaySlipDetail();
            int[] cols = new int[]{3, 4};
            gpw.prepareString(3, "Payment date", true, 12.0);
            LocalDate ld = transaction.getTransactionDateAsDate();
            if (ld != null && (date = ld.format(this.prettyDateFormatter)) != null && !date.isEmpty()) {
                gpw.prepareString(4, date, true, 12.0, "right");
            }
            gpw.ruleOff(cols);
            if (paySlipDetail != null) {
                gpw.prepareString(3, "Pay period start", true, 12.0);
                ld = paySlipDetail.getTransactionPaySlipStartDateAsDate();
                if (ld != null && (date = ld.format(this.prettyDateFormatter)) != null && !date.isEmpty()) {
                    gpw.prepareString(4, date, true, 12.0, "right");
                }
                gpw.ruleOff(cols);
                gpw.prepareString(3, "Pay period end", true, 12.0);
                ld = paySlipDetail.getTransactionPaySlipEndDateAsDate();
                if (ld != null && (date = ld.format(this.prettyDateFormatter)) != null && !date.isEmpty()) {
                    gpw.prepareString(4, date, true, 12.0, "right");
                }
                gpw.ruleOff(cols);
            }
            gpw.prepareString(3, "Gross", true, 12.0);
            if (totalEarnings == null) {
                gpw.prepareString(4, " ", true, 12.0, "right");
            } else {
                gpw.prepareString(4, this.formatMoney(totalEarnings), true, 12.0, "right");
            }
            gpw.ruleOff(cols);
            gpw.prepareString(3, "Tax withheld", true, 12.0);
            if (totalTax == null) {
                gpw.prepareString(4, " ", true, 12.0, "right");
            } else {
                gpw.prepareString(4, this.formatMoney(-totalTax.doubleValue()), true, 12.0, "right");
            }
            gpw.ruleOff(cols);
            if (totalOther != null && totalOther != 0.0) {
                gpw.prepareString(3, "Other", true, 12.0);
                gpw.prepareString(4, this.formatMoney(totalOther), true, 12.0, "right");
                gpw.ruleOff(cols);
            }
            gpw.prepareString(3, "Net pay", true, 12.0);
            if (totalAmount == null) {
                gpw.prepareString(4, " ", true, 12.0, "right");
            } else {
                gpw.prepareString(4, this.formatMoney(totalAmount), true, 12.0, "right");
            }
            gpw.ruleOff(cols);
            gpw.drawStrings(20.0);
            String transactionComment = transaction.getTransactionComment();
            if (transactionComment != null && !transactionComment.isEmpty()) {
                gpw.prepareString(0, transactionComment, true, 12.0);
                gpw.drawStrings(20.0);
            }
            if (paySlipDetail != null) {
                String jobTitle = paySlipDetail.getTransactionPaySlipJobTitle();
                if (jobTitle != null && !jobTitle.isEmpty()) {
                    gpw.prepareString(1, "Job title: " + jobTitle, true, 12.0);
                }
                gpw.drawStrings(5.0);
                String agreement = paySlipDetail.getTransactionPaySlipAgreement();
                if (agreement != null && !agreement.isEmpty()) {
                    gpw.prepareString(1, "Award/agreement: " + agreement, true, 12.0);
                }
                gpw.drawStrings(5.0);
            }
            int detailStartPageIndex = gpw.getCurrentPageIndex();
            Double detailStartTop = gpw.getCurrentTop(0);
            boolean hastimesheet = false;
            for (i = 0; i < lineCount; ++i) {
                tl = transaction.getTransactionLine(i);
                String type3 = null;
                String ai3 = tl.getAccountIdentifier();
                if (ai3 != null) {
                    Transaction at3 = this.getAccountTransaction(ai3);
                    type3 = at3.getAccountPaymentDeductionType();
                }
                if (type3 == null || !type3.equals("time")) continue;
                hastimesheet = true;
            }
            if (hastimesheet) {
                if (gpw.muliBoldFont != null) {
                    gpw.setColumnFont(5, gpw.muliBoldFont);
                    gpw.setColumnFont(6, gpw.muliBoldFont);
                    gpw.setColumnFont(7, gpw.muliBoldFont);
                    gpw.setColumnFont(8, gpw.muliBoldFont);
                    gpw.setColumnFont(9, gpw.muliBoldFont);
                    gpw.setColumnFont(10, gpw.muliBoldFont);
                } else {
                    gpw.setColumnFont(5, PDType1Font.HELVETICA_BOLD);
                    gpw.setColumnFont(6, PDType1Font.HELVETICA_BOLD);
                    gpw.setColumnFont(7, PDType1Font.HELVETICA_BOLD);
                    gpw.setColumnFont(8, PDType1Font.HELVETICA_BOLD);
                    gpw.setColumnFont(9, PDType1Font.HELVETICA_BOLD);
                    gpw.setColumnFont(10, PDType1Font.HELVETICA_BOLD);
                }
                gpw.prepareString(5, "Date", true, 8.0);
                gpw.prepareString(6, "Start", true, 8.0, "right");
                gpw.prepareString(7, "Finish", true, 8.0, "right");
                gpw.prepareString(8, "Break", true, 8.0, "right");
                gpw.prepareString(9, "Worked", true, 8.0, "right");
                gpw.prepareString(10, "Description", true, 8.0);
                if (gpw.muliLightFont != null) {
                    gpw.setColumnFont(5, gpw.muliLightFont);
                    gpw.setColumnFont(6, gpw.muliLightFont);
                    gpw.setColumnFont(7, gpw.muliLightFont);
                    gpw.setColumnFont(8, gpw.muliLightFont);
                    gpw.setColumnFont(9, gpw.muliLightFont);
                    gpw.setColumnFont(10, gpw.muliLightFont);
                } else {
                    gpw.setColumnFont(5, PDType1Font.HELVETICA);
                    gpw.setColumnFont(6, PDType1Font.HELVETICA);
                    gpw.setColumnFont(7, PDType1Font.HELVETICA);
                    gpw.setColumnFont(8, PDType1Font.HELVETICA);
                    gpw.setColumnFont(9, PDType1Font.HELVETICA);
                    gpw.setColumnFont(10, PDType1Font.HELVETICA);
                }
                gpw.drawStrings();
                for (i = 0; i < lineCount; ++i) {
                    LocalTime breakTime;
                    LocalDateTime endDateTime;
                    tl = transaction.getTransactionLine(i);
                    desc = null;
                    type = null;
                    ai = tl.getAccountIdentifier();
                    if (ai != null) {
                        at = this.getAccountTransaction(ai);
                        desc = at.getAccountName();
                        type = at.getAccountPaymentDeductionType();
                    }
                    if (desc == null || desc.isEmpty()) {
                        desc = "Unknown";
                    }
                    if (type == null || !type.equals("time")) continue;
                    LocalDateTime startDateTime = tl.getStartDateTimeAsDateTime();
                    if (startDateTime != null) {
                        gpw.prepareString(5, startDateTime.format(this.prettyDateFormatter), true, 8.0);
                        gpw.prepareString(6, startDateTime.format(this.basicTimeFormatter), true, 8.0, "right");
                    }
                    if ((endDateTime = tl.getEndDateTimeAsDateTime()) != null) {
                        gpw.prepareString(7, endDateTime.format(this.basicTimeFormatter), true, 8.0, "right");
                    }
                    if ((breakTime = tl.getBreakTimeAsTime()) != null) {
                        gpw.prepareString(8, breakTime.format(this.basicTimeFormatter), true, 8.0, "right");
                    }
                    Double quantity = tl.getQuantityAsDouble();
                    Double hours = Math.floor(quantity);
                    Double minutes = new Double(Math.round((quantity - hours) * 60.0));
                    if (minutes < 0.0) {
                        minutes = 0.0;
                    } else if (minutes == 60.0) {
                        hours = hours + 1.0;
                        minutes = 0.0;
                    }
                    String hoursStr = "" + hours.intValue();
                    String minutesStr = "" + minutes.intValue();
                    if (minutes < 10.0) {
                        minutesStr = "0" + minutes.intValue();
                    }
                    gpw.prepareString(9, hoursStr + ":" + minutesStr, true, 8.0, "right");
                    gpw.prepareString(10, desc, true, 8.0);
                    gpw.drawStrings();
                }
                gpw.ruleOff(5.0);
            }
            gpw.setColumnLeftPosAndWidthMM(5, 20.0, 55.0);
            gpw.setColumnLeftPosAndWidthMM(8, 75.0, 15.0);
            gpw.setColumnLeftPosAndWidthMM(9, 90.0, 15.0);
            gpw.setColumnLeftPosAndWidthMM(10, 105.0, 25.0);
            if (gpw.muliBoldFont != null) {
                gpw.setColumnFont(5, gpw.muliBoldFont);
                gpw.setColumnFont(6, gpw.muliBoldFont);
                gpw.setColumnFont(7, gpw.muliBoldFont);
                gpw.setColumnFont(8, gpw.muliBoldFont);
                gpw.setColumnFont(9, gpw.muliBoldFont);
                gpw.setColumnFont(10, gpw.muliBoldFont);
            } else {
                gpw.setColumnFont(5, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(6, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(7, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(8, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(9, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(10, PDType1Font.HELVETICA_BOLD);
            }
            gpw.prepareString(5, "Description", true, 8.0);
            gpw.prepareString(8, "Quantity", true, 8.0, "right");
            gpw.prepareString(9, "Rate", true, 8.0, "right");
            gpw.prepareString(10, "Amount", true, 8.0, "right");
            if (gpw.muliLightFont != null) {
                gpw.setColumnFont(5, gpw.muliLightFont);
                gpw.setColumnFont(6, gpw.muliLightFont);
                gpw.setColumnFont(7, gpw.muliLightFont);
                gpw.setColumnFont(8, gpw.muliLightFont);
                gpw.setColumnFont(9, gpw.muliLightFont);
                gpw.setColumnFont(10, gpw.muliLightFont);
            } else {
                gpw.setColumnFont(5, PDType1Font.HELVETICA);
                gpw.setColumnFont(6, PDType1Font.HELVETICA);
                gpw.setColumnFont(7, PDType1Font.HELVETICA);
                gpw.setColumnFont(8, PDType1Font.HELVETICA);
                gpw.setColumnFont(9, PDType1Font.HELVETICA);
                gpw.setColumnFont(10, PDType1Font.HELVETICA);
            }
            gpw.drawStrings();
            for (i = 0; i < lineCount; ++i) {
                Double pa2;
                tl = transaction.getTransactionLine(i);
                desc = null;
                type = null;
                ai = tl.getAccountIdentifier();
                if (ai != null) {
                    at = this.getAccountTransaction(ai);
                    desc = at.getAccountName();
                    type = at.getAccountPaymentDeductionType();
                }
                if (desc == null || desc.isEmpty()) {
                    desc = "Unknown";
                }
                if (type == null || !type.equals("earnings")) continue;
                Double quantity = tl.getQuantityAsDouble();
                String qtyStr = tl.getQuantityString();
                Double amount = tl.getAmountAsDouble();
                String pi = tl.getProvisionIdentifier();
                String psclass3 = null;
                boolean istaxwithheld = false;
                if (pi != null) {
                    pt2 = this.getProvisionTransaction(pi);
                    psclass3 = pt2.getProvisionTaxPSClassification();
                }
                if (psclass3 != null && !psclass3.isEmpty() && this.taxWithheldCodes.contains(psclass3) && (pa2 = tl.getProvisionAmountAsDouble()) != null) {
                    amount = amount - pa2;
                    istaxwithheld = true;
                }
                if (istaxwithheld && (!istaxwithheld || amount == 0.0)) continue;
                gpw.prepareString(5, desc, true, 8.0);
                if (quantity != null && quantity != 0.0) {
                    gpw.prepareString(8, this.formatFiveDp(quantity), true, 8.0, "right");
                    if (amount != null) {
                        Double rate = amount / quantity;
                        gpw.prepareString(9, this.formatTwoDp(rate), true, 8.0, "right");
                    }
                }
                if (amount != null) {
                    gpw.prepareString(10, this.formatMoney(amount), true, 8.0, "right");
                }
                gpw.drawStrings();
            }
            gpw.ruleOff(5.0);
            if (gpw.muliBoldFont != null) {
                gpw.setColumnFont(5, gpw.muliBoldFont);
                gpw.setColumnFont(10, gpw.muliBoldFont);
            } else {
                gpw.setColumnFont(5, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(10, PDType1Font.HELVETICA_BOLD);
            }
            if (totalEarnings != null) {
                gpw.prepareString(5, "Total gross", true, 8.0);
                gpw.prepareString(10, this.formatMoney(totalEarnings), true, 8.0, "right");
            }
            if (gpw.muliLightFont != null) {
                gpw.setColumnFont(5, gpw.muliLightFont);
                gpw.setColumnFont(10, gpw.muliLightFont);
            } else {
                gpw.setColumnFont(5, PDType1Font.HELVETICA);
                gpw.setColumnFont(10, PDType1Font.HELVETICA);
            }
            gpw.drawStrings(5.0);
            boolean hastax = false;
            for (int i4 = 0; i4 < lineCount; ++i4) {
                TransactionLine tl3 = transaction.getTransactionLine(i4);
                String desc2 = null;
                String pi = tl3.getProvisionIdentifier();
                String psclass4 = null;
                if (pi != null) {
                    Transaction pt4 = this.getProvisionTransaction(pi);
                    psclass4 = pt4.getProvisionTaxPSClassification();
                    desc2 = pt4.getProvisionName();
                }
                if (psclass4 == null || psclass4.isEmpty() || !this.taxWithheldCodes.contains(psclass4)) continue;
                hastax = true;
                Double provisionAmount = tl3.getProvisionAmountAsDouble();
                if (desc2 == null || desc2.isEmpty()) {
                    desc2 = "Unknown";
                }
                gpw.prepareString(5, desc2, true, 8.0);
                if (provisionAmount != null) {
                    gpw.prepareString(10, this.formatMoney(-provisionAmount.doubleValue()), true, 8.0, "right");
                }
                gpw.drawStrings();
            }
            if (hastax) {
                gpw.ruleOff(5.0);
            }
            boolean hasne = false;
            for (int i5 = 0; i5 < lineCount; ++i5) {
                TransactionLine tl4 = transaction.getTransactionLine(i5);
                String desc3 = null;
                String type4 = null;
                String ai4 = tl4.getAccountIdentifier();
                if (ai4 != null) {
                    Transaction at4 = this.getAccountTransaction(ai4);
                    desc3 = at4.getAccountName();
                    type4 = at4.getAccountPaymentDeductionType();
                }
                if (desc3 == null || desc3.isEmpty()) {
                    desc3 = "Unknown";
                }
                if (type4 != null && (type4.equals("earnings") || type4.equals("time"))) continue;
                Double quantity = tl4.getQuantityAsDouble();
                String qtyStr = tl4.getQuantityString();
                Double amount = tl4.getAmountAsDouble();
                String pi = tl4.getProvisionIdentifier();
                psclass = null;
                if (pi != null) {
                    pt = this.getProvisionTransaction(pi);
                    psclass = pt.getProvisionTaxPSClassification();
                }
                if (psclass != null && !psclass.isEmpty() && this.taxWithheldCodes.contains(psclass) && (pa = tl4.getProvisionAmountAsDouble()) != null) {
                    amount = amount - pa;
                }
                if (amount == 0.0) continue;
                hasne = true;
                gpw.prepareString(5, desc3, true, 8.0);
                if (quantity != null && quantity != 0.0) {
                    gpw.prepareString(8, this.formatFiveDp(quantity), true, 8.0, "right");
                    if (amount != null) {
                        Double rate = amount / quantity;
                        gpw.prepareString(9, this.formatFiveDp(rate), true, 8.0, "right");
                    }
                }
                if (amount != null) {
                    gpw.prepareString(10, this.formatMoney(-amount.doubleValue()), true, 8.0, "right");
                }
                gpw.drawStrings();
            }
            if (hasne) {
                gpw.ruleOff(5.0);
            }
            if (gpw.muliBoldFont != null) {
                gpw.setColumnFont(5, gpw.muliBoldFont);
                gpw.setColumnFont(10, gpw.muliBoldFont);
            } else {
                gpw.setColumnFont(5, PDType1Font.HELVETICA_BOLD);
                gpw.setColumnFont(10, PDType1Font.HELVETICA_BOLD);
            }
            if (totalAmount != null) {
                gpw.prepareString(5, "Net pay", true, 8.0);
                gpw.prepareString(10, this.formatMoney(totalAmount), true, 8.0, "right");
            }
            if (gpw.muliLightFont != null) {
                gpw.setColumnFont(5, gpw.muliLightFont);
                gpw.setColumnFont(10, gpw.muliLightFont);
            } else {
                gpw.setColumnFont(5, PDType1Font.HELVETICA);
                gpw.setColumnFont(10, PDType1Font.HELVETICA);
            }
            gpw.drawStrings(5.0);
            gpw.gotoPageLocation(detailStartPageIndex, detailStartTop);
            if (gpw.muliBoldFont != null) {
                gpw.setColumnFont(11, gpw.muliBoldFont);
            } else {
                gpw.setColumnFont(11, PDType1Font.HELVETICA_BOLD);
            }
            gpw.prepareString(11, "Superannuation contributions", true, 8.0);
            gpw.drawStrings();
            String superFundName = null;
            String memberNumber = null;
            if (paySlipDetail != null) {
                Transaction sfTransaction;
                memberNumber = paySlipDetail.getTransactionPaySlipMemberNumber();
                String superFundId = paySlipDetail.getTransactionPaySlipSuperFund();
                if (superFundId != null && (sfTransaction = this.getCounterpartyTransaction(superFundId)) != null) {
                    superFundName = sfTransaction.getCounterpartyLegalName();
                }
            }
            if (gpw.muliLightFont != null) {
                gpw.setColumnFont(11, gpw.muliLightFont);
            } else {
                gpw.setColumnFont(11, PDType1Font.HELVETICA);
            }
            if (superFundName != null) {
                gpw.prepareString(11, "Super fund: " + superFundName, true, 8.0);
                gpw.drawStrings();
            }
            if (memberNumber != null) {
                gpw.prepareString(11, "Member number: " + memberNumber, true, 8.0);
                gpw.drawStrings();
            }
            if (gpw.muliBoldFont != null) {
                gpw.setColumnFont(11, gpw.muliBoldFont);
            } else {
                gpw.setColumnFont(11, PDType1Font.HELVETICA_BOLD);
            }
            boolean hassuper = false;
            for (int i6 = 0; i6 < lineCount; ++i6) {
                TransactionLine tl5 = transaction.getTransactionLine(i6);
                String type5 = null;
                String ai5 = tl5.getAccountIdentifier();
                if (ai5 != null) {
                    Transaction at5 = this.getAccountTransaction(ai5);
                    type5 = at5.getAccountPaymentDeductionType();
                }
                if (type5 != null && (type5.equals("earnings") || type5.equals("time"))) continue;
                String pi = tl5.getProvisionIdentifier();
                String psclass5 = null;
                if (pi == null || (psclass5 = (pt2 = this.getProvisionTransaction(pi)).getProvisionTaxPSClassification()) == null || psclass5.isEmpty() || !psclass5.equals("Superannuation_SGC_Contributions") && !psclass5.equals("Superannuation_Additional_Employer_Contributions") || (pa = tl5.getProvisionAmountAsDouble()) == null) continue;
                hassuper = true;
                String desc4 = pt2.getProvisionName();
                if (desc4 == null || desc4.isEmpty()) {
                    desc4 = "Unknown";
                }
                gpw.prepareString(12, desc4, true, 8.0);
                gpw.prepareString(13, this.formatMoney(-pa.doubleValue()), true, 8.0, "right");
                gpw.drawStrings();
            }
            gpw.ruleOff(5.0);
            boolean hasoncost = false;
            for (int i7 = 0; i7 < lineCount; ++i7) {
                String desc5;
                Double pa3;
                TransactionLine tl6 = transaction.getTransactionLine(i7);
                String type6 = null;
                String ai6 = tl6.getAccountIdentifier();
                if (ai6 != null) {
                    Transaction at6 = this.getAccountTransaction(ai6);
                    type6 = at6.getAccountPaymentDeductionType();
                }
                if (type6 != null && type6.equals("earnings")) continue;
                String pi = tl6.getProvisionIdentifier();
                psclass = null;
                if (pi == null || (psclass = (pt = this.getProvisionTransaction(pi)).getProvisionTaxPSClassification()) == null || psclass.isEmpty() || !psclass.equals("NA") && !psclass.equals("Fringe_Benefits_Reportable") && !psclass.equals("Fringe_Benefits_Reportable_Exempt") || (pa3 = tl6.getProvisionAmountAsDouble()) == null) continue;
                if (!hasoncost) {
                    gpw.prepareString(11, "Fringe benefits/other", true, 8.0);
                    hasoncost = true;
                }
                if ((desc5 = pt.getProvisionName()) == null || desc5.isEmpty()) {
                    desc5 = "Unknown";
                }
                gpw.prepareString(12, desc5, true, 8.0);
                gpw.prepareString(13, this.formatMoney(-pa3.doubleValue()), true, 8.0, "right");
                gpw.drawStrings(5.0);
            }
            if (hasoncost) {
                gpw.ruleOff(5.0);
            }
            PEE0003Payee payee = transaction.getTransactionPayEventEmp();
            int[] ytdcols = new int[]{11, 12, 13};
            if (payee != null) {
                gpw.prepareString(11, "Year to date totals", true, 8.0);
                PEE0003RemunerationPAYGW remuneration = payee.getRemunerationIncomeTaxPayAsYouGoWithholding();
                gpw.drawStrings(5.0);
                if (remuneration != null) {
                    PEE0003IncomeFringeBenefitsReportable rfb;
                    PEE0003SuperannuationContribution sc;
                    int ic3;
                    String amt;
                    int ic2;
                    PEE0003WorkingHolidayMaker whm;
                    PEE0003JointPetroleumDevelopmentAreaPayment jpda;
                    PEE0003SpecifiedByRegulationPayment sp;
                    PEE0003LabourHireArrangementPayment lh;
                    PEE0003VoluntaryAgreement va;
                    PEE0003IndividualNonBusiness inb = remuneration.getIndividualNonBusiness();
                    if (inb != null) {
                        gpw.prepareString(11, "Individual non-business", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = inb.getGrossA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Gross amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = inb.getCommunityDevelopmentEmploymentProjectA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Community development employment project (CDEP) amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = inb.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = inb.getExemptForeignEmploymentIncomeA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Exempt foreign income amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((va = remuneration.getVoluntaryAgreement()) != null) {
                        gpw.prepareString(11, "Voluntary agreement", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = va.getGrossA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Voluntary agreement gross amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = va.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Voluntary agreement tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((lh = remuneration.getLabourHireArrangementPayment()) != null) {
                        gpw.prepareString(11, "Labour hire arrangement payment", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = lh.getGrossA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Labour hire gross amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = lh.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Labour hire tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((sp = remuneration.getSpecifiedByRegulationPayment()) != null) {
                        gpw.prepareString(11, "Specified by regulation payment", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = sp.getGrossA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Specified by regulation gross amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = sp.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Specified by regulation tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((jpda = remuneration.getJointPetroleumDevelopmentAreaPayment()) != null) {
                        gpw.prepareString(11, "Joint Petroleum Development Area (JPDA) payment", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = jpda.getA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "JPDA amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = jpda.getForeignWithholdingA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "JPDA foreign withholding amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = jpda.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "JPDA tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((whm = remuneration.getWorkingHolidayMaker()) != null) {
                        gpw.prepareString(11, "Working holiday maker", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = whm.getGrossA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Working holiday maker gross amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = whm.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Working holiday maker tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    int ic = remuneration.getEmploymentTerminationPaymentCount();
                    for (int i8 = 0; i8 < ic; ++i8) {
                        LocalDate effdate;
                        PEE0003EmploymentTerminationPayment etp = remuneration.getEmploymentTerminationPayment(i8);
                        if (etp == null) continue;
                        gpw.prepareString(11, "Employment termination payment (ETP)", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = etp.getTypeC();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "ETP type code", true, 8.0);
                            gpw.prepareString(13, tmp, true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((effdate = etp.getPaymentRecordPaymentEffectiveDAsDate()) != null) {
                            gpw.prepareString(12, "ETP payment date", true, 8.0);
                            gpw.prepareString(13, effdate.format(this.prettyDateFormatter), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = etp.getSuperannuationTaxFreeComponentA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "ETP tax free component", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = etp.getSuperETPTaxableComponentTotalA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "ETP taxable component", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = etp.getTaxWithheldA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "ETP tax withheld amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    PEE0003UnusedAnnualOrLongServiceLeavePayment ul = remuneration.getUnusedAnnualOrLongServiceLeavePayment();
                    if (ul != null) {
                        gpw.prepareString(11, "Unused annual or long service leave payment", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = ul.getLumpSumAC();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Unused leave lump sump A code", true, 8.0);
                            gpw.prepareString(13, tmp, true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = ul.getLumpSumAA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Unused leave lump sump A", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = ul.getLumpSumBA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Unused leave lump sump B", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = ul.getLumpSumDA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Unused leave lump sump D", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = ul.getLumpSumEA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Unused leave lump sump E", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = ul.getLumpSumAA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Unused leave lump sump A", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((ic2 = remuneration.getAllowanceCount()) > 0) {
                        gpw.prepareString(11, "Allowance", true, 8.0);
                        gpw.ruleOff(ytdcols);
                    }
                    for (int i9 = 0; i9 < ic2; ++i9) {
                        PEE0003Allowance all = remuneration.getAllowance(i9);
                        if (all == null) continue;
                        String tc = all.getAllowanceTypeC();
                        String oth = all.getOtherAllowanceTypeDe();
                        amt = all.getIndividualNonBusinessEmploymentAllowancesA();
                        if (oth != null && !oth.isEmpty() && (tc == null || tc.equals("Other"))) {
                            gpw.prepareString(12, oth, true, 8.0);
                        } else if (tc != null && !tc.isEmpty()) {
                            gpw.prepareString(12, tc, true, 8.0);
                        }
                        if (amt != null && !amt.isEmpty()) {
                            gpw.prepareString(13, this.formatMoney(amt), true, 8.0, "right");
                        }
                        gpw.drawStrings();
                    }
                    if (ic2 > 0) {
                        gpw.ruleOff(ytdcols, 5.0);
                    }
                    if ((ic3 = remuneration.getDeductionCount()) > 0) {
                        gpw.prepareString(11, "Deduction", true, 8.0);
                        gpw.ruleOff(ytdcols);
                    }
                    for (int i10 = 0; i10 < ic3; ++i10) {
                        PEE0003Deduction ded = remuneration.getDeduction(i10);
                        if (ded == null) continue;
                        String tc = ded.getDeductionTypeC();
                        amt = ded.getA();
                        if (tc != null && !tc.isEmpty()) {
                            gpw.prepareString(12, tc, true, 8.0);
                        }
                        if (amt != null && !amt.isEmpty()) {
                            gpw.prepareString(13, this.formatMoney(amt), true, 8.0, "right");
                        }
                        gpw.drawStrings();
                    }
                    if (ic3 > 0) {
                        gpw.ruleOff(ytdcols, 5.0);
                    }
                    if ((sc = remuneration.getSuperannuationContribution()) != null) {
                        gpw.prepareString(11, "Superannuation contribution", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = sc.getOrdinaryTimeEarningsA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Ordinary Time Earnings", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = sc.getEmployerContributionsSGA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Super Guarantee Amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = sc.getEmployerReportableA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Employer reportable super contribution", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                    if ((rfb = remuneration.getIncomeFringeBenefitsReportable()) != null) {
                        gpw.prepareString(11, "Reportable fringe benefits", true, 8.0);
                        gpw.ruleOff(ytdcols);
                        String tmp = rfb.getExemptIncomeFringeBenefitsReportableA();
                        if (tmp != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Exempt income reportable fringe benefits amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                            gpw.ruleOff(ytdcols);
                        }
                        if ((tmp = rfb.getTaxableIncomeFringeBenefitsReportableA()) != null && !tmp.isEmpty()) {
                            gpw.prepareString(12, "Taxable income reportable fringe benefits amount", true, 8.0);
                            gpw.prepareString(13, this.formatMoney(tmp), true, 8.0, "right");
                        }
                        gpw.drawStrings(5.0);
                    }
                }
            }
            gpw.savePdfReport(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatusBarMessage(e.getMessage());
        }
    }

    private void initialiseCountries() {
        this.countries.put("au", "AUSTRALIA");
        this.countries.put("af", "AFGHANISTAN");
        this.countries.put("ax", "ALAND ISLANDS");
        this.countries.put("al", "ALBANIA");
        this.countries.put("dz", "ALGERIA");
        this.countries.put("as", "AMERICAN SAMOA");
        this.countries.put("ad", "ANDORRA");
        this.countries.put("ao", "ANGOLA");
        this.countries.put("ai", "ANGUILLA");
        this.countries.put("aq", "ANTARCTICA");
        this.countries.put("ag", "ANTIGUA AND BARBUDA");
        this.countries.put("ar", "ARGENTINA");
        this.countries.put("am", "ARMENIA");
        this.countries.put("aw", "ARUBA");
        this.countries.put("au", "AUSTRALIA");
        this.countries.put("at", "AUSTRIA");
        this.countries.put("az", "AZERBAIJAN");
        this.countries.put("bs", "BAHAMAS");
        this.countries.put("bh", "BAHRAIN");
        this.countries.put("bd", "BANGLADESH");
        this.countries.put("bb", "BARBADOS");
        this.countries.put("by", "BELARUS");
        this.countries.put("be", "BELGIUM");
        this.countries.put("bz", "BELIZE");
        this.countries.put("bj", "BENIN");
        this.countries.put("bm", "BERMUDA");
        this.countries.put("bt", "BHUTAN");
        this.countries.put("bo", "BOLIVIA");
        this.countries.put("bq", "BONAIRE,ST EUSTATIUS AND SABA ISLANDS");
        this.countries.put("ba", "BOSNIA AND HERZEGOVINA");
        this.countries.put("bw", "BOTSWANA");
        this.countries.put("bv", "BOUVET ISLAND");
        this.countries.put("br", "BRAZIL");
        this.countries.put("io", "BRITISH INDIAN OCEAN TERRITORY");
        this.countries.put("vg", "BRITISH VIRGIN ISLANDS");
        this.countries.put("bn", "BRUNEI DARUSSALAM");
        this.countries.put("bg", "BULGARIA");
        this.countries.put("bf", "BURKINA FASO");
        this.countries.put("bi", "BURUNDI");
        this.countries.put("kh", "CAMBODIA");
        this.countries.put("cm", "CAMEROON");
        this.countries.put("ca", "CANADA");
        this.countries.put("cv", "CAPE VERDE");
        this.countries.put("ky", "CAYMAN ISLANDS");
        this.countries.put("cf", "CENTRAL AFRICAN REPUBLIC");
        this.countries.put("td", "CHAD");
        this.countries.put("cl", "CHILE");
        this.countries.put("cn", "CHINA");
        this.countries.put("cx", "CHRISTMAS ISLAND");
        this.countries.put("cc", "COCOS (KEELING) ISLANDS");
        this.countries.put("co", "COLOMBIA");
        this.countries.put("km", "COMOROS");
        this.countries.put("cd", "CONGO, PEOPLE'S REPUBLIC OF");
        this.countries.put("cg", "CONGO, DEMOCRATIC REPUBLIC OF (WAS ZAIRE");
        this.countries.put("ck", "COOK ISLANDS");
        this.countries.put("cr", "COSTA RICA");
        this.countries.put("ci", "COTE D'IVOIRE (IVORY COAST)");
        this.countries.put("hr", "CROATIA (HRVATSKA)");
        this.countries.put("cu", "CUBA");
        this.countries.put("cw", "CURACAO");
        this.countries.put("cy", "CYPRUS");
        this.countries.put("cz", "CZECH REPUBLIC");
        this.countries.put("dk", "DENMARK");
        this.countries.put("dj", "DJIBOUTI");
        this.countries.put("dm", "DOMINICA");
        this.countries.put("do", "DOMINICAN REPUBLIC");
        this.countries.put("tl", "EAST TIMOR (TIMOR LESTE)");
        this.countries.put("ec", "ECUADOR");
        this.countries.put("eg", "EGYPT");
        this.countries.put("sv", "EL SALVADOR");
        this.countries.put("gq", "EQUATORIAL GUINEA");
        this.countries.put("er", "ERITREA");
        this.countries.put("ee", "ESTONIA");
        this.countries.put("et", "ETHIOPIA");
        this.countries.put("fk", "FALKLAND ISLANDS (MALVINAS)");
        this.countries.put("fo", "FAROE ISLANDS");
        this.countries.put("fj", "FIJI");
        this.countries.put("fi", "FINLAND");
        this.countries.put("fr", "FRANCE");
        this.countries.put("gf", "FRENCH GUIANA");
        this.countries.put("pf", "FRENCH POLYNESIA");
        this.countries.put("tf", "FRENCH SOUTHERN TERRITORIES");
        this.countries.put("ga", "GABON");
        this.countries.put("gm", "GAMBIA");
        this.countries.put("ge", "GEORGIA");
        this.countries.put("de", "GERMANY");
        this.countries.put("gh", "GHANA");
        this.countries.put("gi", "GIBRALTAR");
        this.countries.put("gr", "GREECE");
        this.countries.put("gl", "GREENLAND");
        this.countries.put("gd", "GRENADA");
        this.countries.put("gp", "GUADELOUPE");
        this.countries.put("gu", "GUAM");
        this.countries.put("gt", "GUATEMALA");
        this.countries.put("gg", "GUERNSEY");
        this.countries.put("gn", "GUINEA");
        this.countries.put("gw", "GUINEA-BISSAU");
        this.countries.put("gy", "GUYANA");
        this.countries.put("ht", "HAITI");
        this.countries.put("hm", "HEARD AND MCDONALD ISLANDS");
        this.countries.put("va", "HOLY SEE (VATICAN CITY STATE)");
        this.countries.put("hn", "HONDURAS");
        this.countries.put("hk", "HONG KONG");
        this.countries.put("hu", "HUNGARY");
        this.countries.put("is", "ICELAND");
        this.countries.put("in", "INDIA");
        this.countries.put("id", "INDONESIA");
        this.countries.put("ir", "IRAN");
        this.countries.put("iq", "IRAQ");
        this.countries.put("ie", "IRELAND");
        this.countries.put("im", "ISLE OF MAN, THE");
        this.countries.put("il", "ISRAEL");
        this.countries.put("it", "ITALY");
        this.countries.put("jm", "JAMAICA");
        this.countries.put("jp", "JAPAN");
        this.countries.put("je", "JERSEY");
        this.countries.put("jo", "JORDAN");
        this.countries.put("kz", "KAZAKHSTAN");
        this.countries.put("ke", "KENYA");
        this.countries.put("ki", "KIRIBATI");
        this.countries.put("kp", "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF (");
        this.countries.put("kr", "KOREA, REPUBLIC OF (SOUTH KOREA)");
        this.countries.put("kw", "KUWAIT");
        this.countries.put("kg", "KYRGYZSTAN");
        this.countries.put("la", "LAOS");
        this.countries.put("lv", "LATVIA");
        this.countries.put("lb", "LEBANON");
        this.countries.put("ls", "LESOTHO");
        this.countries.put("lr", "LIBERIA");
        this.countries.put("ly", "LIBYA");
        this.countries.put("li", "LIECHTENSTEIN");
        this.countries.put("lt", "LITHUANIA");
        this.countries.put("lu", "LUXEMBOURG");
        this.countries.put("mo", "MACAU");
        this.countries.put("mk", "MACEDONIA, THE FORMER YUGOSLAV REPUBLIC ");
        this.countries.put("mg", "MADAGASCAR");
        this.countries.put("mw", "MALAWI");
        this.countries.put("my", "MALAYSIA");
        this.countries.put("mv", "MALDIVES");
        this.countries.put("ml", "MALI");
        this.countries.put("mt", "MALTA");
        this.countries.put("mh", "MARSHALL ISLANDS");
        this.countries.put("mq", "MARTINIQUE");
        this.countries.put("mr", "MAURITANIA");
        this.countries.put("mu", "MAURITIUS");
        this.countries.put("yt", "MAYOTTE");
        this.countries.put("mx", "MEXICO");
        this.countries.put("fm", "MICRONESIA, FEDERATED STATES OF");
        this.countries.put("md", "MOLDOVA");
        this.countries.put("mc", "MONACO");
        this.countries.put("mn", "MONGOLIA");
        this.countries.put("me", "MONTENEGRO");
        this.countries.put("ms", "MONTSERRAT");
        this.countries.put("ma", "MOROCCO");
        this.countries.put("mz", "MOZAMBIQUE");
        this.countries.put("mm", "MYANMAR (WAS BURMA)");
        this.countries.put("na", "NAMIBIA");
        this.countries.put("nr", "NAURU");
        this.countries.put("np", "NEPAL");
        this.countries.put("an", "NETHERLANDS ANTILLES");
        this.countries.put("nl", "NETHERLANDS");
        this.countries.put("nc", "NEW CALEDONIA");
        this.countries.put("nz", "NEW ZEALAND");
        this.countries.put("ni", "NICARAGUA");
        this.countries.put("ne", "NIGER");
        this.countries.put("ng", "NIGERIA");
        this.countries.put("nu", "NIUE");
        this.countries.put("nf", "NORFOLK ISLAND");
        this.countries.put("mp", "NORTHERN MARIANA ISLANDS");
        this.countries.put("no", "NORWAY");
        this.countries.put("om", "OMAN");
        this.countries.put("pk", "PAKISTAN");
        this.countries.put("pw", "PALAU");
        this.countries.put("ps", "PALESTINIAN TERRITORY, OCCUPIED");
        this.countries.put("pa", "PANAMA");
        this.countries.put("pg", "PAPUA NEW GUINEA");
        this.countries.put("py", "PARAGUAY");
        this.countries.put("pe", "PERU");
        this.countries.put("ph", "PHILIPPINES");
        this.countries.put("pn", "PITCAIRN ISLAND");
        this.countries.put("pl", "POLAND");
        this.countries.put("pt", "PORTUGAL");
        this.countries.put("pr", "PUERTO RICO");
        this.countries.put("qa", "QATAR");
        this.countries.put("re", "REUNION");
        this.countries.put("ro", "ROMANIA");
        this.countries.put("ru", "RUSSIAN FEDERATION");
        this.countries.put("rw", "RWANDA");
        this.countries.put("bl", "SAINT BARTHELEMY");
        this.countries.put("sh", "SAINT HELENA");
        this.countries.put("kn", "SAINT KITTS AND NEVIS");
        this.countries.put("lc", "SAINT LUCIA");
        this.countries.put("sx", "SAINT MARTIN (DUTCH PART)");
        this.countries.put("mf", "SAINT MARTIN (FRENCH PART)");
        this.countries.put("pm", "SAINT PIERRE AND MIQUELON");
        this.countries.put("vc", "SAINT VINCENT AND THE GRENADINES");
        this.countries.put("ws", "SAMOA");
        this.countries.put("sm", "SAN MARINO");
        this.countries.put("st", "SAO TOME AND PRINCIPE");
        this.countries.put("sa", "SAUDI ARABIA");
        this.countries.put("sn", "SENEGAL");
        this.countries.put("rs", "SERBIA");
        this.countries.put("sc", "SEYCHELLES");
        this.countries.put("sl", "SIERRA LEONE");
        this.countries.put("sg", "SINGAPORE");
        this.countries.put("sk", "SLOVAKIA (SLOVAK REPUBLIC)");
        this.countries.put("si", "SLOVENIA");
        this.countries.put("sb", "SOLOMON ISLANDS");
        this.countries.put("so", "SOMALIA");
        this.countries.put("za", "SOUTH AFRICA");
        this.countries.put("ss", "SOUTH SUDAN");
        this.countries.put("es", "SPAIN");
        this.countries.put("lk", "SRI LANKA");
        this.countries.put("gs", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISL");
        this.countries.put("sd", "SUDAN");
        this.countries.put("sr", "SURINAME");
        this.countries.put("sj", "SVALBARD AND JAN MAYEN ISLANDS");
        this.countries.put("sz", "SWAZILAND");
        this.countries.put("se", "SWEDEN");
        this.countries.put("ch", "SWITZERLAND");
        this.countries.put("sy", "SYRIA");
        this.countries.put("tw", "TAIWAN");
        this.countries.put("tj", "TAJIKISTAN");
        this.countries.put("tz", "TANZANIA");
        this.countries.put("th", "THAILAND");
        this.countries.put("tg", "TOGO");
        this.countries.put("tk", "TOKELAU");
        this.countries.put("to", "TONGA");
        this.countries.put("tt", "TRINIDAD AND TOBAGO");
        this.countries.put("tn", "TUNISIA");
        this.countries.put("tr", "TURKEY");
        this.countries.put("tm", "TURKMENISTAN");
        this.countries.put("tc", "TURKS AND CAICOS ISLANDS");
        this.countries.put("tv", "TUVALU");
        this.countries.put("ug", "UGANDA");
        this.countries.put("ua", "UKRAINE");
        this.countries.put("ae", "UNITED ARAB EMIRATES");
        this.countries.put("gb", "UNITED KINGDOM");
        this.countries.put("us", "UNITED STATES");
        this.countries.put("um", "UNITED STATES MINOR OUTLYING ISLANDS");
        this.countries.put("vi", "UNITED STATES VIRGIN ISLANDS");
        this.countries.put("uy", "URUGUAY");
        this.countries.put("uz", "UZBEKISTAN");
        this.countries.put("vu", "VANUATU");
        this.countries.put("ve", "VENEZUELA");
        this.countries.put("vn", "VIETNAM");
        this.countries.put("wf", "WALLIS AND FUTUNA ISLANDS");
        this.countries.put("eh", "WESTERN SAHARA");
        this.countries.put("ye", "YEMEN");
        this.countries.put("yu", "YUGOSLAVIA");
        this.countries.put("zm", "ZAMBIA");
        this.countries.put("zw", "ZIMBABWE");
    }

    public String getCountryName(String code) {
        return this.countries.get(code);
    }

    protected Set buildCounterpartyMatchingSet(String filterText) throws Exception {
        Business b;
        if (filterText == null || filterText.isEmpty()) {
            return null;
        }
        if (this.glenixTrnXBRLCounterparty == null) {
            this.loadCounterpartyList();
        }
        if (this.glenixTrnXBRLCounterparty != null && (b = this.glenixTrnXBRLCounterparty.getBusiness()) != null) {
            HashSet<String> result = new HashSet<String>();
            ArrayList<Transaction> cts = b.getTransactionArrayList();
            for (Transaction t : cts) {
                String ci;
                String cn = t.getCounterpartyLegalName();
                if (cn == null || !cn.toLowerCase().contains(filterText) || (ci = t.getCounterpartyIdentifier()) == null) continue;
                result.add(ci);
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    protected Set buildAccountMatchingSet(String filterText) throws Exception {
        Business b;
        if (filterText == null || filterText.isEmpty()) {
            return null;
        }
        if (this.glenixTrnXBRLAccount == null) {
            this.loadAccountList();
        }
        if (this.glenixTrnXBRLAccount != null && (b = this.glenixTrnXBRLAccount.getBusiness()) != null) {
            HashSet<String> result = new HashSet<String>();
            ArrayList<Transaction> cts = b.getTransactionArrayList();
            for (Transaction t : cts) {
                String ci;
                String cn = t.getAccountName();
                if (cn == null || !cn.toLowerCase().contains(filterText) || (ci = t.getAccountIdentifier()) == null) continue;
                result.add(ci);
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    protected Set buildProvisionMatchingSet(String filterText) throws Exception {
        Business b;
        if (filterText == null || filterText.isEmpty()) {
            return null;
        }
        if (this.glenixTrnXBRLProvision == null) {
            this.loadProvisionList();
        }
        if (this.glenixTrnXBRLProvision != null && (b = this.glenixTrnXBRLProvision.getBusiness()) != null) {
            HashSet<String> result = new HashSet<String>();
            ArrayList<Transaction> cts = b.getTransactionArrayList();
            for (Transaction t : cts) {
                String ci;
                String cn = t.getProvisionName();
                if (cn == null || !cn.toLowerCase().contains(filterText) || (ci = t.getProvisionIdentifier()) == null) continue;
                result.add(ci);
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    public GlenixTrnXBRL getAccountTransactionXBRL(String accountIdentifier, LocalDate startDate, LocalDate endDate) throws Exception {
        return this.getTransactions();
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineListByAccount(String accountIdentifier, String filterText, LocalDate fromDate, LocalDate toDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        GlenixTrnXBRL xt = this.getAccountTransactionXBRL(accountIdentifier, fromDate, toDate);
        if (xt == null) {
            return null;
        }
        Business b = xt.getBusiness();
        if (b == null) {
            return null;
        }
        HashSet<String> cs = null;
        if (counterpartyIdentifier != null && !counterpartyIdentifier.isEmpty()) {
            cs = new HashSet<String>();
            cs.add(counterpartyIdentifier);
        } else {
            cs = this.buildCounterpartyMatchingSet(filterText);
        }
        HashSet<String> ps = null;
        if (provisionIdentifier != null && !provisionIdentifier.isEmpty()) {
            ps = new HashSet<String>();
            ps.add(provisionIdentifier);
        } else {
            ps = this.buildProvisionMatchingSet(filterText);
        }
        return b.getTransactionLineArrayListByAccount(accountIdentifier, false, filterText, fromDate, toDate, cs, ps);
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineListByProvision(String provisionIdentifier, String filterText, LocalDate fromDate, LocalDate toDate) throws Exception {
        GlenixTrnXBRL xt = this.getTransactions();
        if (xt == null) {
            return null;
        }
        Business b = xt.getBusiness();
        if (b == null) {
            return null;
        }
        return b.getTransactionLineArrayListByProvision(provisionIdentifier, false, filterText, fromDate, toDate, this.buildCounterpartyMatchingSet(filterText), this.buildAccountMatchingSet(filterText));
    }

    public List<Transaction> getAccountProvisionTotals(String filterText, LocalDate fromDate, LocalDate toDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        GlenixTrnXBRL xt = this.getTransactions();
        if (xt == null) {
            return null;
        }
        Business b = xt.getBusiness();
        if (b == null) {
            return null;
        }
        Transaction result = new Transaction();
        result.setTransactionType("cash_payment");
        ArrayList<Transaction> trns = b.getTransactionArrayList();
        HashMap workings = new HashMap();
        for (Transaction t : trns) {
            String status = t.getTransactionStatus();
            if (status != null && status.equals("cancelled")) continue;
            LocalDate localDate = t.getTransactionDateAsDate();
            if ((fromDate != null || toDate != null) && (localDate == null || fromDate != null && localDate.isBefore(fromDate) || toDate != null && localDate.isAfter(toDate))) continue;
            boolean matchedTextFilter = false;
            if (filterText != null && !filterText.isEmpty()) {
                String transactionComment = t.getTransactionComment();
                if (transactionComment != null && transactionComment.toLowerCase().contains(filterText.toLowerCase())) {
                    matchedTextFilter = true;
                } else {
                    String formattedDate;
                    String cid = t.getCounterpartyIdentifier();
                    if (cid != null && !cid.isEmpty()) {
                        try {
                            String cname;
                            Transaction ct = this.getCounterpartyTransaction(cid);
                            if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(filterText.toLowerCase())) {
                                matchedTextFilter = true;
                            }
                        }
                        catch (Exception ct) {
                            // empty catch block
                        }
                    }
                    if (localDate != null && (formattedDate = this.prettyDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(filterText.toLowerCase())) {
                        matchedTextFilter = true;
                    }
                }
            }
            String tt = t.getTransactionType();
            for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                Object a;
                String key;
                TransactionLine wt;
                TransactionLine tl = t.getTransactionLine(i);
                String ai = tl.getAccountIdentifier();
                String pi = tl.getProvisionIdentifier();
                Transaction ma = this.getAccountTransaction(ai);
                Transaction pt = this.getProvisionTransaction(pi);
                if (filterText != null && !filterText.isEmpty()) {
                    if (!matchedTextFilter) {
                        String lineComment = tl.getLineCommentString();
                        if (lineComment != null && lineComment.toLowerCase().contains(filterText.toLowerCase())) {
                            matchedTextFilter = true;
                        } else {
                            String provName;
                            String accName;
                            if (ma != null && (accName = ma.getAccountName()) != null && accName.toLowerCase().contains(filterText.toLowerCase())) {
                                matchedTextFilter = true;
                            }
                            if (!matchedTextFilter && pt != null && (provName = pt.getProvisionName()) != null && provName.toLowerCase().contains(filterText.toLowerCase())) {
                                matchedTextFilter = true;
                            }
                        }
                    }
                    if (!matchedTextFilter) continue;
                }
                if ((wt = (TransactionLine)workings.get(key = ai + "_,_" + pi)) == null) {
                    wt = result.addBlankTransactionLine();
                    a = wt.getOrAddAccount();
                    ((Account)a).setAccountIdentifier(ai);
                    if (ma != null) {
                        ((Account)a).setAccountName(ma.getAccountName());
                        ((Account)a).setAccountClassificationReference(ma.getAccountClassificationReference());
                    }
                    Provision p = wt.getOrAddProvision();
                    p.setProvisionIdentifier(pi);
                    if (pt != null) {
                        p.setProvisionName(pt.getProvisionName());
                        p.setProvisionClassificationReference(pt.getProvisionClassificationReference());
                        p.setProvisionGrossBASClassification(pt.getProvisionGrossBASClassification());
                    }
                    wt.setAmount(0.0);
                    wt.setProvisionAmount(0.0);
                    wt.setQuantity(0.0);
                }
                a = tl.getAmountAsDouble();
                Double pa = tl.getProvisionAmountAsDouble();
                Double qty = tl.getQuantityAsDouble();
                if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_quote") || tt.equals("cash_received") || tt.equals("purchase_credit"))) {
                    if (a != null) {
                        a = -((Double)a).doubleValue();
                    }
                    if (pa != null) {
                        pa = -pa.doubleValue();
                    }
                    if (qty != null) {
                        qty = -qty.doubleValue();
                    }
                }
                wt.setAmount(this.addDouble((Double)a, wt.getAmountAsDouble()));
                wt.setProvisionAmount(this.addDouble(pa, wt.getProvisionAmountAsDouble()));
                wt.setQuantity(this.addDouble(qty, wt.getQuantityAsDouble()));
            }
        }
        ArrayList<Transaction> listresult = new ArrayList<Transaction>();
        listresult.add(result);
        return listresult;
    }

    public Profile getOutgoingMailServer() throws Exception {
        if (this.outgoingMailServerXBRL == null) {
            this.loadOutgoingMailServer();
        }
        return this.outgoingMailServerXBRL;
    }

    protected GlenixSBRResponse sendRegisterProfile(GlenixAUSKey gak, String commonName, String messageIdentifier, GlenixSBRAttachment gatt) throws Exception {
        MessageDetails md = gak.newMessageDetails();
        md.setService(this.glenix_soap_service_register_profile);
        md.setAction(this.glenix_soap_action_submit);
        md.addAttachment(gatt);
        gak.setProductName(this.glenix_productName);
        gak.setVersionNumber(this.getVersionNumber());
        Document doc = gak.buildOtherSoapDocument(messageIdentifier, this.glenix_soap_legal_name_identifier, commonName, this.glenix_soap_user_role_identifier, this.glenix_dspIdentifierType, this.glenix_dspABN, this.glenix_dspRole, md);
        return gak.dorequest_lodge_apache(this.glenix_fasSoapURL, doc, md.getAttachments(), null);
    }

    public void setSelectedBusinessIdentifier(String businessIdentifier) throws Exception {
    }

    public String getSelectedBusinessIdentifier() {
        return null;
    }

    public void gotoSendInvoiceE(Transaction transaction) throws Exception {
        throw new Exception("Send invoice not implemented in desktop version");
    }

    public void gotoReceiveMoneyE(Transaction editTransaction) throws Exception {
        throw new Exception("Accounts receivable not implemented in desktop version");
    }

    public String getSignedSoftwareSubscriptionIdentifier() throws Exception {
        throw new Exception("Software subscription identifier not implemented in desktop version");
    }

    public GlenixSBRResponse saveAndLodgeCounterpartyTFND(String counterpartyIdentifier, SBRDocumentTFND0004 sbrDocumentTFND) throws Exception {
        throw new Exception("Save and lodge counterparty TFN declaration not implemented");
    }

    public Transaction getBatchTransactionReload(String batchIdentifier) throws Exception {
        throw new Exception("Get batch transaction reload not implemented in desktop software");
    }

    public void gotoProfitAndLossAccountDetail(String accountIdentifier, LocalDate startDate, LocalDate endDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        throw new Exception("Go to profit and loss account detail not implemented in desktop version");
    }

    public void gotoBalanceSheet(LocalDate endDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        throw new Exception("Go to balance sheet not implemented in desktop version");
    }

    public void gotoBalanceSheetAccountDetail(String accountIdentifier, LocalDate endDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        throw new Exception("Go to balance sheet account detail not implemented in desktop version");
    }

    public void gotoBalanceSheetProvisionDetail(String provisionIdentifier, LocalDate endDate, String counterpartyIdentifier, String accountIdentifier) throws Exception {
        throw new Exception("Go to balance sheet provision detail not implemented in desktop version");
    }

    public void gotoBalanceSheetProvisionDetail(Set<String> provisionIdentifier, LocalDate endDate, String counterpartyIdentifier, String accountIdentifier) throws Exception {
        throw new Exception("Go to balance sheet provision detail not implemented in desktop version");
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineListByAccountReconciliation(String accountIdentifier, String filterText, LocalDate fromDate, LocalDate toDate, String counterpartyIdentifier, String provisionIdentifier) throws Exception {
        throw new Exception("Get account reconciliation not implemented in desktop version");
    }

    public GlenixResult sendSplit(String splitCsv) throws Exception {
        throw new Exception("Send split is not implemented in desktop version");
    }

    public GlenixResult sendReconcile(String reconcileCsv) throws Exception {
        throw new Exception("Send reconcile is not implemented in desktop version");
    }

    public GlenixTrnXBRL saveTransactionGetXBRL(Transaction transaction) throws Exception {
        throw new Exception("Save transaction get XBRL is not implemented in desktop version");
    }

    public void gotoBankReconciliationE(Transaction editTransaction, Integer months, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        throw new Exception("Bank reconciliation is not implemented in desktop version");
    }

    public void gotoPayMoneyE(Transaction editTransaction, Integer months, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        throw new Exception("Accounts payable is not implemented in desktop version");
    }

    public void gotoReceiveMoneyE(Transaction editTransaction, Integer months, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        throw new Exception("Accounts receivable is not implemented in desktop version");
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineListByProvisionReconciliation(String provisionIdentifier, String filterText, LocalDate fromDate, LocalDate toDate, String counterpartyIdentifier, String accountIdentifier) throws Exception {
        throw new Exception("Get provision reconciliation is not implemented in desktop version");
    }

    public ArrayList<Transaction.TransactionTransactionLine> getTransactionLineListByProvisionReconciliation(Set<String> provisionIdentifiers, String filterText, LocalDate fromDate, LocalDate toDate, String counterpartyIdentifier, String accountIdentifier) throws Exception {
        throw new Exception("Get provision reconciliation is not implemented in desktop version");
    }

    public void gotoNewFilePartTwoE(BusinessMasterFile bmf) throws Exception {
        throw new Exception("Go to new file is not implemented in desktop version");
    }

    public void gotoLicenseFeePaymentE(String message) throws Exception {
        throw new Exception("Go to new file is not implemented in desktop version");
    }

    public File openTemplateFile() throws Exception {
        throw new Exception("Error, open pdf template file not implemented in desktop version");
    }

    public void uploadTemplateSalesInvoice(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplateSalesInvoice() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplateSalesInvoice() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplateSalesInvoice() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public void uploadTemplateCashReceived(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplateCashReceived() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplateCashReceived() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplateCashReceived() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public void uploadTemplateSalesCredit(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplateSalesCredit() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplateSalesCredit() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplateSalesCredit() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public void uploadTemplatePurchaseInvoice(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplatePurchaseInvoice() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplatePurchaseInvoice() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplatePurchaseInvoice() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public void uploadTemplatePurchaseCredit(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplatePurchaseCredit() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplatePurchaseCredit() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplatePurchaseCredit() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public void uploadTemplateCashPayment(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplateCashPayment() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplateCashPayment() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplateCashPayment() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public void uploadTemplateGeneralJournal(File file) throws Exception {
        throw new Exception("Error, upload template sales invoice not implemented in desktop version");
    }

    public void downloadTemplateGeneralJournal() throws Exception {
        throw new Exception("Error, download template sales invoice not implemented in desktop version");
    }

    public void downloadDefaultTemplateGeneralJournal() throws Exception {
        throw new Exception("Error, download default template sales invoice not implemented in desktop version");
    }

    public void deleteTemplateGeneralJournal() throws Exception {
        throw new Exception("Error, delete template sales invoice not implemented in desktop version");
    }

    public GlenixTrnXBRL getCancelledTransactionList(LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        throw new Exception("Error, get cancelled transactions not implemented in desktop version");
    }

    public GlenixTrnXBRL getGeneralJournalTransactionList(LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        throw new Exception("Error, get general journal transactions not implemented in desktop version");
    }

    public GlenixSBRResponse saveGlenixCertificate(GlenixCertificate glenixCertificate) throws Exception {
        throw new Exception("Error, save glenix certificate not implemented in desktop version");
    }

    public GlenixSBRResponse saveGlenixCertificateList(GlenixCertificateList glenixCertificateList) throws Exception {
        throw new Exception("Error, save glenix certificate not implemented in desktop version");
    }

    @FXML
    public void gotoGeneralJournalTransactions() {
        this.setStatusBarMessage("Cannot post general journals in desktop version");
    }

    public void gotoGeneralJournalTransactions(Transaction transaction) throws Exception {
        this.setStatusBarMessage("Cannot post general journals in desktop version");
    }

    public String getMessageDomain() {
        return this.glenix_messageDomain;
    }

    public File openCsvImportFile() throws Exception {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("All files (*.*)", new String[]{"*.*"});
        fileChooser.getExtensionFilters().add((Object)extFilter2);
        fileChooser.setTitle("Open your .csv file for import");
        return fileChooser.showOpenDialog((Window)this.stage);
    }

    public void gotoImportDataImportFileFieldSelect(CSVReader reader, File afile, String[] firstline) throws Exception {
        if (this.importDataImportFileFieldSelectVBox == null) {
            this.importDataImportFileFieldSelectVBox = new ImportDataImportFileFieldSelectVBox(this);
        }
        this.importDataImportFileFieldSelectVBox.setImportDataFileDetails(reader, afile, firstline);
        this.invalidateComponentsCache();
        this.file_content_display.getChildren().clear();
        this.file_content_display.getChildren().add((Object)this.importDataImportFileFieldSelectVBox);
        this.setStatusBarMessage(null);
    }

    public void assignUUIDToTransactionNumber(Transaction transaction) throws Exception {
        transaction.assignUUIDToTransactionNumber();
    }

    public void assignUUIDToHomeOfficeIdentifier(HomeOffice homeOffice) throws Exception {
        homeOffice.assignUUIDToHomeOfficeIdentifier();
    }

    public void setMyBusinessFileToOpen(String filenamepath) {
        this.myBusinessFileToOpen = filenamepath;
    }

    public String signString(String data) throws Exception {
        GlenixAUSKey useKey = this.glenixAUSKey;
        if (useKey == null) {
            useKey = this.glenixKey;
        }
        if (useKey == null) {
            throw new Exception("No glenix key to use");
        }
        MessageDigest md = useKey.calcDigestBytes(data.getBytes(), "SHA-1");
        return this.createSignatureBase64OneLine(md.digest());
    }

    public void checkAlertUserStatusMessage() {
        if (this.businessMessageListVBox != null) {
            this.businessMessageListVBox.alertUserStatusMessage();
        }
    }

    public void alertUserStatusMessage(boolean doalert) {
        if (doalert) {
            this.supportMenu.setGraphic((Node)this.asterixView);
            this.gotoBusinessMessageListMenuItem.setGraphic((Node)this.asterixView2);
        } else {
            this.supportMenu.setGraphic(null);
            this.gotoBusinessMessageListMenuItem.setGraphic(null);
        }
    }

    private static /* synthetic */ Observable[] lambda$gotoIncomeAndExpenditureAccountDetail$38(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoIncomeAndExpenditureAccountDetail$37(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoFuelTaxCreditEdit$35(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoImportDataList$31(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoImportDataList$30(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoBatchPaySlipEdit$27(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoBatchPaySlipEdit$26(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoBatchTransactionEdit$24(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoBatchTransactionEdit$23(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoTransactionEdit$21(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoTransactionEdit$20(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoBatchTransactions$18(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoBatchTransactions$17(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoTrashTransactions$15(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoTrashTransactions$14(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoImportDataTransactionsE$12(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoImportDataTransactionsE$11(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoASTransactions$9(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoASTransactions$8(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$loadTransactionsVBox$6(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$loadTransactionsVBox$5(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoTransactions$3(Transaction p) {
        return new Observable[]{p.getAccount().getAccountNameProperty()};
    }

    private static /* synthetic */ Observable[] lambda$gotoTransactions$2(Transaction p) {
        return new Observable[]{p.getProvision().getProvisionNameProperty()};
    }
}

