/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.EventItemsVBox;
import au.com.glenix.GlenixLabelAUSKeyCombo;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.ASLStatement;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.ActivityStatementList;
import au.com.glenix.trn.ActivityStatementListIntermediary;
import au.com.glenix.trn.ActivityStatementListResponse;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelDateLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivityStatementListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    protected DocumentBuilder dBuilder;
    protected GlenixTrnXBRL glenixTrnXBRL = null;
    protected ActivityStatementList activityStatementList = null;
    @FXML
    protected Label page_heading;
    @FXML
    protected Label error_message;
    @FXML
    protected Label warning_message;
    @FXML
    protected GlenixLabelLabel activityStatementListABN;
    @FXML
    protected GlenixLabelLabel OrganisationDetails_OrganisationBranch_Code;
    @FXML
    protected GlenixLabelLabel activityStatementListTFN;
    @FXML
    protected GlenixLabelDateLabel startDate;
    @FXML
    protected GlenixLabelDateLabel endDate;
    @FXML
    protected GlenixLabelLabel Report_Statement_SearchCriteriaGroupStatus_Code;
    @FXML
    protected GlenixLabelLabel Identifiers_TaxAgentNumber_Identifier;
    @FXML
    protected GlenixLabelLabel activityStatementListIntermediaryABN;
    @FXML
    protected GlenixLabelDateLabel Report_Submission_Date;
    @FXML
    protected Hyperlink show_detail;
    @FXML
    protected Hyperlink hide_detail;
    @FXML
    protected GlenixFlowPane fp1;
    @FXML
    protected GlenixLabelAUSKeyCombo ausKeyCombo;
    @FXML
    protected GlenixLabelPassword password;
    @FXML
    protected TableView aslStatementTable;
    @FXML
    protected TableColumn startDateAsDateColumn;
    @FXML
    protected TableColumn endDateAsDateColumn;
    @FXML
    protected TableColumn Lodgment_Due_Date_As_Date;
    @FXML
    protected TableColumn Report_Name_Text;
    @FXML
    protected TableColumn BusinessDocument_GovernmentGeneratedIdentifier_Text;
    @FXML
    protected TableColumn Report_Statement_Revision_Indicator;
    @FXML
    protected TableColumn Report_ProcessStatus_Code;
    @FXML
    protected EventItemsVBox overalleventitemsvbox;
    @FXML
    protected EventItemsVBox businesseventitemsvbox;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    protected ApplicationController xbrlFileController = null;
    protected ObservableList<ASLStatement> aslStatementObservableList = null;
    @FXML
    protected Button downloadAndPrefillButton;
    @FXML
    protected Button reviseSelectedActivityStatementButton;

    public ActivityStatementListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.aslStatementTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        ASLStatement aslStatement = (ASLStatement)row.getItem();
                        if (aslStatement != null) {
                            String asNumber = aslStatement.getActivityStatementNumber();
                            if (asNumber != null) {
                                try {
                                    this.xbrlFileController.gotoASTransactions(asNumber);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.error_message.setText(e.getMessage());
                                }
                            } else {
                                this.error_message.setText("Error, could not get activity statement identifier.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get activity statement.");
                        }
                    } else {
                        this.error_message.setText("Error, no selected activity statement.");
                    }
                }
            });
            return row;
        });
        this.startDateAsDateColumn.setCellFactory((Callback)new Callback<TableColumn<ASLStatement, LocalDate>, TableCell<ASLStatement, LocalDate>>(){

            public TableCell call(TableColumn<ASLStatement, LocalDate> param) {
                TableCell<ASLStatement, LocalDate> cell = new TableCell<ASLStatement, LocalDate>(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(ActivityStatementListController.this.displayDateFormatter.format(item));
                        }
                    }
                };
                return cell;
            }
        });
        this.endDateAsDateColumn.setCellFactory((Callback)new Callback<TableColumn<ASLStatement, LocalDate>, TableCell<ASLStatement, LocalDate>>(){

            public TableCell call(TableColumn<ASLStatement, LocalDate> param) {
                TableCell<ASLStatement, LocalDate> cell = new TableCell<ASLStatement, LocalDate>(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(ActivityStatementListController.this.displayDateFormatter.format(item));
                        }
                    }
                };
                return cell;
            }
        });
        this.Lodgment_Due_Date_As_Date.setCellFactory((Callback)new Callback<TableColumn<ASLStatement, LocalDate>, TableCell<ASLStatement, LocalDate>>(){

            public TableCell call(TableColumn<ASLStatement, LocalDate> param) {
                TableCell<ASLStatement, LocalDate> cell = new TableCell<ASLStatement, LocalDate>(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(ActivityStatementListController.this.displayDateFormatter.format(item));
                        }
                    }
                };
                return cell;
            }
        });
    }

    public void loadGlenixDefaults() throws Exception {
        if (this.activityStatementList == null) {
            return;
        }
        this.activityStatementList.setActivityStatementListABN(this.xbrlFileController.getBusinessABN());
        this.activityStatementList.setActivityStatementListTFN(this.xbrlFileController.getBusinessTFN());
        this.activityStatementList.setStartDate(this.xbrlFileController.getLedgerStartDate());
        this.activityStatementList.setEndDate(this.xbrlFileController.getLedgerEndDate());
        this.activityStatementList.setOrganisationDetails_OrganisationBranch_Code(this.xbrlFileController.getBusinessABNBranch());
        this.activityStatementList.setReport_Statement_SearchCriteriaGroupStatus_Code("All");
        ActivityStatementListIntermediary activityStatementListIntermediary = this.activityStatementList.getActivityStatementListIntermediary();
        String intABN = this.xbrlFileController.getProfileXBRL().getAgentABN();
        if (intABN != null) {
            activityStatementListIntermediary.setActivityStatementListIntermediaryABN(this.xbrlFileController.getProfileXBRL().getAgentABN());
            activityStatementListIntermediary.setIdentifiers_TaxAgentNumber_Identifier(this.xbrlFileController.getProfileXBRL().getAgentNumber());
            Calendar calendar = Calendar.getInstance();
            String formatteddate = String.format("%d-%02d-%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
            activityStatementListIntermediary.setReport_Submission_Date(formatteddate);
        } else {
            activityStatementListIntermediary.setActivityStatementListIntermediaryABN(null);
            activityStatementListIntermediary.setIdentifiers_TaxAgentNumber_Identifier(null);
            activityStatementListIntermediary.setReport_Submission_Date(null);
        }
        if (this.ausKeyCombo != null) {
            this.xbrlFileController.loadAUSKey();
            List<GlenixElement> al = this.xbrlFileController.getAUSKeyCredentialList();
            ObservableList ol = FXCollections.observableArrayList(al);
            this.ausKeyCombo.setItems((ObservableList<GlenixElement>)ol);
        }
        Document doc = this.glenixTrnXBRL.buildDocument();
        this.loadGlenixXBRL(doc, doc.getDocumentElement());
        this.hide_detail();
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        super.buildGlenixXBRL(resultDoc, businessEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    Element el = (Element)node2;
                    super.loadGlenixXBRL(loadDoc, el);
                }
            }
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc;
            this.activityStatementList = glenixTrnXBRL.getActivityStatementList();
            if (this.activityStatementList != null && (doc = glenixTrnXBRL.buildDocument()) != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
        this.loadGlenixDefaults();
        if (this.activityStatementList != null && this.activityStatementList != null) {
            String alias;
            this.setASLStatementObservableList();
            this.overalleventitemsvbox.setEventItemsModel(this.activityStatementList.getOverallEventItems());
            this.businesseventitemsvbox.setEventItemsModel(this.activityStatementList.getBusinessEventItems());
            if (this.ausKeyCombo != null && (alias = this.activityStatementList.getCertAlias()) != null) {
                this.ausKeyCombo.setGlenixElementValue(alias);
            }
        }
    }

    protected void setASLStatementObservableList() {
        ActivityStatementListResponse activityStatementListResponse = this.activityStatementList.getActivityStatementListResponse();
        if (activityStatementListResponse == null) {
            return;
        }
        ArrayList<ASLStatement> aslStatementArrayList = activityStatementListResponse.getASLStatementList();
        aslStatementArrayList.sort(new Comparator<ASLStatement>(){

            @Override
            public int compare(ASLStatement t1, ASLStatement t2) {
                LocalDate t1enddate = t1.getEndDateAsDate();
                LocalDate t2enddate = t2.getEndDateAsDate();
                int res = t2enddate.compareTo(t1enddate);
                if (res != 0) {
                    return res;
                }
                LocalDate sd1 = t1.getStartDateAsDate();
                LocalDate sd2 = t2.getStartDateAsDate();
                res = sd2.compareTo(sd1);
                if (res != 0) {
                    return res;
                }
                String din1 = t1.getBusinessDocument_GovernmentGeneratedIdentifier_Text();
                String din2 = t2.getBusinessDocument_GovernmentGeneratedIdentifier_Text();
                res = din2.compareTo(din1);
                if (res != 0) {
                    return res;
                }
                String num1 = t1.getActivityStatementNumber();
                String num2 = t2.getActivityStatementNumber();
                return num2.compareTo(num1);
            }
        });
        this.aslStatementObservableList = FXCollections.observableList(aslStatementArrayList);
        this.aslStatementTable.setItems(this.aslStatementObservableList);
    }

    protected void saveActivityStatementList() throws Exception {
        this.xbrlFileController.saveActivityStatementList(this.activityStatementList);
    }

    @FXML
    protected void activityStatementListDownload() {
        try {
            this.error_message.setText(null);
            this.saveActivityStatementList();
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.activityStatementListDownload(credentialId, password, true, true, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@" + this.xbrlFileController.getMessageDomain();
    }

    protected void activityStatementListDownload(final String credentialId, final String password, final boolean doAll, final boolean doHistorical, final boolean doPrefill, final boolean enableListButton) {
        final String tan = this.Identifiers_TaxAgentNumber_Identifier.getText();
        final String agentABN = this.activityStatementListIntermediaryABN.getText();
        final ActivityStatementList activityStatementList = this.activityStatementList;
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Document doc;
                    String filename;
                    String href;
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin Activity Statement list download...");
                        ActivityStatementListController.this.warning_message.setText(null);
                        ActivityStatementListController.this.warning_message.setVisible(false);
                        ActivityStatementListController.this.warning_message.setManaged(false);
                    });
                    String searchCriteria = "Historical";
                    if (doAll) {
                        searchCriteria = "All";
                    }
                    String abn = activityStatementList.getActivityStatementListABN();
                    String tfn = activityStatementList.getActivityStatementListTFN();
                    String service = "http://sbr.gov.au/ato/as/2009";
                    String action = "List.001.00";
                    if (doAll) {
                        String usageMessageID = ActivityStatementListController.this.generateMessageIdentifier();
                        GlenixResult glenixResult = xbrlFileController.doUsageCheck(tan, agentABN, abn, null, service, action, usageMessageID, null, null, -1);
                        String resultCode = null;
                        if (glenixResult != null) {
                            resultCode = glenixResult.getResultCode();
                        }
                        if (resultCode == null) {
                            throw new Exception("Error, unable to check version or license information, cannot lodge");
                        }
                        if (!resultCode.equals("OK")) {
                            if (resultCode.equals("WARNVERSION")) {
                                Platform.runLater(() -> {
                                    ActivityStatementListController.this.warning_message.setText("Warning: There is a new version available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                    ActivityStatementListController.this.warning_message.setVisible(true);
                                    ActivityStatementListController.this.warning_message.setManaged(true);
                                });
                            } else if (resultCode.equals("WARNLICENSE")) {
                                Platform.runLater(() -> {
                                    ActivityStatementListController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                    ActivityStatementListController.this.warning_message.setVisible(true);
                                    ActivityStatementListController.this.warning_message.setManaged(true);
                                });
                            } else if (resultCode.equals("WARNING")) {
                                Platform.runLater(() -> {
                                    ActivityStatementListController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                    ActivityStatementListController.this.warning_message.setVisible(true);
                                    ActivityStatementListController.this.warning_message.setManaged(true);
                                });
                            } else {
                                if (resultCode.equals("ERRORLICENSE")) {
                                    throw new Exception("Error, you do not have the required license to perform this lodgement. You may need to contact Free Accounting Software on 1300 113 733.");
                                }
                                if (resultCode.equals("ERRORVERSION")) {
                                    throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                }
                                if (resultCode.equals("ERROR")) {
                                    throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                                }
                                throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                        }
                    }
                    activityStatementList.setReport_Statement_SearchCriteriaGroupStatus_Code(searchCriteria);
                    Document attachdoc = activityStatementList.buildActivityStatementListDocument();
                    activityStatementList.setCertAlias(credentialId);
                    xbrlFileController.loadAUSKeyCredential(credentialId);
                    xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                    xbrlFileController.extractAUSKeyCredentialX509Certificate();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("List download - signing request"));
                    Node encryptedDataNode = xbrlFileController.buildAndSendSTSDocument();
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement()));
                    gatt.setDocumentName("AS");
                    gatt.setDocumentType("BASE");
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    gattl.add(gatt);
                    activityStatementList.setSBRDocumentDateTime();
                    String timestamp = activityStatementList.getSBRDocumentDateTime();
                    activityStatementList.generateASLRMessageIdentifier();
                    String messageId = activityStatementList.getASLRMessageIdentifier();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("List download - sending list request"));
                    String logFileName = "ASLR_" + messageId + "_list.log";
                    GlenixSBRResponse glenixSBRResponse = xbrlFileController.buildAndSendLodgeDocument(encryptedDataNode, tan, agentABN, abn, null, tfn, service, action, messageId, timestamp, gattl, logFileName);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("List download - reading response"));
                    glenixSBRResponse.parseResponse();
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("OverallEventMessage")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        activityStatementList.loadSBROverallEventMessageDocument(doc, doc.getDocumentElement());
                    }
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("BaseEventMessage")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        activityStatementList.loadSBRBusinessEventMessageDocument(doc, doc.getDocumentElement());
                    }
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("BusinessResponse")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        ActivityStatementListResponse activityStatementListResponse = activityStatementList.getActivityStatementListResponse();
                        activityStatementListResponse.loadSBRDocumentElement(doc, doc.getDocumentElement());
                        for (ASLStatement asls : activityStatementListResponse.getASLStatementList()) {
                            String din;
                            String asn = asls.getActivityStatementNumber();
                            if (asn != null && !asn.isEmpty() || (din = asls.getBusinessDocument_GovernmentGeneratedIdentifier_Text()) == null || din.isEmpty()) continue;
                            asls.setActivityStatementNumber(din);
                        }
                        ActivityStatementListController.this.setASLStatementObservableList();
                    }
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("List download - complete"));
                    if (doAll && doHistorical) {
                        ActivityStatementListController.this.activityStatementListDownload(credentialId, password, false, true, doPrefill, enableListButton);
                    } else if (doPrefill) {
                        ActivityStatementListController.this.activityStatementPrefillDownload(activityStatementList, tan, agentABN, credentialId, password, enableListButton);
                    } else {
                        ActivityStatementListController.this.saveActivityStatementList();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        ActivityStatementListController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                    ActivityStatementListController.this.downloadAndPrefillButton.disableProperty().set(false);
                }
                finally {
                    xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                    if (!(doAll && doHistorical || doPrefill || !enableListButton)) {
                        ActivityStatementListController.this.downloadAndPrefillButton.disableProperty().set(false);
                    }
                }
            }
        }).start();
    }

    @FXML
    public void show_detail() {
        this.fp1.setVisible(true);
        this.show_detail.setVisible(false);
        this.hide_detail.setVisible(true);
        this.fp1.setManaged(true);
        this.show_detail.setManaged(false);
        this.hide_detail.setManaged(true);
    }

    @FXML
    public void hide_detail() {
        this.fp1.setVisible(false);
        this.show_detail.setVisible(true);
        this.hide_detail.setVisible(false);
        this.fp1.setManaged(false);
        this.show_detail.setManaged(true);
        this.hide_detail.setManaged(false);
    }

    @FXML
    protected void activityStatementListDownloadAndPrefill() {
        try {
            this.error_message.setText(null);
            this.downloadAndPrefillButton.disableProperty().set(true);
            this.saveActivityStatementList();
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.password.setText(null);
            this.activityStatementListDownload(credentialId, password, true, true, true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.downloadAndPrefillButton.disableProperty().set(false);
        }
    }

    @FXML
    protected void activityStatementPrefillDownload() {
        try {
            this.error_message.setText(null);
            this.downloadAndPrefillButton.disableProperty().set(true);
            this.saveActivityStatementList();
            String tan = this.Identifiers_TaxAgentNumber_Identifier.getText();
            String agentABN = this.activityStatementListIntermediaryABN.getText();
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.activityStatementPrefillDownload(this.activityStatementList, tan, agentABN, credentialId, password, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            this.downloadAndPrefillButton.disableProperty().set(false);
        }
        this.aslStatementTable.refresh();
    }

    protected void activityStatementPrefillDownload(final ActivityStatementList activityStatementList, final String tan, final String agentABN, final String credentialId, final String password, final boolean enableListButton) {
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Activity Statement begin prefills..."));
                ZoneId zoneIdUTC = ZoneId.of("UTC");
                ZonedDateTime now = ZonedDateTime.now(zoneIdUTC);
                ActivityStatementListResponse r = activityStatementList.getActivityStatementListResponse();
                ArrayList<ASLStatement> aslStatementList = r.getASLStatementList();
                if (aslStatementList != null) {
                    for (ASLStatement aslStatement : aslStatementList) {
                        Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Activity Statement prefills AS " + aslStatement.getBusinessDocument_GovernmentGeneratedIdentifier_Text() + "..."));
                        try {
                            Document doc;
                            String filename;
                            String href;
                            Document attachdoc = activityStatementList.buildActivityStatementPrefillDocument(aslStatement);
                            xbrlFileController.loadAUSKeyCredential(credentialId);
                            xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                            xbrlFileController.extractAUSKeyCredentialX509Certificate();
                            Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Activity Statement prefill sign request for " + aslStatement.getBusinessDocument_GovernmentGeneratedIdentifier_Text()));
                            Node encryptedDataNode = xbrlFileController.buildAndSendSTSDocument();
                            String abn = activityStatementList.getActivityStatementListABN();
                            String tfn = activityStatementList.getActivityStatementListTFN();
                            String service = "http://sbr.gov.au/ato/as/2009";
                            String action = "Get.001.00";
                            GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement()));
                            gatt.setDocumentName("AS");
                            gatt.setDocumentType("BASE");
                            ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                            gattl.add(gatt);
                            aslStatement.setSBRDocumentDateTime();
                            String timestamp = aslStatement.getSBRDocumentDateTime();
                            aslStatement.generateASLSMessageIdentifier();
                            String messageId = aslStatement.getASLSMessageIdentifier();
                            Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Activity Statement request prefill for " + aslStatement.getBusinessDocument_GovernmentGeneratedIdentifier_Text()));
                            String logFileName = "ASLR_" + messageId + "_prefill.log";
                            GlenixSBRResponse glenixSBRResponse = xbrlFileController.buildAndSendLodgeDocument(encryptedDataNode, tan, agentABN, abn, null, tfn, service, action, messageId, timestamp, gattl, logFileName);
                            glenixSBRResponse.parseResponse();
                            Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Activity Statement parse prefill response for " + aslStatement.getBusinessDocument_GovernmentGeneratedIdentifier_Text()));
                            glenixSBRResponse.resetPartIterator();
                            while (glenixSBRResponse.hasNextPart()) {
                                href = glenixSBRResponse.nextPartHref();
                                if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("OverallEventMessage")) continue;
                                doc = glenixSBRResponse.getDocumentByHref(href);
                                aslStatement.loadSBROverallEventMessageDocument(doc, doc.getDocumentElement());
                            }
                            glenixSBRResponse.resetPartIterator();
                            while (glenixSBRResponse.hasNextPart()) {
                                href = glenixSBRResponse.nextPartHref();
                                if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("BaseEventMessage")) continue;
                                doc = glenixSBRResponse.getDocumentByHref(href);
                                aslStatement.loadSBRBusinessEventMessageDocument(doc, doc.getDocumentElement());
                            }
                            glenixSBRResponse.resetPartIterator();
                            while (glenixSBRResponse.hasNextPart()) {
                                href = glenixSBRResponse.nextPartHref();
                                if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("BusinessResponse")) continue;
                                doc = glenixSBRResponse.getDocumentByHref(href);
                                String asNumber = aslStatement.getActivityStatementNumber();
                                GlenixTrnXBRL asXBRL = xbrlFileController.loadActivityStatement(asNumber);
                                if (asXBRL == null) continue;
                                ActivityStatement as = asXBRL.getActivityStatement();
                                as.loadSBRDocumentRoot(doc, doc.getDocumentElement(), false);
                                as.setActivityStatementNumber(asNumber);
                                String atoStatus = as.getReportProcessStatusCode();
                                if (atoStatus != null && atoStatus.equals("FIN")) {
                                    as.setSBRDocumentStatus("lodge_complete");
                                } else {
                                    as.setSBRDocumentStatus("prefill_complete");
                                }
                                as.setASCertAlias(credentialId);
                                as.setSBRDocumentDateTime();
                                xbrlFileController.saveActivityStatement(asXBRL);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Platform.runLater(() -> {
                                ActivityStatementListController.this.error_message.setText(e.getMessage());
                                xbrlFileController.setStatusBarMessage(e.getMessage());
                            });
                        }
                        finally {
                            xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                        }
                    }
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Activity Statement prefill complete");
                        if (enableListButton) {
                            ActivityStatementListController.this.downloadAndPrefillButton.disableProperty().set(false);
                        }
                        try {
                            ActivityStatementListController.this.setModel(ActivityStatementListController.this.glenixTrnXBRL);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ActivityStatementListController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                try {
                    ActivityStatementListController.this.saveActivityStatementList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        ActivityStatementListController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                }
            }
        }).start();
    }

    @FXML
    protected void reviseSelectedActivityStatement() {
        ASLStatement aslStatement = (ASLStatement)this.aslStatementTable.getSelectionModel().getSelectedItem();
        if (aslStatement == null) {
            this.error_message.setText("No activity statement selected. Select an Activity Statement to revise.");
            this.xbrlFileController.setStatusBarMessage("No activity statement selected. Select an Activity Statement to revise.");
            return;
        }
        try {
            String asNumber = aslStatement.getActivityStatementNumber();
            ActivityStatementListResponse activityStatementListResponse = this.activityStatementList.getActivityStatementListResponse();
            if (activityStatementListResponse == null) {
                throw new Exception("No activity statements are listed yet.");
            }
            ASLStatement prevRevisedAS = activityStatementListResponse.getASLRByOriginalASNumber(asNumber);
            if (prevRevisedAS != null) {
                throw new Exception("Error, this Activity Statement has already been revised.");
            }
            GlenixTrnXBRL asXBRL = this.xbrlFileController.loadActivityStatementCheckCacheNoDefault(asNumber);
            if (asXBRL == null) {
                throw new Exception("Error, you cannot revise this activity statement as you have not lodged it yet.");
            }
            ActivityStatement as = asXBRL.getActivityStatement();
            if (as == null) {
                throw new Exception("Error, you cannot revise this activity statement as you have not lodged it yet.");
            }
            String status = as.getSBRDocumentStatus();
            if (status == null || !status.equals("lodge_complete")) {
                throw new Exception("Error, you cannot revise this activity statement as you have not lodged it yet.");
            }
            ASLStatement revisedASLStatement = activityStatementListResponse.reviseASLStatementByAsNumber(asNumber);
            this.xbrlFileController.saveActivityStatementList(this.activityStatementList, revisedASLStatement);
            String revisedASNumber = revisedASLStatement.getActivityStatementNumber();
            GlenixTrnXBRL revisedASXBRL = this.xbrlFileController.loadActivityStatement(revisedASNumber);
            if (revisedASXBRL == null) {
                throw new Exception("Error, an error has occured in revising the activity statement");
            }
            Document doc = asXBRL.buildDocument();
            revisedASXBRL.loadDocumentElementOverwrite(doc, doc.getDocumentElement());
            ActivityStatement revisedAS = revisedASXBRL.getActivityStatement();
            if (revisedAS == null) {
                throw new Exception("Error, an error has occured in revising the activity statement");
            }
            revisedAS.setActivityStatementNumber(revisedASNumber);
            revisedAS.setOriginalActivityStatementNumber(asNumber);
            revisedAS.setSBRDocumentStatus("prefill_complete");
            revisedAS.removeEventMessages();
            revisedAS.setReportStatementRevisionIndicator("true");
            this.xbrlFileController.saveActivityStatement(revisedASXBRL);
            this.setASLStatementObservableList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(9);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(3, 44.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(4, 68.0, 48.0);
        gpw.setColumnLeftPosAndWidthMM(5, 116.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(6, 140.0, 16.0);
        gpw.setColumnLeftPosAndWidthMM(7, 156.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(8, 176.0, 24.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (ASLStatement s : this.aslStatementObservableList) {
            gpw.prepareString(2, this.displayDateFormatter.format(s.getStartDateAsDate()), true, fontSize);
            gpw.prepareString(3, this.displayDateFormatter.format(s.getEndDateAsDate()), true, fontSize);
            gpw.prepareString(4, s.getReport_Name_Text(), true, fontSize);
            gpw.prepareString(5, s.getBusinessDocument_GovernmentGeneratedIdentifier_Text(), true, fontSize);
            gpw.prepareString(6, s.getReport_Statement_Revision_Indicator(), true, fontSize);
            gpw.prepareString(7, s.getReport_ProcessStatus_Code(), true, fontSize);
            gpw.prepareString(8, this.displayDateFormatter.format(s.getLodgment_Due_Date_As_Date()), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    protected void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.startDateAsDateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.endDateAsDateColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.Report_Name_Text.getText(), true, fontSize);
        gpw.prepareString(5, this.BusinessDocument_GovernmentGeneratedIdentifier_Text.getText(), true, fontSize);
        gpw.prepareString(6, this.Report_Statement_Revision_Indicator.getText(), true, fontSize);
        gpw.prepareString(7, this.Report_ProcessStatus_Code.getText(), true, fontSize);
        gpw.prepareString(8, this.Lodgment_Due_Date_As_Date.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

