/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.EventItemsVBox;
import au.com.glenix.FBTObligationVBox;
import au.com.glenix.GSTObligationVBox;
import au.com.glenix.GlenixLabelAUSKeyCombo;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.PAYGIObligationVBox;
import au.com.glenix.PAYGWObligationVBox;
import au.com.glenix.trn.ASLStatement;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.FBTObligation;
import au.com.glenix.trn.GSTObligation;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.PAYGIObligation;
import au.com.glenix.trn.PAYGWObligation;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelDateTimeLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelPassword;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivityStatementController
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    protected GlenixTrnXBRL glenixTrnXBRL = null;
    protected ActivityStatement activityStatement = null;
    @FXML
    protected Label error_message;
    @FXML
    protected Label warning_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected Button saveButton;
    @FXML
    protected Button prelodgeButton;
    @FXML
    protected Button lodgeButton;
    @FXML
    protected Hyperlink show_detail;
    @FXML
    protected Hyperlink hide_detail;
    @FXML
    protected GlenixFlowPane fp1;
    @FXML
    protected GlenixLabelAUSKeyCombo ausKeyCombo;
    @FXML
    protected GlenixLabelPassword password;
    @FXML
    protected VBox gstspace;
    @FXML
    protected VBox fbtspace;
    @FXML
    protected VBox paygispace;
    @FXML
    protected VBox paygwspace;
    @FXML
    protected GSTObligationVBox gstvbox;
    @FXML
    protected FBTObligationVBox fbtvbox;
    @FXML
    protected PAYGIObligationVBox paygivbox;
    @FXML
    protected PAYGWObligationVBox paygwvbox;
    @FXML
    protected EventItemsVBox overalleventitemsvbox;
    @FXML
    protected EventItemsVBox businesseventitemsvbox;
    @FXML
    protected GlenixLabelLabel Report_Statement_Summary_Payable_Amount;
    @FXML
    protected GlenixLabelLabel Report_Statement_Summary_Refundable_Amount;
    @FXML
    protected GlenixLabelLabel Report_Statement_Summary_Net_Amount;
    @FXML
    protected GlenixLabelLabel sbrDocumentStatus;
    @FXML
    protected GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;
    @FXML
    protected GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    @FXML
    protected GlenixLabelLabel ASIntermediary_ABN;
    @FXML
    protected GlenixLabelLabel ASIntermediary_TAN;
    @FXML
    protected GlenixLabelDate Report_Submission_Date;
    @FXML
    protected GlenixVBox intermediarysection;
    @FXML
    protected GlenixLabelCheckbox INT_Declaration_StatementAccepted_Indicator;
    @FXML
    protected GlenixLabelDate INT_Declaration_Signature_Date;
    @FXML
    protected GlenixLabelText INT_Declaration_SignatoryIdentifier_Text;
    @FXML
    protected GlenixLabelCheckbox RP_Declaration_StatementAccepted_Indicator;
    @FXML
    protected GlenixLabelDate RP_Declaration_Signature_Date;
    @FXML
    protected GlenixLabelText RP_Declaration_SignatoryIdentifier_Text;
    @FXML
    protected GlenixLabelDateTimeLabel SBRDocumentDateTime;
    protected ApplicationController xbrlFileController = null;
    protected DateTimeFormatter outputDateFormatter;

    public ActivityStatementController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
        this.outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
            if (this.ausKeyCombo != null) {
                List<GlenixElement> al = this.xbrlFileController.getAUSKeyCredentialList();
                ObservableList ol = FXCollections.observableArrayList(al);
                this.ausKeyCombo.setItems((ObservableList<GlenixElement>)ol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.hide_detail();
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (!this.gstspace.getChildren().contains((Object)this.gstvbox)) {
            this.gstspace.getChildren().add((Object)this.gstvbox);
        }
        if (!this.fbtspace.getChildren().contains((Object)this.fbtvbox)) {
            this.fbtspace.getChildren().add((Object)this.fbtvbox);
        }
        if (!this.paygispace.getChildren().contains((Object)this.paygivbox)) {
            this.paygispace.getChildren().add((Object)this.paygivbox);
        }
        if (!this.paygwspace.getChildren().contains((Object)this.paygwvbox)) {
            this.paygwspace.getChildren().add((Object)this.paygwvbox);
        }
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element asElement = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, asElement);
                        }
                    }
                }
            }
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL == null) {
            this.gstspace.getChildren().clear();
            this.fbtspace.getChildren().clear();
            this.paygispace.getChildren().clear();
            this.paygwspace.getChildren().clear();
            this.gstvbox.clearGlenixXBRL();
            this.fbtvbox.clearGlenixXBRL();
            this.paygivbox.clearGlenixXBRL();
            this.paygwvbox.clearGlenixXBRL();
        } else {
            this.activityStatement = glenixTrnXBRL.getActivityStatement();
            if (this.activityStatement == null) {
                this.gstspace.getChildren().clear();
                this.fbtspace.getChildren().clear();
                this.paygispace.getChildren().clear();
                this.paygwspace.getChildren().clear();
                this.gstvbox.clearGlenixXBRL();
                this.fbtvbox.clearGlenixXBRL();
                this.paygivbox.clearGlenixXBRL();
                this.paygwvbox.clearGlenixXBRL();
            } else {
                String alias;
                String lodgeStatus;
                GSTObligation gstObligation;
                String documentStatus = this.activityStatement.getSBRDocumentStatus();
                Document doc = glenixTrnXBRL.buildDocument();
                this.gstvbox.clearGlenixXBRL();
                this.fbtvbox.clearGlenixXBRL();
                this.paygivbox.clearGlenixXBRL();
                this.paygwvbox.clearGlenixXBRL();
                if (doc != null) {
                    this.loadGlenixXBRL(doc, doc.getDocumentElement());
                }
                if ((gstObligation = this.activityStatement.getGSTObligation()) == null) {
                    this.gstspace.getChildren().clear();
                } else {
                    if (!this.gstspace.getChildren().contains((Object)this.gstvbox)) {
                        this.gstspace.getChildren().add((Object)this.gstvbox);
                    }
                    this.gstvbox.setDocumentStatus(documentStatus);
                    this.gstvbox.setGSTObligationModel(gstObligation);
                }
                FBTObligation fbtObligation = this.activityStatement.getFBTObligation();
                if (fbtObligation == null) {
                    this.fbtspace.getChildren().clear();
                } else {
                    if (!this.fbtspace.getChildren().contains((Object)this.fbtvbox)) {
                        this.fbtspace.getChildren().add((Object)this.fbtvbox);
                    }
                    this.fbtvbox.setDocumentStatus(documentStatus);
                    this.fbtvbox.setFBTObligationModel(fbtObligation);
                }
                PAYGIObligation paygiObligation = this.activityStatement.getPAYGIObligation();
                if (paygiObligation == null) {
                    this.paygispace.getChildren().clear();
                } else {
                    if (!this.paygispace.getChildren().contains((Object)this.paygivbox)) {
                        this.paygispace.getChildren().add((Object)this.paygivbox);
                    }
                    this.paygivbox.setDocumentStatus(documentStatus);
                    this.paygivbox.setPAYGIObligationModel(paygiObligation);
                }
                PAYGWObligation paygwObligation = this.activityStatement.getPAYGWObligation();
                if (paygwObligation == null) {
                    this.paygwspace.getChildren().clear();
                } else {
                    if (!this.paygwspace.getChildren().contains((Object)this.paygwvbox)) {
                        this.paygwspace.getChildren().add((Object)this.paygwvbox);
                    }
                    this.paygwvbox.setDocumentStatus(documentStatus);
                    this.paygwvbox.setPAYGWObligationModel(paygwObligation);
                }
                this.overalleventitemsvbox.setEventItemsModel(this.activityStatement.getOverallEventItems());
                this.businesseventitemsvbox.setEventItemsModel(this.activityStatement.getBusinessEventItems());
                String startDate = this.activityStatement.getStartDate();
                String endDate = this.activityStatement.getEndDate();
                if (startDate != null && endDate != null) {
                    LocalDate ld = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
                    String formattedStartDate = ld.format(this.outputDateFormatter);
                    ld = LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE);
                    String formattedEndDate = ld.format(this.outputDateFormatter);
                    this.page_heading.setText("Activity statement from " + formattedStartDate + " to " + formattedEndDate);
                }
                if ((lodgeStatus = this.activityStatement.getSBRDocumentStatus()) == null || lodgeStatus.isEmpty() || lodgeStatus.equals("created") || lodgeStatus.equals("prefill_complete") || lodgeStatus.equals("prelodge_complete")) {
                    this.updateTotals();
                    this.gstvbox.setSingleChangeListener(new ChangeListener<GSTObligation>(){

                        public void changed(ObservableValue<? extends GSTObligation> observable, GSTObligation oldValue, GSTObligation newValue) {
                            ActivityStatementController.this.updateTotals();
                        }
                    });
                    this.fbtvbox.setSingleChangeListener(new ChangeListener<FBTObligation>(){

                        public void changed(ObservableValue<? extends FBTObligation> observable, FBTObligation oldValue, FBTObligation newValue) {
                            ActivityStatementController.this.updateTotals();
                        }
                    });
                    this.paygivbox.setSingleChangeListener(new ChangeListener<PAYGIObligation>(){

                        public void changed(ObservableValue<? extends PAYGIObligation> observable, PAYGIObligation oldValue, PAYGIObligation newValue) {
                            ActivityStatementController.this.updateTotals();
                        }
                    });
                }
                if ((alias = this.activityStatement.getASCertAlias()) != null) {
                    this.ausKeyCombo.setGlenixElementValue(alias);
                }
            }
        }
    }

    protected void updateTotals() {
        Double totalPayable = 0.0;
        totalPayable = totalPayable + this.gstvbox.getGoodsAndServicesTax_Payable_Amount();
        totalPayable = totalPayable + this.gstvbox.getWineEqualisationTax_Liability_Amount();
        totalPayable = totalPayable + this.gstvbox.getLuxuryCarTax_Liability_Amount();
        totalPayable = totalPayable + this.gstvbox.getFuelTax_OverclaimedCredits_Amount();
        totalPayable = totalPayable + this.gstvbox.getGST_DeferredLiabilityOnImportDuty_Amount();
        Double totalReceivable = 0.0;
        totalReceivable = totalReceivable + this.gstvbox.getGoodsAndServicesTax_ClaimableCredits_Amount();
        totalReceivable = totalReceivable + this.gstvbox.getWineEqualisationTax_ClaimableCredits_Amount();
        totalReceivable = totalReceivable + this.gstvbox.getLuxuryCarTax_ClaimableCredits_Amount();
        totalReceivable = totalReceivable + this.gstvbox.getFuelTax_ClaimableCredits_Amount();
        totalPayable = totalPayable + this.paygwvbox.getIncomeTax_PayAsYouGoWithholding_Total_Amount();
        totalPayable = totalPayable + this.paygivbox.getIT_CompanyAndSuperDeferredLiabilityInstalment_Amount();
        totalPayable = totalPayable + this.paygivbox.getIncomeTax_InstalmentPayable_Amount();
        totalReceivable = totalReceivable + this.paygivbox.getIncomeTax_InstalmentClaimableCredits_Amount();
        totalPayable = totalPayable + this.fbtvbox.getFringeBenefitsTax_Payable_Amount();
        totalReceivable = totalReceivable + this.fbtvbox.getFringeBenefitsTax_ClaimableCredits_Amount();
        this.Report_Statement_Summary_Payable_Amount.setGlenixElementValue("" + totalPayable.intValue());
        this.Report_Statement_Summary_Refundable_Amount.setGlenixElementValue("" + totalReceivable.intValue());
        this.Report_Statement_Summary_Net_Amount.setGlenixElementValue("" + (totalPayable.intValue() - totalReceivable.intValue()));
    }

    @FXML
    public void show_detail() {
        this.fp1.setVisible(true);
        this.show_detail.setVisible(false);
        this.hide_detail.setVisible(true);
        this.fp1.setManaged(true);
        this.hide_detail.setManaged(true);
        this.hide_detail.requestFocus();
        this.show_detail.setManaged(false);
    }

    @FXML
    public void hide_detail() {
        this.fp1.setVisible(false);
        this.show_detail.setVisible(true);
        this.hide_detail.setVisible(false);
        this.fp1.setManaged(false);
        this.show_detail.setManaged(true);
        this.show_detail.requestFocus();
        this.hide_detail.setManaged(false);
    }

    private void activityStatementSaveModel() throws Exception {
        this.xbrlFileController.saveActivityStatement(this.glenixTrnXBRL);
    }

    protected void activityStatementSaveEnteredData() throws Exception {
        String status = this.activityStatement.getSBRDocumentStatus();
        if (status != null && status.equals("lodge_complete")) {
            throw new Exception("Error, the Activity statement is lodged you cannot modify it.");
        }
        ZoneId zoneIdUTC = ZoneId.of("UTC");
        ZonedDateTime now = ZonedDateTime.now(zoneIdUTC);
        String dateTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(now);
        this.SBRDocumentDateTime.setGlenixElementValue(dateTime);
        Document doc = this.dBuilder.newDocument();
        super.buildGlenixXBRL(doc, null);
        this.activityStatement.loadDocumentElementOverwrite(doc, doc.getDocumentElement());
        if (this.intermediarysection.isVisible()) {
            this.activityStatement.setRpDeclarationStatementTypeCode(null);
        } else {
            this.activityStatement.setRpDeclarationStatementTypeCode("TrueAndCorrect");
        }
        if (!this.intermediarysection.isVisible()) {
            this.activityStatement.setIntDeclarationStatementTypeCode(null);
        } else {
            this.activityStatement.setIntDeclarationStatementTypeCode("TrueAndCorrect");
        }
        this.activityStatementSaveModel();
    }

    @FXML
    public void activityStatementSave() {
        try {
            this.activityStatementSaveEnteredData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void activityStatementPrelodge() {
        if (this.activityStatement == null) {
            this.xbrlFileController.setStatusBarMessage("Error, activity statement is null, save first.");
            this.error_message.setText("Error, activity statement is null, save first.");
            return;
        }
        try {
            this.error_message.setText(null);
            this.xbrlFileController.setStatusBarMessage("Begin prelodge validation");
            this.activityStatement.removeEventMessages();
            this.activityStatementSaveEnteredData();
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.password.setText(null);
            this.lodge(this.activityStatement, "prelodge", credentialId, password);
            this.activityStatementSaveModel();
            this.setModel(this.glenixTrnXBRL);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void activityStatementLodge() {
        if (this.activityStatement == null) {
            this.xbrlFileController.setStatusBarMessage("Error, activity statement is null, save first.");
            this.error_message.setText("Error, activity statement is null, save first.");
            return;
        }
        try {
            this.error_message.setText(null);
            this.xbrlFileController.setStatusBarMessage("Begin lodge...");
            this.activityStatement.removeEventMessages();
            this.activityStatementSaveEnteredData();
            String credentialId = this.ausKeyCombo.getGlenixElementValue();
            String password = this.password.getText();
            this.password.setText(null);
            this.lodge(this.activityStatement, "lodge", credentialId, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void backToTransactions() {
        if (this.activityStatement == null) {
            this.error_message.setText("Error, no activity statement selected.");
        }
        String asNumber = this.activityStatement.getActivityStatementNumber();
        this.xbrlFileController.gotoASTransactions(asNumber);
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    private void lodge(final ActivityStatement activityStatement, final String action, final String credentialId, final String password) {
        final String tan = this.ASIntermediary_TAN.getText();
        final String agentABN = this.ASIntermediary_ABN.getText();
        final String abn = this.Identifiers_AustralianBusinessNumber_Identifier.getText();
        final String tfn = this.Identifiers_TaxFileNumber_Identifier.getText();
        final ApplicationController xbrlFileController = this.xbrlFileController;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String maxError;
                    Document doc;
                    String filename;
                    String href;
                    Platform.runLater(() -> {
                        xbrlFileController.setStatusBarMessage("Begin Activity Statement " + action + "...");
                        ActivityStatementController.this.warning_message.setText(null);
                        ActivityStatementController.this.warning_message.setVisible(false);
                        ActivityStatementController.this.warning_message.setManaged(false);
                    });
                    String service = "http://sbr.gov.au/ato/as/2009";
                    String actionCode = "Validate.001.00";
                    if (action != null && action.equals("lodge")) {
                        actionCode = "Submit.001.00";
                    }
                    String usageMessageID = ActivityStatementController.this.generateMessageIdentifier();
                    System.out.print("Pre as usage");
                    GlenixResult glenixResult = xbrlFileController.doUsageCheck(tan, agentABN, abn, null, service, actionCode, usageMessageID, null, null, -1);
                    System.out.print("Post as usage");
                    String resultCode = null;
                    if (glenixResult != null) {
                        resultCode = glenixResult.getResultCode();
                    }
                    if (resultCode == null) {
                        throw new Exception("Error, unable to check version or license information, cannot lodge");
                    }
                    if (!resultCode.equals("OK")) {
                        if (resultCode.equals("WARNVERSION")) {
                            Platform.runLater(() -> {
                                ActivityStatementController.this.warning_message.setText("Warning: There is a new version available please go to www.freeaccountingsoftware.com.au to download the latest version.");
                                ActivityStatementController.this.warning_message.setVisible(true);
                                ActivityStatementController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNLICENSE")) {
                            Platform.runLater(() -> {
                                ActivityStatementController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                ActivityStatementController.this.warning_message.setVisible(true);
                                ActivityStatementController.this.warning_message.setManaged(true);
                            });
                        } else if (resultCode.equals("WARNING")) {
                            Platform.runLater(() -> {
                                ActivityStatementController.this.warning_message.setText("Warning: " + glenixResult.getResultDescription());
                                ActivityStatementController.this.warning_message.setVisible(true);
                                ActivityStatementController.this.warning_message.setManaged(true);
                            });
                        } else {
                            if (resultCode.equals("ERRORLICENSE")) {
                                throw new Exception("Error, you do not have the required license to perform this lodgement. You may need to contact Free Accounting Software on 1300 113 733.");
                            }
                            if (resultCode.equals("ERRORVERSION")) {
                                throw new Exception("Error, the version of the software you are using is out of date. You need to upgrade first please go to www.freeaccountingsoftware.com.au to download the latest version.");
                            }
                            if (resultCode.equals("ERROR")) {
                                throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                            }
                            throw new Exception("Error, unable to check version or license information, error code " + resultCode + ", description " + glenixResult.getResultDescription());
                        }
                    }
                    xbrlFileController.loadAUSKeyCredential(credentialId);
                    xbrlFileController.unprotectAUSKeyCredentialPrivateKey(password);
                    xbrlFileController.extractAUSKeyCredentialX509Certificate();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Signing activity statement document..."));
                    Node encryptedDataNode = xbrlFileController.buildAndSendSTSDocument();
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Building activity statement document..."));
                    Document attachdoc = activityStatement.buildActivityStatementDocument(action);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Sending activity statement to ATO..."));
                    GlenixSBRAttachment gatt = new GlenixSBRAttachment(attachdoc, "Attachment01", xbrlFileController.calculateSHA1Digest(attachdoc.getDocumentElement()));
                    gatt.setDocumentName("AS");
                    gatt.setDocumentType("BASE");
                    ArrayList<GlenixSBRAttachment> gattl = new ArrayList<GlenixSBRAttachment>();
                    gattl.add(gatt);
                    activityStatement.setSBRDocumentDateTime();
                    String timestamp = activityStatement.getSBRDocumentDateTime();
                    activityStatement.generateASMessageIdentifier();
                    String messageId = activityStatement.getASMessageIdentifier();
                    String identifier = activityStatement.getActivityStatementNumber();
                    String logFileName = "AS_" + identifier + "_prelodge.log";
                    if (action != null && action.equals("lodge")) {
                        logFileName = "AS_" + identifier + "_lodge.log";
                    }
                    GlenixSBRResponse glenixSBRResponse = xbrlFileController.buildAndSendLodgeDocument(encryptedDataNode, tan, agentABN, abn, null, tfn, service, actionCode, messageId, timestamp, gattl, logFileName);
                    Platform.runLater(() -> xbrlFileController.setStatusBarMessage("Interpreting response from ATO..."));
                    glenixSBRResponse.parseResponse();
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) != null && !filename.equals("OverallEventMessage")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        activityStatement.loadSBROverallEventMessageDocument(doc, doc.getDocumentElement());
                    }
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        href = glenixSBRResponse.nextPartHref();
                        if (href == null || (filename = glenixSBRResponse.getPartProperty(href, "filename")) == null || !filename.equals("BusinessEventMessage") && !filename.equals("BaseEventMessage")) continue;
                        doc = glenixSBRResponse.getDocumentByHref(href);
                        activityStatement.loadSBRBusinessEventMessageDocument(doc, doc.getDocumentElement());
                    }
                    boolean ok = false;
                    EventItems ei = activityStatement.getBusinessEventItems();
                    if (ei != null && (maxError = ei.getMaximumSeverityCode()) != null && maxError.equals("Information")) {
                        Platform.runLater(() -> {
                            if (action != null && action.equals("lodge")) {
                                xbrlFileController.setStatusBarMessage("Activity statement lodge complete.");
                            } else {
                                xbrlFileController.setStatusBarMessage("Activity statement prelodge validate complete.");
                            }
                        });
                        ok = true;
                    }
                    glenixSBRResponse.resetPartIterator();
                    while (glenixSBRResponse.hasNextPart()) {
                        String filename2;
                        String href2 = glenixSBRResponse.nextPartHref();
                        if (href2 == null || (filename2 = glenixSBRResponse.getPartProperty(href2, "filename")) == null || !filename2.equals("BusinessResponse")) continue;
                        Document doc2 = glenixSBRResponse.getDocumentByHref(href2);
                        activityStatement.loadSBRDocumentRoot(doc2, doc2.getDocumentElement(), true);
                    }
                    String ts = glenixSBRResponse.getTimestamp();
                    activityStatement.setLodgmentReceiptDatetime(ts);
                    if (ok) {
                        if (action != null && action.equals("lodge")) {
                            activityStatement.setSBRDocumentStatus("lodge_complete");
                        } else {
                            activityStatement.setSBRDocumentStatus("prelodge_complete");
                        }
                        Platform.runLater(() -> {
                            try {
                                ASLStatement aslStatement = xbrlFileController.getASLStatement(identifier);
                                if (aslStatement != null) {
                                    String value = activityStatement.getReportProcessStatusCode();
                                    if (value != null) {
                                        aslStatement.setReport_ProcessStatus_Code(value);
                                    }
                                    if ((value = activityStatement.getBusinessDocumentGovernmentGeneratedIdentifierText()) != null) {
                                        aslStatement.setBusinessDocument_GovernmentGeneratedIdentifier_Text(value);
                                    }
                                    if ((value = activityStatement.getPaymentRecordDueDate()) != null) {
                                        aslStatement.setPaymentRecord_Due_Date(value);
                                    }
                                    if ((value = activityStatement.getLodgmentDueDate()) != null) {
                                        aslStatement.setLodgment_Due_Date(value);
                                    }
                                    xbrlFileController.saveActivityStatementList(null);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ActivityStatementController.this.error_message.setText(e.getMessage());
                                xbrlFileController.setStatusBarMessage(e.getMessage());
                            }
                        });
                    } else {
                        Platform.runLater(() -> xbrlFileController.setStatusBarMessage("An error has occurred please check the messages."));
                        activityStatement.setSBRDocumentStatus("prefill_complete");
                    }
                    Platform.runLater(() -> {
                        try {
                            xbrlFileController.saveActivityStatement(ActivityStatementController.this.glenixTrnXBRL);
                            ActivityStatementController.this.setModel(ActivityStatementController.this.glenixTrnXBRL);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ActivityStatementController.this.error_message.setText(e.getMessage());
                            xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater(() -> {
                        ActivityStatementController.this.error_message.setText(e.getMessage());
                        xbrlFileController.setStatusBarMessage(e.getMessage());
                    });
                }
                finally {
                    xbrlFileController.reprotectAUSKeyCredentialPrivateKey();
                }
            }
        }).start();
    }

    public void setProfileDetails(Profile profileXBRL) {
        String status = this.sbrDocumentStatus.getText();
        if (status == null || !status.equals("lodge_complete")) {
            AgentDetails agentDetails = null;
            if (profileXBRL != null) {
                agentDetails = profileXBRL.getAgentDetails();
            }
            if (agentDetails == null) {
                this.ASIntermediary_ABN.setText(null);
                this.ASIntermediary_TAN.setText(null);
                this.INT_Declaration_Signature_Date.setGlenixElementValue(null);
                this.INT_Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
                this.INT_Declaration_SignatoryIdentifier_Text.setGlenixElementValue(null);
                this.intermediarysection.setVisible(false);
                this.intermediarysection.setManaged(false);
                this.RP_Declaration_StatementAccepted_Indicator.getGlenixController().enableGlenixXBRL();
                this.RP_Declaration_Signature_Date.getGlenixController().enableGlenixXBRL();
                this.RP_Declaration_SignatoryIdentifier_Text.getGlenixController().enableGlenixXBRL();
                this.RP_Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
                LocalDate ld = LocalDate.now();
                String dateValue = ld.format(DateTimeFormatter.ISO_LOCAL_DATE);
                this.RP_Declaration_Signature_Date.setGlenixElementValue(dateValue);
                this.RP_Declaration_SignatoryIdentifier_Text.setGlenixElementValue(profileXBRL.getFullName());
            } else {
                this.ASIntermediary_ABN.setText(agentDetails.getAgentABN());
                this.ASIntermediary_TAN.setText(agentDetails.getAgentNumber());
                String agentABN = agentDetails.getAgentABN();
                if (agentABN == null || agentABN.isEmpty()) {
                    this.intermediarysection.setVisible(false);
                    this.intermediarysection.setManaged(false);
                    this.INT_Declaration_Signature_Date.setGlenixElementValue(null);
                    this.INT_Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
                    this.INT_Declaration_SignatoryIdentifier_Text.setGlenixElementValue(null);
                    this.RP_Declaration_StatementAccepted_Indicator.getGlenixController().enableGlenixXBRL();
                    this.RP_Declaration_Signature_Date.getGlenixController().enableGlenixXBRL();
                    this.RP_Declaration_SignatoryIdentifier_Text.getGlenixController().enableGlenixXBRL();
                    this.RP_Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
                    LocalDate ld = LocalDate.now();
                    String dateValue = ld.format(DateTimeFormatter.ISO_LOCAL_DATE);
                    this.RP_Declaration_Signature_Date.setGlenixElementValue(dateValue);
                    this.RP_Declaration_SignatoryIdentifier_Text.setGlenixElementValue(profileXBRL.getFullName());
                } else {
                    this.intermediarysection.setVisible(true);
                    this.intermediarysection.setManaged(true);
                    this.RP_Declaration_StatementAccepted_Indicator.getGlenixController().disableGlenixXBRL();
                    this.RP_Declaration_Signature_Date.getGlenixController().disableGlenixXBRL();
                    this.RP_Declaration_SignatoryIdentifier_Text.getGlenixController().disableGlenixXBRL();
                    this.RP_Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
                    this.RP_Declaration_Signature_Date.setGlenixElementValue(null);
                    this.RP_Declaration_SignatoryIdentifier_Text.setGlenixElementValue(null);
                    this.INT_Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
                    LocalDate ld = LocalDate.now();
                    String dateValue = ld.format(DateTimeFormatter.ISO_LOCAL_DATE);
                    this.INT_Declaration_Signature_Date.setGlenixElementValue(dateValue);
                    this.Report_Submission_Date.setGlenixElementValue(dateValue);
                    this.INT_Declaration_SignatoryIdentifier_Text.setGlenixElementValue(profileXBRL.getFullName());
                }
            }
        }
    }
}

