/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccountListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    private TableView accountTable;
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private TableColumn accountName;
    @FXML
    private TableColumn accountDescription;
    @FXML
    private TableColumn accountClassificationReference;
    @FXML
    private TableColumn accountActive;
    @FXML
    private TableColumn accountDefaultProvisionIdentifier;
    @FXML
    private TableColumn accountApplySuper;
    @FXML
    private TableColumn accountApplyLeave;
    private ApplicationController xbrlFileController = null;
    private GlenixTrnXBRL glenixTrnXBRL = null;
    private ObservableList<Transaction> transactionObservableList;

    public AccountListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.accountTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        Transaction transaction = (Transaction)row.getItem();
                        if (transaction != null) {
                            TransactionLine line = transaction.getFirstTransactionLine();
                            if (line != null) {
                                Account p = line.getAccount();
                                if (p != null) {
                                    try {
                                        this.xbrlFileController.gotoAccountEdit(p);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.error_message.setText("Error, could not go to account page.");
                                    }
                                } else {
                                    this.error_message.setText("Error, could not get account.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get account transaction line.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get account transaction.");
                        }
                    } else {
                        this.addAccount();
                    }
                }
            });
            return row;
        });
        this.accountDefaultProvisionIdentifier.setCellFactory((Callback)new Callback<TableColumn<Transaction, String>, TableCell<Transaction, String>>(){

            public TableCell call(TableColumn<Transaction, String> param) {
                TableCell<Transaction, String> cell = new TableCell<Transaction, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setGraphic(null);
                        if (empty) {
                            this.setText(null);
                        } else {
                            boolean isset = false;
                            if (item != null && !item.isEmpty()) {
                                try {
                                    Transaction pt = AccountListController.this.xbrlFileController.getProvisionTransaction(item);
                                    if (pt != null) {
                                        this.setText(pt.getProvisionName());
                                        isset = true;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (!isset) {
                                this.setText(null);
                            }
                        }
                    }
                };
                return cell;
            }
        });
        this.accountTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        Element businessEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        super.buildGlenixXBRL(resultDoc, transactionLineEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element businessElement;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (businessElement = (Element)node).getNamespaceURI() == null || !businessElement.getNamespaceURI().equals("http://www.glenix.com.au/") || businessElement.getLocalName() == null || !businessElement.getLocalName().equals("business")) continue;
                NodeList nodeList2 = businessElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element transactionElement;
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1 || (transactionElement = (Element)node2).getNamespaceURI() == null || !transactionElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionElement.getLocalName() == null || !transactionElement.getLocalName().equals("transaction")) continue;
                    NodeList nodeList3 = transactionElement.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element transactionLineElement;
                        Node node3 = nodeList3.item(k);
                        if (node3.getNodeType() != 1 || (transactionLineElement = (Element)node3).getNamespaceURI() == null || !transactionLineElement.getNamespaceURI().equals("http://www.glenix.com.au/") || transactionLineElement.getLocalName() == null || !transactionLineElement.getLocalName().equals("transactionLine")) continue;
                        NodeList nodeList4 = transactionLineElement.getChildNodes();
                        for (int m = 0; m < nodeList4.getLength(); ++m) {
                            Node node4 = nodeList4.item(m);
                            if (node4.getNodeType() != 1) continue;
                            Element el = (Element)node4;
                            super.loadGlenixXBRL(loadDoc, el);
                        }
                    }
                }
            }
        }
    }

    @FXML
    private void saveAccount() {
        try {
            this.xbrlFileController.saveAccountList();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void addAccount() {
        try {
            this.xbrlFileController.gotoAccountEdit(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText("Error, could not load account edit page.");
        }
    }

    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        this.glenixTrnXBRL = glenixTrnXBRL;
        if (glenixTrnXBRL != null) {
            Document doc = glenixTrnXBRL.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
            this.setAccountObservableList();
        }
    }

    private void setAccountObservableList() {
        Business business = this.glenixTrnXBRL.getBusiness();
        if (business == null) {
            return;
        }
        ArrayList<Transaction> transactionArrayList = business.getTransactionArrayList();
        transactionArrayList.sort(new Comparator<Transaction>(){

            @Override
            public int compare(Transaction t1, Transaction t2) {
                int res;
                int res2;
                Account a1 = t1.getAccount();
                Account a2 = t2.getAccount();
                if (a1 == null && a2 != null) {
                    return -1;
                }
                if (a2 == null && a1 != null) {
                    return 1;
                }
                if (a2 == null && a1 == null) {
                    return 0;
                }
                String name1 = a1.getAccountName();
                String name2 = a2.getAccountName();
                if ((name1 == null || name1.isEmpty()) && name2 != null && !name2.isEmpty()) {
                    return -1;
                }
                if ((name2 == null || name2.isEmpty()) && name1 != null && !name1.isEmpty()) {
                    return 1;
                }
                if (name1 != null && name2 != null && (res2 = name1.compareToIgnoreCase(name2)) != 0) {
                    return res2;
                }
                String id1 = a1.getAccountIdentifier();
                String id2 = a2.getAccountIdentifier();
                if ((id1 == null || id1.isEmpty()) && id2 != null && !id2.isEmpty()) {
                    return -1;
                }
                if ((id2 == null || id2.isEmpty()) && id1 != null && !id1.isEmpty()) {
                    return 1;
                }
                if (id1 != null && id2 != null && (res = id1.compareTo(id2)) != 0) {
                    return res;
                }
                return 0;
            }
        });
        this.transactionObservableList = FXCollections.observableList(transactionArrayList);
        this.accountTable.setItems(this.transactionObservableList);
    }

    public void refreshTable() {
        this.setAccountObservableList();
        this.accountTable.refresh();
    }

    @FXML
    private void deleteSelectedAccounts() {
        try {
            ObservableList selectedAccountTransactions = this.accountTable.getSelectionModel().getSelectedItems();
            if (selectedAccountTransactions != null && selectedAccountTransactions.size() > 0) {
                this.xbrlFileController.deleteSelectedAccounts((ObservableList<Transaction>)selectedAccountTransactions);
                this.xbrlFileController.saveAccountList();
                this.setModel(this.xbrlFileController.getGlenixTrnXBRLAccount());
            } else {
                String message = "Error, there are no selected accounts to delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(9);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(3, 60.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 100.0, 20.0);
        gpw.setColumnLeftPosAndWidthMM(5, 120.0, 15.0);
        gpw.setColumnLeftPosAndWidthMM(6, 135.0, 35.0);
        gpw.setColumnLeftPosAndWidthMM(7, 170.0, 15.0);
        gpw.setColumnLeftPosAndWidthMM(8, 185.0, 15.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Transaction t : this.transactionObservableList) {
            Transaction pt;
            gpw.prepareString(2, t.getAccountName(), true, fontSize);
            gpw.prepareString(3, t.getAccountDescription(), true, fontSize);
            gpw.prepareString(4, t.getAccountClassificationReference(), true, fontSize);
            gpw.prepareString(5, t.getAccountActive(), true, fontSize);
            String pi = t.getAccountDefaultProvisionIdentifier();
            if (pi != null && !pi.isEmpty() && (pt = this.xbrlFileController.getProvisionTransaction(pi)) != null) {
                gpw.prepareString(6, pt.getProvisionName(), true, fontSize);
            }
            gpw.prepareString(7, t.getAccountApplySuper(), true, fontSize);
            gpw.prepareString(8, t.getAccountApplyLeave(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.accountName.getText(), true, fontSize);
        gpw.prepareString(3, this.accountDescription.getText(), true, fontSize);
        gpw.prepareString(4, this.accountClassificationReference.getText(), true, fontSize);
        gpw.prepareString(5, this.accountActive.getText(), true, fontSize);
        gpw.prepareString(6, this.accountDefaultProvisionIdentifier.getText(), true, fontSize);
        gpw.prepareString(7, this.accountApplySuper.getText(), true, fontSize);
        gpw.prepareString(8, this.accountApplyLeave.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

