/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelDefaultProvisionCombo;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class AccountEditController
extends GlenixBranchController {
    @FXML
    protected Label error_message;
    @FXML
    protected ScrollPane sp;
    @FXML
    protected GlenixFlowPane fp;
    @FXML
    protected VBox vb;
    @FXML
    protected GlenixLabelDefaultProvisionCombo defaultProvisionIdentifier;
    protected ApplicationController applicationController = null;
    protected DocumentBuilder dBuilder;
    protected Account account = null;

    public AccountEditController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setAccountElement(Account account) throws Exception {
        this.account = account;
        this.error_message.setText(null);
        this.applicationController.setStatusBarMessage(null);
        this.clearGlenixXBRL();
        if (account != null) {
            Document doc = this.dBuilder.newDocument();
            account.appendToElement(doc);
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        this.defaultProvisionIdentifier.setItems(provisionObservableList);
    }

    @FXML
    private void saveAccount() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.account == null) {
                this.account = this.applicationController.addAccount();
                this.account.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
                this.applicationController.saveAccount(this.account);
            } else {
                this.account.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
                Account saveAccount = new Account();
                saveAccount.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
                saveAccount.setAccountIdentifier(this.account.getAccountIdentifier());
                this.applicationController.saveAccount(saveAccount);
            }
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void clearAccount() {
        try {
            this.setAccountElement(null);
            this.error_message.setText("New account");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoAccountList() {
        this.applicationController.gotoAccountList();
    }
}

